/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.common.config;

import com.google.cloud.flink.bigquery.common.config.AutoValue_BigQueryConnectOptions;
import com.google.cloud.flink.bigquery.common.config.BigQueryConnectOptions;
import com.google.cloud.flink.bigquery.common.config.CredentialsOptions;
import com.google.cloud.flink.bigquery.services.BigQueryServices;
import javax.annotation.Nullable;
import org.apache.flink.util.function.SerializableSupplier;

abstract class $AutoValue_BigQueryConnectOptions
extends BigQueryConnectOptions {
    private final String projectId;
    private final String dataset;
    private final String table;
    @Nullable
    private final CredentialsOptions credentialsOptions;
    @Nullable
    private final SerializableSupplier<BigQueryServices> testingBigQueryServices;

    $AutoValue_BigQueryConnectOptions(String projectId, String dataset, String table, @Nullable CredentialsOptions credentialsOptions, @Nullable SerializableSupplier<BigQueryServices> testingBigQueryServices) {
        if (projectId == null) {
            throw new NullPointerException("Null projectId");
        }
        this.projectId = projectId;
        if (dataset == null) {
            throw new NullPointerException("Null dataset");
        }
        this.dataset = dataset;
        if (table == null) {
            throw new NullPointerException("Null table");
        }
        this.table = table;
        this.credentialsOptions = credentialsOptions;
        this.testingBigQueryServices = testingBigQueryServices;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public String getDataset() {
        return this.dataset;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    @Nullable
    public CredentialsOptions getCredentialsOptions() {
        return this.credentialsOptions;
    }

    @Override
    @Nullable
    public SerializableSupplier<BigQueryServices> getTestingBigQueryServices() {
        return this.testingBigQueryServices;
    }

    @Override
    public BigQueryConnectOptions.Builder toBuilder() {
        return new Builder(this);
    }

    static class Builder
    extends BigQueryConnectOptions.Builder {
        private String projectId;
        private String dataset;
        private String table;
        private CredentialsOptions credentialsOptions;
        private SerializableSupplier<BigQueryServices> testingBigQueryServices;

        Builder() {
        }

        private Builder(BigQueryConnectOptions source) {
            this.projectId = source.getProjectId();
            this.dataset = source.getDataset();
            this.table = source.getTable();
            this.credentialsOptions = source.getCredentialsOptions();
            this.testingBigQueryServices = source.getTestingBigQueryServices();
        }

        @Override
        public BigQueryConnectOptions.Builder setProjectId(String projectId) {
            if (projectId == null) {
                throw new NullPointerException("Null projectId");
            }
            this.projectId = projectId;
            return this;
        }

        @Override
        public BigQueryConnectOptions.Builder setDataset(String dataset) {
            if (dataset == null) {
                throw new NullPointerException("Null dataset");
            }
            this.dataset = dataset;
            return this;
        }

        @Override
        public BigQueryConnectOptions.Builder setTable(String table) {
            if (table == null) {
                throw new NullPointerException("Null table");
            }
            this.table = table;
            return this;
        }

        @Override
        public BigQueryConnectOptions.Builder setCredentialsOptions(CredentialsOptions credentialsOptions) {
            this.credentialsOptions = credentialsOptions;
            return this;
        }

        @Override
        public BigQueryConnectOptions.Builder setTestingBigQueryServices(SerializableSupplier<BigQueryServices> testingBigQueryServices) {
            this.testingBigQueryServices = testingBigQueryServices;
            return this;
        }

        @Override
        public BigQueryConnectOptions build() {
            if (this.projectId == null || this.dataset == null || this.table == null) {
                StringBuilder missing = new StringBuilder();
                if (this.projectId == null) {
                    missing.append(" projectId");
                }
                if (this.dataset == null) {
                    missing.append(" dataset");
                }
                if (this.table == null) {
                    missing.append(" table");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BigQueryConnectOptions(this.projectId, this.dataset, this.table, this.credentialsOptions, this.testingBigQueryServices);
        }
    }
}

