/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.common.config;

import com.google.auto.value.AutoValue;
import com.google.cloud.flink.bigquery.common.config.$AutoValue_BigQueryConnectOptions;
import com.google.cloud.flink.bigquery.common.config.CredentialsOptions;
import com.google.cloud.flink.bigquery.services.BigQueryServices;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.function.SerializableSupplier;

@AutoValue
@PublicEvolving
public abstract class BigQueryConnectOptions
implements Serializable {
    public abstract String getProjectId();

    public abstract String getDataset();

    public abstract String getTable();

    @Nullable
    public abstract CredentialsOptions getCredentialsOptions();

    @Nullable
    public abstract SerializableSupplier<BigQueryServices> getTestingBigQueryServices();

    public final String toString() {
        return String.format("[project : %s, dataset : %s, table : %s]", this.getProjectId(), this.getDataset(), this.getTable());
    }

    public final int hashCode() {
        int hash = 5;
        hash = 61 * hash + Objects.hashCode(this.getProjectId());
        hash = 61 * hash + Objects.hashCode(this.getDataset());
        hash = 61 * hash + Objects.hashCode(this.getTable());
        hash = 61 * hash + Objects.hashCode(this.getCredentialsOptions());
        return hash;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigQueryConnectOptions other = (BigQueryConnectOptions)obj;
        return Objects.equals(this.getProjectId(), other.getProjectId()) && Objects.equals(this.getDataset(), other.getDataset()) && Objects.equals(this.getTable(), other.getTable()) && Objects.equals(this.getCredentialsOptions(), other.getCredentialsOptions());
    }

    public static Builder builder() {
        return new $AutoValue_BigQueryConnectOptions.Builder().setCredentialsOptions(CredentialsOptions.builder().build());
    }

    public static Builder builderForQuerySource() {
        return new $AutoValue_BigQueryConnectOptions.Builder().setCredentialsOptions(CredentialsOptions.builder().build()).setProjectId("").setDataset("").setTable("");
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setProjectId(String var1);

        public abstract Builder setDataset(String var1);

        public abstract Builder setTable(String var1);

        public abstract Builder setCredentialsOptions(CredentialsOptions var1);

        public abstract Builder setTestingBigQueryServices(SerializableSupplier<BigQueryServices> var1);

        public abstract BigQueryConnectOptions build();
    }
}

