/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.common.config;

import com.google.auth.Credentials;
import com.google.auto.value.AutoValue;
import com.google.cloud.flink.bigquery.common.config.AutoValue_CredentialsOptions;
import com.google.cloud.flink.bigquery.common.utils.GoogleCredentialsSupplier;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;

@AutoValue
@PublicEvolving
public abstract class CredentialsOptions
implements Serializable {
    @Nullable
    public abstract String getCredentialsFile();

    @Nullable
    public abstract String getCredentialsKey();

    @Nullable
    public abstract String getAccessToken();

    public Credentials getCredentials() {
        return GoogleCredentialsSupplier.supplyCredentialsFromSources(Optional.ofNullable(this.getAccessToken()), Optional.ofNullable(this.getCredentialsKey()), Optional.ofNullable(this.getCredentialsFile()));
    }

    public final int hashCode() {
        int hash = 5;
        hash = 61 * hash + Objects.hashCode(this.getCredentialsFile());
        hash = 61 * hash + Objects.hashCode(this.getCredentialsKey());
        hash = 61 * hash + Objects.hashCode(this.getAccessToken());
        return hash;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CredentialsOptions other = (CredentialsOptions)obj;
        return Objects.equals(this.getCredentialsFile(), other.getCredentialsFile()) && Objects.equals(this.getCredentialsKey(), other.getCredentialsKey()) && Objects.equals(this.getAccessToken(), other.getAccessToken());
    }

    public static Builder builder() {
        return new AutoValue_CredentialsOptions.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setCredentialsFile(String var1);

        public abstract Builder setCredentialsKey(String var1);

        public abstract Builder setAccessToken(String var1);

        public abstract CredentialsOptions build();
    }
}

