/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.common.utils;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.function.BiConsumerWithException;
import org.apache.flink.util.function.FunctionWithException;

@Internal
public class BigQueryStateSerde {
    private BigQueryStateSerde() {
    }

    public static <T> void serializeList(DataOutputStream out, List<T> list, BiConsumerWithException<DataOutputStream, T, IOException> serializer) throws IOException {
        out.writeInt(list.size());
        for (T t : list) {
            serializer.accept((Object)out, t);
        }
    }

    public static <T> List<T> deserializeList(DataInputStream in, FunctionWithException<DataInputStream, T, IOException> deserializer) throws IOException {
        int size = in.readInt();
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            Object t = deserializer.apply((Object)in);
            list.add(t);
        }
        return list;
    }

    public static <K, V> void serializeMap(DataOutputStream out, Map<K, V> map, BiConsumerWithException<DataOutputStream, K, IOException> keySerializer, BiConsumerWithException<DataOutputStream, V, IOException> valueSerializer) throws IOException {
        out.writeInt(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            keySerializer.accept((Object)out, entry.getKey());
            valueSerializer.accept((Object)out, entry.getValue());
        }
    }

    public static <K, V> Map<K, V> deserializeMap(DataInputStream in, FunctionWithException<DataInputStream, K, IOException> keyDeserializer, FunctionWithException<DataInputStream, V, IOException> valueDeserializer) throws IOException {
        int size = in.readInt();
        HashMap<Object, Object> result = new HashMap<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            Object key = keyDeserializer.apply((Object)in);
            Object value = valueDeserializer.apply((Object)in);
            result.put(key, value);
        }
        return result;
    }
}

