/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.common.utils;

import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Base64;
import java.util.Optional;
import org.apache.flink.annotation.Internal;

@Internal
public class GoogleCredentialsSupplier {
    private GoogleCredentialsSupplier() {
    }

    public static Credentials supplyCredentialsFromSources(Optional<String> accessToken, Optional<String> credentialsKey, Optional<String> credentialsFile) {
        Credentials credentials = accessToken.isPresent() ? GoogleCredentialsSupplier.createCredentialsFromAccessToken(accessToken.get()) : (credentialsKey.isPresent() ? GoogleCredentialsSupplier.createCredentialsFromKey(credentialsKey.get()) : (credentialsFile.isPresent() ? GoogleCredentialsSupplier.createCredentialsFromFile(credentialsFile.get()) : GoogleCredentialsSupplier.createDefaultCredentials()));
        return credentials;
    }

    private static Credentials createCredentialsFromAccessToken(String accessToken) {
        return GoogleCredentials.create((AccessToken)new AccessToken(accessToken, null));
    }

    private static Credentials createCredentialsFromKey(String key) {
        try {
            return GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(key)));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create Credentials from key", e);
        }
    }

    private static Credentials createCredentialsFromFile(String file) {
        try {
            return GoogleCredentials.fromStream((InputStream)new FileInputStream(file));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create Credentials from file", e);
        }
    }

    private static Credentials createDefaultCredentials() {
        try {
            return GoogleCredentials.getApplicationDefault();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create default Credentials", e);
        }
    }
}

