/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.common.utils;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.StandardSQLTypeName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;

public class SchemaTransform {
    public static final String DEFAULT_NAMESPACE = "com.google.cloud.flink.bigquery";
    static final Map<String, List<Schema.Type>> BIG_QUERY_TO_AVRO_TYPES = SchemaTransform.initializeBigQueryToAvroTypesMapping();
    static final Map<String, StandardSQLTypeName> BIG_QUERY_TO_SQL_TYPES = SchemaTransform.initializeBigQueryToSQLTypesMapping();

    private static Map<String, List<Schema.Type>> initializeBigQueryToAvroTypesMapping() {
        HashMap<String, List<Schema.Type>> mapping = new HashMap<String, List<Schema.Type>>();
        mapping.put("STRING", Arrays.asList(Schema.Type.STRING));
        mapping.put("GEOGRAPHY", Arrays.asList(Schema.Type.STRING));
        mapping.put("BYTES", Arrays.asList(Schema.Type.BYTES));
        mapping.put("INTEGER", Arrays.asList(Schema.Type.LONG));
        mapping.put("INT64", Arrays.asList(Schema.Type.LONG));
        mapping.put("FLOAT", Arrays.asList(Schema.Type.DOUBLE));
        mapping.put("FLOAT64", Arrays.asList(Schema.Type.DOUBLE));
        mapping.put("NUMERIC", Arrays.asList(Schema.Type.BYTES));
        mapping.put("BIGNUMERIC", Arrays.asList(Schema.Type.BYTES));
        mapping.put("BOOLEAN", Arrays.asList(Schema.Type.BOOLEAN));
        mapping.put("BOOL", Arrays.asList(Schema.Type.BOOLEAN));
        mapping.put("TIMESTAMP", Arrays.asList(Schema.Type.LONG));
        mapping.put("RECORD", Arrays.asList(Schema.Type.RECORD));
        mapping.put("STRUCT", Arrays.asList(Schema.Type.RECORD));
        mapping.put("DATE", Arrays.asList(Schema.Type.STRING, Schema.Type.INT));
        mapping.put("DATETIME", Arrays.asList(Schema.Type.STRING));
        mapping.put("TIME", Arrays.asList(Schema.Type.STRING, Schema.Type.LONG));
        mapping.put("JSON", Arrays.asList(Schema.Type.STRING));
        return mapping;
    }

    private static Map<String, StandardSQLTypeName> initializeBigQueryToSQLTypesMapping() {
        HashMap<String, StandardSQLTypeName> mapping = new HashMap<String, StandardSQLTypeName>();
        mapping.put("STRING", StandardSQLTypeName.STRING);
        mapping.put("BYTES", StandardSQLTypeName.BYTES);
        mapping.put("INTEGER", StandardSQLTypeName.INT64);
        mapping.put("INT64", StandardSQLTypeName.INT64);
        mapping.put("FLOAT", StandardSQLTypeName.FLOAT64);
        mapping.put("FLOAT64", StandardSQLTypeName.FLOAT64);
        mapping.put("NUMERIC", StandardSQLTypeName.NUMERIC);
        mapping.put("BIGNUMERIC", StandardSQLTypeName.BIGNUMERIC);
        mapping.put("BOOLEAN", StandardSQLTypeName.BOOL);
        mapping.put("BOOL", StandardSQLTypeName.BOOL);
        mapping.put("TIMESTAMP", StandardSQLTypeName.TIMESTAMP);
        mapping.put("DATE", StandardSQLTypeName.DATE);
        mapping.put("TIME", StandardSQLTypeName.TIME);
        mapping.put("DATETIME", StandardSQLTypeName.DATETIME);
        mapping.put("INTERVAL", StandardSQLTypeName.INTERVAL);
        mapping.put("RECORD", StandardSQLTypeName.STRUCT);
        mapping.put("STRUCT", StandardSQLTypeName.STRUCT);
        return mapping;
    }

    public static Schema toGenericAvroSchema(String schemaName, List<TableFieldSchema> fieldSchemas, String namespace) {
        String nextNamespace = namespace == null ? null : String.format("%s.%s", namespace, schemaName);
        ArrayList<Schema.Field> avroFields = new ArrayList<Schema.Field>();
        for (TableFieldSchema bigQueryField : fieldSchemas) {
            avroFields.add(SchemaTransform.convertField(bigQueryField, nextNamespace));
        }
        return Schema.createRecord((String)schemaName, (String)("Translated Avro Schema for " + schemaName), (String)(namespace == null ? DEFAULT_NAMESPACE : namespace), (boolean)false, avroFields);
    }

    public static Schema toGenericAvroSchema(String schemaName, List<TableFieldSchema> fieldSchemas) {
        return SchemaTransform.toGenericAvroSchema(schemaName, fieldSchemas, SchemaTransform.hasNamespaceCollision(fieldSchemas) ? DEFAULT_NAMESPACE : null);
    }

    private static boolean hasNamespaceCollision(List<TableFieldSchema> fieldSchemas) {
        HashSet<String> recordTypeFieldNames = new HashSet<String>();
        ArrayList<TableFieldSchema> fieldsToCheck = new ArrayList<TableFieldSchema>();
        fieldsToCheck.addAll(fieldSchemas);
        while (!fieldsToCheck.isEmpty()) {
            TableFieldSchema field = (TableFieldSchema)fieldsToCheck.remove(0);
            if (!field.getType().equals("STRUCT") && !field.getType().equals("RECORD")) continue;
            if (recordTypeFieldNames.contains(field.getName())) {
                return true;
            }
            recordTypeFieldNames.add(field.getName());
            fieldsToCheck.addAll(field.getFields());
        }
        return false;
    }

    private static Schema.Field convertField(TableFieldSchema bigQueryField, String namespace) {
        Schema fieldSchema;
        List<Schema.Type> avroTypes = BIG_QUERY_TO_AVRO_TYPES.get(bigQueryField.getType());
        if (avroTypes.isEmpty()) {
            throw new IllegalArgumentException("Unable to map BigQuery field type " + bigQueryField.getType() + " to avro type.");
        }
        Schema.Type avroType = avroTypes.iterator().next();
        Schema elementSchema = avroType == Schema.Type.RECORD ? SchemaTransform.toGenericAvroSchema(bigQueryField.getName(), bigQueryField.getFields(), namespace) : SchemaTransform.handleAvroLogicalTypes(bigQueryField, avroType);
        if (bigQueryField.getMode() == null || bigQueryField.getMode().equals("NULLABLE")) {
            fieldSchema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), elementSchema});
        } else if (Objects.equals(bigQueryField.getMode(), "REQUIRED")) {
            fieldSchema = elementSchema;
        } else if (bigQueryField.getMode().equals("REPEATED")) {
            fieldSchema = Schema.createArray((Schema)elementSchema);
        } else {
            throw new IllegalArgumentException(String.format("Unknown BigQuery Field Mode: %s", bigQueryField.getMode()));
        }
        return new Schema.Field(bigQueryField.getName(), fieldSchema, bigQueryField.getDescription(), null);
    }

    private static Schema handleAvroLogicalTypes(TableFieldSchema bigQueryField, Schema.Type avroType) {
        String bqType;
        switch (bqType = bigQueryField.getType()) {
            case "NUMERIC": {
                int precision = Optional.ofNullable(bigQueryField.getPrecision()).orElse(38L).intValue();
                int scale = Optional.ofNullable(bigQueryField.getScale()).orElse(9L).intValue();
                Schema numericSchema = LogicalTypes.decimal((int)precision, (int)scale).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES));
                numericSchema.addProp("isNumeric", (Object)true);
                return numericSchema;
            }
            case "BIGNUMERIC": {
                int precisionBigNumeric = Optional.ofNullable(bigQueryField.getPrecision()).orElse(77L).intValue();
                int scaleBigNumeric = Optional.ofNullable(bigQueryField.getScale()).orElse(38L).intValue();
                return LogicalTypes.decimal((int)precisionBigNumeric, (int)scaleBigNumeric).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES));
            }
            case "TIMESTAMP": {
                return LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
            }
            case "GEOGRAPHY": {
                Schema geoSchema = Schema.create((Schema.Type)Schema.Type.STRING);
                geoSchema.addProp("logicalType", "geography_wkt");
                return geoSchema;
            }
            case "JSON": {
                Schema jsonSchema = Schema.create((Schema.Type)Schema.Type.STRING);
                jsonSchema.addProp("logicalType", "Json");
                return jsonSchema;
            }
            case "TIME": {
                return LogicalTypes.timeMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
            }
            case "DATETIME": {
                Schema datetimeSchema = Schema.create((Schema.Type)Schema.Type.STRING);
                datetimeSchema.addProp("logicalType", LogicalTypes.localTimestampMicros().getName());
                return datetimeSchema;
            }
            case "DATE": {
                return LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
            }
        }
        return Schema.create((Schema.Type)avroType);
    }

    static List<TableFieldSchema> fieldListToListOfTableFieldSchema(FieldList fieldList) {
        return Optional.ofNullable(fieldList).map(fList -> fList.stream().map(field -> SchemaTransform.fieldToTableFieldSchema(field)).collect(Collectors.toList())).orElse(new ArrayList());
    }

    static TableFieldSchema fieldToTableFieldSchema(Field field) {
        return new TableFieldSchema().setName(field.getName()).setDescription(field.getDescription()).setDefaultValueExpression(field.getDefaultValueExpression()).setCollation(field.getCollation()).setMode((String)Optional.ofNullable(field.getMode()).map(m -> m.name()).orElse(null)).setType(field.getType().name()).setFields(SchemaTransform.fieldListToListOfTableFieldSchema(field.getSubFields()));
    }

    public static TableSchema bigQuerySchemaToTableSchema(com.google.cloud.bigquery.Schema schema) {
        return new TableSchema().setFields(SchemaTransform.fieldListToListOfTableFieldSchema(schema.getFields()));
    }

    public static StandardSQLTypeName bigQueryTableFieldSchemaTypeToSQLType(String tableFieldSchemaType) {
        return BIG_QUERY_TO_SQL_TYPES.getOrDefault(tableFieldSchemaType, null);
    }
}

