/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.services;

import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.FinalizeWriteStreamResponse;
import com.google.cloud.bigquery.storage.v1.FlushRowsResponse;
import com.google.cloud.bigquery.storage.v1.ProtoSchema;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.StreamWriter;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.cloud.flink.bigquery.common.config.CredentialsOptions;
import com.google.cloud.flink.bigquery.services.PartitionIdWithInfoAndStatus;
import com.google.cloud.flink.bigquery.services.QueryResultInfo;
import com.google.cloud.flink.bigquery.services.TablePartitionInfo;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;

@Internal
public interface BigQueryServices
extends Serializable {
    public QueryDataClient createQueryDataClient(CredentialsOptions var1);

    public StorageReadClient createStorageReadClient(CredentialsOptions var1) throws IOException;

    public StorageWriteClient createStorageWriteClient(CredentialsOptions var1) throws IOException;

    public static interface QueryDataClient
    extends Serializable {
        public List<String> retrieveTablePartitions(String var1, String var2, String var3);

        public Optional<TablePartitionInfo> retrievePartitionColumnInfo(String var1, String var2, String var3);

        public List<PartitionIdWithInfoAndStatus> retrievePartitionsStatus(String var1, String var2, String var3);

        public TableSchema getTableSchema(String var1, String var2, String var3);

        public Optional<QueryResultInfo> runQuery(String var1, String var2);

        public Job dryRunQuery(String var1, String var2);
    }

    public static interface StorageWriteClient
    extends AutoCloseable {
        public StreamWriter createStreamWriter(String var1, ProtoSchema var2, boolean var3) throws IOException;

        public WriteStream createWriteStream(String var1, WriteStream.Type var2);

        public FlushRowsResponse flushRows(String var1, long var2);

        public FinalizeWriteStreamResponse finalizeWriteStream(String var1);

        @Override
        public void close();
    }

    public static interface StorageReadClient
    extends AutoCloseable {
        public ReadSession createReadSession(CreateReadSessionRequest var1);

        public BigQueryServerStream<ReadRowsResponse> readRows(ReadRowsRequest var1);

        @Override
        public void close();
    }

    public static interface BigQueryServerStream<T>
    extends Iterable<T>,
    Serializable {
        public void cancel();
    }
}

