/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.services;

import com.google.cloud.flink.bigquery.common.config.BigQueryConnectOptions;
import com.google.cloud.flink.bigquery.services.BigQueryServices;
import com.google.cloud.flink.bigquery.services.BigQueryServicesImpl;
import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.util.Preconditions;

@Internal
public class BigQueryServicesFactory {
    private static final BigQueryServicesFactory INSTANCE = new BigQueryServicesFactory();
    private static final BigQueryServices SERVICES = new BigQueryServicesImpl();
    private Boolean isTestingEnabled = false;
    private BigQueryServices testingServices;
    private BigQueryConnectOptions bqConnectOptions;

    private BigQueryServicesFactory() {
    }

    public static BigQueryServicesFactory instance(BigQueryConnectOptions options) {
        BigQueryServicesFactory.INSTANCE.bqConnectOptions = options;
        if (options.getTestingBigQueryServices() == null) {
            return INSTANCE.defaultImplementation();
        }
        return INSTANCE.withTestingServices((BigQueryServices)options.getTestingBigQueryServices().get());
    }

    public BigQueryServices.StorageReadClient storageRead() throws IOException {
        if (this.isTestingEnabled.booleanValue()) {
            return this.testingServices.createStorageReadClient(this.bqConnectOptions.getCredentialsOptions());
        }
        return SERVICES.createStorageReadClient(this.bqConnectOptions.getCredentialsOptions());
    }

    public BigQueryServices.StorageWriteClient storageWrite() throws IOException {
        if (this.isTestingEnabled.booleanValue()) {
            return this.testingServices.createStorageWriteClient(this.bqConnectOptions.getCredentialsOptions());
        }
        return SERVICES.createStorageWriteClient(this.bqConnectOptions.getCredentialsOptions());
    }

    public BigQueryServices.QueryDataClient queryClient() {
        if (this.isTestingEnabled.booleanValue()) {
            return this.testingServices.createQueryDataClient(this.bqConnectOptions.getCredentialsOptions());
        }
        return SERVICES.createQueryDataClient(this.bqConnectOptions.getCredentialsOptions());
    }

    @VisibleForTesting
    BigQueryServicesFactory withTestingServices(BigQueryServices testingServices) {
        Preconditions.checkNotNull((Object)testingServices);
        this.isTestingEnabled = true;
        this.testingServices = testingServices;
        return this;
    }

    public BigQueryServicesFactory defaultImplementation() {
        this.isTestingEnabled = false;
        this.testingServices = null;
        return this;
    }

    public Boolean getIsTestingEnabled() {
        return this.isTestingEnabled;
    }

    public BigQueryServices getTestingServices() {
        return this.testingServices;
    }
}

