/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.services;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.ErrorProto;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.auth.Credentials;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.BigQueryReadSettings;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteSettings;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.CreateWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1.FinalizeWriteStreamResponse;
import com.google.cloud.bigquery.storage.v1.FlushRowsRequest;
import com.google.cloud.bigquery.storage.v1.FlushRowsResponse;
import com.google.cloud.bigquery.storage.v1.ProtoSchema;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.StreamWriter;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.cloud.flink.bigquery.common.config.CredentialsOptions;
import com.google.cloud.flink.bigquery.common.utils.BigQueryPartitionUtils;
import com.google.cloud.flink.bigquery.common.utils.BigQueryTableInfo;
import com.google.cloud.flink.bigquery.services.BigQueryServices;
import com.google.cloud.flink.bigquery.services.BigQueryUtils;
import com.google.cloud.flink.bigquery.services.PartitionIdWithInfoAndStatus;
import com.google.cloud.flink.bigquery.services.QueryResultInfo;
import com.google.cloud.flink.bigquery.services.TablePartitionInfo;
import com.google.protobuf.Int64Value;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.flink.FlinkVersion;
import org.apache.flink.annotation.Internal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.Duration;

@Internal
public class BigQueryServicesImpl
implements BigQueryServices {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryServicesImpl.class);
    private static final HeaderProvider USER_AGENT_HEADER_PROVIDER = FixedHeaderProvider.create((String[])new String[]{"User-Agent", "flink-bigquery-connector/" + FlinkVersion.current().toString()});
    public static final String TRACE_ID = String.format("Flink:%s", FlinkVersion.current().toString());

    @Override
    public BigQueryServices.StorageReadClient createStorageReadClient(CredentialsOptions credentialsOptions) throws IOException {
        return new StorageReadClientImpl(credentialsOptions);
    }

    @Override
    public BigQueryServices.StorageWriteClient createStorageWriteClient(CredentialsOptions credentialsOptions) throws IOException {
        return new StorageWriteClientImpl(credentialsOptions);
    }

    @Override
    public BigQueryServices.QueryDataClient createQueryDataClient(CredentialsOptions creadentialsOptions) {
        return new QueryDataClientImpl(creadentialsOptions);
    }

    public static class QueryDataClientImpl
    implements BigQueryServices.QueryDataClient {
        private final BigQuery bigQuery;
        private final Bigquery bigquery;

        public QueryDataClientImpl(CredentialsOptions options) {
            this.bigQuery = (BigQuery)((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setCredentials(options.getCredentials())).setHeaderProvider(USER_AGENT_HEADER_PROVIDER)).build().getService();
            this.bigquery = BigQueryUtils.newBigqueryBuilder(options).build();
        }

        @Override
        public List<String> retrieveTablePartitions(String project, String dataset, String table) {
            try {
                String query = Arrays.asList("SELECT", "  partition_id", "FROM", String.format("  `%s.%s.INFORMATION_SCHEMA.PARTITIONS`", project, dataset), "WHERE", " partition_id <> '__STREAMING_UNPARTITIONED__'", String.format(" AND table_catalog = '%s'", project), String.format(" AND table_schema = '%s'", dataset), String.format(" AND table_name = '%s'", table), "ORDER BY 1 ASC;").stream().collect(Collectors.joining("\n"));
                QueryJobConfiguration queryConfig = QueryJobConfiguration.newBuilder((String)query).build();
                TableResult results = this.bigQuery.query(queryConfig, new BigQuery.JobOption[0]);
                List<String> result = StreamSupport.stream(results.iterateAll().spliterator(), false).flatMap(row -> row.stream()).map(fValue -> fValue.getStringValue()).collect(Collectors.toList());
                LOG.info("Table partitions: {}", result);
                return result;
            }
            catch (Exception ex) {
                throw new RuntimeException(String.format("Problems while trying to retrieve table partitions (table: %s.%s.%s).", project, dataset, table), ex);
            }
        }

        @Override
        public List<PartitionIdWithInfoAndStatus> retrievePartitionsStatus(String project, String dataset, String table) {
            try {
                return this.retrievePartitionColumnInfo(project, dataset, table).map(info -> info.toPartitionsWithInfo(this.retrieveTablePartitions(project, dataset, table)).stream().map(pInfo -> BigQueryPartitionUtils.checkPartitionCompleted(pInfo)).collect(Collectors.toList())).orElse(new ArrayList());
            }
            catch (Exception ex) {
                throw new RuntimeException(String.format("Problems while trying to retrieve table partitions status (table: %s.%s.%s).", project, dataset, table), ex);
            }
        }

        @Override
        public Optional<TablePartitionInfo> retrievePartitionColumnInfo(String project, String dataset, String table) {
            try {
                Table tableInfo = BigQueryUtils.tableInfo(this.bigquery, project, dataset, table);
                if (tableInfo.getRangePartitioning() == null && tableInfo.getTimePartitioning() == null) {
                    return Optional.empty();
                }
                Instant bqStreamingBufferOldestEntryTime = Optional.ofNullable(tableInfo.getStreamingBuffer()).map(sbuffer -> sbuffer.getOldestEntryTime().longValue()).map(millisFromEpoch -> Instant.ofEpochMilli(millisFromEpoch)).orElse(Instant.MAX);
                return Optional.ofNullable(tableInfo.getTimePartitioning()).map(tp -> Optional.of(new TablePartitionInfo(tp.getField(), BigQueryPartitionUtils.PartitionType.valueOf(tp.getType()), BigQueryPartitionUtils.retrievePartitionColumnType(tableInfo.getSchema(), tp.getField()), bqStreamingBufferOldestEntryTime))).orElseGet(() -> Optional.of(new TablePartitionInfo(tableInfo.getRangePartitioning().getField(), BigQueryPartitionUtils.PartitionType.INT_RANGE, StandardSQLTypeName.INT64, bqStreamingBufferOldestEntryTime)));
            }
            catch (Exception ex) {
                throw new RuntimeException(String.format("Problems while trying to retrieve table partition's column name (table: %s.%s.%s).", project, dataset, table), ex);
            }
        }

        @Override
        public TableSchema getTableSchema(String project, String dataset, String table) {
            return BigQueryTableInfo.getSchema(this.bigQuery, project, dataset, table);
        }

        @Override
        public Job dryRunQuery(String projectId, String query) {
            try {
                JobConfigurationQuery queryConfiguration = new JobConfigurationQuery().setQuery(query).setUseQueryCache(Boolean.valueOf(true)).setUseLegacySql(Boolean.valueOf(false));
                return BigQueryUtils.dryRunQuery(this.bigquery, projectId, queryConfiguration, null);
            }
            catch (Exception ex) {
                throw new RuntimeException("Problems occurred while trying to dry-run a BigQuery query job.", ex);
            }
        }

        @Override
        public Optional<QueryResultInfo> runQuery(String projectId, String query) {
            try {
                JobConfigurationQuery queryConfiguration = new JobConfigurationQuery().setQuery(query).setUseQueryCache(Boolean.valueOf(true)).setUseLegacySql(Boolean.valueOf(false));
                Job dryRun = BigQueryUtils.dryRunQuery(this.bigquery, projectId, queryConfiguration, null);
                if (dryRun.getStatus().getErrors() != null) {
                    return Optional.of(dryRun.getStatus().getErrors()).map(errors -> QueryDataClientImpl.processErrorMessages(errors)).map(errors -> QueryResultInfo.failed(errors));
                }
                List referencedTables = dryRun.getStatistics().getQuery().getReferencedTables();
                TableReference firstTable = (TableReference)referencedTables.get(0);
                Dataset dataset = BigQueryUtils.datasetInfo(this.bigquery, firstTable.getProjectId(), firstTable.getDatasetId());
                Job job = BigQueryUtils.runQuery(this.bigquery, projectId, queryConfiguration, dataset.getLocation());
                TableReference queryDestTable = job.getConfiguration().getQuery().getDestinationTable();
                return Optional.of(Optional.ofNullable(job.getStatus()).flatMap(s -> Optional.ofNullable(s.getErrors())).map(errors -> QueryDataClientImpl.processErrorMessages(errors)).map(errors -> QueryResultInfo.failed(errors)).orElse(QueryResultInfo.succeed(queryDestTable.getProjectId(), queryDestTable.getDatasetId(), queryDestTable.getTableId())));
            }
            catch (Exception ex) {
                throw new RuntimeException("Problems occurred while trying to run a BigQuery query job.", ex);
            }
        }

        static List<String> processErrorMessages(List<ErrorProto> errors) {
            return errors.stream().map(error -> String.format("Message: '%s', reason: '%s', location: '%s'", error.getMessage(), error.getReason(), error.getLocation())).collect(Collectors.toList());
        }
    }

    public static class StorageWriteClientImpl
    implements BigQueryServices.StorageWriteClient {
        private final BigQueryWriteClient client;

        private StorageWriteClientImpl(CredentialsOptions options) throws IOException {
            BigQueryWriteSettings.Builder settingsBuilder = (BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)BigQueryWriteSettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)options.getCredentials()))).setHeaderProvider(USER_AGENT_HEADER_PROVIDER)).setTransportChannelProvider((TransportChannelProvider)BigQueryReadSettings.defaultGrpcTransportProviderBuilder().build());
            UnaryCallSettings.Builder createWriteStreamSettings = settingsBuilder.getStubSettingsBuilder().createWriteStreamSettings();
            createWriteStreamSettings.setRetrySettings(createWriteStreamSettings.getRetrySettings().toBuilder().setMaxAttempts(5).setInitialRpcTimeout(Duration.ofSeconds((long)60L)).setRpcTimeoutMultiplier(1.2).setInitialRetryDelay(Duration.ofSeconds((long)2L)).setRetryDelayMultiplier(1.2).build());
            UnaryCallSettings.Builder flushRowsSettings = settingsBuilder.getStubSettingsBuilder().flushRowsSettings();
            flushRowsSettings.setRetrySettings(flushRowsSettings.getRetrySettings().toBuilder().setMaxAttempts(5).setInitialRpcTimeout(Duration.ofSeconds((long)30L)).setRpcTimeoutMultiplier(1.0).setInitialRetryDelay(Duration.ofSeconds((long)1L)).setRetryDelayMultiplier(1.2).build());
            UnaryCallSettings.Builder finalizeWriteStreamSettings = settingsBuilder.getStubSettingsBuilder().finalizeWriteStreamSettings();
            finalizeWriteStreamSettings.setRetrySettings(finalizeWriteStreamSettings.getRetrySettings().toBuilder().setMaxAttempts(5).setInitialRpcTimeout(Duration.ofSeconds((long)30L)).setRpcTimeoutMultiplier(1.0).setInitialRetryDelay(Duration.ofSeconds((long)1L)).setRetryDelayMultiplier(1.2).build());
            this.client = BigQueryWriteClient.create((BigQueryWriteSettings)settingsBuilder.build());
        }

        @Override
        public StreamWriter createStreamWriter(String streamName, ProtoSchema protoSchema, boolean enableConnectionPool) throws IOException {
            RetrySettings retrySettings = RetrySettings.newBuilder().setMaxAttempts(5).setTotalTimeout(Duration.ofMinutes((long)5L)).setInitialRpcTimeout(Duration.ofSeconds((long)30L)).setMaxRpcTimeout(Duration.ofMinutes((long)2L)).setRpcTimeoutMultiplier(1.6).setRetryDelayMultiplier(1.6).setInitialRetryDelay(Duration.ofMillis((long)1250L)).setMaxRetryDelay(Duration.ofSeconds((long)5L)).build();
            return StreamWriter.newBuilder((String)streamName, (BigQueryWriteClient)this.client).setEnableConnectionPool(enableConnectionPool).setTraceId(TRACE_ID).setRetrySettings(retrySettings).setWriterSchema(protoSchema).build();
        }

        @Override
        public WriteStream createWriteStream(String tablePath, WriteStream.Type streamType) {
            return this.client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(tablePath).setWriteStream(WriteStream.newBuilder().setType(streamType).build()).build());
        }

        @Override
        public FlushRowsResponse flushRows(String streamName, long offset) {
            return this.client.flushRows(FlushRowsRequest.newBuilder().setWriteStream(streamName).setOffset(Int64Value.of((long)offset)).build());
        }

        @Override
        public FinalizeWriteStreamResponse finalizeWriteStream(String streamName) {
            return this.client.finalizeWriteStream(streamName);
        }

        @Override
        public void close() {
            this.client.close();
        }
    }

    public static class StorageReadClientImpl
    implements BigQueryServices.StorageReadClient {
        private final BigQueryReadClient client;

        private StorageReadClientImpl(CredentialsOptions options) throws IOException {
            BigQueryReadSettings.Builder settingsBuilder = (BigQueryReadSettings.Builder)((BigQueryReadSettings.Builder)((BigQueryReadSettings.Builder)BigQueryReadSettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)options.getCredentials()))).setHeaderProvider(USER_AGENT_HEADER_PROVIDER)).setTransportChannelProvider((TransportChannelProvider)BigQueryReadSettings.defaultGrpcTransportProviderBuilder().build());
            UnaryCallSettings.Builder createReadSessionSettings = settingsBuilder.getStubSettingsBuilder().createReadSessionSettings();
            createReadSessionSettings.setRetrySettings(createReadSessionSettings.getRetrySettings().toBuilder().setInitialRpcTimeout(Duration.ofHours((long)2L)).setMaxRpcTimeout(Duration.ofHours((long)2L)).setTotalTimeout(Duration.ofHours((long)2L)).build());
            UnaryCallSettings.Builder splitReadStreamSettings = settingsBuilder.getStubSettingsBuilder().splitReadStreamSettings();
            splitReadStreamSettings.setRetrySettings(splitReadStreamSettings.getRetrySettings().toBuilder().setInitialRpcTimeout(Duration.ofSeconds((long)30L)).setMaxRpcTimeout(Duration.ofSeconds((long)30L)).setTotalTimeout(Duration.ofSeconds((long)30L)).build());
            this.client = BigQueryReadClient.create((BigQueryReadSettings)settingsBuilder.build());
        }

        @Override
        public ReadSession createReadSession(CreateReadSessionRequest request) {
            return this.client.createReadSession(request);
        }

        @Override
        public BigQueryServices.BigQueryServerStream<ReadRowsResponse> readRows(ReadRowsRequest request) {
            return new BigQueryServerStreamImpl<ReadRowsResponse>(this.client.readRowsCallable().call((Object)request));
        }

        @Override
        public void close() {
            this.client.close();
        }
    }

    public static class BigQueryServerStreamImpl<T>
    implements BigQueryServices.BigQueryServerStream<T> {
        private final ServerStream<T> serverStream;

        public BigQueryServerStreamImpl(ServerStream<T> serverStream) {
            this.serverStream = serverStream;
        }

        @Override
        public Iterator<T> iterator() {
            return this.serverStream.iterator();
        }

        @Override
        public void cancel() {
            this.serverStream.cancel();
        }
    }
}

