/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.services;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.Table;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.cloud.flink.bigquery.common.config.CredentialsOptions;
import dev.failsafe.Failsafe;
import dev.failsafe.FailsafeExecutor;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import dev.failsafe.function.CheckedSupplier;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.Arrays;
import java.util.UUID;
import org.apache.flink.FlinkVersion;
import org.apache.flink.annotation.Internal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class BigQueryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryUtils.class);
    static final Long BACKOFF_DELAY_IN_SECONDS = 5L;
    static final Long BACKOFF_MAX_DELAY_IN_MINUTES = 5L;
    static final Double RETRY_JITTER_PROB = 0.2;
    static Integer maxRetryCount = 3;
    private static final JsonFactory JSON_FACTORY;
    private static final HttpTransport HTTP_TRANSPORT;

    private BigQueryUtils() {
    }

    public static Bigquery.Builder newBigqueryBuilder(CredentialsOptions options) {
        return new Bigquery.Builder(HTTP_TRANSPORT, JSON_FACTORY, (HttpRequestInitializer)new HttpCredentialsAdapter(options.getCredentials())).setApplicationName("BigQuery Connector for Apache Flink version " + FlinkVersion.current().toString());
    }

    public static String bqSanitizedRandomUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String bqSanitizedRandomUUIDForDescriptor() {
        return "D" + UUID.randomUUID().toString().replaceAll("-", "_");
    }

    static <T> FailsafeExecutor<T> buildRetriableExecutorForOperation(String operationName) {
        return Failsafe.with((Policy)((RetryPolicyBuilder)RetryPolicy.builder().handle(Arrays.asList(IOException.class))).withMaxAttempts(maxRetryCount.intValue()).withBackoff(Duration.ofSeconds(BACKOFF_DELAY_IN_SECONDS), Duration.ofMinutes(BACKOFF_MAX_DELAY_IN_MINUTES)).withJitter(RETRY_JITTER_PROB.doubleValue()).onFailedAttempt(e -> LOG.error("Execution failed for operation: " + operationName, e.getLastException())).onRetry(r -> LOG.info("Retrying operation {}, for {} time.", (Object)operationName, (Object)r.getExecutionCount())).onRetriesExceeded(e -> LOG.error("Failed to execute operation {}, retries exhausted.")).build(), (Policy[])new RetryPolicy[0]);
    }

    static <T> T executeOperation(FailsafeExecutor<T> failsafeExecutor, CheckedSupplier<T> operation) {
        return (T)failsafeExecutor.get(operation);
    }

    static Job runInsertJob(Bigquery client, String projectId, Job job) throws IOException {
        return (Job)client.jobs().insert(projectId, job).setPrettyPrint(Boolean.valueOf(false)).execute();
    }

    public static Job dryRunQuery(Bigquery client, String projectId, JobConfigurationQuery queryConfig, String location) throws InterruptedException, IOException {
        String jobId = "apacheflink_dryRun_" + BigQueryUtils.bqSanitizedRandomUUID();
        JobReference jobRef = new JobReference().setLocation(location).setProjectId(projectId).setJobId(jobId);
        Job job = new Job().setJobReference(jobRef).setConfiguration(new JobConfiguration().setQuery(queryConfig).setDryRun(Boolean.valueOf(true)));
        return (Job)BigQueryUtils.executeOperation(BigQueryUtils.buildRetriableExecutorForOperation(jobId), () -> BigQueryUtils.runInsertJob(client, projectId, job));
    }

    public static Job runQuery(Bigquery client, String projectId, JobConfigurationQuery queryConfig, String location) throws InterruptedException, IOException {
        String jobId = "apacheflink_queryjob_" + BigQueryUtils.bqSanitizedRandomUUID();
        JobReference jobRef = new JobReference().setLocation(location).setProjectId(projectId).setJobId(jobId);
        Job job = new Job().setJobReference(jobRef).setConfiguration(new JobConfiguration().setQuery(queryConfig).setDryRun(Boolean.valueOf(false)));
        return (Job)BigQueryUtils.executeOperation(BigQueryUtils.buildRetriableExecutorForOperation(jobId), () -> BigQueryUtils.runInsertJob(client, projectId, job));
    }

    public static Dataset datasetInfo(Bigquery client, String projectId, String datasetId) throws IOException, InterruptedException {
        return (Dataset)BigQueryUtils.executeOperation(BigQueryUtils.buildRetriableExecutorForOperation(String.format("GetDataset - %s.%s", projectId, datasetId)), () -> (Dataset)client.datasets().get(projectId, datasetId).setPrettyPrint(Boolean.valueOf(false)).execute());
    }

    public static Table tableInfo(Bigquery client, String projectId, String datasetId, String tableId) throws IOException, InterruptedException {
        return (Table)BigQueryUtils.executeOperation(BigQueryUtils.buildRetriableExecutorForOperation(String.format("GetTable - %s.%s.%s", projectId, datasetId, tableId)), () -> (Table)client.tables().get(projectId, datasetId, tableId).setPrettyPrint(Boolean.valueOf(false)).execute());
    }

    static {
        try {
            JSON_FACTORY = GsonFactory.getDefaultInstance();
            HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

