/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.services;

import com.google.cloud.flink.bigquery.common.utils.BigQueryPartitionUtils;
import com.google.cloud.flink.bigquery.services.TablePartitionInfo;
import java.util.Objects;
import org.apache.flink.annotation.Internal;

@Internal
public class PartitionIdWithInfoAndStatus {
    private final String partitionId;
    private final TablePartitionInfo info;
    private final BigQueryPartitionUtils.PartitionStatus status;

    public PartitionIdWithInfoAndStatus(String partitionId, TablePartitionInfo info, BigQueryPartitionUtils.PartitionStatus status) {
        this.partitionId = partitionId;
        this.info = info;
        this.status = status;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public TablePartitionInfo getInfo() {
        return this.info;
    }

    public BigQueryPartitionUtils.PartitionStatus getStatus() {
        return this.status;
    }

    public Boolean isCompleted() {
        return this.status.equals((Object)BigQueryPartitionUtils.PartitionStatus.COMPLETED);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getPartitionId(), this.getInfo(), this.getStatus()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PartitionIdWithInfoAndStatus other = (PartitionIdWithInfoAndStatus)obj;
        return Objects.equals(this.getPartitionId(), other.getPartitionId()) && Objects.equals(this.getInfo(), other.getInfo()) && this.getStatus() == other.getStatus();
    }

    public String toString() {
        return "PartitionIdWithInfoAndStatus{partitionId=" + this.partitionId + ", info=" + this.info + ", status=" + (Object)((Object)this.status) + '}';
    }
}

