/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.services;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.annotation.Internal;

@Internal
public class QueryResultInfo
implements Serializable {
    private final Status status;
    private final List<String> errorMessages;
    private final String destinationProject;
    private final String destinationDataset;
    private final String destinationTable;

    private QueryResultInfo(Status status, List<String> errors) {
        this.status = status;
        this.errorMessages = errors;
        this.destinationProject = null;
        this.destinationDataset = null;
        this.destinationTable = null;
    }

    private QueryResultInfo(Status status, String project, String dataset, String table) {
        this.status = status;
        this.errorMessages = Arrays.asList(new String[0]);
        this.destinationProject = project;
        this.destinationDataset = dataset;
        this.destinationTable = table;
    }

    public static QueryResultInfo failed(List<String> errors) {
        return new QueryResultInfo(Status.FAILED, errors);
    }

    public static QueryResultInfo succeed(String project, String dataset, String table) {
        return new QueryResultInfo(Status.SUCCEED, project, dataset, table);
    }

    public Status getStatus() {
        return this.status;
    }

    public Optional<List<String>> getErrorMessages() {
        return Optional.ofNullable(this.errorMessages);
    }

    public Optional<String> getDestinationProject() {
        return Optional.ofNullable(this.destinationProject);
    }

    public Optional<String> getDestinationDataset() {
        return Optional.ofNullable(this.destinationDataset);
    }

    public Optional<String> getDestinationTable() {
        return Optional.ofNullable(this.destinationTable);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getStatus(), this.getErrorMessages(), this.getDestinationProject(), this.getDestinationDataset(), this.getDestinationTable()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryResultInfo other = (QueryResultInfo)obj;
        return Objects.equals(this.destinationProject, other.destinationProject) && Objects.equals(this.destinationDataset, other.destinationDataset) && Objects.equals(this.destinationTable, other.destinationTable) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.errorMessages, other.errorMessages);
    }

    public String toString() {
        return "QueryResultInfo{status=" + (Object)((Object)this.status) + ", errorMessages=" + this.errorMessages + ", destinationProject=" + this.destinationProject + ", destinationDataset=" + this.destinationDataset + ", destinationTable=" + this.destinationTable + '}';
    }

    public static enum Status {
        SUCCEED,
        FAILED;

    }
}

