/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.services;

import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.flink.bigquery.common.utils.BigQueryPartitionUtils;
import com.google.cloud.flink.bigquery.services.PartitionIdWithInfo;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;

@Internal
public class TablePartitionInfo {
    private final String columnName;
    private final StandardSQLTypeName columnType;
    private final BigQueryPartitionUtils.PartitionType partitionType;
    private final Instant streamingBufferOldestEntryTime;

    public TablePartitionInfo(String columnName, BigQueryPartitionUtils.PartitionType partitionType, StandardSQLTypeName columnType, Instant streamingBufferOldestEntryTime) {
        this.columnName = columnName;
        this.columnType = columnType;
        this.partitionType = partitionType;
        this.streamingBufferOldestEntryTime = streamingBufferOldestEntryTime;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public StandardSQLTypeName getColumnType() {
        return this.columnType;
    }

    public BigQueryPartitionUtils.PartitionType getPartitionType() {
        return this.partitionType;
    }

    public Instant getStreamingBufferOldestEntryTime() {
        return this.streamingBufferOldestEntryTime;
    }

    public List<PartitionIdWithInfo> toPartitionsWithInfo(List<String> partitionIds) {
        return Optional.ofNullable(partitionIds).map(ps -> ps.stream().map(id -> new PartitionIdWithInfo((String)id, this)).collect(Collectors.toList())).orElse(Arrays.asList(new PartitionIdWithInfo[0]));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columnName, this.columnType, this.partitionType, this.streamingBufferOldestEntryTime});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TablePartitionInfo other = (TablePartitionInfo)obj;
        return Objects.equals(this.columnName, other.columnName) && this.columnType == other.columnType && this.partitionType == other.partitionType && Objects.equals(this.streamingBufferOldestEntryTime, other.streamingBufferOldestEntryTime);
    }

    public String toString() {
        return "TablePartitionInfo{columnName=" + this.columnName + ", columnType=" + this.columnType + ", partitionType=" + (Object)((Object)this.partitionType) + ", streamingBufferOldestEntryTime=" + this.streamingBufferOldestEntryTime + '}';
    }
}

