/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.source.config;

import com.google.cloud.flink.bigquery.common.config.BigQueryConnectOptions;
import com.google.cloud.flink.bigquery.source.config.AutoValue_BigQueryReadOptions;
import com.google.cloud.flink.bigquery.source.config.BigQueryReadOptions;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

abstract class $AutoValue_BigQueryReadOptions
extends BigQueryReadOptions {
    private final List<String> columnNames;
    private final String rowRestriction;
    private final Optional<Long> snapshotTimestampInMillis;
    private final Optional<String> query;
    private final Optional<String> queryExecutionProject;
    private final Optional<Integer> limit;
    private final Optional<String> oldestPartitionId;
    private final Integer partitionDiscoveryRefreshIntervalInMinutes;
    private final Integer maxStreamCount;
    private final Integer maxRecordsPerSplitFetch;
    private final BigQueryConnectOptions bigQueryConnectOptions;

    $AutoValue_BigQueryReadOptions(List<String> columnNames, String rowRestriction, Optional<Long> snapshotTimestampInMillis, Optional<String> query, Optional<String> queryExecutionProject, Optional<Integer> limit, Optional<String> oldestPartitionId, Integer partitionDiscoveryRefreshIntervalInMinutes, Integer maxStreamCount, Integer maxRecordsPerSplitFetch, BigQueryConnectOptions bigQueryConnectOptions) {
        if (columnNames == null) {
            throw new NullPointerException("Null columnNames");
        }
        this.columnNames = columnNames;
        if (rowRestriction == null) {
            throw new NullPointerException("Null rowRestriction");
        }
        this.rowRestriction = rowRestriction;
        if (snapshotTimestampInMillis == null) {
            throw new NullPointerException("Null snapshotTimestampInMillis");
        }
        this.snapshotTimestampInMillis = snapshotTimestampInMillis;
        if (query == null) {
            throw new NullPointerException("Null query");
        }
        this.query = query;
        if (queryExecutionProject == null) {
            throw new NullPointerException("Null queryExecutionProject");
        }
        this.queryExecutionProject = queryExecutionProject;
        if (limit == null) {
            throw new NullPointerException("Null limit");
        }
        this.limit = limit;
        if (oldestPartitionId == null) {
            throw new NullPointerException("Null oldestPartitionId");
        }
        this.oldestPartitionId = oldestPartitionId;
        if (partitionDiscoveryRefreshIntervalInMinutes == null) {
            throw new NullPointerException("Null partitionDiscoveryRefreshIntervalInMinutes");
        }
        this.partitionDiscoveryRefreshIntervalInMinutes = partitionDiscoveryRefreshIntervalInMinutes;
        if (maxStreamCount == null) {
            throw new NullPointerException("Null maxStreamCount");
        }
        this.maxStreamCount = maxStreamCount;
        if (maxRecordsPerSplitFetch == null) {
            throw new NullPointerException("Null maxRecordsPerSplitFetch");
        }
        this.maxRecordsPerSplitFetch = maxRecordsPerSplitFetch;
        if (bigQueryConnectOptions == null) {
            throw new NullPointerException("Null bigQueryConnectOptions");
        }
        this.bigQueryConnectOptions = bigQueryConnectOptions;
    }

    @Override
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public String getRowRestriction() {
        return this.rowRestriction;
    }

    @Override
    public Optional<Long> getSnapshotTimestampInMillis() {
        return this.snapshotTimestampInMillis;
    }

    @Override
    public Optional<String> getQuery() {
        return this.query;
    }

    @Override
    public Optional<String> getQueryExecutionProject() {
        return this.queryExecutionProject;
    }

    @Override
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @Override
    public Optional<String> getOldestPartitionId() {
        return this.oldestPartitionId;
    }

    @Override
    public Integer getPartitionDiscoveryRefreshIntervalInMinutes() {
        return this.partitionDiscoveryRefreshIntervalInMinutes;
    }

    @Override
    public Integer getMaxStreamCount() {
        return this.maxStreamCount;
    }

    @Override
    public Integer getMaxRecordsPerSplitFetch() {
        return this.maxRecordsPerSplitFetch;
    }

    @Override
    public BigQueryConnectOptions getBigQueryConnectOptions() {
        return this.bigQueryConnectOptions;
    }

    public String toString() {
        return "BigQueryReadOptions{columnNames=" + this.columnNames + ", rowRestriction=" + this.rowRestriction + ", snapshotTimestampInMillis=" + this.snapshotTimestampInMillis + ", query=" + this.query + ", queryExecutionProject=" + this.queryExecutionProject + ", limit=" + this.limit + ", oldestPartitionId=" + this.oldestPartitionId + ", partitionDiscoveryRefreshIntervalInMinutes=" + this.partitionDiscoveryRefreshIntervalInMinutes + ", maxStreamCount=" + this.maxStreamCount + ", maxRecordsPerSplitFetch=" + this.maxRecordsPerSplitFetch + ", bigQueryConnectOptions=" + this.bigQueryConnectOptions + "}";
    }

    @Override
    public BigQueryReadOptions.Builder toBuilder() {
        return new Builder(this);
    }

    static class Builder
    extends BigQueryReadOptions.Builder {
        private List<String> columnNames;
        private String rowRestriction;
        private Optional<Long> snapshotTimestampInMillis = Optional.empty();
        private Optional<String> query = Optional.empty();
        private Optional<String> queryExecutionProject = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<String> oldestPartitionId = Optional.empty();
        private Integer partitionDiscoveryRefreshIntervalInMinutes;
        private Integer maxStreamCount;
        private Integer maxRecordsPerSplitFetch;
        private BigQueryConnectOptions bigQueryConnectOptions;

        Builder() {
        }

        private Builder(BigQueryReadOptions source) {
            this.columnNames = source.getColumnNames();
            this.rowRestriction = source.getRowRestriction();
            this.snapshotTimestampInMillis = source.getSnapshotTimestampInMillis();
            this.query = source.getQuery();
            this.queryExecutionProject = source.getQueryExecutionProject();
            this.limit = source.getLimit();
            this.oldestPartitionId = source.getOldestPartitionId();
            this.partitionDiscoveryRefreshIntervalInMinutes = source.getPartitionDiscoveryRefreshIntervalInMinutes();
            this.maxStreamCount = source.getMaxStreamCount();
            this.maxRecordsPerSplitFetch = source.getMaxRecordsPerSplitFetch();
            this.bigQueryConnectOptions = source.getBigQueryConnectOptions();
        }

        @Override
        public BigQueryReadOptions.Builder setColumnNames(List<String> columnNames) {
            if (columnNames == null) {
                throw new NullPointerException("Null columnNames");
            }
            this.columnNames = columnNames;
            return this;
        }

        @Override
        public BigQueryReadOptions.Builder setRowRestriction(String rowRestriction) {
            if (rowRestriction == null) {
                throw new NullPointerException("Null rowRestriction");
            }
            this.rowRestriction = rowRestriction;
            return this;
        }

        @Override
        public BigQueryReadOptions.Builder setSnapshotTimestampInMillis(@Nullable Long snapshotTimestampInMillis) {
            this.snapshotTimestampInMillis = Optional.ofNullable(snapshotTimestampInMillis);
            return this;
        }

        @Override
        public BigQueryReadOptions.Builder setQuery(@Nullable String query) {
            this.query = Optional.ofNullable(query);
            return this;
        }

        @Override
        public BigQueryReadOptions.Builder setQueryExecutionProject(@Nullable String queryExecutionProject) {
            this.queryExecutionProject = Optional.ofNullable(queryExecutionProject);
            return this;
        }

        @Override
        public BigQueryReadOptions.Builder setLimit(@Nullable Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @Override
        public BigQueryReadOptions.Builder setOldestPartitionId(@Nullable String oldestPartitionId) {
            this.oldestPartitionId = Optional.ofNullable(oldestPartitionId);
            return this;
        }

        @Override
        public BigQueryReadOptions.Builder setPartitionDiscoveryRefreshIntervalInMinutes(Integer partitionDiscoveryRefreshIntervalInMinutes) {
            if (partitionDiscoveryRefreshIntervalInMinutes == null) {
                throw new NullPointerException("Null partitionDiscoveryRefreshIntervalInMinutes");
            }
            this.partitionDiscoveryRefreshIntervalInMinutes = partitionDiscoveryRefreshIntervalInMinutes;
            return this;
        }

        @Override
        public BigQueryReadOptions.Builder setMaxStreamCount(Integer maxStreamCount) {
            if (maxStreamCount == null) {
                throw new NullPointerException("Null maxStreamCount");
            }
            this.maxStreamCount = maxStreamCount;
            return this;
        }

        @Override
        public BigQueryReadOptions.Builder setMaxRecordsPerSplitFetch(Integer maxRecordsPerSplitFetch) {
            if (maxRecordsPerSplitFetch == null) {
                throw new NullPointerException("Null maxRecordsPerSplitFetch");
            }
            this.maxRecordsPerSplitFetch = maxRecordsPerSplitFetch;
            return this;
        }

        @Override
        public BigQueryReadOptions.Builder setBigQueryConnectOptions(BigQueryConnectOptions bigQueryConnectOptions) {
            if (bigQueryConnectOptions == null) {
                throw new NullPointerException("Null bigQueryConnectOptions");
            }
            this.bigQueryConnectOptions = bigQueryConnectOptions;
            return this;
        }

        @Override
        BigQueryReadOptions autoBuild() {
            if (this.columnNames == null || this.rowRestriction == null || this.partitionDiscoveryRefreshIntervalInMinutes == null || this.maxStreamCount == null || this.maxRecordsPerSplitFetch == null || this.bigQueryConnectOptions == null) {
                StringBuilder missing = new StringBuilder();
                if (this.columnNames == null) {
                    missing.append(" columnNames");
                }
                if (this.rowRestriction == null) {
                    missing.append(" rowRestriction");
                }
                if (this.partitionDiscoveryRefreshIntervalInMinutes == null) {
                    missing.append(" partitionDiscoveryRefreshIntervalInMinutes");
                }
                if (this.maxStreamCount == null) {
                    missing.append(" maxStreamCount");
                }
                if (this.maxRecordsPerSplitFetch == null) {
                    missing.append(" maxRecordsPerSplitFetch");
                }
                if (this.bigQueryConnectOptions == null) {
                    missing.append(" bigQueryConnectOptions");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BigQueryReadOptions(this.columnNames, this.rowRestriction, this.snapshotTimestampInMillis, this.query, this.queryExecutionProject, this.limit, this.oldestPartitionId, this.partitionDiscoveryRefreshIntervalInMinutes, this.maxStreamCount, this.maxRecordsPerSplitFetch, this.bigQueryConnectOptions);
        }
    }
}

