/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.source.config;

import com.google.auto.value.AutoValue;
import com.google.cloud.flink.bigquery.common.config.BigQueryConnectOptions;
import com.google.cloud.flink.bigquery.common.config.CredentialsOptions;
import com.google.cloud.flink.bigquery.source.config.$AutoValue_BigQueryReadOptions;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;
import org.threeten.bp.Instant;

@AutoValue
@PublicEvolving
public abstract class BigQueryReadOptions
implements Serializable {
    public abstract List<String> getColumnNames();

    public abstract String getRowRestriction();

    public abstract Optional<Long> getSnapshotTimestampInMillis();

    public abstract Optional<String> getQuery();

    public abstract Optional<String> getQueryExecutionProject();

    public abstract Optional<Integer> getLimit();

    public abstract Optional<String> getOldestPartitionId();

    public abstract Integer getPartitionDiscoveryRefreshIntervalInMinutes();

    public abstract Integer getMaxStreamCount();

    public abstract Integer getMaxRecordsPerSplitFetch();

    public abstract BigQueryConnectOptions getBigQueryConnectOptions();

    public final int hashCode() {
        return Objects.hash(this.getColumnNames(), this.getRowRestriction(), this.getSnapshotTimestampInMillis(), this.getMaxStreamCount(), this.getBigQueryConnectOptions());
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigQueryReadOptions other = (BigQueryReadOptions)obj;
        return Objects.equals(this.getColumnNames(), other.getColumnNames()) && Objects.equals(this.getRowRestriction(), other.getRowRestriction()) && Objects.equals(this.getSnapshotTimestampInMillis(), other.getSnapshotTimestampInMillis()) && Objects.equals(this.getMaxStreamCount(), other.getMaxStreamCount()) && Objects.equals(this.getBigQueryConnectOptions(), other.getBigQueryConnectOptions());
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new $AutoValue_BigQueryReadOptions.Builder().setRowRestriction("").setColumnNames(Arrays.asList(new String[0])).setMaxStreamCount(0).setMaxRecordsPerSplitFetch(10000).setSnapshotTimestampInMillis(null).setPartitionDiscoveryRefreshIntervalInMinutes(10);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public Builder setQueryAndExecutionProject(String query, String projectId) throws IOException {
            return this.setQueryWithExecutionProjectAndCredentialsOptions(query, projectId, CredentialsOptions.builder().build());
        }

        public Builder setQueryWithExecutionProjectAndCredentialsOptions(String query, String projectId, CredentialsOptions credentialsOptions) throws IOException {
            this.setQuery(query);
            this.setQueryExecutionProject(projectId);
            this.setBigQueryConnectOptions(BigQueryConnectOptions.builderForQuerySource().setCredentialsOptions(credentialsOptions).build());
            return this;
        }

        public abstract Builder setQuery(@Nullable String var1);

        public abstract Builder setQueryExecutionProject(@Nullable String var1);

        public abstract Builder setOldestPartitionId(@Nullable String var1);

        public abstract Builder setPartitionDiscoveryRefreshIntervalInMinutes(Integer var1);

        public abstract Builder setLimit(@Nullable Integer var1);

        public abstract Builder setRowRestriction(String var1);

        public abstract Builder setColumnNames(List<String> var1);

        public abstract Builder setSnapshotTimestampInMillis(@Nullable Long var1);

        public abstract Builder setMaxStreamCount(Integer var1);

        public abstract Builder setMaxRecordsPerSplitFetch(Integer var1);

        public abstract Builder setBigQueryConnectOptions(BigQueryConnectOptions var1);

        abstract BigQueryReadOptions autoBuild();

        public final BigQueryReadOptions build() {
            BigQueryReadOptions readOptions = this.autoBuild();
            Preconditions.checkState((readOptions.getMaxStreamCount() >= 0 ? 1 : 0) != 0, (Object)"The max number of streams should be zero or positive.");
            Preconditions.checkState((!readOptions.getSnapshotTimestampInMillis().filter(timeInMillis -> timeInMillis < Instant.EPOCH.toEpochMilli()).isPresent() ? 1 : 0) != 0, (Object)"The oldest timestamp should be equal or bigger than epoch.");
            Preconditions.checkState((!readOptions.getQuery().filter(unusedQuery -> readOptions.getQueryExecutionProject() == null).isPresent() ? 1 : 0) != 0, (Object)"If a query is configured, then a GCP project should be provided.");
            return readOptions;
        }
    }
}

