/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.source.split;

import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.flink.bigquery.common.config.BigQueryConnectOptions;
import com.google.cloud.flink.bigquery.common.exceptions.BigQueryConnectorException;
import com.google.cloud.flink.bigquery.services.BigQueryServices;
import com.google.cloud.flink.bigquery.services.BigQueryServicesFactory;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class SplitDiscoverer {
    private static final Logger LOG = LoggerFactory.getLogger(SplitDiscoverer.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> discoverSplits(BigQueryConnectOptions connectionOptions, DataFormat format, List<String> columnNames, String rowRestriction, Optional<Long> snapshotTimeInMillis, Integer maxStreamCount) {
        try (BigQueryServices.StorageReadClient client = BigQueryServicesFactory.instance(connectionOptions).storageRead();){
            String parent = String.format("projects/%s", connectionOptions.getProjectId());
            String srcTable = String.format("projects/%s/datasets/%s/tables/%s", connectionOptions.getProjectId(), connectionOptions.getDataset(), connectionOptions.getTable());
            ReadSession.TableReadOptions.Builder optionsBuilder = ReadSession.TableReadOptions.newBuilder();
            columnNames.forEach(name -> optionsBuilder.addSelectedFields(name));
            optionsBuilder.setRowRestriction(rowRestriction);
            ReadSession.TableReadOptions options = optionsBuilder.build();
            ReadSession.Builder sessionBuilder = ReadSession.newBuilder().setTable(srcTable).setDataFormat(format).setReadOptions(options);
            if (snapshotTimeInMillis.isPresent()) {
                long snapshotTimestampInMs = snapshotTimeInMillis.get();
                Timestamp t = Timestamp.newBuilder().setSeconds(snapshotTimestampInMs / 1000L).setNanos((int)(snapshotTimestampInMs % 1000L * 1000000L)).build();
                ReadSession.TableModifiers modifiers = ReadSession.TableModifiers.newBuilder().setSnapshotTime(t).build();
                sessionBuilder.setTableModifiers(modifiers);
            }
            CreateReadSessionRequest.Builder builder = CreateReadSessionRequest.newBuilder().setParent(parent).setReadSession(sessionBuilder).setMaxStreamCount(maxStreamCount.intValue());
            ReadSession session = client.createReadSession(builder.build());
            LOG.info("BigQuery Storage Read session, name: {}, estimated row count {}, estimated scanned bytes {}, streams count {}, expired time {} (seconds after epoch),  format: {}, column names: {}, row restriction: \"{}\", snapshot time: {}, max stream count: {}.", new Object[]{session.getName(), session.getEstimatedRowCount(), session.getEstimatedTotalBytesScanned(), session.getStreamsCount(), session.getExpireTime().getSeconds(), format, columnNames, rowRestriction, snapshotTimeInMillis, maxStreamCount});
            List<String> list = session.getStreamsList().stream().map(stream -> stream.getName()).collect(Collectors.toList());
            return list;
        }
        catch (IOException ex) {
            throw new BigQueryConnectorException("Problems creating the BigQuery Storage Read session.", ex);
        }
    }
}

