/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.invoker.runner;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.google.cloud.functions.HttpFunction;
import com.google.cloud.functions.invoker.BackgroundFunctionExecutor;
import com.google.cloud.functions.invoker.HttpFunctionExecutor;
import com.google.cloud.functions.invoker.gcf.JsonLogHandler;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class Invoker {
    private static final Logger rootLogger = Logger.getLogger("");
    private static final Logger logger = Logger.getLogger(Invoker.class.getName());
    private final Integer port;
    private final String functionTarget;
    private final String functionSignatureType;
    private final ClassLoader functionClassLoader;

    public static void main(String[] args) throws Exception {
        Optional<Invoker> invoker = Invoker.makeInvoker(args);
        if (invoker.isPresent()) {
            invoker.get().startServer();
        }
    }

    static Optional<Invoker> makeInvoker(String ... args) {
        return Invoker.makeInvoker(System.getenv(), args);
    }

    static Optional<Invoker> makeInvoker(Map<String, String> environment, String ... args) {
        int port;
        Options options = new Options();
        JCommander jCommander = JCommander.newBuilder().addObject(options).build();
        try {
            jCommander.parse(args);
        }
        catch (ParameterException e) {
            Invoker.usage(jCommander);
            throw e;
        }
        if (options.help) {
            Invoker.usage(jCommander);
            return Optional.empty();
        }
        try {
            port = Integer.parseInt(options.port);
        }
        catch (NumberFormatException e) {
            System.err.println("--port value should be an integer: " + options.port);
            Invoker.usage(jCommander);
            throw e;
        }
        String functionTarget = options.target;
        Path standardFunctionJarPath = Paths.get("function/function.jar", new String[0]);
        Optional<String> functionClasspath = Arrays.asList(options.classPath, environment.get("FUNCTION_CLASSPATH"), Files.exists(standardFunctionJarPath, new LinkOption[0]) ? standardFunctionJarPath.toString() : null).stream().filter(Objects::nonNull).findFirst();
        ClassLoader functionClassLoader = Invoker.makeClassLoader(functionClasspath);
        Invoker invoker = new Invoker(port, functionTarget, environment.get("FUNCTION_SIGNATURE_TYPE"), functionClassLoader);
        return Optional.of(invoker);
    }

    private static void usage(JCommander jCommander) {
        StringBuilder usageBuilder = new StringBuilder();
        jCommander.getUsageFormatter().usage(usageBuilder);
        String usage = usageBuilder.toString().replace("${file.separator}", File.separator).replace("${path.separator}", File.pathSeparator);
        jCommander.getConsole().println(usage);
    }

    private static ClassLoader makeClassLoader(Optional<String> functionClasspath) {
        ClassLoader runtimeLoader = Invoker.class.getClassLoader();
        if (functionClasspath.isPresent()) {
            OnlyApiClassLoader parent = new OnlyApiClassLoader(runtimeLoader);
            return new FunctionClassLoader(Invoker.classpathToUrls(functionClasspath.get()), (ClassLoader)parent);
        }
        return runtimeLoader;
    }

    public Invoker(Integer port, String functionTarget, String functionSignatureType, ClassLoader functionClassLoader) {
        this.port = port;
        this.functionTarget = functionTarget;
        this.functionSignatureType = functionSignatureType;
        this.functionClassLoader = functionClassLoader;
    }

    Integer getPort() {
        return this.port;
    }

    String getFunctionTarget() {
        return this.functionTarget;
    }

    String getFunctionSignatureType() {
        return this.functionSignatureType;
    }

    ClassLoader getFunctionClassLoader() {
        return this.functionClassLoader;
    }

    public void startServer() throws Exception {
        HttpServlet servlet;
        Server server = new Server(this.port);
        ServletContextHandler servletContextHandler = new ServletContextHandler();
        servletContextHandler.setContextPath("/");
        server.setHandler(NotFoundHandler.forServlet(servletContextHandler));
        Class<?> functionClass = this.loadFunctionClass();
        if ("http".equals(this.functionSignatureType)) {
            servlet = HttpFunctionExecutor.forClass(functionClass);
        } else if ("event".equals(this.functionSignatureType)) {
            servlet = BackgroundFunctionExecutor.forClass(functionClass);
        } else if (this.functionSignatureType == null) {
            servlet = this.servletForDeducedSignatureType(functionClass);
        } else {
            String error = String.format("Function signature type %s is unknown; should be \"http\" or \"event\"", this.functionSignatureType);
            throw new RuntimeException(error);
        }
        ServletHolder servletHolder = new ServletHolder(servlet);
        servletHolder.getRegistration().setMultipartConfig(new MultipartConfigElement(""));
        servletContextHandler.addServlet(servletHolder, "/*");
        server.start();
        this.logServerInfo();
        server.join();
    }

    private Class<?> loadFunctionClass() throws ClassNotFoundException {
        Object target = this.functionTarget;
        ClassNotFoundException firstException = null;
        while (true) {
            try {
                return this.functionClassLoader.loadClass((String)target);
            }
            catch (ClassNotFoundException e) {
                int lastDot;
                if (firstException == null) {
                    firstException = e;
                }
                if ((lastDot = ((String)target).lastIndexOf(46)) < 0) {
                    throw firstException;
                }
                target = ((String)target).substring(0, lastDot) + "$" + ((String)target).substring(lastDot + 1);
                continue;
            }
            break;
        }
    }

    private HttpServlet servletForDeducedSignatureType(Class<?> functionClass) {
        if (HttpFunction.class.isAssignableFrom(functionClass)) {
            return HttpFunctionExecutor.forClass(functionClass);
        }
        Optional<BackgroundFunctionExecutor> maybeExecutor = BackgroundFunctionExecutor.maybeForClass(functionClass);
        if (maybeExecutor.isPresent()) {
            return maybeExecutor.get();
        }
        String error = String.format("Could not determine function signature type from target %s. Either this should be a class implementing one of the interfaces in com.google.cloud.functions, or the environment variable FUNCTION_SIGNATURE_TYPE should be set to \"http\" or \"event\".", this.functionTarget);
        throw new RuntimeException(error);
    }

    static URL[] classpathToUrls(String classpath) {
        String[] components = classpath.split(File.pathSeparator);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String component : components) {
            if (component.endsWith(File.separator + "*")) {
                urls.addAll(Invoker.jarsIn(component.substring(0, component.length() - 2)));
                continue;
            }
            Path path = Paths.get(component, new String[0]);
            try {
                urls.add(path.toUri().toURL());
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException(e);
            }
        }
        return urls.toArray(new URL[0]);
    }

    private static List<URL> jarsIn(String dir) {
        Stream<Path> stream;
        Path path = Paths.get(dir, new String[0]);
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try {
            stream = Files.list(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return stream.filter(p -> p.getFileName().toString().endsWith(".jar")).map(p -> {
            try {
                return p.toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException(e);
            }
        }).collect(Collectors.toList());
    }

    private void logServerInfo() {
        if (!Invoker.isGcf()) {
            logger.log(Level.INFO, "Serving function...");
            logger.log(Level.INFO, "Function: {0}", this.functionTarget);
            logger.log(Level.INFO, "URL: http://localhost:{0,number,#}/", this.port);
        }
    }

    private static boolean isGcf() {
        return System.getenv("K_SERVICE") != null;
    }

    static {
        if (Invoker.isGcf()) {
            for (Handler handler : rootLogger.getHandlers()) {
                rootLogger.removeHandler(handler);
            }
            rootLogger.addHandler(new JsonLogHandler(System.out, false));
        }
    }

    private static class OnlyApiClassLoader
    extends ClassLoader {
        private final ClassLoader runtimeClassLoader;
        private static final String CLOUD_EVENTS_API_PREFIX = "io.cloudevents.";
        private static final int CLOUD_EVENTS_API_PREFIX_LENGTH = "io.cloudevents.".length();

        OnlyApiClassLoader(ClassLoader runtimeClassLoader) {
            super(OnlyApiClassLoader.getSystemOrBootstrapClassLoader());
            this.runtimeClassLoader = runtimeClassLoader;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            String prefix = "com.google.cloud.functions.";
            if (name.startsWith(prefix) && Character.isUpperCase(name.charAt(prefix.length())) || name.startsWith("javax.servlet.") || OnlyApiClassLoader.isCloudEventsApiClass(name)) {
                return this.runtimeClassLoader.loadClass(name);
            }
            return super.findClass(name);
        }

        private static boolean isCloudEventsApiClass(String name) {
            return name.startsWith(CLOUD_EVENTS_API_PREFIX) && Character.isUpperCase(name.charAt(CLOUD_EVENTS_API_PREFIX_LENGTH));
        }

        private static ClassLoader getSystemOrBootstrapClassLoader() {
            try {
                Method getPlatformClassLoader = ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]);
                return (ClassLoader)getPlatformClassLoader.invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                return null;
            }
        }
    }

    private static class NotFoundHandler
    extends HandlerWrapper {
        private static final Set<String> NOT_FOUND_PATHS = new HashSet<String>(Arrays.asList("/favicon.ico", "/robots.txt"));

        private NotFoundHandler() {
        }

        static NotFoundHandler forServlet(ServletContextHandler servletHandler) {
            NotFoundHandler handler = new NotFoundHandler();
            handler.setHandler(servletHandler);
            return handler;
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (NOT_FOUND_PATHS.contains(request.getRequestURI())) {
                response.sendError(404, "Not Found");
            }
            super.handle(target, baseRequest, request, response);
        }
    }

    private static class FunctionClassLoader
    extends URLClassLoader {
        FunctionClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }
    }

    private static class Options {
        @Parameter(description="Port on which to listen for HTTP requests.", names={"--port"})
        private String port = System.getenv().getOrDefault("PORT", "8080");
        @Parameter(description="Name of function class to execute when servicing incoming requests.", names={"--target"})
        private String target = System.getenv().getOrDefault("FUNCTION_TARGET", "Function");
        @Parameter(description="List of files or directories where the compiled Java classes making up the function will be found. This functions like the -classpath option to the java command. It is a list of filenames separated by '${path.separator}'. If an entry in the list names a directory then the class foo.bar.Baz will be looked for in foo${file.separator}bar${file.separator}Baz.class under that directory. If an entry in the list names a file and that file is a jar file then class foo.bar.Baz will be looked for in an entry foo/bar/Baz.class in that jar file. If an entry is a directory followed by '${file.separator}*' then every file in the directory whose name ends with '.jar' will be searched for classes.", names={"--classpath"})
        private String classPath = null;
        @Parameter(names={"--help"}, help=true)
        private boolean help = false;

        private Options() {
        }
    }
}

