/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.extensions;

import io.cloudevents.CloudEventExtensions;
import io.cloudevents.Extension;
import io.cloudevents.core.extensions.impl.ExtensionUtils;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class DatarefExtension
implements Extension {
    public static final String DATAREF = "dataref";
    private static final Set<String> KEY_SET = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("dataref")));
    private URI dataref;

    public URI getDataref() {
        return this.dataref;
    }

    public void setDataref(URI dataref) {
        this.dataref = dataref;
    }

    @Override
    public void readFrom(CloudEventExtensions extensions) {
        Object value = extensions.getExtension(DATAREF);
        if (value != null) {
            this.dataref = URI.create(value.toString());
        }
    }

    @Override
    public Object getValue(String key) {
        if (DATAREF.equals(key)) {
            return this.dataref;
        }
        throw ExtensionUtils.generateInvalidKeyException(this.getClass().getSimpleName(), key);
    }

    @Override
    public Set<String> getKeys() {
        return KEY_SET;
    }

    public String toString() {
        return "DatarefExtension{dataref='" + this.dataref + '\'' + '}';
    }

    public int hashCode() {
        int prime = 31;
        return 31 + (this.dataref == null ? 0 : this.dataref.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatarefExtension other = (DatarefExtension)obj;
        if (this.dataref == null) {
            return other.dataref == null;
        }
        return this.dataref.equals(other.dataref);
    }
}

