/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.impl;

import io.cloudevents.CloudEvent;
import io.cloudevents.rw.CloudEventAttributesWriter;
import io.cloudevents.rw.CloudEventExtensionsWriter;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventReader;
import io.cloudevents.rw.CloudEventWriter;
import io.cloudevents.rw.CloudEventWriterFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class BaseCloudEvent
implements CloudEvent,
CloudEventReader {
    private final byte[] data;
    protected final Map<String, Object> extensions;

    protected BaseCloudEvent(byte[] data, Map<String, Object> extensions) {
        this.data = data;
        this.extensions = extensions != null ? extensions : new HashMap();
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public Object getExtension(String extensionName) {
        return this.extensions.get(extensionName);
    }

    @Override
    public Set<String> getExtensionNames() {
        return this.extensions.keySet();
    }

    public <T extends CloudEventWriter<V>, V> V read(CloudEventWriterFactory<T, V> writerFactory) throws CloudEventRWException, IllegalStateException {
        T visitor = writerFactory.create(this.getSpecVersion());
        this.readAttributes((CloudEventAttributesWriter)visitor);
        this.readExtensions((CloudEventExtensionsWriter)visitor);
        if (this.data != null) {
            return visitor.end(this.data);
        }
        return visitor.end();
    }

    @Override
    public void readExtensions(CloudEventExtensionsWriter visitor) throws CloudEventRWException {
        for (Map.Entry<String, Object> entry : this.extensions.entrySet()) {
            if (entry.getValue() instanceof String) {
                visitor.setExtension(entry.getKey(), (String)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Number) {
                visitor.setExtension(entry.getKey(), (Number)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Boolean) {
                visitor.setExtension(entry.getKey(), (Boolean)entry.getValue());
                continue;
            }
            throw new IllegalStateException("Illegal value inside extensions map: " + entry);
        }
    }
}

