/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.impl;

import io.cloudevents.CloudEvent;
import io.cloudevents.rw.CloudEventAttributesWriter;
import io.cloudevents.rw.CloudEventExtensionsWriter;
import io.cloudevents.rw.CloudEventReader;
import io.cloudevents.rw.CloudEventWriter;
import io.cloudevents.rw.CloudEventWriterFactory;

public class CloudEventReaderAdapter
implements CloudEventReader {
    private CloudEvent event;

    CloudEventReaderAdapter(CloudEvent event) {
        this.event = event;
    }

    @Override
    public <V extends CloudEventWriter<R>, R> R read(CloudEventWriterFactory<V, R> writerFactory) throws RuntimeException {
        V visitor = writerFactory.create(this.event.getSpecVersion());
        this.readAttributes((CloudEventAttributesWriter)visitor);
        this.readExtensions((CloudEventExtensionsWriter)visitor);
        if (this.event.getData() != null) {
            return visitor.end(this.event.getData());
        }
        return visitor.end();
    }

    @Override
    public void readAttributes(CloudEventAttributesWriter writer) throws RuntimeException {
        writer.setAttribute("id", this.event.getId());
        writer.setAttribute("source", this.event.getSource());
        writer.setAttribute("type", this.event.getType());
        if (this.event.getDataContentType() != null) {
            writer.setAttribute("datacontenttype", this.event.getDataContentType());
        }
        if (this.event.getDataSchema() != null) {
            writer.setAttribute("dataschema", this.event.getDataSchema());
        }
        if (this.event.getSubject() != null) {
            writer.setAttribute("subject", this.event.getSubject());
        }
        if (this.event.getTime() != null) {
            writer.setAttribute("time", this.event.getTime());
        }
    }

    @Override
    public void readExtensions(CloudEventExtensionsWriter visitor) throws RuntimeException {
        for (String key : this.event.getExtensionNames()) {
            Object value = this.event.getExtension(key);
            if (value instanceof String) {
                visitor.setExtension(key, (String)value);
                continue;
            }
            if (value instanceof Number) {
                visitor.setExtension(key, (Number)value);
                continue;
            }
            if (value instanceof Boolean) {
                visitor.setExtension(key, (Boolean)value);
                continue;
            }
            throw new IllegalStateException("Illegal value inside extensions map: " + key + " " + value);
        }
    }
}

