/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.message.impl;

import io.cloudevents.SpecVersion;
import io.cloudevents.core.message.impl.BaseBinaryMessageReader;
import io.cloudevents.rw.CloudEventAttributesWriter;
import io.cloudevents.rw.CloudEventExtensionsWriter;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventWriter;
import io.cloudevents.rw.CloudEventWriterFactory;
import java.util.Objects;
import java.util.function.BiConsumer;

public abstract class BaseGenericBinaryMessageReaderImpl<HK, HV>
extends BaseBinaryMessageReader {
    private final SpecVersion version;
    private final byte[] body;

    protected BaseGenericBinaryMessageReaderImpl(SpecVersion version, byte[] body) {
        Objects.requireNonNull(version);
        this.version = version;
        this.body = body;
    }

    public <T extends CloudEventWriter<V>, V> V read(CloudEventWriterFactory<T, V> writerFactory) throws CloudEventRWException, IllegalStateException {
        Object visitor = writerFactory.create(this.version);
        this.forEachHeader((key, value) -> {
            if (this.isContentTypeHeader(key)) {
                visitor.setAttribute("datacontenttype", this.toCloudEventsValue(value));
            } else if (this.isCloudEventsHeader(key)) {
                String name = this.toCloudEventsKey(key);
                if (name.equals("specversion")) {
                    return;
                }
                if (this.version.getAllAttributes().contains(name)) {
                    visitor.setAttribute(name, this.toCloudEventsValue(value));
                } else {
                    visitor.setExtension(name, this.toCloudEventsValue(value));
                }
            }
        });
        if (this.body != null && this.body.length != 0) {
            return visitor.end(this.body);
        }
        return visitor.end();
    }

    @Override
    public void readAttributes(CloudEventAttributesWriter writer) throws RuntimeException {
        this.forEachHeader((key, value) -> {
            if (this.isContentTypeHeader(key)) {
                writer.setAttribute("datacontenttype", this.toCloudEventsValue(value));
            } else if (this.isCloudEventsHeader(key)) {
                String name = this.toCloudEventsKey(key);
                if (name.equals("specversion")) {
                    return;
                }
                if (this.version.getAllAttributes().contains(name)) {
                    writer.setAttribute(name, this.toCloudEventsValue(value));
                }
            }
        });
    }

    @Override
    public void readExtensions(CloudEventExtensionsWriter visitor) throws RuntimeException {
        this.forEachHeader((key, value) -> {
            if (this.isCloudEventsHeader(key)) {
                String name = this.toCloudEventsKey(key);
                if (!this.version.getAllAttributes().contains(name)) {
                    visitor.setExtension(name, this.toCloudEventsValue(value));
                }
            }
        });
    }

    protected abstract boolean isContentTypeHeader(HK var1);

    protected abstract boolean isCloudEventsHeader(HK var1);

    protected abstract String toCloudEventsKey(HK var1);

    protected abstract void forEachHeader(BiConsumer<HK, HV> var1);

    protected abstract String toCloudEventsValue(HV var1);
}

