/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.v1;

import io.cloudevents.SpecVersion;
import io.cloudevents.core.impl.BaseCloudEvent;
import io.cloudevents.core.v1.ContextAttributes;
import io.cloudevents.rw.CloudEventAttributesWriter;
import io.cloudevents.rw.CloudEventRWException;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public final class CloudEventV1
extends BaseCloudEvent {
    private final String id;
    private final URI source;
    private final String type;
    private final String datacontenttype;
    private final URI dataschema;
    private final String subject;
    private final OffsetDateTime time;

    public CloudEventV1(String id, URI source, String type, String datacontenttype, URI dataschema, String subject, OffsetDateTime time, byte[] data, Map<String, Object> extensions) {
        super(data, extensions);
        this.id = id;
        this.source = source;
        this.type = type;
        this.datacontenttype = datacontenttype;
        this.dataschema = dataschema;
        this.subject = subject;
        this.time = time;
    }

    @Override
    public SpecVersion getSpecVersion() {
        return SpecVersion.V1;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public URI getSource() {
        return this.source;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getDataContentType() {
        return this.datacontenttype;
    }

    @Override
    public URI getDataSchema() {
        return this.dataschema;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public OffsetDateTime getTime() {
        return this.time;
    }

    @Override
    public Object getAttribute(String attributeName) {
        switch (attributeName) {
            case "specversion": {
                return this.getSpecVersion();
            }
            case "id": {
                return this.id;
            }
            case "source": {
                return this.source;
            }
            case "type": {
                return this.type;
            }
            case "datacontenttype": {
                return this.datacontenttype;
            }
            case "dataschema": {
                return this.dataschema;
            }
            case "subject": {
                return this.subject;
            }
            case "time": {
                return this.time;
            }
        }
        throw new IllegalArgumentException("Spec version v1 doesn't have attribute named " + attributeName);
    }

    @Override
    public void readAttributes(CloudEventAttributesWriter writer) throws CloudEventRWException {
        writer.setAttribute(ContextAttributes.ID.name().toLowerCase(), this.id);
        writer.setAttribute(ContextAttributes.SOURCE.name().toLowerCase(), this.source);
        writer.setAttribute(ContextAttributes.TYPE.name().toLowerCase(), this.type);
        if (this.datacontenttype != null) {
            writer.setAttribute(ContextAttributes.DATACONTENTTYPE.name().toLowerCase(), this.datacontenttype);
        }
        if (this.dataschema != null) {
            writer.setAttribute(ContextAttributes.DATASCHEMA.name().toLowerCase(), this.dataschema);
        }
        if (this.subject != null) {
            writer.setAttribute(ContextAttributes.SUBJECT.name().toLowerCase(), this.subject);
        }
        if (this.time != null) {
            writer.setAttribute(ContextAttributes.TIME.name().toLowerCase(), this.time);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudEventV1 that = (CloudEventV1)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getSource(), that.getSource()) && Objects.equals(this.getType(), that.getType()) && Objects.equals(this.datacontenttype, that.getDataContentType()) && Objects.equals(this.dataschema, that.getDataSchema()) && Objects.equals(this.getSubject(), that.getSubject()) && Objects.equals(this.getTime(), that.getTime()) && Arrays.equals(this.getData(), that.getData()) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getSource(), this.getType(), this.datacontenttype, this.dataschema, this.getSubject(), this.getTime(), Arrays.hashCode(this.getData()), this.extensions);
    }

    public String toString() {
        return "CloudEvent{id='" + this.id + '\'' + ", source=" + this.source + ", type='" + this.type + '\'' + ", datacontenttype='" + this.datacontenttype + '\'' + ", dataschema=" + this.dataschema + ", subject='" + this.subject + '\'' + ", time=" + this.time + ", data=" + Arrays.toString(this.getData()) + ", extensions=" + this.extensions + '}';
    }
}

