/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.jackson.JsonFormat;
import io.cloudevents.rw.CloudEventAttributesWriter;
import io.cloudevents.rw.CloudEventExtensionsWriter;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventReader;
import io.cloudevents.rw.CloudEventWriter;
import io.cloudevents.rw.CloudEventWriterFactory;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.function.Consumer;

public class CloudEventDeserializer
extends StdDeserializer<CloudEvent> {
    protected CloudEventDeserializer() {
        super(CloudEvent.class);
    }

    @Override
    public CloudEvent deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectNode node = ctxt.readValue(p, ObjectNode.class);
        try {
            return (CloudEvent)new JsonMessage(p, node).read(CloudEventBuilder::fromSpecVersion);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw MismatchedInputException.wrapWithPath(e, null);
        }
    }

    private static class JsonMessage
    implements CloudEventReader {
        private final JsonParser p;
        private final ObjectNode node;

        public JsonMessage(JsonParser p, ObjectNode node) {
            this.p = p;
            this.node = node;
        }

        /*
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        public <T extends CloudEventWriter<V>, V> V read(CloudEventWriterFactory<T, V> writerFactory) throws CloudEventRWException, IllegalStateException {
            try {
                specVersion = SpecVersion.parse(this.getStringNode(this.node, this.p, "specversion"));
                visitor = writerFactory.create(specVersion);
                for (Object attr : specVersion.getMandatoryAttributes()) {
                    if ("specversion".equals(attr)) continue;
                    visitor.setAttribute((String)attr, this.getStringNode(this.node, this.p, (String)attr));
                }
                contentType = this.getOptionalStringNode(this.node, this.p, "datacontenttype");
                if (contentType != null) {
                    visitor.setAttribute("datacontenttype", contentType);
                }
                for (String attr : specVersion.getOptionalAttributes()) {
                    if ("datacontentencoding".equals(attr) || (val = this.getOptionalStringNode(this.node, this.p, attr)) == null) continue;
                    visitor.setAttribute(attr, val);
                }
                data = null;
                switch (1.$SwitchMap$io$cloudevents$SpecVersion[specVersion.ordinal()]) {
                    case 1: {
                        isBase64 = "base64".equals(this.getOptionalStringNode(this.node, this.p, "datacontentencoding"));
                        if (!this.node.has("data")) ** GOTO lbl29
                        if (!isBase64) ** GOTO lbl23
                        data = this.node.remove("data").binaryValue();
                        ** GOTO lbl29
lbl23:
                        // 1 sources

                        if (JsonFormat.dataIsJsonContentType(contentType)) {
                            data = this.node.remove("data").toString().getBytes();
                        } else {
                            dataNode = this.node.remove("data");
                            this.assertNodeType(dataNode, JsonNodeType.STRING, "data", "Because content type is not a json, only a string is accepted as data");
                            data = dataNode.asText().getBytes();
                        }
                    }
lbl29:
                    // 5 sources

                    case 2: {
                        if (this.node.has("data_base64") && this.node.has("data")) {
                            throw MismatchedInputException.from(this.p, CloudEvent.class, "CloudEvent cannot have both 'data' and 'data_base64' fields");
                        }
                        if (this.node.has("data_base64")) {
                            data = this.node.remove("data_base64").binaryValue();
                            break;
                        }
                        if (!this.node.has("data")) break;
                        if (JsonFormat.dataIsJsonContentType(contentType)) {
                            data = this.node.remove("data").toString().getBytes();
                            break;
                        }
                        dataNode = this.node.remove("data");
                        this.assertNodeType(dataNode, JsonNodeType.STRING, "data", "Because content type is not a json, only a string is accepted as data");
                        data = dataNode.asText().getBytes();
                    }
                }
                this.node.fields().forEachRemaining((Consumer<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$read$0(io.cloudevents.rw.CloudEventWriter java.util.Map$Entry ), (Ljava/util/Map$Entry;)V)(visitor));
                if (data != null) {
                    return visitor.end(data);
                }
                return visitor.end();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(MismatchedInputException.from(this.p, CloudEvent.class, e.getMessage()));
            }
        }

        @Override
        public void readAttributes(CloudEventAttributesWriter writer) throws CloudEventRWException {
        }

        @Override
        public void readExtensions(CloudEventExtensionsWriter visitor) throws CloudEventRWException {
        }

        private String getStringNode(ObjectNode objNode, JsonParser p, String attributeName) throws JsonProcessingException {
            String val = this.getOptionalStringNode(objNode, p, attributeName);
            if (val == null) {
                throw MismatchedInputException.from(p, CloudEvent.class, "Missing mandatory " + attributeName + " attribute");
            }
            return val;
        }

        private String getOptionalStringNode(ObjectNode objNode, JsonParser p, String attributeName) throws JsonProcessingException {
            JsonNode unparsedSpecVersion = objNode.remove(attributeName);
            if (unparsedSpecVersion == null) {
                return null;
            }
            this.assertNodeType(unparsedSpecVersion, JsonNodeType.STRING, attributeName, null);
            return unparsedSpecVersion.asText();
        }

        private void assertNodeType(JsonNode node, JsonNodeType type, String attributeName, String desc) throws JsonProcessingException {
            if (node.getNodeType() != type) {
                throw MismatchedInputException.from(this.p, CloudEvent.class, "Wrong type " + (Object)((Object)node.getNodeType()) + " for attribute " + attributeName + ", expecting " + (Object)((Object)type) + (desc != null ? ". " + desc : ""));
            }
        }

        private static /* synthetic */ void lambda$read$0(CloudEventWriter visitor, Map.Entry entry) {
            String extensionName = (String)entry.getKey();
            JsonNode extensionValue = (JsonNode)entry.getValue();
            switch (extensionValue.getNodeType()) {
                case BOOLEAN: {
                    visitor.setExtension(extensionName, extensionValue.booleanValue());
                    break;
                }
                case NUMBER: {
                    visitor.setExtension(extensionName, extensionValue.numberValue());
                    break;
                }
                case STRING: {
                    visitor.setExtension(extensionName, extensionValue.textValue());
                    break;
                }
                default: {
                    visitor.setExtension(extensionName, extensionValue.toString());
                }
            }
        }
    }
}

