/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.invoker;

import com.google.auto.value.AutoValue;
import com.google.cloud.functions.invoker.AutoValue_Event;
import com.google.cloud.functions.invoker.CloudFunctionsContext;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;

@AutoValue
abstract class Event {
    Event() {
    }

    static Event of(JsonElement data, CloudFunctionsContext context) {
        return new AutoValue_Event(data, context);
    }

    abstract JsonElement getData();

    abstract CloudFunctionsContext getContext();

    static class EventDeserializer
    implements JsonDeserializer<Event> {
        EventDeserializer() {
        }

        @Override
        public Event deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            CloudFunctionsContext context;
            JsonObject root = jsonElement.getAsJsonObject();
            JsonElement data = root.get("data");
            if (root.has("context")) {
                JsonObject contextCopy = root.getAsJsonObject("context").deepCopy();
                context = (CloudFunctionsContext)jsonDeserializationContext.deserialize(this.adjustContextResource(contextCopy), (Type)((Object)CloudFunctionsContext.class));
            } else {
                JsonObject rootCopy = root.deepCopy();
                rootCopy.remove("data");
                context = (CloudFunctionsContext)jsonDeserializationContext.deserialize(this.adjustContextResource(rootCopy), (Type)((Object)CloudFunctionsContext.class));
            }
            return Event.of(data, context);
        }

        private JsonObject adjustContextResource(JsonObject contextObject) {
            String resourceValue = contextObject.has("resource") ? contextObject.get("resource").toString() : "";
            contextObject.remove("resource");
            contextObject.addProperty("resource", resourceValue);
            return contextObject;
        }
    }
}

