/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.invoker;

import com.google.auto.value.AutoValue;
import com.google.cloud.functions.invoker.AutoValue_GcfEvents_SourceAndSubject;
import com.google.cloud.functions.invoker.CloudFunctionsContext;
import com.google.cloud.functions.invoker.Event;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class GcfEvents {
    private static final String FIREBASE_SERVICE = "firebase.googleapis.com";
    private static final String FIRESTORE_SERVICE = "firestore.googleapis.com";
    private static final String PUB_SUB_SERVICE = "pubsub.googleapis.com";
    private static final String STORAGE_SERVICE = "storage.googleapis.com";
    private static final String PUB_SUB_MESSAGE_PUBLISHED = "google.cloud.pubsub.topic.v1.messagePublished";
    private static final Map<String, EventAdapter> EVENT_TYPE_MAPPING = Map.ofEntries(Map.entry("google.pubsub.topic.publish", new PubSubEventAdapter("google.cloud.pubsub.topic.v1.messagePublished")), Map.entry("google.storage.object.finalize", new StorageEventAdapter("google.cloud.storage.object.v1.finalized")), Map.entry("google.storage.object.delete", new StorageEventAdapter("google.cloud.storage.object.v1.deleted")), Map.entry("google.storage.object.archive", new StorageEventAdapter("google.cloud.storage.object.v1.archived")), Map.entry("google.storage.object.metadataUpdate", new StorageEventAdapter("google.cloud.storage.object.v1.metadataUpdated")), Map.entry("providers/cloud.firestore/eventTypes/document.write", new FirestoreFirebaseEventAdapter("google.cloud.firestore.document.v1.written", "firestore.googleapis.com")), Map.entry("providers/cloud.firestore/eventTypes/document.create", new FirestoreFirebaseEventAdapter("google.cloud.firestore.document.v1.created", "firestore.googleapis.com")), Map.entry("providers/cloud.firestore/eventTypes/document.update", new FirestoreFirebaseEventAdapter("google.cloud.firestore.document.v1.updated", "firestore.googleapis.com")), Map.entry("providers/cloud.firestore/eventTypes/document.delete", new FirestoreFirebaseEventAdapter("google.cloud.firestore.document.v1.deleted", "firestore.googleapis.com")), Map.entry("providers/firebase.auth/eventTypes/user.create", new FirestoreFirebaseEventAdapter("google.firebase.auth.user.v1.created", "firebase.googleapis.com")), Map.entry("providers/firebase.auth/eventTypes/user.delete", new FirestoreFirebaseEventAdapter("google.firebase.auth.user.v1.deleted", "firebase.googleapis.com")), Map.entry("providers/google.firebase.analytics/eventTypes/event.log", new FirestoreFirebaseEventAdapter("google.firebase.analytics.log.v1.written", "firebase.googleapis.com")), Map.entry("providers/google.firebase.database/eventTypes/ref.create", new FirestoreFirebaseEventAdapter("google.firebase.database.document.v1.created", "firebase.googleapis.com")), Map.entry("providers/google.firebase.database/eventTypes/ref.write", new FirestoreFirebaseEventAdapter("google.firebase.database.document.v1.written", "firebase.googleapis.com")), Map.entry("providers/google.firebase.database/eventTypes/ref.update", new FirestoreFirebaseEventAdapter("google.firebase.database.document.v1.updated", "firebase.googleapis.com")), Map.entry("providers/google.firebase.database/eventTypes/ref.delete", new FirestoreFirebaseEventAdapter("google.firebase.database.document.v1.deleted", "firebase.googleapis.com")), Map.entry("providers/cloud.pubsub/eventTypes/topic.publish", new PubSubEventAdapter("google.cloud.pubsub.topic.v1.messagePublished")), Map.entry("providers/cloud.storage/eventTypes/object.change", new StorageEventAdapter("google.cloud.storage.object.v1.changed")));
    private static final Gson GSON = new Gson();

    GcfEvents() {
    }

    static CloudEvent convertToCloudEvent(Event legacyEvent) {
        String eventType = legacyEvent.getContext().eventType();
        EventAdapter eventAdapter = EVENT_TYPE_MAPPING.get(eventType);
        if (eventAdapter == null) {
            throw new IllegalArgumentException("Unrecognized event type \"" + eventType + "\"");
        }
        return eventAdapter.convertToCloudEvent(legacyEvent);
    }

    private static class FirestoreFirebaseEventAdapter
    extends EventAdapter {
        FirestoreFirebaseEventAdapter(String cloudEventType, String defaultService) {
            super(cloudEventType, defaultService);
        }

        @Override
        SourceAndSubject convertResourceToSourceAndSubject(String resourceName) {
            List<String> resourceSegments = Arrays.asList(resourceName.split("/"));
            int documentsIndex = resourceSegments.indexOf("documents");
            if (documentsIndex < 0) {
                return super.convertResourceToSourceAndSubject(resourceName);
            }
            String sourcePath = String.join((CharSequence)"/", resourceSegments.subList(0, documentsIndex));
            String subject = String.join((CharSequence)"/", resourceSegments.subList(documentsIndex, resourceSegments.size()));
            return SourceAndSubject.of(sourcePath, subject);
        }

        @Override
        String maybeReshapeData(Event legacyEvent, String jsonData) {
            return jsonData;
        }

        private static /* synthetic */ void lambda$maybeReshapeData$0(JsonObject wildcards, String k, String v) {
            wildcards.addProperty(k, v);
        }
    }

    private static class StorageEventAdapter
    extends EventAdapter {
        private static final Pattern STORAGE_RESOURCE_PATTERN = Pattern.compile("^(projects/_/buckets/[^/]+)/(objects/.*?)(?:#\\d+)?$");

        StorageEventAdapter(String cloudEventType) {
            super(cloudEventType, GcfEvents.STORAGE_SERVICE);
        }

        @Override
        SourceAndSubject convertResourceToSourceAndSubject(String resourceName) {
            Matcher matcher = STORAGE_RESOURCE_PATTERN.matcher(resourceName);
            if (matcher.matches()) {
                String resource = matcher.group(1);
                String subject = matcher.group(2);
                return SourceAndSubject.of(resource, subject);
            }
            return super.convertResourceToSourceAndSubject(resourceName);
        }
    }

    private static class PubSubEventAdapter
    extends EventAdapter {
        PubSubEventAdapter(String cloudEventType) {
            super(cloudEventType, GcfEvents.PUB_SUB_SERVICE);
        }

        @Override
        String maybeReshapeData(Event legacyEvent, String jsonData) {
            JsonObject jsonObject = GSON.fromJson(jsonData, JsonObject.class);
            JsonObject wrapped = new JsonObject();
            wrapped.add("message", jsonObject);
            return GSON.toJson(wrapped);
        }
    }

    private static abstract class EventAdapter {
        private final String cloudEventType;
        private final String defaultService;

        EventAdapter(String cloudEventType, String defaultService) {
            this.cloudEventType = cloudEventType;
            this.defaultService = defaultService;
        }

        final CloudEvent convertToCloudEvent(Event legacyEvent) {
            String jsonData = GSON.toJson(legacyEvent.getData());
            jsonData = this.maybeReshapeData(legacyEvent, jsonData);
            CloudFunctionsContext.Resource resource = CloudFunctionsContext.Resource.from(legacyEvent.getContext().resource());
            String service = Optional.ofNullable(resource.service()).orElse(this.defaultService);
            String resourceName = resource.name();
            SourceAndSubject sourceAndSubject = this.convertResourceToSourceAndSubject(resourceName);
            URI source = URI.create("//" + service + "/" + sourceAndSubject.source());
            OffsetDateTime timestamp = Optional.ofNullable(legacyEvent.getContext().timestamp()).map(s -> OffsetDateTime.parse(s, DateTimeFormatter.ISO_DATE_TIME)).orElse(null);
            return ((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withData(jsonData.getBytes(StandardCharsets.UTF_8))).withDataContentType("application/json").withId(legacyEvent.getContext().eventId()).withSource(source).withSubject(sourceAndSubject.subject()).withTime(timestamp).withType(this.cloudEventType).build();
        }

        String maybeReshapeData(Event legacyEvent, String jsonData) {
            return jsonData;
        }

        SourceAndSubject convertResourceToSourceAndSubject(String resourceName) {
            return SourceAndSubject.of(resourceName, null);
        }
    }

    @AutoValue
    static abstract class SourceAndSubject {
        SourceAndSubject() {
        }

        abstract String source();

        abstract String subject();

        static SourceAndSubject of(String source, String subject) {
            return new AutoValue_GcfEvents_SourceAndSubject(source, subject);
        }
    }
}

