/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.message;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.core.CloudEventUtils;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.Encoding;
import io.cloudevents.core.message.MessageWriter;
import io.cloudevents.core.message.StructuredMessageReader;
import io.cloudevents.core.message.StructuredMessageWriter;
import io.cloudevents.rw.CloudEventDataMapper;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventReader;
import io.cloudevents.rw.CloudEventWriter;
import io.cloudevents.rw.CloudEventWriterFactory;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface MessageReader
extends StructuredMessageReader,
CloudEventReader {
    @Override
    default public <W extends CloudEventWriter<R>, R> R read(CloudEventWriterFactory<W, R> writerFactory) throws CloudEventRWException, IllegalStateException {
        return this.read(writerFactory, CloudEventDataMapper.identity());
    }

    @Override
    public <W extends CloudEventWriter<R>, R> R read(CloudEventWriterFactory<W, R> var1, CloudEventDataMapper<? extends CloudEventData> var2) throws CloudEventRWException, IllegalStateException;

    @Override
    public <R> R read(StructuredMessageWriter<R> var1) throws CloudEventRWException, IllegalStateException;

    public Encoding getEncoding();

    default public <BW extends CloudEventWriter<R>, R> R read(MessageWriter<BW, R> writer) throws CloudEventRWException, IllegalStateException {
        switch (this.getEncoding()) {
            case BINARY: {
                return this.read((CloudEventWriterFactory)writer);
            }
            case STRUCTURED: {
                return this.read((StructuredMessageWriter<R>)writer);
            }
        }
        throw new IllegalStateException("The provided Encoding doesn't exist. Please make sure your io.cloudevents deps versions are aligned.");
    }

    @Override
    default public CloudEvent toEvent() throws CloudEventRWException, IllegalStateException {
        return this.toEvent(CloudEventDataMapper.identity());
    }

    @Override
    default public CloudEvent toEvent(CloudEventDataMapper<? extends CloudEventData> mapper) throws CloudEventRWException, IllegalStateException {
        switch (this.getEncoding()) {
            case BINARY: {
                return CloudEventUtils.toEvent(this, mapper);
            }
            case STRUCTURED: {
                return this.read((EventFormat format, byte[] value) -> format.deserialize(value, mapper));
            }
        }
        throw new IllegalStateException("The provided Encoding doesn't exist. Please make sure your io.cloudevents deps versions are aligned.");
    }
}

