/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.provider;

import io.cloudevents.core.format.EventFormat;
import io.cloudevents.lang.Nullable;
import java.util.HashMap;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class EventFormatProvider {
    private final HashMap<String, EventFormat> formats = new HashMap();

    public static EventFormatProvider getInstance() {
        return SingletonContainer.INSTANCE;
    }

    private EventFormatProvider() {
        StreamSupport.stream(ServiceLoader.load(EventFormat.class).spliterator(), false).forEach(this::registerFormat);
    }

    public void registerFormat(EventFormat format) {
        for (String k : format.deserializableContentTypes()) {
            this.formats.put(k, format);
        }
    }

    @Nullable
    public EventFormat resolveFormat(String contentType) {
        int i = contentType.indexOf(59);
        if (i != -1) {
            contentType = contentType.substring(0, i);
        }
        return this.formats.get(contentType);
    }

    private static class SingletonContainer {
        private static final EventFormatProvider INSTANCE = new EventFormatProvider();

        private SingletonContainer() {
        }
    }
}

