/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.accessapproval.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.accessapproval.v1.AccessApprovalAdminClient;
import com.google.cloud.accessapproval.v1.AccessApprovalServiceAccount;
import com.google.cloud.accessapproval.v1.AccessApprovalSettings;
import com.google.cloud.accessapproval.v1.ApprovalRequest;
import com.google.cloud.accessapproval.v1.ApproveApprovalRequestMessage;
import com.google.cloud.accessapproval.v1.DeleteAccessApprovalSettingsMessage;
import com.google.cloud.accessapproval.v1.DismissApprovalRequestMessage;
import com.google.cloud.accessapproval.v1.GetAccessApprovalServiceAccountMessage;
import com.google.cloud.accessapproval.v1.GetAccessApprovalSettingsMessage;
import com.google.cloud.accessapproval.v1.GetApprovalRequestMessage;
import com.google.cloud.accessapproval.v1.InvalidateApprovalRequestMessage;
import com.google.cloud.accessapproval.v1.ListApprovalRequestsMessage;
import com.google.cloud.accessapproval.v1.ListApprovalRequestsResponse;
import com.google.cloud.accessapproval.v1.UpdateAccessApprovalSettingsMessage;
import com.google.cloud.accessapproval.v1.stub.AccessApprovalStub;
import com.google.cloud.accessapproval.v1.stub.AccessApprovalStubSettings;
import com.google.cloud.accessapproval.v1.stub.GrpcAccessApprovalCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcAccessApprovalStub
extends AccessApprovalStub {
    private static final MethodDescriptor<ListApprovalRequestsMessage, ListApprovalRequestsResponse> listApprovalRequestsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.accessapproval.v1.AccessApproval/ListApprovalRequests").setRequestMarshaller(ProtoUtils.marshaller((Message)ListApprovalRequestsMessage.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListApprovalRequestsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetApprovalRequestMessage, ApprovalRequest> getApprovalRequestMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.accessapproval.v1.AccessApproval/GetApprovalRequest").setRequestMarshaller(ProtoUtils.marshaller((Message)GetApprovalRequestMessage.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ApprovalRequest.getDefaultInstance())).build();
    private static final MethodDescriptor<ApproveApprovalRequestMessage, ApprovalRequest> approveApprovalRequestMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.accessapproval.v1.AccessApproval/ApproveApprovalRequest").setRequestMarshaller(ProtoUtils.marshaller((Message)ApproveApprovalRequestMessage.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ApprovalRequest.getDefaultInstance())).build();
    private static final MethodDescriptor<DismissApprovalRequestMessage, ApprovalRequest> dismissApprovalRequestMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.accessapproval.v1.AccessApproval/DismissApprovalRequest").setRequestMarshaller(ProtoUtils.marshaller((Message)DismissApprovalRequestMessage.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ApprovalRequest.getDefaultInstance())).build();
    private static final MethodDescriptor<InvalidateApprovalRequestMessage, ApprovalRequest> invalidateApprovalRequestMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.accessapproval.v1.AccessApproval/InvalidateApprovalRequest").setRequestMarshaller(ProtoUtils.marshaller((Message)InvalidateApprovalRequestMessage.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ApprovalRequest.getDefaultInstance())).build();
    private static final MethodDescriptor<GetAccessApprovalSettingsMessage, AccessApprovalSettings> getAccessApprovalSettingsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.accessapproval.v1.AccessApproval/GetAccessApprovalSettings").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAccessApprovalSettingsMessage.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AccessApprovalSettings.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateAccessApprovalSettingsMessage, AccessApprovalSettings> updateAccessApprovalSettingsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.accessapproval.v1.AccessApproval/UpdateAccessApprovalSettings").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateAccessApprovalSettingsMessage.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AccessApprovalSettings.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteAccessApprovalSettingsMessage, Empty> deleteAccessApprovalSettingsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.accessapproval.v1.AccessApproval/DeleteAccessApprovalSettings").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteAccessApprovalSettingsMessage.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<GetAccessApprovalServiceAccountMessage, AccessApprovalServiceAccount> getAccessApprovalServiceAccountMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.accessapproval.v1.AccessApproval/GetAccessApprovalServiceAccount").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAccessApprovalServiceAccountMessage.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AccessApprovalServiceAccount.getDefaultInstance())).build();
    private final UnaryCallable<ListApprovalRequestsMessage, ListApprovalRequestsResponse> listApprovalRequestsCallable;
    private final UnaryCallable<ListApprovalRequestsMessage, AccessApprovalAdminClient.ListApprovalRequestsPagedResponse> listApprovalRequestsPagedCallable;
    private final UnaryCallable<GetApprovalRequestMessage, ApprovalRequest> getApprovalRequestCallable;
    private final UnaryCallable<ApproveApprovalRequestMessage, ApprovalRequest> approveApprovalRequestCallable;
    private final UnaryCallable<DismissApprovalRequestMessage, ApprovalRequest> dismissApprovalRequestCallable;
    private final UnaryCallable<InvalidateApprovalRequestMessage, ApprovalRequest> invalidateApprovalRequestCallable;
    private final UnaryCallable<GetAccessApprovalSettingsMessage, AccessApprovalSettings> getAccessApprovalSettingsCallable;
    private final UnaryCallable<UpdateAccessApprovalSettingsMessage, AccessApprovalSettings> updateAccessApprovalSettingsCallable;
    private final UnaryCallable<DeleteAccessApprovalSettingsMessage, Empty> deleteAccessApprovalSettingsCallable;
    private final UnaryCallable<GetAccessApprovalServiceAccountMessage, AccessApprovalServiceAccount> getAccessApprovalServiceAccountCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAccessApprovalStub create(AccessApprovalStubSettings settings) throws IOException {
        return new GrpcAccessApprovalStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAccessApprovalStub create(ClientContext clientContext) throws IOException {
        return new GrpcAccessApprovalStub(AccessApprovalStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAccessApprovalStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAccessApprovalStub(AccessApprovalStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAccessApprovalStub(AccessApprovalStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAccessApprovalCallableFactory());
    }

    protected GrpcAccessApprovalStub(AccessApprovalStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listApprovalRequestsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listApprovalRequestsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getApprovalRequestTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getApprovalRequestMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings approveApprovalRequestTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(approveApprovalRequestMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings dismissApprovalRequestTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(dismissApprovalRequestMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings invalidateApprovalRequestTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(invalidateApprovalRequestMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getAccessApprovalSettingsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAccessApprovalSettingsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateAccessApprovalSettingsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateAccessApprovalSettingsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("settings.name", String.valueOf(request.getSettings().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteAccessApprovalSettingsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteAccessApprovalSettingsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getAccessApprovalServiceAccountTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAccessApprovalServiceAccountMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listApprovalRequestsCallable = callableFactory.createUnaryCallable(listApprovalRequestsTransportSettings, settings.listApprovalRequestsSettings(), clientContext);
        this.listApprovalRequestsPagedCallable = callableFactory.createPagedCallable(listApprovalRequestsTransportSettings, settings.listApprovalRequestsSettings(), clientContext);
        this.getApprovalRequestCallable = callableFactory.createUnaryCallable(getApprovalRequestTransportSettings, settings.getApprovalRequestSettings(), clientContext);
        this.approveApprovalRequestCallable = callableFactory.createUnaryCallable(approveApprovalRequestTransportSettings, settings.approveApprovalRequestSettings(), clientContext);
        this.dismissApprovalRequestCallable = callableFactory.createUnaryCallable(dismissApprovalRequestTransportSettings, settings.dismissApprovalRequestSettings(), clientContext);
        this.invalidateApprovalRequestCallable = callableFactory.createUnaryCallable(invalidateApprovalRequestTransportSettings, settings.invalidateApprovalRequestSettings(), clientContext);
        this.getAccessApprovalSettingsCallable = callableFactory.createUnaryCallable(getAccessApprovalSettingsTransportSettings, settings.getAccessApprovalSettingsSettings(), clientContext);
        this.updateAccessApprovalSettingsCallable = callableFactory.createUnaryCallable(updateAccessApprovalSettingsTransportSettings, settings.updateAccessApprovalSettingsSettings(), clientContext);
        this.deleteAccessApprovalSettingsCallable = callableFactory.createUnaryCallable(deleteAccessApprovalSettingsTransportSettings, settings.deleteAccessApprovalSettingsSettings(), clientContext);
        this.getAccessApprovalServiceAccountCallable = callableFactory.createUnaryCallable(getAccessApprovalServiceAccountTransportSettings, settings.getAccessApprovalServiceAccountSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListApprovalRequestsMessage, ListApprovalRequestsResponse> listApprovalRequestsCallable() {
        return this.listApprovalRequestsCallable;
    }

    @Override
    public UnaryCallable<ListApprovalRequestsMessage, AccessApprovalAdminClient.ListApprovalRequestsPagedResponse> listApprovalRequestsPagedCallable() {
        return this.listApprovalRequestsPagedCallable;
    }

    @Override
    public UnaryCallable<GetApprovalRequestMessage, ApprovalRequest> getApprovalRequestCallable() {
        return this.getApprovalRequestCallable;
    }

    @Override
    public UnaryCallable<ApproveApprovalRequestMessage, ApprovalRequest> approveApprovalRequestCallable() {
        return this.approveApprovalRequestCallable;
    }

    @Override
    public UnaryCallable<DismissApprovalRequestMessage, ApprovalRequest> dismissApprovalRequestCallable() {
        return this.dismissApprovalRequestCallable;
    }

    @Override
    public UnaryCallable<InvalidateApprovalRequestMessage, ApprovalRequest> invalidateApprovalRequestCallable() {
        return this.invalidateApprovalRequestCallable;
    }

    @Override
    public UnaryCallable<GetAccessApprovalSettingsMessage, AccessApprovalSettings> getAccessApprovalSettingsCallable() {
        return this.getAccessApprovalSettingsCallable;
    }

    @Override
    public UnaryCallable<UpdateAccessApprovalSettingsMessage, AccessApprovalSettings> updateAccessApprovalSettingsCallable() {
        return this.updateAccessApprovalSettingsCallable;
    }

    @Override
    public UnaryCallable<DeleteAccessApprovalSettingsMessage, Empty> deleteAccessApprovalSettingsCallable() {
        return this.deleteAccessApprovalSettingsCallable;
    }

    @Override
    public UnaryCallable<GetAccessApprovalServiceAccountMessage, AccessApprovalServiceAccount> getAccessApprovalServiceAccountCallable() {
        return this.getAccessApprovalServiceAccountCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

