/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.CreateEndpointOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreateEndpointRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteEndpointRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.DeployModelOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.DeployModelRequest;
import com.google.cloud.aiplatform.v1beta1.DeployModelResponse;
import com.google.cloud.aiplatform.v1beta1.DeployedModel;
import com.google.cloud.aiplatform.v1beta1.Endpoint;
import com.google.cloud.aiplatform.v1beta1.EndpointName;
import com.google.cloud.aiplatform.v1beta1.EndpointServiceSettings;
import com.google.cloud.aiplatform.v1beta1.GetEndpointRequest;
import com.google.cloud.aiplatform.v1beta1.ListEndpointsRequest;
import com.google.cloud.aiplatform.v1beta1.ListEndpointsResponse;
import com.google.cloud.aiplatform.v1beta1.LocationName;
import com.google.cloud.aiplatform.v1beta1.UndeployModelOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.UndeployModelRequest;
import com.google.cloud.aiplatform.v1beta1.UndeployModelResponse;
import com.google.cloud.aiplatform.v1beta1.UpdateEndpointRequest;
import com.google.cloud.aiplatform.v1beta1.stub.EndpointServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.EndpointServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class EndpointServiceClient
implements BackgroundResource {
    private final EndpointServiceSettings settings;
    private final EndpointServiceStub stub;
    private final OperationsClient operationsClient;

    public static final EndpointServiceClient create() throws IOException {
        return EndpointServiceClient.create(EndpointServiceSettings.newBuilder().build());
    }

    public static final EndpointServiceClient create(EndpointServiceSettings settings) throws IOException {
        return new EndpointServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final EndpointServiceClient create(EndpointServiceStub stub) {
        return new EndpointServiceClient(stub);
    }

    protected EndpointServiceClient(EndpointServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((EndpointServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected EndpointServiceClient(EndpointServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final EndpointServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public EndpointServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<Endpoint, CreateEndpointOperationMetadata> createEndpointAsync(LocationName parent, Endpoint endpoint) {
        CreateEndpointRequest request = CreateEndpointRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEndpoint(endpoint).build();
        return this.createEndpointAsync(request);
    }

    public final OperationFuture<Endpoint, CreateEndpointOperationMetadata> createEndpointAsync(String parent, Endpoint endpoint) {
        CreateEndpointRequest request = CreateEndpointRequest.newBuilder().setParent(parent).setEndpoint(endpoint).build();
        return this.createEndpointAsync(request);
    }

    public final OperationFuture<Endpoint, CreateEndpointOperationMetadata> createEndpointAsync(LocationName parent, Endpoint endpoint, String endpointId) {
        CreateEndpointRequest request = CreateEndpointRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEndpoint(endpoint).setEndpointId(endpointId).build();
        return this.createEndpointAsync(request);
    }

    public final OperationFuture<Endpoint, CreateEndpointOperationMetadata> createEndpointAsync(String parent, Endpoint endpoint, String endpointId) {
        CreateEndpointRequest request = CreateEndpointRequest.newBuilder().setParent(parent).setEndpoint(endpoint).setEndpointId(endpointId).build();
        return this.createEndpointAsync(request);
    }

    public final OperationFuture<Endpoint, CreateEndpointOperationMetadata> createEndpointAsync(CreateEndpointRequest request) {
        return this.createEndpointOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateEndpointRequest, Endpoint, CreateEndpointOperationMetadata> createEndpointOperationCallable() {
        return this.stub.createEndpointOperationCallable();
    }

    public final UnaryCallable<CreateEndpointRequest, Operation> createEndpointCallable() {
        return this.stub.createEndpointCallable();
    }

    public final Endpoint getEndpoint(EndpointName name) {
        GetEndpointRequest request = GetEndpointRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEndpoint(request);
    }

    public final Endpoint getEndpoint(String name) {
        GetEndpointRequest request = GetEndpointRequest.newBuilder().setName(name).build();
        return this.getEndpoint(request);
    }

    public final Endpoint getEndpoint(GetEndpointRequest request) {
        return (Endpoint)this.getEndpointCallable().call((Object)request);
    }

    public final UnaryCallable<GetEndpointRequest, Endpoint> getEndpointCallable() {
        return this.stub.getEndpointCallable();
    }

    public final ListEndpointsPagedResponse listEndpoints(LocationName parent) {
        ListEndpointsRequest request = ListEndpointsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEndpoints(request);
    }

    public final ListEndpointsPagedResponse listEndpoints(String parent) {
        ListEndpointsRequest request = ListEndpointsRequest.newBuilder().setParent(parent).build();
        return this.listEndpoints(request);
    }

    public final ListEndpointsPagedResponse listEndpoints(ListEndpointsRequest request) {
        return (ListEndpointsPagedResponse)((Object)this.listEndpointsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEndpointsRequest, ListEndpointsPagedResponse> listEndpointsPagedCallable() {
        return this.stub.listEndpointsPagedCallable();
    }

    public final UnaryCallable<ListEndpointsRequest, ListEndpointsResponse> listEndpointsCallable() {
        return this.stub.listEndpointsCallable();
    }

    public final Endpoint updateEndpoint(Endpoint endpoint, FieldMask updateMask) {
        UpdateEndpointRequest request = UpdateEndpointRequest.newBuilder().setEndpoint(endpoint).setUpdateMask(updateMask).build();
        return this.updateEndpoint(request);
    }

    public final Endpoint updateEndpoint(UpdateEndpointRequest request) {
        return (Endpoint)this.updateEndpointCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateEndpointRequest, Endpoint> updateEndpointCallable() {
        return this.stub.updateEndpointCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteEndpointAsync(EndpointName name) {
        DeleteEndpointRequest request = DeleteEndpointRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteEndpointAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteEndpointAsync(String name) {
        DeleteEndpointRequest request = DeleteEndpointRequest.newBuilder().setName(name).build();
        return this.deleteEndpointAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteEndpointAsync(DeleteEndpointRequest request) {
        return this.deleteEndpointOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteEndpointRequest, Empty, DeleteOperationMetadata> deleteEndpointOperationCallable() {
        return this.stub.deleteEndpointOperationCallable();
    }

    public final UnaryCallable<DeleteEndpointRequest, Operation> deleteEndpointCallable() {
        return this.stub.deleteEndpointCallable();
    }

    public final OperationFuture<DeployModelResponse, DeployModelOperationMetadata> deployModelAsync(EndpointName endpoint, DeployedModel deployedModel, Map<String, Integer> trafficSplit) {
        DeployModelRequest request = DeployModelRequest.newBuilder().setEndpoint(endpoint == null ? null : endpoint.toString()).setDeployedModel(deployedModel).putAllTrafficSplit(trafficSplit).build();
        return this.deployModelAsync(request);
    }

    public final OperationFuture<DeployModelResponse, DeployModelOperationMetadata> deployModelAsync(String endpoint, DeployedModel deployedModel, Map<String, Integer> trafficSplit) {
        DeployModelRequest request = DeployModelRequest.newBuilder().setEndpoint(endpoint).setDeployedModel(deployedModel).putAllTrafficSplit(trafficSplit).build();
        return this.deployModelAsync(request);
    }

    public final OperationFuture<DeployModelResponse, DeployModelOperationMetadata> deployModelAsync(DeployModelRequest request) {
        return this.deployModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeployModelRequest, DeployModelResponse, DeployModelOperationMetadata> deployModelOperationCallable() {
        return this.stub.deployModelOperationCallable();
    }

    public final UnaryCallable<DeployModelRequest, Operation> deployModelCallable() {
        return this.stub.deployModelCallable();
    }

    public final OperationFuture<UndeployModelResponse, UndeployModelOperationMetadata> undeployModelAsync(EndpointName endpoint, String deployedModelId, Map<String, Integer> trafficSplit) {
        UndeployModelRequest request = UndeployModelRequest.newBuilder().setEndpoint(endpoint == null ? null : endpoint.toString()).setDeployedModelId(deployedModelId).putAllTrafficSplit(trafficSplit).build();
        return this.undeployModelAsync(request);
    }

    public final OperationFuture<UndeployModelResponse, UndeployModelOperationMetadata> undeployModelAsync(String endpoint, String deployedModelId, Map<String, Integer> trafficSplit) {
        UndeployModelRequest request = UndeployModelRequest.newBuilder().setEndpoint(endpoint).setDeployedModelId(deployedModelId).putAllTrafficSplit(trafficSplit).build();
        return this.undeployModelAsync(request);
    }

    public final OperationFuture<UndeployModelResponse, UndeployModelOperationMetadata> undeployModelAsync(UndeployModelRequest request) {
        return this.undeployModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UndeployModelRequest, UndeployModelResponse, UndeployModelOperationMetadata> undeployModelOperationCallable() {
        return this.stub.undeployModelOperationCallable();
    }

    public final UnaryCallable<UndeployModelRequest, Operation> undeployModelCallable() {
        return this.stub.undeployModelCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListEndpointsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEndpointsRequest, ListEndpointsResponse, Endpoint, ListEndpointsPage, ListEndpointsFixedSizeCollection> {
        private ListEndpointsFixedSizeCollection(List<ListEndpointsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEndpointsFixedSizeCollection createEmptyCollection() {
            return new ListEndpointsFixedSizeCollection(null, 0);
        }

        protected ListEndpointsFixedSizeCollection createCollection(List<ListEndpointsPage> pages, int collectionSize) {
            return new ListEndpointsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEndpointsPage
    extends AbstractPage<ListEndpointsRequest, ListEndpointsResponse, Endpoint, ListEndpointsPage> {
        private ListEndpointsPage(PageContext<ListEndpointsRequest, ListEndpointsResponse, Endpoint> context, ListEndpointsResponse response) {
            super(context, (Object)response);
        }

        private static ListEndpointsPage createEmptyPage() {
            return new ListEndpointsPage(null, null);
        }

        protected ListEndpointsPage createPage(PageContext<ListEndpointsRequest, ListEndpointsResponse, Endpoint> context, ListEndpointsResponse response) {
            return new ListEndpointsPage(context, response);
        }

        public ApiFuture<ListEndpointsPage> createPageAsync(PageContext<ListEndpointsRequest, ListEndpointsResponse, Endpoint> context, ApiFuture<ListEndpointsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEndpointsPagedResponse
    extends AbstractPagedListResponse<ListEndpointsRequest, ListEndpointsResponse, Endpoint, ListEndpointsPage, ListEndpointsFixedSizeCollection> {
        public static ApiFuture<ListEndpointsPagedResponse> createAsync(PageContext<ListEndpointsRequest, ListEndpointsResponse, Endpoint> context, ApiFuture<ListEndpointsResponse> futureResponse) {
            ApiFuture<ListEndpointsPage> futurePage = ListEndpointsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEndpointsPagedResponse((ListEndpointsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEndpointsPagedResponse(ListEndpointsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEndpointsFixedSizeCollection.createEmptyCollection());
        }
    }
}

