/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.CreatePersistentResourceOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreatePersistentResourceRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.DeletePersistentResourceRequest;
import com.google.cloud.aiplatform.v1beta1.GetPersistentResourceRequest;
import com.google.cloud.aiplatform.v1beta1.ListPersistentResourcesRequest;
import com.google.cloud.aiplatform.v1beta1.ListPersistentResourcesResponse;
import com.google.cloud.aiplatform.v1beta1.LocationName;
import com.google.cloud.aiplatform.v1beta1.PersistentResource;
import com.google.cloud.aiplatform.v1beta1.PersistentResourceName;
import com.google.cloud.aiplatform.v1beta1.PersistentResourceServiceSettings;
import com.google.cloud.aiplatform.v1beta1.UpdatePersistentResourceOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.UpdatePersistentResourceRequest;
import com.google.cloud.aiplatform.v1beta1.stub.PersistentResourceServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.PersistentResourceServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class PersistentResourceServiceClient
implements BackgroundResource {
    private final PersistentResourceServiceSettings settings;
    private final PersistentResourceServiceStub stub;
    private final OperationsClient operationsClient;

    public static final PersistentResourceServiceClient create() throws IOException {
        return PersistentResourceServiceClient.create(PersistentResourceServiceSettings.newBuilder().build());
    }

    public static final PersistentResourceServiceClient create(PersistentResourceServiceSettings settings) throws IOException {
        return new PersistentResourceServiceClient(settings);
    }

    public static final PersistentResourceServiceClient create(PersistentResourceServiceStub stub) {
        return new PersistentResourceServiceClient(stub);
    }

    protected PersistentResourceServiceClient(PersistentResourceServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PersistentResourceServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected PersistentResourceServiceClient(PersistentResourceServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final PersistentResourceServiceSettings getSettings() {
        return this.settings;
    }

    public PersistentResourceServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<PersistentResource, CreatePersistentResourceOperationMetadata> createPersistentResourceAsync(LocationName parent, PersistentResource persistentResource, String persistentResourceId) {
        CreatePersistentResourceRequest request = CreatePersistentResourceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPersistentResource(persistentResource).setPersistentResourceId(persistentResourceId).build();
        return this.createPersistentResourceAsync(request);
    }

    public final OperationFuture<PersistentResource, CreatePersistentResourceOperationMetadata> createPersistentResourceAsync(String parent, PersistentResource persistentResource, String persistentResourceId) {
        CreatePersistentResourceRequest request = CreatePersistentResourceRequest.newBuilder().setParent(parent).setPersistentResource(persistentResource).setPersistentResourceId(persistentResourceId).build();
        return this.createPersistentResourceAsync(request);
    }

    public final OperationFuture<PersistentResource, CreatePersistentResourceOperationMetadata> createPersistentResourceAsync(CreatePersistentResourceRequest request) {
        return this.createPersistentResourceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreatePersistentResourceRequest, PersistentResource, CreatePersistentResourceOperationMetadata> createPersistentResourceOperationCallable() {
        return this.stub.createPersistentResourceOperationCallable();
    }

    public final UnaryCallable<CreatePersistentResourceRequest, Operation> createPersistentResourceCallable() {
        return this.stub.createPersistentResourceCallable();
    }

    public final PersistentResource getPersistentResource(PersistentResourceName name) {
        GetPersistentResourceRequest request = GetPersistentResourceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPersistentResource(request);
    }

    public final PersistentResource getPersistentResource(String name) {
        GetPersistentResourceRequest request = GetPersistentResourceRequest.newBuilder().setName(name).build();
        return this.getPersistentResource(request);
    }

    public final PersistentResource getPersistentResource(GetPersistentResourceRequest request) {
        return (PersistentResource)this.getPersistentResourceCallable().call((Object)request);
    }

    public final UnaryCallable<GetPersistentResourceRequest, PersistentResource> getPersistentResourceCallable() {
        return this.stub.getPersistentResourceCallable();
    }

    public final ListPersistentResourcesPagedResponse listPersistentResources(LocationName parent) {
        ListPersistentResourcesRequest request = ListPersistentResourcesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPersistentResources(request);
    }

    public final ListPersistentResourcesPagedResponse listPersistentResources(String parent) {
        ListPersistentResourcesRequest request = ListPersistentResourcesRequest.newBuilder().setParent(parent).build();
        return this.listPersistentResources(request);
    }

    public final ListPersistentResourcesPagedResponse listPersistentResources(ListPersistentResourcesRequest request) {
        return (ListPersistentResourcesPagedResponse)((Object)this.listPersistentResourcesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPersistentResourcesRequest, ListPersistentResourcesPagedResponse> listPersistentResourcesPagedCallable() {
        return this.stub.listPersistentResourcesPagedCallable();
    }

    public final UnaryCallable<ListPersistentResourcesRequest, ListPersistentResourcesResponse> listPersistentResourcesCallable() {
        return this.stub.listPersistentResourcesCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deletePersistentResourceAsync(PersistentResourceName name) {
        DeletePersistentResourceRequest request = DeletePersistentResourceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deletePersistentResourceAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deletePersistentResourceAsync(String name) {
        DeletePersistentResourceRequest request = DeletePersistentResourceRequest.newBuilder().setName(name).build();
        return this.deletePersistentResourceAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deletePersistentResourceAsync(DeletePersistentResourceRequest request) {
        return this.deletePersistentResourceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeletePersistentResourceRequest, Empty, DeleteOperationMetadata> deletePersistentResourceOperationCallable() {
        return this.stub.deletePersistentResourceOperationCallable();
    }

    public final UnaryCallable<DeletePersistentResourceRequest, Operation> deletePersistentResourceCallable() {
        return this.stub.deletePersistentResourceCallable();
    }

    public final OperationFuture<PersistentResource, UpdatePersistentResourceOperationMetadata> updatePersistentResourceAsync(PersistentResource persistentResource, FieldMask updateMask) {
        UpdatePersistentResourceRequest request = UpdatePersistentResourceRequest.newBuilder().setPersistentResource(persistentResource).setUpdateMask(updateMask).build();
        return this.updatePersistentResourceAsync(request);
    }

    public final OperationFuture<PersistentResource, UpdatePersistentResourceOperationMetadata> updatePersistentResourceAsync(UpdatePersistentResourceRequest request) {
        return this.updatePersistentResourceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdatePersistentResourceRequest, PersistentResource, UpdatePersistentResourceOperationMetadata> updatePersistentResourceOperationCallable() {
        return this.stub.updatePersistentResourceOperationCallable();
    }

    public final UnaryCallable<UpdatePersistentResourceRequest, Operation> updatePersistentResourceCallable() {
        return this.stub.updatePersistentResourceCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPersistentResourcesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPersistentResourcesRequest, ListPersistentResourcesResponse, PersistentResource, ListPersistentResourcesPage, ListPersistentResourcesFixedSizeCollection> {
        private ListPersistentResourcesFixedSizeCollection(List<ListPersistentResourcesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPersistentResourcesFixedSizeCollection createEmptyCollection() {
            return new ListPersistentResourcesFixedSizeCollection(null, 0);
        }

        protected ListPersistentResourcesFixedSizeCollection createCollection(List<ListPersistentResourcesPage> pages, int collectionSize) {
            return new ListPersistentResourcesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPersistentResourcesPage
    extends AbstractPage<ListPersistentResourcesRequest, ListPersistentResourcesResponse, PersistentResource, ListPersistentResourcesPage> {
        private ListPersistentResourcesPage(PageContext<ListPersistentResourcesRequest, ListPersistentResourcesResponse, PersistentResource> context, ListPersistentResourcesResponse response) {
            super(context, (Object)response);
        }

        private static ListPersistentResourcesPage createEmptyPage() {
            return new ListPersistentResourcesPage(null, null);
        }

        protected ListPersistentResourcesPage createPage(PageContext<ListPersistentResourcesRequest, ListPersistentResourcesResponse, PersistentResource> context, ListPersistentResourcesResponse response) {
            return new ListPersistentResourcesPage(context, response);
        }

        public ApiFuture<ListPersistentResourcesPage> createPageAsync(PageContext<ListPersistentResourcesRequest, ListPersistentResourcesResponse, PersistentResource> context, ApiFuture<ListPersistentResourcesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPersistentResourcesPagedResponse
    extends AbstractPagedListResponse<ListPersistentResourcesRequest, ListPersistentResourcesResponse, PersistentResource, ListPersistentResourcesPage, ListPersistentResourcesFixedSizeCollection> {
        public static ApiFuture<ListPersistentResourcesPagedResponse> createAsync(PageContext<ListPersistentResourcesRequest, ListPersistentResourcesResponse, PersistentResource> context, ApiFuture<ListPersistentResourcesResponse> futureResponse) {
            ApiFuture<ListPersistentResourcesPage> futurePage = ListPersistentResourcesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPersistentResourcesPagedResponse((ListPersistentResourcesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPersistentResourcesPagedResponse(ListPersistentResourcesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPersistentResourcesFixedSizeCollection.createEmptyCollection());
        }
    }
}

