/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.FeaturestoreOnlineServingServiceClient;
import com.google.cloud.aiplatform.v1beta1.ReadFeatureValuesRequest;
import com.google.cloud.aiplatform.v1beta1.ReadFeatureValuesResponse;
import com.google.cloud.aiplatform.v1beta1.StreamingReadFeatureValuesRequest;
import com.google.cloud.aiplatform.v1beta1.WriteFeatureValuesRequest;
import com.google.cloud.aiplatform.v1beta1.WriteFeatureValuesResponse;
import com.google.cloud.aiplatform.v1beta1.stub.FeaturestoreOnlineServingServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.GrpcFeaturestoreOnlineServingServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class FeaturestoreOnlineServingServiceStubSettings
extends StubSettings<FeaturestoreOnlineServingServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<ReadFeatureValuesRequest, ReadFeatureValuesResponse> readFeatureValuesSettings;
    private final ServerStreamingCallSettings<StreamingReadFeatureValuesRequest, ReadFeatureValuesResponse> streamingReadFeatureValuesSettings;
    private final UnaryCallSettings<WriteFeatureValuesRequest, WriteFeatureValuesResponse> writeFeatureValuesSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, FeaturestoreOnlineServingServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, FeaturestoreOnlineServingServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, FeaturestoreOnlineServingServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<FeaturestoreOnlineServingServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return FeaturestoreOnlineServingServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<ReadFeatureValuesRequest, ReadFeatureValuesResponse> readFeatureValuesSettings() {
        return this.readFeatureValuesSettings;
    }

    public ServerStreamingCallSettings<StreamingReadFeatureValuesRequest, ReadFeatureValuesResponse> streamingReadFeatureValuesSettings() {
        return this.streamingReadFeatureValuesSettings;
    }

    public UnaryCallSettings<WriteFeatureValuesRequest, WriteFeatureValuesResponse> writeFeatureValuesSettings() {
        return this.writeFeatureValuesSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, FeaturestoreOnlineServingServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public FeaturestoreOnlineServingServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcFeaturestoreOnlineServingServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "aiplatform";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "aiplatform.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "aiplatform.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return FeaturestoreOnlineServingServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(FeaturestoreOnlineServingServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected FeaturestoreOnlineServingServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.readFeatureValuesSettings = settingsBuilder.readFeatureValuesSettings().build();
        this.streamingReadFeatureValuesSettings = settingsBuilder.streamingReadFeatureValuesSettings().build();
        this.writeFeatureValuesSettings = settingsBuilder.writeFeatureValuesSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<FeaturestoreOnlineServingServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<ReadFeatureValuesRequest, ReadFeatureValuesResponse> readFeatureValuesSettings;
        private final ServerStreamingCallSettings.Builder<StreamingReadFeatureValuesRequest, ReadFeatureValuesResponse> streamingReadFeatureValuesSettings;
        private final UnaryCallSettings.Builder<WriteFeatureValuesRequest, WriteFeatureValuesResponse> writeFeatureValuesSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, FeaturestoreOnlineServingServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.readFeatureValuesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.streamingReadFeatureValuesSettings = ServerStreamingCallSettings.newBuilder();
            this.writeFeatureValuesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.readFeatureValuesSettings, this.writeFeatureValuesSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(FeaturestoreOnlineServingServiceStubSettings settings) {
            super((StubSettings)settings);
            this.readFeatureValuesSettings = settings.readFeatureValuesSettings.toBuilder();
            this.streamingReadFeatureValuesSettings = settings.streamingReadFeatureValuesSettings.toBuilder();
            this.writeFeatureValuesSettings = settings.writeFeatureValuesSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.readFeatureValuesSettings, this.writeFeatureValuesSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(FeaturestoreOnlineServingServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)FeaturestoreOnlineServingServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)FeaturestoreOnlineServingServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(FeaturestoreOnlineServingServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(FeaturestoreOnlineServingServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.readFeatureValuesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_13_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_13_params"));
            builder.streamingReadFeatureValuesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_13_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_13_params"));
            builder.writeFeatureValuesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<ReadFeatureValuesRequest, ReadFeatureValuesResponse> readFeatureValuesSettings() {
            return this.readFeatureValuesSettings;
        }

        public ServerStreamingCallSettings.Builder<StreamingReadFeatureValuesRequest, ReadFeatureValuesResponse> streamingReadFeatureValuesSettings() {
            return this.streamingReadFeatureValuesSettings;
        }

        public UnaryCallSettings.Builder<WriteFeatureValuesRequest, WriteFeatureValuesResponse> writeFeatureValuesSettings() {
            return this.writeFeatureValuesSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, FeaturestoreOnlineServingServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public FeaturestoreOnlineServingServiceStubSettings build() throws IOException {
            return new FeaturestoreOnlineServingServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_13_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)5000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)5000L)).setTotalTimeout(Duration.ofMillis((long)5000L)).build();
            definitions.put((Object)"no_retry_13_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

