/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.CancelTuningJobRequest;
import com.google.cloud.aiplatform.v1.CreateTuningJobRequest;
import com.google.cloud.aiplatform.v1.GenAiTuningServiceClient;
import com.google.cloud.aiplatform.v1.GetTuningJobRequest;
import com.google.cloud.aiplatform.v1.ListTuningJobsRequest;
import com.google.cloud.aiplatform.v1.ListTuningJobsResponse;
import com.google.cloud.aiplatform.v1.TuningJob;
import com.google.cloud.aiplatform.v1.stub.GenAiTuningServiceStub;
import com.google.cloud.aiplatform.v1.stub.GenAiTuningServiceStubSettings;
import com.google.cloud.aiplatform.v1.stub.GrpcGenAiTuningServiceCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcGenAiTuningServiceStub
extends GenAiTuningServiceStub {
    private static final MethodDescriptor<CreateTuningJobRequest, TuningJob> createTuningJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.GenAiTuningService/CreateTuningJob").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateTuningJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TuningJob.getDefaultInstance())).build();
    private static final MethodDescriptor<GetTuningJobRequest, TuningJob> getTuningJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.GenAiTuningService/GetTuningJob").setRequestMarshaller(ProtoUtils.marshaller((Message)GetTuningJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TuningJob.getDefaultInstance())).build();
    private static final MethodDescriptor<ListTuningJobsRequest, ListTuningJobsResponse> listTuningJobsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.GenAiTuningService/ListTuningJobs").setRequestMarshaller(ProtoUtils.marshaller((Message)ListTuningJobsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListTuningJobsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CancelTuningJobRequest, Empty> cancelTuningJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.GenAiTuningService/CancelTuningJob").setRequestMarshaller(ProtoUtils.marshaller((Message)CancelTuningJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateTuningJobRequest, TuningJob> createTuningJobCallable;
    private final UnaryCallable<GetTuningJobRequest, TuningJob> getTuningJobCallable;
    private final UnaryCallable<ListTuningJobsRequest, ListTuningJobsResponse> listTuningJobsCallable;
    private final UnaryCallable<ListTuningJobsRequest, GenAiTuningServiceClient.ListTuningJobsPagedResponse> listTuningJobsPagedCallable;
    private final UnaryCallable<CancelTuningJobRequest, Empty> cancelTuningJobCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, GenAiTuningServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcGenAiTuningServiceStub create(GenAiTuningServiceStubSettings settings) throws IOException {
        return new GrpcGenAiTuningServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcGenAiTuningServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcGenAiTuningServiceStub(GenAiTuningServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcGenAiTuningServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcGenAiTuningServiceStub(GenAiTuningServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcGenAiTuningServiceStub(GenAiTuningServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcGenAiTuningServiceCallableFactory());
    }

    protected GrpcGenAiTuningServiceStub(GenAiTuningServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createTuningJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createTuningJobMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getTuningJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getTuningJobMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listTuningJobsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTuningJobsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings cancelTuningJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(cancelTuningJobMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.createTuningJobCallable = callableFactory.createUnaryCallable(createTuningJobTransportSettings, settings.createTuningJobSettings(), clientContext);
        this.getTuningJobCallable = callableFactory.createUnaryCallable(getTuningJobTransportSettings, settings.getTuningJobSettings(), clientContext);
        this.listTuningJobsCallable = callableFactory.createUnaryCallable(listTuningJobsTransportSettings, settings.listTuningJobsSettings(), clientContext);
        this.listTuningJobsPagedCallable = callableFactory.createPagedCallable(listTuningJobsTransportSettings, settings.listTuningJobsSettings(), clientContext);
        this.cancelTuningJobCallable = callableFactory.createUnaryCallable(cancelTuningJobTransportSettings, settings.cancelTuningJobSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateTuningJobRequest, TuningJob> createTuningJobCallable() {
        return this.createTuningJobCallable;
    }

    @Override
    public UnaryCallable<GetTuningJobRequest, TuningJob> getTuningJobCallable() {
        return this.getTuningJobCallable;
    }

    @Override
    public UnaryCallable<ListTuningJobsRequest, ListTuningJobsResponse> listTuningJobsCallable() {
        return this.listTuningJobsCallable;
    }

    @Override
    public UnaryCallable<ListTuningJobsRequest, GenAiTuningServiceClient.ListTuningJobsPagedResponse> listTuningJobsPagedCallable() {
        return this.listTuningJobsPagedCallable;
    }

    @Override
    public UnaryCallable<CancelTuningJobRequest, Empty> cancelTuningJobCallable() {
        return this.cancelTuningJobCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, GenAiTuningServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

