/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.AssignNotebookRuntimeOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.AssignNotebookRuntimeRequest;
import com.google.cloud.aiplatform.v1beta1.CreateNotebookExecutionJobOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreateNotebookExecutionJobRequest;
import com.google.cloud.aiplatform.v1beta1.CreateNotebookRuntimeTemplateOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreateNotebookRuntimeTemplateRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteNotebookExecutionJobRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteNotebookRuntimeRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteNotebookRuntimeTemplateRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.GetNotebookExecutionJobRequest;
import com.google.cloud.aiplatform.v1beta1.GetNotebookRuntimeRequest;
import com.google.cloud.aiplatform.v1beta1.GetNotebookRuntimeTemplateRequest;
import com.google.cloud.aiplatform.v1beta1.ListNotebookExecutionJobsRequest;
import com.google.cloud.aiplatform.v1beta1.ListNotebookExecutionJobsResponse;
import com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimeTemplatesRequest;
import com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimeTemplatesResponse;
import com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesRequest;
import com.google.cloud.aiplatform.v1beta1.ListNotebookRuntimesResponse;
import com.google.cloud.aiplatform.v1beta1.LocationName;
import com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob;
import com.google.cloud.aiplatform.v1beta1.NotebookExecutionJobName;
import com.google.cloud.aiplatform.v1beta1.NotebookRuntime;
import com.google.cloud.aiplatform.v1beta1.NotebookRuntimeName;
import com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplate;
import com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateName;
import com.google.cloud.aiplatform.v1beta1.NotebookServiceSettings;
import com.google.cloud.aiplatform.v1beta1.StartNotebookRuntimeOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.StartNotebookRuntimeRequest;
import com.google.cloud.aiplatform.v1beta1.StartNotebookRuntimeResponse;
import com.google.cloud.aiplatform.v1beta1.UpdateNotebookRuntimeTemplateRequest;
import com.google.cloud.aiplatform.v1beta1.UpgradeNotebookRuntimeOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.UpgradeNotebookRuntimeRequest;
import com.google.cloud.aiplatform.v1beta1.UpgradeNotebookRuntimeResponse;
import com.google.cloud.aiplatform.v1beta1.stub.NotebookServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.NotebookServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class NotebookServiceClient
implements BackgroundResource {
    private final NotebookServiceSettings settings;
    private final NotebookServiceStub stub;
    private final OperationsClient operationsClient;

    public static final NotebookServiceClient create() throws IOException {
        return NotebookServiceClient.create(NotebookServiceSettings.newBuilder().build());
    }

    public static final NotebookServiceClient create(NotebookServiceSettings settings) throws IOException {
        return new NotebookServiceClient(settings);
    }

    public static final NotebookServiceClient create(NotebookServiceStub stub) {
        return new NotebookServiceClient(stub);
    }

    protected NotebookServiceClient(NotebookServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((NotebookServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected NotebookServiceClient(NotebookServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final NotebookServiceSettings getSettings() {
        return this.settings;
    }

    public NotebookServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<NotebookRuntimeTemplate, CreateNotebookRuntimeTemplateOperationMetadata> createNotebookRuntimeTemplateAsync(LocationName parent, NotebookRuntimeTemplate notebookRuntimeTemplate, String notebookRuntimeTemplateId) {
        CreateNotebookRuntimeTemplateRequest request = CreateNotebookRuntimeTemplateRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setNotebookRuntimeTemplate(notebookRuntimeTemplate).setNotebookRuntimeTemplateId(notebookRuntimeTemplateId).build();
        return this.createNotebookRuntimeTemplateAsync(request);
    }

    public final OperationFuture<NotebookRuntimeTemplate, CreateNotebookRuntimeTemplateOperationMetadata> createNotebookRuntimeTemplateAsync(String parent, NotebookRuntimeTemplate notebookRuntimeTemplate, String notebookRuntimeTemplateId) {
        CreateNotebookRuntimeTemplateRequest request = CreateNotebookRuntimeTemplateRequest.newBuilder().setParent(parent).setNotebookRuntimeTemplate(notebookRuntimeTemplate).setNotebookRuntimeTemplateId(notebookRuntimeTemplateId).build();
        return this.createNotebookRuntimeTemplateAsync(request);
    }

    public final OperationFuture<NotebookRuntimeTemplate, CreateNotebookRuntimeTemplateOperationMetadata> createNotebookRuntimeTemplateAsync(CreateNotebookRuntimeTemplateRequest request) {
        return this.createNotebookRuntimeTemplateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateNotebookRuntimeTemplateRequest, NotebookRuntimeTemplate, CreateNotebookRuntimeTemplateOperationMetadata> createNotebookRuntimeTemplateOperationCallable() {
        return this.stub.createNotebookRuntimeTemplateOperationCallable();
    }

    public final UnaryCallable<CreateNotebookRuntimeTemplateRequest, Operation> createNotebookRuntimeTemplateCallable() {
        return this.stub.createNotebookRuntimeTemplateCallable();
    }

    public final NotebookRuntimeTemplate getNotebookRuntimeTemplate(NotebookRuntimeTemplateName name) {
        GetNotebookRuntimeTemplateRequest request = GetNotebookRuntimeTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNotebookRuntimeTemplate(request);
    }

    public final NotebookRuntimeTemplate getNotebookRuntimeTemplate(String name) {
        GetNotebookRuntimeTemplateRequest request = GetNotebookRuntimeTemplateRequest.newBuilder().setName(name).build();
        return this.getNotebookRuntimeTemplate(request);
    }

    public final NotebookRuntimeTemplate getNotebookRuntimeTemplate(GetNotebookRuntimeTemplateRequest request) {
        return (NotebookRuntimeTemplate)this.getNotebookRuntimeTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<GetNotebookRuntimeTemplateRequest, NotebookRuntimeTemplate> getNotebookRuntimeTemplateCallable() {
        return this.stub.getNotebookRuntimeTemplateCallable();
    }

    public final ListNotebookRuntimeTemplatesPagedResponse listNotebookRuntimeTemplates(LocationName parent) {
        ListNotebookRuntimeTemplatesRequest request = ListNotebookRuntimeTemplatesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNotebookRuntimeTemplates(request);
    }

    public final ListNotebookRuntimeTemplatesPagedResponse listNotebookRuntimeTemplates(String parent) {
        ListNotebookRuntimeTemplatesRequest request = ListNotebookRuntimeTemplatesRequest.newBuilder().setParent(parent).build();
        return this.listNotebookRuntimeTemplates(request);
    }

    public final ListNotebookRuntimeTemplatesPagedResponse listNotebookRuntimeTemplates(ListNotebookRuntimeTemplatesRequest request) {
        return (ListNotebookRuntimeTemplatesPagedResponse)((Object)this.listNotebookRuntimeTemplatesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNotebookRuntimeTemplatesRequest, ListNotebookRuntimeTemplatesPagedResponse> listNotebookRuntimeTemplatesPagedCallable() {
        return this.stub.listNotebookRuntimeTemplatesPagedCallable();
    }

    public final UnaryCallable<ListNotebookRuntimeTemplatesRequest, ListNotebookRuntimeTemplatesResponse> listNotebookRuntimeTemplatesCallable() {
        return this.stub.listNotebookRuntimeTemplatesCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteNotebookRuntimeTemplateAsync(NotebookRuntimeTemplateName name) {
        DeleteNotebookRuntimeTemplateRequest request = DeleteNotebookRuntimeTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteNotebookRuntimeTemplateAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteNotebookRuntimeTemplateAsync(String name) {
        DeleteNotebookRuntimeTemplateRequest request = DeleteNotebookRuntimeTemplateRequest.newBuilder().setName(name).build();
        return this.deleteNotebookRuntimeTemplateAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteNotebookRuntimeTemplateAsync(DeleteNotebookRuntimeTemplateRequest request) {
        return this.deleteNotebookRuntimeTemplateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteNotebookRuntimeTemplateRequest, Empty, DeleteOperationMetadata> deleteNotebookRuntimeTemplateOperationCallable() {
        return this.stub.deleteNotebookRuntimeTemplateOperationCallable();
    }

    public final UnaryCallable<DeleteNotebookRuntimeTemplateRequest, Operation> deleteNotebookRuntimeTemplateCallable() {
        return this.stub.deleteNotebookRuntimeTemplateCallable();
    }

    public final NotebookRuntimeTemplate updateNotebookRuntimeTemplate(NotebookRuntimeTemplate notebookRuntimeTemplate, FieldMask updateMask) {
        UpdateNotebookRuntimeTemplateRequest request = UpdateNotebookRuntimeTemplateRequest.newBuilder().setNotebookRuntimeTemplate(notebookRuntimeTemplate).setUpdateMask(updateMask).build();
        return this.updateNotebookRuntimeTemplate(request);
    }

    public final NotebookRuntimeTemplate updateNotebookRuntimeTemplate(UpdateNotebookRuntimeTemplateRequest request) {
        return (NotebookRuntimeTemplate)this.updateNotebookRuntimeTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateNotebookRuntimeTemplateRequest, NotebookRuntimeTemplate> updateNotebookRuntimeTemplateCallable() {
        return this.stub.updateNotebookRuntimeTemplateCallable();
    }

    public final OperationFuture<NotebookRuntime, AssignNotebookRuntimeOperationMetadata> assignNotebookRuntimeAsync(LocationName parent, NotebookRuntimeTemplateName notebookRuntimeTemplate, NotebookRuntime notebookRuntime, String notebookRuntimeId) {
        AssignNotebookRuntimeRequest request = AssignNotebookRuntimeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setNotebookRuntimeTemplate(notebookRuntimeTemplate == null ? null : notebookRuntimeTemplate.toString()).setNotebookRuntime(notebookRuntime).setNotebookRuntimeId(notebookRuntimeId).build();
        return this.assignNotebookRuntimeAsync(request);
    }

    public final OperationFuture<NotebookRuntime, AssignNotebookRuntimeOperationMetadata> assignNotebookRuntimeAsync(LocationName parent, String notebookRuntimeTemplate, NotebookRuntime notebookRuntime, String notebookRuntimeId) {
        AssignNotebookRuntimeRequest request = AssignNotebookRuntimeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setNotebookRuntimeTemplate(notebookRuntimeTemplate).setNotebookRuntime(notebookRuntime).setNotebookRuntimeId(notebookRuntimeId).build();
        return this.assignNotebookRuntimeAsync(request);
    }

    public final OperationFuture<NotebookRuntime, AssignNotebookRuntimeOperationMetadata> assignNotebookRuntimeAsync(String parent, NotebookRuntimeTemplateName notebookRuntimeTemplate, NotebookRuntime notebookRuntime, String notebookRuntimeId) {
        AssignNotebookRuntimeRequest request = AssignNotebookRuntimeRequest.newBuilder().setParent(parent).setNotebookRuntimeTemplate(notebookRuntimeTemplate == null ? null : notebookRuntimeTemplate.toString()).setNotebookRuntime(notebookRuntime).setNotebookRuntimeId(notebookRuntimeId).build();
        return this.assignNotebookRuntimeAsync(request);
    }

    public final OperationFuture<NotebookRuntime, AssignNotebookRuntimeOperationMetadata> assignNotebookRuntimeAsync(String parent, String notebookRuntimeTemplate, NotebookRuntime notebookRuntime, String notebookRuntimeId) {
        AssignNotebookRuntimeRequest request = AssignNotebookRuntimeRequest.newBuilder().setParent(parent).setNotebookRuntimeTemplate(notebookRuntimeTemplate).setNotebookRuntime(notebookRuntime).setNotebookRuntimeId(notebookRuntimeId).build();
        return this.assignNotebookRuntimeAsync(request);
    }

    public final OperationFuture<NotebookRuntime, AssignNotebookRuntimeOperationMetadata> assignNotebookRuntimeAsync(AssignNotebookRuntimeRequest request) {
        return this.assignNotebookRuntimeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AssignNotebookRuntimeRequest, NotebookRuntime, AssignNotebookRuntimeOperationMetadata> assignNotebookRuntimeOperationCallable() {
        return this.stub.assignNotebookRuntimeOperationCallable();
    }

    public final UnaryCallable<AssignNotebookRuntimeRequest, Operation> assignNotebookRuntimeCallable() {
        return this.stub.assignNotebookRuntimeCallable();
    }

    public final NotebookRuntime getNotebookRuntime(NotebookRuntimeName name) {
        GetNotebookRuntimeRequest request = GetNotebookRuntimeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNotebookRuntime(request);
    }

    public final NotebookRuntime getNotebookRuntime(String name) {
        GetNotebookRuntimeRequest request = GetNotebookRuntimeRequest.newBuilder().setName(name).build();
        return this.getNotebookRuntime(request);
    }

    public final NotebookRuntime getNotebookRuntime(GetNotebookRuntimeRequest request) {
        return (NotebookRuntime)this.getNotebookRuntimeCallable().call((Object)request);
    }

    public final UnaryCallable<GetNotebookRuntimeRequest, NotebookRuntime> getNotebookRuntimeCallable() {
        return this.stub.getNotebookRuntimeCallable();
    }

    public final ListNotebookRuntimesPagedResponse listNotebookRuntimes(LocationName parent) {
        ListNotebookRuntimesRequest request = ListNotebookRuntimesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNotebookRuntimes(request);
    }

    public final ListNotebookRuntimesPagedResponse listNotebookRuntimes(String parent) {
        ListNotebookRuntimesRequest request = ListNotebookRuntimesRequest.newBuilder().setParent(parent).build();
        return this.listNotebookRuntimes(request);
    }

    public final ListNotebookRuntimesPagedResponse listNotebookRuntimes(ListNotebookRuntimesRequest request) {
        return (ListNotebookRuntimesPagedResponse)((Object)this.listNotebookRuntimesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNotebookRuntimesRequest, ListNotebookRuntimesPagedResponse> listNotebookRuntimesPagedCallable() {
        return this.stub.listNotebookRuntimesPagedCallable();
    }

    public final UnaryCallable<ListNotebookRuntimesRequest, ListNotebookRuntimesResponse> listNotebookRuntimesCallable() {
        return this.stub.listNotebookRuntimesCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteNotebookRuntimeAsync(NotebookRuntimeName name) {
        DeleteNotebookRuntimeRequest request = DeleteNotebookRuntimeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteNotebookRuntimeAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteNotebookRuntimeAsync(String name) {
        DeleteNotebookRuntimeRequest request = DeleteNotebookRuntimeRequest.newBuilder().setName(name).build();
        return this.deleteNotebookRuntimeAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteNotebookRuntimeAsync(DeleteNotebookRuntimeRequest request) {
        return this.deleteNotebookRuntimeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteNotebookRuntimeRequest, Empty, DeleteOperationMetadata> deleteNotebookRuntimeOperationCallable() {
        return this.stub.deleteNotebookRuntimeOperationCallable();
    }

    public final UnaryCallable<DeleteNotebookRuntimeRequest, Operation> deleteNotebookRuntimeCallable() {
        return this.stub.deleteNotebookRuntimeCallable();
    }

    public final OperationFuture<UpgradeNotebookRuntimeResponse, UpgradeNotebookRuntimeOperationMetadata> upgradeNotebookRuntimeAsync(NotebookRuntimeName name) {
        UpgradeNotebookRuntimeRequest request = UpgradeNotebookRuntimeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.upgradeNotebookRuntimeAsync(request);
    }

    public final OperationFuture<UpgradeNotebookRuntimeResponse, UpgradeNotebookRuntimeOperationMetadata> upgradeNotebookRuntimeAsync(String name) {
        UpgradeNotebookRuntimeRequest request = UpgradeNotebookRuntimeRequest.newBuilder().setName(name).build();
        return this.upgradeNotebookRuntimeAsync(request);
    }

    public final OperationFuture<UpgradeNotebookRuntimeResponse, UpgradeNotebookRuntimeOperationMetadata> upgradeNotebookRuntimeAsync(UpgradeNotebookRuntimeRequest request) {
        return this.upgradeNotebookRuntimeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpgradeNotebookRuntimeRequest, UpgradeNotebookRuntimeResponse, UpgradeNotebookRuntimeOperationMetadata> upgradeNotebookRuntimeOperationCallable() {
        return this.stub.upgradeNotebookRuntimeOperationCallable();
    }

    public final UnaryCallable<UpgradeNotebookRuntimeRequest, Operation> upgradeNotebookRuntimeCallable() {
        return this.stub.upgradeNotebookRuntimeCallable();
    }

    public final OperationFuture<StartNotebookRuntimeResponse, StartNotebookRuntimeOperationMetadata> startNotebookRuntimeAsync(NotebookRuntimeName name) {
        StartNotebookRuntimeRequest request = StartNotebookRuntimeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.startNotebookRuntimeAsync(request);
    }

    public final OperationFuture<StartNotebookRuntimeResponse, StartNotebookRuntimeOperationMetadata> startNotebookRuntimeAsync(String name) {
        StartNotebookRuntimeRequest request = StartNotebookRuntimeRequest.newBuilder().setName(name).build();
        return this.startNotebookRuntimeAsync(request);
    }

    public final OperationFuture<StartNotebookRuntimeResponse, StartNotebookRuntimeOperationMetadata> startNotebookRuntimeAsync(StartNotebookRuntimeRequest request) {
        return this.startNotebookRuntimeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StartNotebookRuntimeRequest, StartNotebookRuntimeResponse, StartNotebookRuntimeOperationMetadata> startNotebookRuntimeOperationCallable() {
        return this.stub.startNotebookRuntimeOperationCallable();
    }

    public final UnaryCallable<StartNotebookRuntimeRequest, Operation> startNotebookRuntimeCallable() {
        return this.stub.startNotebookRuntimeCallable();
    }

    public final OperationFuture<NotebookExecutionJob, CreateNotebookExecutionJobOperationMetadata> createNotebookExecutionJobAsync(LocationName parent, NotebookExecutionJob notebookExecutionJob, String notebookExecutionJobId) {
        CreateNotebookExecutionJobRequest request = CreateNotebookExecutionJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setNotebookExecutionJob(notebookExecutionJob).setNotebookExecutionJobId(notebookExecutionJobId).build();
        return this.createNotebookExecutionJobAsync(request);
    }

    public final OperationFuture<NotebookExecutionJob, CreateNotebookExecutionJobOperationMetadata> createNotebookExecutionJobAsync(String parent, NotebookExecutionJob notebookExecutionJob, String notebookExecutionJobId) {
        CreateNotebookExecutionJobRequest request = CreateNotebookExecutionJobRequest.newBuilder().setParent(parent).setNotebookExecutionJob(notebookExecutionJob).setNotebookExecutionJobId(notebookExecutionJobId).build();
        return this.createNotebookExecutionJobAsync(request);
    }

    public final OperationFuture<NotebookExecutionJob, CreateNotebookExecutionJobOperationMetadata> createNotebookExecutionJobAsync(CreateNotebookExecutionJobRequest request) {
        return this.createNotebookExecutionJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateNotebookExecutionJobRequest, NotebookExecutionJob, CreateNotebookExecutionJobOperationMetadata> createNotebookExecutionJobOperationCallable() {
        return this.stub.createNotebookExecutionJobOperationCallable();
    }

    public final UnaryCallable<CreateNotebookExecutionJobRequest, Operation> createNotebookExecutionJobCallable() {
        return this.stub.createNotebookExecutionJobCallable();
    }

    public final NotebookExecutionJob getNotebookExecutionJob(NotebookExecutionJobName name) {
        GetNotebookExecutionJobRequest request = GetNotebookExecutionJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNotebookExecutionJob(request);
    }

    public final NotebookExecutionJob getNotebookExecutionJob(String name) {
        GetNotebookExecutionJobRequest request = GetNotebookExecutionJobRequest.newBuilder().setName(name).build();
        return this.getNotebookExecutionJob(request);
    }

    public final NotebookExecutionJob getNotebookExecutionJob(GetNotebookExecutionJobRequest request) {
        return (NotebookExecutionJob)this.getNotebookExecutionJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetNotebookExecutionJobRequest, NotebookExecutionJob> getNotebookExecutionJobCallable() {
        return this.stub.getNotebookExecutionJobCallable();
    }

    public final ListNotebookExecutionJobsPagedResponse listNotebookExecutionJobs(LocationName parent) {
        ListNotebookExecutionJobsRequest request = ListNotebookExecutionJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNotebookExecutionJobs(request);
    }

    public final ListNotebookExecutionJobsPagedResponse listNotebookExecutionJobs(String parent) {
        ListNotebookExecutionJobsRequest request = ListNotebookExecutionJobsRequest.newBuilder().setParent(parent).build();
        return this.listNotebookExecutionJobs(request);
    }

    public final ListNotebookExecutionJobsPagedResponse listNotebookExecutionJobs(ListNotebookExecutionJobsRequest request) {
        return (ListNotebookExecutionJobsPagedResponse)((Object)this.listNotebookExecutionJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNotebookExecutionJobsRequest, ListNotebookExecutionJobsPagedResponse> listNotebookExecutionJobsPagedCallable() {
        return this.stub.listNotebookExecutionJobsPagedCallable();
    }

    public final UnaryCallable<ListNotebookExecutionJobsRequest, ListNotebookExecutionJobsResponse> listNotebookExecutionJobsCallable() {
        return this.stub.listNotebookExecutionJobsCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteNotebookExecutionJobAsync(NotebookExecutionJobName name) {
        DeleteNotebookExecutionJobRequest request = DeleteNotebookExecutionJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteNotebookExecutionJobAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteNotebookExecutionJobAsync(String name) {
        DeleteNotebookExecutionJobRequest request = DeleteNotebookExecutionJobRequest.newBuilder().setName(name).build();
        return this.deleteNotebookExecutionJobAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteNotebookExecutionJobAsync(DeleteNotebookExecutionJobRequest request) {
        return this.deleteNotebookExecutionJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteNotebookExecutionJobRequest, Empty, DeleteOperationMetadata> deleteNotebookExecutionJobOperationCallable() {
        return this.stub.deleteNotebookExecutionJobOperationCallable();
    }

    public final UnaryCallable<DeleteNotebookExecutionJobRequest, Operation> deleteNotebookExecutionJobCallable() {
        return this.stub.deleteNotebookExecutionJobCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNotebookExecutionJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNotebookExecutionJobsRequest, ListNotebookExecutionJobsResponse, NotebookExecutionJob, ListNotebookExecutionJobsPage, ListNotebookExecutionJobsFixedSizeCollection> {
        private ListNotebookExecutionJobsFixedSizeCollection(List<ListNotebookExecutionJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNotebookExecutionJobsFixedSizeCollection createEmptyCollection() {
            return new ListNotebookExecutionJobsFixedSizeCollection(null, 0);
        }

        protected ListNotebookExecutionJobsFixedSizeCollection createCollection(List<ListNotebookExecutionJobsPage> pages, int collectionSize) {
            return new ListNotebookExecutionJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNotebookExecutionJobsPage
    extends AbstractPage<ListNotebookExecutionJobsRequest, ListNotebookExecutionJobsResponse, NotebookExecutionJob, ListNotebookExecutionJobsPage> {
        private ListNotebookExecutionJobsPage(PageContext<ListNotebookExecutionJobsRequest, ListNotebookExecutionJobsResponse, NotebookExecutionJob> context, ListNotebookExecutionJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListNotebookExecutionJobsPage createEmptyPage() {
            return new ListNotebookExecutionJobsPage(null, null);
        }

        protected ListNotebookExecutionJobsPage createPage(PageContext<ListNotebookExecutionJobsRequest, ListNotebookExecutionJobsResponse, NotebookExecutionJob> context, ListNotebookExecutionJobsResponse response) {
            return new ListNotebookExecutionJobsPage(context, response);
        }

        public ApiFuture<ListNotebookExecutionJobsPage> createPageAsync(PageContext<ListNotebookExecutionJobsRequest, ListNotebookExecutionJobsResponse, NotebookExecutionJob> context, ApiFuture<ListNotebookExecutionJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNotebookExecutionJobsPagedResponse
    extends AbstractPagedListResponse<ListNotebookExecutionJobsRequest, ListNotebookExecutionJobsResponse, NotebookExecutionJob, ListNotebookExecutionJobsPage, ListNotebookExecutionJobsFixedSizeCollection> {
        public static ApiFuture<ListNotebookExecutionJobsPagedResponse> createAsync(PageContext<ListNotebookExecutionJobsRequest, ListNotebookExecutionJobsResponse, NotebookExecutionJob> context, ApiFuture<ListNotebookExecutionJobsResponse> futureResponse) {
            ApiFuture<ListNotebookExecutionJobsPage> futurePage = ListNotebookExecutionJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNotebookExecutionJobsPagedResponse((ListNotebookExecutionJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListNotebookExecutionJobsPagedResponse(ListNotebookExecutionJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNotebookExecutionJobsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNotebookRuntimesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNotebookRuntimesRequest, ListNotebookRuntimesResponse, NotebookRuntime, ListNotebookRuntimesPage, ListNotebookRuntimesFixedSizeCollection> {
        private ListNotebookRuntimesFixedSizeCollection(List<ListNotebookRuntimesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNotebookRuntimesFixedSizeCollection createEmptyCollection() {
            return new ListNotebookRuntimesFixedSizeCollection(null, 0);
        }

        protected ListNotebookRuntimesFixedSizeCollection createCollection(List<ListNotebookRuntimesPage> pages, int collectionSize) {
            return new ListNotebookRuntimesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNotebookRuntimesPage
    extends AbstractPage<ListNotebookRuntimesRequest, ListNotebookRuntimesResponse, NotebookRuntime, ListNotebookRuntimesPage> {
        private ListNotebookRuntimesPage(PageContext<ListNotebookRuntimesRequest, ListNotebookRuntimesResponse, NotebookRuntime> context, ListNotebookRuntimesResponse response) {
            super(context, (Object)response);
        }

        private static ListNotebookRuntimesPage createEmptyPage() {
            return new ListNotebookRuntimesPage(null, null);
        }

        protected ListNotebookRuntimesPage createPage(PageContext<ListNotebookRuntimesRequest, ListNotebookRuntimesResponse, NotebookRuntime> context, ListNotebookRuntimesResponse response) {
            return new ListNotebookRuntimesPage(context, response);
        }

        public ApiFuture<ListNotebookRuntimesPage> createPageAsync(PageContext<ListNotebookRuntimesRequest, ListNotebookRuntimesResponse, NotebookRuntime> context, ApiFuture<ListNotebookRuntimesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNotebookRuntimesPagedResponse
    extends AbstractPagedListResponse<ListNotebookRuntimesRequest, ListNotebookRuntimesResponse, NotebookRuntime, ListNotebookRuntimesPage, ListNotebookRuntimesFixedSizeCollection> {
        public static ApiFuture<ListNotebookRuntimesPagedResponse> createAsync(PageContext<ListNotebookRuntimesRequest, ListNotebookRuntimesResponse, NotebookRuntime> context, ApiFuture<ListNotebookRuntimesResponse> futureResponse) {
            ApiFuture<ListNotebookRuntimesPage> futurePage = ListNotebookRuntimesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNotebookRuntimesPagedResponse((ListNotebookRuntimesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListNotebookRuntimesPagedResponse(ListNotebookRuntimesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNotebookRuntimesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNotebookRuntimeTemplatesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNotebookRuntimeTemplatesRequest, ListNotebookRuntimeTemplatesResponse, NotebookRuntimeTemplate, ListNotebookRuntimeTemplatesPage, ListNotebookRuntimeTemplatesFixedSizeCollection> {
        private ListNotebookRuntimeTemplatesFixedSizeCollection(List<ListNotebookRuntimeTemplatesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNotebookRuntimeTemplatesFixedSizeCollection createEmptyCollection() {
            return new ListNotebookRuntimeTemplatesFixedSizeCollection(null, 0);
        }

        protected ListNotebookRuntimeTemplatesFixedSizeCollection createCollection(List<ListNotebookRuntimeTemplatesPage> pages, int collectionSize) {
            return new ListNotebookRuntimeTemplatesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNotebookRuntimeTemplatesPage
    extends AbstractPage<ListNotebookRuntimeTemplatesRequest, ListNotebookRuntimeTemplatesResponse, NotebookRuntimeTemplate, ListNotebookRuntimeTemplatesPage> {
        private ListNotebookRuntimeTemplatesPage(PageContext<ListNotebookRuntimeTemplatesRequest, ListNotebookRuntimeTemplatesResponse, NotebookRuntimeTemplate> context, ListNotebookRuntimeTemplatesResponse response) {
            super(context, (Object)response);
        }

        private static ListNotebookRuntimeTemplatesPage createEmptyPage() {
            return new ListNotebookRuntimeTemplatesPage(null, null);
        }

        protected ListNotebookRuntimeTemplatesPage createPage(PageContext<ListNotebookRuntimeTemplatesRequest, ListNotebookRuntimeTemplatesResponse, NotebookRuntimeTemplate> context, ListNotebookRuntimeTemplatesResponse response) {
            return new ListNotebookRuntimeTemplatesPage(context, response);
        }

        public ApiFuture<ListNotebookRuntimeTemplatesPage> createPageAsync(PageContext<ListNotebookRuntimeTemplatesRequest, ListNotebookRuntimeTemplatesResponse, NotebookRuntimeTemplate> context, ApiFuture<ListNotebookRuntimeTemplatesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNotebookRuntimeTemplatesPagedResponse
    extends AbstractPagedListResponse<ListNotebookRuntimeTemplatesRequest, ListNotebookRuntimeTemplatesResponse, NotebookRuntimeTemplate, ListNotebookRuntimeTemplatesPage, ListNotebookRuntimeTemplatesFixedSizeCollection> {
        public static ApiFuture<ListNotebookRuntimeTemplatesPagedResponse> createAsync(PageContext<ListNotebookRuntimeTemplatesRequest, ListNotebookRuntimeTemplatesResponse, NotebookRuntimeTemplate> context, ApiFuture<ListNotebookRuntimeTemplatesResponse> futureResponse) {
            ApiFuture<ListNotebookRuntimeTemplatesPage> futurePage = ListNotebookRuntimeTemplatesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNotebookRuntimeTemplatesPagedResponse((ListNotebookRuntimeTemplatesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListNotebookRuntimeTemplatesPagedResponse(ListNotebookRuntimeTemplatesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNotebookRuntimeTemplatesFixedSizeCollection.createEmptyCollection());
        }
    }
}

