/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.apikeys.v2.stub;

import com.google.api.apikeys.v2.ApiKeysClient;
import com.google.api.apikeys.v2.CreateKeyRequest;
import com.google.api.apikeys.v2.DeleteKeyRequest;
import com.google.api.apikeys.v2.GetKeyRequest;
import com.google.api.apikeys.v2.GetKeyStringRequest;
import com.google.api.apikeys.v2.GetKeyStringResponse;
import com.google.api.apikeys.v2.Key;
import com.google.api.apikeys.v2.ListKeysRequest;
import com.google.api.apikeys.v2.ListKeysResponse;
import com.google.api.apikeys.v2.LookupKeyRequest;
import com.google.api.apikeys.v2.LookupKeyResponse;
import com.google.api.apikeys.v2.UndeleteKeyRequest;
import com.google.api.apikeys.v2.UpdateKeyRequest;
import com.google.api.apikeys.v2.stub.ApiKeysStub;
import com.google.api.apikeys.v2.stub.GrpcApiKeysStub;
import com.google.api.apikeys.v2.stub.HttpJsonApiKeysStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ApiKeysStubSettings
extends StubSettings<ApiKeysStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").build();
    private final UnaryCallSettings<CreateKeyRequest, Operation> createKeySettings;
    private final OperationCallSettings<CreateKeyRequest, Key, Empty> createKeyOperationSettings;
    private final PagedCallSettings<ListKeysRequest, ListKeysResponse, ApiKeysClient.ListKeysPagedResponse> listKeysSettings;
    private final UnaryCallSettings<GetKeyRequest, Key> getKeySettings;
    private final UnaryCallSettings<GetKeyStringRequest, GetKeyStringResponse> getKeyStringSettings;
    private final UnaryCallSettings<UpdateKeyRequest, Operation> updateKeySettings;
    private final OperationCallSettings<UpdateKeyRequest, Key, Empty> updateKeyOperationSettings;
    private final UnaryCallSettings<DeleteKeyRequest, Operation> deleteKeySettings;
    private final OperationCallSettings<DeleteKeyRequest, Key, Empty> deleteKeyOperationSettings;
    private final UnaryCallSettings<UndeleteKeyRequest, Operation> undeleteKeySettings;
    private final OperationCallSettings<UndeleteKeyRequest, Key, Empty> undeleteKeyOperationSettings;
    private final UnaryCallSettings<LookupKeyRequest, LookupKeyResponse> lookupKeySettings;
    private static final PagedListDescriptor<ListKeysRequest, ListKeysResponse, Key> LIST_KEYS_PAGE_STR_DESC = new PagedListDescriptor<ListKeysRequest, ListKeysResponse, Key>(){

        public String emptyToken() {
            return "";
        }

        public ListKeysRequest injectToken(ListKeysRequest payload, String token) {
            return ListKeysRequest.newBuilder((ListKeysRequest)payload).setPageToken(token).build();
        }

        public ListKeysRequest injectPageSize(ListKeysRequest payload, int pageSize) {
            return ListKeysRequest.newBuilder((ListKeysRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListKeysRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListKeysResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Key> extractResources(ListKeysResponse payload) {
            return payload.getKeysList() == null ? ImmutableList.of() : payload.getKeysList();
        }
    };
    private static final PagedListResponseFactory<ListKeysRequest, ListKeysResponse, ApiKeysClient.ListKeysPagedResponse> LIST_KEYS_PAGE_STR_FACT = new PagedListResponseFactory<ListKeysRequest, ListKeysResponse, ApiKeysClient.ListKeysPagedResponse>(){

        public ApiFuture<ApiKeysClient.ListKeysPagedResponse> getFuturePagedResponse(UnaryCallable<ListKeysRequest, ListKeysResponse> callable, ListKeysRequest request, ApiCallContext context, ApiFuture<ListKeysResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_KEYS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ApiKeysClient.ListKeysPagedResponse.createAsync((PageContext<ListKeysRequest, ListKeysResponse, Key>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateKeyRequest, Operation> createKeySettings() {
        return this.createKeySettings;
    }

    public OperationCallSettings<CreateKeyRequest, Key, Empty> createKeyOperationSettings() {
        return this.createKeyOperationSettings;
    }

    public PagedCallSettings<ListKeysRequest, ListKeysResponse, ApiKeysClient.ListKeysPagedResponse> listKeysSettings() {
        return this.listKeysSettings;
    }

    public UnaryCallSettings<GetKeyRequest, Key> getKeySettings() {
        return this.getKeySettings;
    }

    public UnaryCallSettings<GetKeyStringRequest, GetKeyStringResponse> getKeyStringSettings() {
        return this.getKeyStringSettings;
    }

    public UnaryCallSettings<UpdateKeyRequest, Operation> updateKeySettings() {
        return this.updateKeySettings;
    }

    public OperationCallSettings<UpdateKeyRequest, Key, Empty> updateKeyOperationSettings() {
        return this.updateKeyOperationSettings;
    }

    public UnaryCallSettings<DeleteKeyRequest, Operation> deleteKeySettings() {
        return this.deleteKeySettings;
    }

    public OperationCallSettings<DeleteKeyRequest, Key, Empty> deleteKeyOperationSettings() {
        return this.deleteKeyOperationSettings;
    }

    public UnaryCallSettings<UndeleteKeyRequest, Operation> undeleteKeySettings() {
        return this.undeleteKeySettings;
    }

    public OperationCallSettings<UndeleteKeyRequest, Key, Empty> undeleteKeyOperationSettings() {
        return this.undeleteKeyOperationSettings;
    }

    public UnaryCallSettings<LookupKeyRequest, LookupKeyResponse> lookupKeySettings() {
        return this.lookupKeySettings;
    }

    public ApiKeysStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcApiKeysStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonApiKeysStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "apikeys";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "apikeys.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "apikeys.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ApiKeysStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ApiKeysStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ApiKeysStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiKeysStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ApiKeysStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createKeySettings = settingsBuilder.createKeySettings().build();
        this.createKeyOperationSettings = settingsBuilder.createKeyOperationSettings().build();
        this.listKeysSettings = settingsBuilder.listKeysSettings().build();
        this.getKeySettings = settingsBuilder.getKeySettings().build();
        this.getKeyStringSettings = settingsBuilder.getKeyStringSettings().build();
        this.updateKeySettings = settingsBuilder.updateKeySettings().build();
        this.updateKeyOperationSettings = settingsBuilder.updateKeyOperationSettings().build();
        this.deleteKeySettings = settingsBuilder.deleteKeySettings().build();
        this.deleteKeyOperationSettings = settingsBuilder.deleteKeyOperationSettings().build();
        this.undeleteKeySettings = settingsBuilder.undeleteKeySettings().build();
        this.undeleteKeyOperationSettings = settingsBuilder.undeleteKeyOperationSettings().build();
        this.lookupKeySettings = settingsBuilder.lookupKeySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ApiKeysStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateKeyRequest, Operation> createKeySettings;
        private final OperationCallSettings.Builder<CreateKeyRequest, Key, Empty> createKeyOperationSettings;
        private final PagedCallSettings.Builder<ListKeysRequest, ListKeysResponse, ApiKeysClient.ListKeysPagedResponse> listKeysSettings;
        private final UnaryCallSettings.Builder<GetKeyRequest, Key> getKeySettings;
        private final UnaryCallSettings.Builder<GetKeyStringRequest, GetKeyStringResponse> getKeyStringSettings;
        private final UnaryCallSettings.Builder<UpdateKeyRequest, Operation> updateKeySettings;
        private final OperationCallSettings.Builder<UpdateKeyRequest, Key, Empty> updateKeyOperationSettings;
        private final UnaryCallSettings.Builder<DeleteKeyRequest, Operation> deleteKeySettings;
        private final OperationCallSettings.Builder<DeleteKeyRequest, Key, Empty> deleteKeyOperationSettings;
        private final UnaryCallSettings.Builder<UndeleteKeyRequest, Operation> undeleteKeySettings;
        private final OperationCallSettings.Builder<UndeleteKeyRequest, Key, Empty> undeleteKeyOperationSettings;
        private final UnaryCallSettings.Builder<LookupKeyRequest, LookupKeyResponse> lookupKeySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createKeyOperationSettings = OperationCallSettings.newBuilder();
            this.listKeysSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_KEYS_PAGE_STR_FACT);
            this.getKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getKeyStringSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateKeyOperationSettings = OperationCallSettings.newBuilder();
            this.deleteKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteKeyOperationSettings = OperationCallSettings.newBuilder();
            this.undeleteKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.undeleteKeyOperationSettings = OperationCallSettings.newBuilder();
            this.lookupKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createKeySettings, this.listKeysSettings, this.getKeySettings, this.getKeyStringSettings, this.updateKeySettings, this.deleteKeySettings, this.undeleteKeySettings, this.lookupKeySettings);
            Builder.initDefaults(this);
        }

        protected Builder(ApiKeysStubSettings settings) {
            super((StubSettings)settings);
            this.createKeySettings = settings.createKeySettings.toBuilder();
            this.createKeyOperationSettings = settings.createKeyOperationSettings.toBuilder();
            this.listKeysSettings = settings.listKeysSettings.toBuilder();
            this.getKeySettings = settings.getKeySettings.toBuilder();
            this.getKeyStringSettings = settings.getKeyStringSettings.toBuilder();
            this.updateKeySettings = settings.updateKeySettings.toBuilder();
            this.updateKeyOperationSettings = settings.updateKeyOperationSettings.toBuilder();
            this.deleteKeySettings = settings.deleteKeySettings.toBuilder();
            this.deleteKeyOperationSettings = settings.deleteKeyOperationSettings.toBuilder();
            this.undeleteKeySettings = settings.undeleteKeySettings.toBuilder();
            this.undeleteKeyOperationSettings = settings.undeleteKeyOperationSettings.toBuilder();
            this.lookupKeySettings = settings.lookupKeySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createKeySettings, this.listKeysSettings, this.getKeySettings, this.getKeyStringSettings, this.updateKeySettings, this.deleteKeySettings, this.undeleteKeySettings, this.lookupKeySettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ApiKeysStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ApiKeysStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ApiKeysStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ApiKeysStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ApiKeysStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ApiKeysStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ApiKeysStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ApiKeysStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ApiKeysStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ApiKeysStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listKeysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getKeyStringSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.undeleteKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.lookupKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createKeyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Key.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Empty.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateKeyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Key.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Empty.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteKeyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Key.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Empty.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.undeleteKeyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Key.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Empty.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateKeyRequest, Operation> createKeySettings() {
            return this.createKeySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateKeyRequest, Key, Empty> createKeyOperationSettings() {
            return this.createKeyOperationSettings;
        }

        public PagedCallSettings.Builder<ListKeysRequest, ListKeysResponse, ApiKeysClient.ListKeysPagedResponse> listKeysSettings() {
            return this.listKeysSettings;
        }

        public UnaryCallSettings.Builder<GetKeyRequest, Key> getKeySettings() {
            return this.getKeySettings;
        }

        public UnaryCallSettings.Builder<GetKeyStringRequest, GetKeyStringResponse> getKeyStringSettings() {
            return this.getKeyStringSettings;
        }

        public UnaryCallSettings.Builder<UpdateKeyRequest, Operation> updateKeySettings() {
            return this.updateKeySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateKeyRequest, Key, Empty> updateKeyOperationSettings() {
            return this.updateKeyOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteKeyRequest, Operation> deleteKeySettings() {
            return this.deleteKeySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteKeyRequest, Key, Empty> deleteKeyOperationSettings() {
            return this.deleteKeyOperationSettings;
        }

        public UnaryCallSettings.Builder<UndeleteKeyRequest, Operation> undeleteKeySettings() {
            return this.undeleteKeySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UndeleteKeyRequest, Key, Empty> undeleteKeyOperationSettings() {
            return this.undeleteKeyOperationSettings;
        }

        public UnaryCallSettings.Builder<LookupKeyRequest, LookupKeyResponse> lookupKeySettings() {
            return this.lookupKeySettings;
        }

        public ApiKeysStubSettings build() throws IOException {
            return new ApiKeysStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)10000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)10000L)).setTotalTimeout(Duration.ofMillis((long)10000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

