/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.cloud.automl.v1beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.automl.v1beta1.stub.PredictionServiceStubSettings;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.List;
import javax.annotation.Generated;

// AUTO-GENERATED DOCUMENTATION AND CLASS
/**
 * Settings class to configure an instance of {@link PredictionServiceClient}.
 *
 * <p>The default instance has everything set to sensible defaults:
 *
 * <ul>
 *   <li>The default service address (automl.googleapis.com) and default port (443) are used.
 *   <li>Credentials are acquired automatically through Application Default Credentials.
 *   <li>Retries are configured for idempotent methods but not for non-idempotent methods.
 * </ul>
 *
 * <p>The builder of this class is recursive, so contained classes are themselves builders. When
 * build() is called, the tree of builders is called to create the complete settings object.
 *
 * <p>For example, to set the total timeout of predict to 30 seconds:
 *
 * <pre>
 * <code>
 * PredictionServiceSettings.Builder predictionServiceSettingsBuilder =
 *     PredictionServiceSettings.newBuilder();
 * predictionServiceSettingsBuilder.predictSettings().getRetrySettings().toBuilder()
 *     .setTotalTimeout(Duration.ofSeconds(30));
 * PredictionServiceSettings predictionServiceSettings = predictionServiceSettingsBuilder.build();
 * </code>
 * </pre>
 */
@Generated("by gapic-generator")
@BetaApi
public class PredictionServiceSettings extends ClientSettings<PredictionServiceSettings> {
  /** Returns the object with the settings used for calls to predict. */
  public UnaryCallSettings<PredictRequest, PredictResponse> predictSettings() {
    return ((PredictionServiceStubSettings) getStubSettings()).predictSettings();
  }

  /** Returns the object with the settings used for calls to batchPredict. */
  public UnaryCallSettings<BatchPredictRequest, Operation> batchPredictSettings() {
    return ((PredictionServiceStubSettings) getStubSettings()).batchPredictSettings();
  }

  /** Returns the object with the settings used for calls to batchPredict. */
  @BetaApi(
      "The surface for long-running operations is not stable yet and may change in the future.")
  public OperationCallSettings<BatchPredictRequest, BatchPredictResult, OperationMetadata>
      batchPredictOperationSettings() {
    return ((PredictionServiceStubSettings) getStubSettings()).batchPredictOperationSettings();
  }

  public static final PredictionServiceSettings create(PredictionServiceStubSettings stub)
      throws IOException {
    return new PredictionServiceSettings.Builder(stub.toBuilder()).build();
  }

  /** Returns a builder for the default ExecutorProvider for this service. */
  public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
    return PredictionServiceStubSettings.defaultExecutorProviderBuilder();
  }

  /** Returns the default service endpoint. */
  public static String getDefaultEndpoint() {
    return PredictionServiceStubSettings.getDefaultEndpoint();
  }

  /** Returns the default service scopes. */
  public static List<String> getDefaultServiceScopes() {
    return PredictionServiceStubSettings.getDefaultServiceScopes();
  }

  /** Returns a builder for the default credentials for this service. */
  public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
    return PredictionServiceStubSettings.defaultCredentialsProviderBuilder();
  }

  /** Returns a builder for the default ChannelProvider for this service. */
  public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
    return PredictionServiceStubSettings.defaultGrpcTransportProviderBuilder();
  }

  public static TransportChannelProvider defaultTransportChannelProvider() {
    return PredictionServiceStubSettings.defaultTransportChannelProvider();
  }

  @BetaApi("The surface for customizing headers is not stable yet and may change in the future.")
  public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
    return PredictionServiceStubSettings.defaultApiClientHeaderProviderBuilder();
  }

  /** Returns a new builder for this class. */
  public static Builder newBuilder() {
    return Builder.createDefault();
  }

  /** Returns a new builder for this class. */
  public static Builder newBuilder(ClientContext clientContext) {
    return new Builder(clientContext);
  }

  /** Returns a builder containing all the values of this settings class. */
  public Builder toBuilder() {
    return new Builder(this);
  }

  protected PredictionServiceSettings(Builder settingsBuilder) throws IOException {
    super(settingsBuilder);
  }

  /** Builder for PredictionServiceSettings. */
  public static class Builder extends ClientSettings.Builder<PredictionServiceSettings, Builder> {
    protected Builder() throws IOException {
      this((ClientContext) null);
    }

    protected Builder(ClientContext clientContext) {
      super(PredictionServiceStubSettings.newBuilder(clientContext));
    }

    private static Builder createDefault() {
      return new Builder(PredictionServiceStubSettings.newBuilder());
    }

    protected Builder(PredictionServiceSettings settings) {
      super(settings.getStubSettings().toBuilder());
    }

    protected Builder(PredictionServiceStubSettings.Builder stubSettings) {
      super(stubSettings);
    }

    public PredictionServiceStubSettings.Builder getStubSettingsBuilder() {
      return ((PredictionServiceStubSettings.Builder) getStubSettings());
    }

    // NEXT_MAJOR_VER: remove 'throws Exception'
    /**
     * Applies the given settings updater function to all of the unary API methods in this service.
     *
     * <p>Note: This method does not support applying settings to streaming methods.
     */
    public Builder applyToAllUnaryMethods(
        ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
      super.applyToAllUnaryMethods(
          getStubSettingsBuilder().unaryMethodSettingsBuilders(), settingsUpdater);
      return this;
    }

    /** Returns the builder for the settings used for calls to predict. */
    public UnaryCallSettings.Builder<PredictRequest, PredictResponse> predictSettings() {
      return getStubSettingsBuilder().predictSettings();
    }

    /** Returns the builder for the settings used for calls to batchPredict. */
    public UnaryCallSettings.Builder<BatchPredictRequest, Operation> batchPredictSettings() {
      return getStubSettingsBuilder().batchPredictSettings();
    }

    /** Returns the builder for the settings used for calls to batchPredict. */
    @BetaApi(
        "The surface for long-running operations is not stable yet and may change in the future.")
    public OperationCallSettings.Builder<BatchPredictRequest, BatchPredictResult, OperationMetadata>
        batchPredictOperationSettings() {
      return getStubSettingsBuilder().batchPredictOperationSettings();
    }

    @Override
    public PredictionServiceSettings build() throws IOException {
      return new PredictionServiceSettings(this);
    }
  }
}
