/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class InsertAllRequest
implements Serializable {
    private static final long serialVersionUID = 211200307773853078L;
    private final TableId table;
    private final List<RowToInsert> rows;
    private final Boolean skipInvalidRows;
    private final Boolean ignoreUnknownValues;
    private final String templateSuffix;

    private InsertAllRequest(Builder builder) {
        this.table = (TableId)Preconditions.checkNotNull((Object)builder.table);
        this.rows = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull((Object)builder.rows)));
        this.ignoreUnknownValues = builder.ignoreUnknownValues;
        this.skipInvalidRows = builder.skipInvalidRows;
        this.templateSuffix = builder.templateSuffix;
    }

    public TableId getTable() {
        return this.table;
    }

    public List<RowToInsert> getRows() {
        return this.rows;
    }

    public Boolean ignoreUnknownValues() {
        return this.ignoreUnknownValues;
    }

    public Boolean skipInvalidRows() {
        return this.skipInvalidRows;
    }

    public String getTemplateSuffix() {
        return this.templateSuffix;
    }

    public static Builder newBuilder(TableId table) {
        return new Builder().setTable(table);
    }

    public static Builder newBuilder(TableId table, Iterable<RowToInsert> rows) {
        return InsertAllRequest.newBuilder(table).setRows(rows);
    }

    public static Builder newBuilder(TableId table, RowToInsert ... rows) {
        return InsertAllRequest.newBuilder(table, (Iterable<RowToInsert>)ImmutableList.copyOf((Object[])rows));
    }

    public static Builder newBuilder(String datasetId, String tableId) {
        return new Builder().setTable(TableId.of(datasetId, tableId));
    }

    public static Builder newBuilder(String datasetId, String tableId, Iterable<RowToInsert> rows) {
        return InsertAllRequest.newBuilder(TableId.of(datasetId, tableId), rows);
    }

    public static Builder newBuilder(String datasetId, String tableId, RowToInsert ... rows) {
        return InsertAllRequest.newBuilder(TableId.of(datasetId, tableId), rows);
    }

    public static Builder newBuilder(TableInfo tableInfo, Iterable<RowToInsert> rows) {
        return InsertAllRequest.newBuilder(tableInfo.getTableId(), rows);
    }

    public static Builder newBuilder(TableInfo tableInfo, RowToInsert ... rows) {
        return InsertAllRequest.newBuilder(tableInfo.getTableId(), rows);
    }

    public static InsertAllRequest of(TableId tableId, Iterable<RowToInsert> rows) {
        return InsertAllRequest.newBuilder(tableId, rows).build();
    }

    public static InsertAllRequest of(TableId tableId, RowToInsert ... rows) {
        return InsertAllRequest.newBuilder(tableId, rows).build();
    }

    public static InsertAllRequest of(String datasetId, String tableId, Iterable<RowToInsert> rows) {
        return InsertAllRequest.newBuilder(datasetId, tableId, rows).build();
    }

    public static InsertAllRequest of(String datasetId, String tableId, RowToInsert ... rows) {
        return InsertAllRequest.newBuilder(datasetId, tableId, rows).build();
    }

    public static InsertAllRequest of(TableInfo tableInfo, Iterable<RowToInsert> rows) {
        return InsertAllRequest.newBuilder(tableInfo.getTableId(), rows).build();
    }

    public static InsertAllRequest of(TableInfo tableInfo, RowToInsert ... rows) {
        return InsertAllRequest.newBuilder(tableInfo.getTableId(), rows).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("rows", this.rows).add("ignoreUnknownValues", (Object)this.ignoreUnknownValues).add("skipInvalidRows", (Object)this.skipInvalidRows).add("templateSuffix", (Object)this.templateSuffix).toString();
    }

    public int hashCode() {
        return Objects.hash(this.table, this.rows, this.ignoreUnknownValues, this.skipInvalidRows, this.templateSuffix);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InsertAllRequest)) {
            return false;
        }
        InsertAllRequest other = (InsertAllRequest)obj;
        return Objects.equals(this.table, other.table) && Objects.equals(this.rows, other.rows) && Objects.equals(this.ignoreUnknownValues, other.ignoreUnknownValues) && Objects.equals(this.skipInvalidRows, other.skipInvalidRows) && Objects.equals(this.templateSuffix, other.templateSuffix);
    }

    public static final class Builder {
        private TableId table;
        private List<RowToInsert> rows;
        private Boolean skipInvalidRows;
        private Boolean ignoreUnknownValues;
        private String templateSuffix;

        private Builder() {
        }

        public Builder setTable(TableId table) {
            this.table = (TableId)Preconditions.checkNotNull((Object)table);
            return this;
        }

        public Builder setRows(Iterable<RowToInsert> rows) {
            this.rows = Lists.newLinkedList((Iterable)((Iterable)Preconditions.checkNotNull(rows)));
            return this;
        }

        public Builder addRow(RowToInsert rowToInsert) {
            Preconditions.checkNotNull((Object)rowToInsert);
            if (this.rows == null) {
                this.rows = Lists.newArrayList();
            }
            this.rows.add(rowToInsert);
            return this;
        }

        public Builder addRow(String id, Map<String, ?> content) {
            this.addRow(new RowToInsert(id, content));
            return this;
        }

        public Builder addRow(Map<String, ?> content) {
            this.addRow(new RowToInsert(null, content));
            return this;
        }

        public Builder setSkipInvalidRows(boolean skipInvalidRows) {
            this.skipInvalidRows = skipInvalidRows;
            return this;
        }

        public Builder setIgnoreUnknownValues(boolean ignoreUnknownValues) {
            this.ignoreUnknownValues = ignoreUnknownValues;
            return this;
        }

        public Builder setTemplateSuffix(String templateSuffix) {
            this.templateSuffix = templateSuffix;
            return this;
        }

        public InsertAllRequest build() {
            return new InsertAllRequest(this);
        }
    }

    public static class RowToInsert
    implements Serializable {
        private static final long serialVersionUID = 8563060538219179157L;
        private final String id;
        private final Map<String, Object> content;

        RowToInsert(String id, Map<String, ?> content) {
            this.id = id;
            this.content = ImmutableMap.copyOf(content);
        }

        public String getId() {
            return this.id;
        }

        public Map<String, Object> getContent() {
            return this.content;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("content", this.content).toString();
        }

        public int hashCode() {
            return Objects.hash(this.id, this.content);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RowToInsert)) {
                return false;
            }
            RowToInsert other = (RowToInsert)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.content, other.content);
        }

        public static RowToInsert of(String id, Map<String, ?> content) {
            return new RowToInsert((String)Preconditions.checkNotNull((Object)id), (Map)Preconditions.checkNotNull(content));
        }

        public static RowToInsert of(Map<String, ?> content) {
            return new RowToInsert(null, (Map)Preconditions.checkNotNull(content));
        }
    }
}

