
package com.google.cloud.bigquery;

import com.google.common.collect.ImmutableList;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_QueryResponse extends QueryResponse {

  private final Schema schema;
  private final boolean completed;
  private final long totalRows;
  private final ImmutableList<BigQueryError> errors;

  private AutoValue_QueryResponse(
      @Nullable Schema schema,
      boolean completed,
      long totalRows,
      ImmutableList<BigQueryError> errors) {
    this.schema = schema;
    this.completed = completed;
    this.totalRows = totalRows;
    if (errors == null) {
      throw new NullPointerException("Null errors");
    }
    this.errors = errors;
  }

  @Nullable
  @Override
  Schema getSchema() {
    return schema;
  }

  @Override
  boolean getCompleted() {
    return completed;
  }

  @Override
  long getTotalRows() {
    return totalRows;
  }

  @Override
  ImmutableList<BigQueryError> getErrors() {
    return errors;
  }

  @Override
  public String toString() {
    return "QueryResponse{"
        + "schema=" + schema + ", "
        + "completed=" + completed + ", "
        + "totalRows=" + totalRows + ", "
        + "errors=" + errors
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof QueryResponse) {
      QueryResponse that = (QueryResponse) o;
      return ((this.schema == null) ? (that.getSchema() == null) : this.schema.equals(that.getSchema()))
           && (this.completed == that.getCompleted())
           && (this.totalRows == that.getTotalRows())
           && (this.errors.equals(that.getErrors()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (schema == null) ? 0 : this.schema.hashCode();
    h *= 1000003;
    h ^= this.completed ? 1231 : 1237;
    h *= 1000003;
    h ^= (this.totalRows >>> 32) ^ this.totalRows;
    h *= 1000003;
    h ^= this.errors.hashCode();
    return h;
  }

  static final class Builder extends QueryResponse.Builder {
    private Schema schema;
    private Boolean completed;
    private Long totalRows;
    private ImmutableList<BigQueryError> errors;
    Builder() {
    }
    Builder(QueryResponse source) {
      this.schema = source.getSchema();
      this.completed = source.getCompleted();
      this.totalRows = source.getTotalRows();
      this.errors = source.getErrors();
    }
    @Override
    public QueryResponse.Builder setSchema(@Nullable Schema schema) {
      this.schema = schema;
      return this;
    }
    @Override
    public QueryResponse.Builder setCompleted(boolean completed) {
      this.completed = completed;
      return this;
    }
    @Override
    public QueryResponse.Builder setTotalRows(long totalRows) {
      this.totalRows = totalRows;
      return this;
    }
    @Override
    public QueryResponse.Builder setErrors(ImmutableList<BigQueryError> errors) {
      this.errors = errors;
      return this;
    }
    @Override
    public QueryResponse build() {
      String missing = "";
      if (completed == null) {
        missing += " completed";
      }
      if (totalRows == null) {
        missing += " totalRows";
      }
      if (errors == null) {
        missing += " errors";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_QueryResponse(
          this.schema,
          this.completed,
          this.totalRows,
          this.errors);
    }
  }

}
