/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public final class TableId
implements Serializable {
    static final Function<TableReference, TableId> FROM_PB_FUNCTION = new Function<TableReference, TableId>(){

        public TableId apply(TableReference pb) {
            return TableId.fromPb(pb);
        }
    };
    static final Function<TableId, TableReference> TO_PB_FUNCTION = new Function<TableId, TableReference>(){

        public TableReference apply(TableId tableId) {
            return tableId.toPb();
        }
    };
    private static final long serialVersionUID = -6186254820908152300L;
    private final String project;
    private final String dataset;
    private final String table;

    @Deprecated
    public String project() {
        return this.getProject();
    }

    public String getProject() {
        return this.project;
    }

    @Deprecated
    public String dataset() {
        return this.getDataset();
    }

    public String getDataset() {
        return this.dataset;
    }

    @Deprecated
    public String table() {
        return this.getTable();
    }

    public String getTable() {
        return this.table;
    }

    private TableId(String project, String dataset, String table) {
        this.project = project;
        this.dataset = dataset;
        this.table = table;
    }

    public static TableId of(String project, String dataset, String table) {
        return new TableId((String)Preconditions.checkNotNull((Object)project), (String)Preconditions.checkNotNull((Object)dataset), (String)Preconditions.checkNotNull((Object)table));
    }

    public static TableId of(String dataset, String table) {
        return new TableId(null, (String)Preconditions.checkNotNull((Object)dataset), (String)Preconditions.checkNotNull((Object)table));
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof TableId && Objects.equals(this.toPb(), ((TableId)obj).toPb());
    }

    public int hashCode() {
        return Objects.hash(this.project, this.dataset, this.table);
    }

    public String toString() {
        return this.toPb().toString();
    }

    TableId setProjectId(String projectId) {
        return this.getProject() != null ? this : TableId.of(projectId, this.getDataset(), this.getTable());
    }

    TableReference toPb() {
        return new TableReference().setProjectId(this.project).setDatasetId(this.dataset).setTableId(this.table);
    }

    static TableId fromPb(TableReference tableRef) {
        return new TableId(tableRef.getProjectId(), tableRef.getDatasetId(), tableRef.getTableId());
    }
}

