package com.google.cloud.bigquery;

import com.google.common.collect.ImmutableList;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ExternalTableDefinition extends ExternalTableDefinition {

  private final TableDefinition.Type type;

  private final Schema schema;

  private final String compression;

  private final Boolean ignoreUnknownValues;

  private final Integer maxBadRecords;

  private final ImmutableList<String> sourceUrisImmut;

  private final FormatOptions formatOptionsInner;

  private final Boolean autodetect;

  private final HivePartitioningOptions hivePartitioningOptionsInner;

  private AutoValue_ExternalTableDefinition(
      TableDefinition.Type type,
      @Nullable Schema schema,
      @Nullable String compression,
      @Nullable Boolean ignoreUnknownValues,
      @Nullable Integer maxBadRecords,
      @Nullable ImmutableList<String> sourceUrisImmut,
      @Nullable FormatOptions formatOptionsInner,
      @Nullable Boolean autodetect,
      @Nullable HivePartitioningOptions hivePartitioningOptionsInner) {
    this.type = type;
    this.schema = schema;
    this.compression = compression;
    this.ignoreUnknownValues = ignoreUnknownValues;
    this.maxBadRecords = maxBadRecords;
    this.sourceUrisImmut = sourceUrisImmut;
    this.formatOptionsInner = formatOptionsInner;
    this.autodetect = autodetect;
    this.hivePartitioningOptionsInner = hivePartitioningOptionsInner;
  }

  @Override
  public TableDefinition.Type getType() {
    return type;
  }

  @Nullable
  @Override
  public Schema getSchema() {
    return schema;
  }

  @Nullable
  @Override
  public String getCompression() {
    return compression;
  }

  @Nullable
  @Override
  public Boolean getIgnoreUnknownValues() {
    return ignoreUnknownValues;
  }

  @Nullable
  @Override
  public Integer getMaxBadRecords() {
    return maxBadRecords;
  }

  @Nullable
  @Override
  public ImmutableList<String> getSourceUrisImmut() {
    return sourceUrisImmut;
  }

  @Nullable
  @Override
  FormatOptions getFormatOptionsInner() {
    return formatOptionsInner;
  }

  @Nullable
  @Override
  public Boolean getAutodetect() {
    return autodetect;
  }

  @Nullable
  @Override
  HivePartitioningOptions getHivePartitioningOptionsInner() {
    return hivePartitioningOptionsInner;
  }

  @Override
  public String toString() {
    return "ExternalTableDefinition{"
         + "type=" + type + ", "
         + "schema=" + schema + ", "
         + "compression=" + compression + ", "
         + "ignoreUnknownValues=" + ignoreUnknownValues + ", "
         + "maxBadRecords=" + maxBadRecords + ", "
         + "sourceUrisImmut=" + sourceUrisImmut + ", "
         + "formatOptionsInner=" + formatOptionsInner + ", "
         + "autodetect=" + autodetect + ", "
         + "hivePartitioningOptionsInner=" + hivePartitioningOptionsInner
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ExternalTableDefinition) {
      ExternalTableDefinition that = (ExternalTableDefinition) o;
      return this.type.equals(that.getType())
          && (this.schema == null ? that.getSchema() == null : this.schema.equals(that.getSchema()))
          && (this.compression == null ? that.getCompression() == null : this.compression.equals(that.getCompression()))
          && (this.ignoreUnknownValues == null ? that.getIgnoreUnknownValues() == null : this.ignoreUnknownValues.equals(that.getIgnoreUnknownValues()))
          && (this.maxBadRecords == null ? that.getMaxBadRecords() == null : this.maxBadRecords.equals(that.getMaxBadRecords()))
          && (this.sourceUrisImmut == null ? that.getSourceUrisImmut() == null : this.sourceUrisImmut.equals(that.getSourceUrisImmut()))
          && (this.formatOptionsInner == null ? that.getFormatOptionsInner() == null : this.formatOptionsInner.equals(that.getFormatOptionsInner()))
          && (this.autodetect == null ? that.getAutodetect() == null : this.autodetect.equals(that.getAutodetect()))
          && (this.hivePartitioningOptionsInner == null ? that.getHivePartitioningOptionsInner() == null : this.hivePartitioningOptionsInner.equals(that.getHivePartitioningOptionsInner()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= (schema == null) ? 0 : schema.hashCode();
    h$ *= 1000003;
    h$ ^= (compression == null) ? 0 : compression.hashCode();
    h$ *= 1000003;
    h$ ^= (ignoreUnknownValues == null) ? 0 : ignoreUnknownValues.hashCode();
    h$ *= 1000003;
    h$ ^= (maxBadRecords == null) ? 0 : maxBadRecords.hashCode();
    h$ *= 1000003;
    h$ ^= (sourceUrisImmut == null) ? 0 : sourceUrisImmut.hashCode();
    h$ *= 1000003;
    h$ ^= (formatOptionsInner == null) ? 0 : formatOptionsInner.hashCode();
    h$ *= 1000003;
    h$ ^= (autodetect == null) ? 0 : autodetect.hashCode();
    h$ *= 1000003;
    h$ ^= (hivePartitioningOptionsInner == null) ? 0 : hivePartitioningOptionsInner.hashCode();
    return h$;
  }

  private static final long serialVersionUID = -5951580238459622025L;

  @Override
  public ExternalTableDefinition.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ExternalTableDefinition.Builder {
    private TableDefinition.Type type;
    private Schema schema;
    private String compression;
    private Boolean ignoreUnknownValues;
    private Integer maxBadRecords;
    private ImmutableList<String> sourceUrisImmut;
    private FormatOptions formatOptionsInner;
    private Boolean autodetect;
    private HivePartitioningOptions hivePartitioningOptionsInner;
    Builder() {
    }
    private Builder(ExternalTableDefinition source) {
      this.type = source.getType();
      this.schema = source.getSchema();
      this.compression = source.getCompression();
      this.ignoreUnknownValues = source.getIgnoreUnknownValues();
      this.maxBadRecords = source.getMaxBadRecords();
      this.sourceUrisImmut = source.getSourceUrisImmut();
      this.formatOptionsInner = source.getFormatOptionsInner();
      this.autodetect = source.getAutodetect();
      this.hivePartitioningOptionsInner = source.getHivePartitioningOptionsInner();
    }
    @Override
    public ExternalTableDefinition.Builder setType(TableDefinition.Type type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public ExternalTableDefinition.Builder setSchema(Schema schema) {
      this.schema = schema;
      return this;
    }
    @Override
    public ExternalTableDefinition.Builder setCompression(String compression) {
      this.compression = compression;
      return this;
    }
    @Override
    public ExternalTableDefinition.Builder setIgnoreUnknownValues(Boolean ignoreUnknownValues) {
      this.ignoreUnknownValues = ignoreUnknownValues;
      return this;
    }
    @Override
    public ExternalTableDefinition.Builder setMaxBadRecords(Integer maxBadRecords) {
      this.maxBadRecords = maxBadRecords;
      return this;
    }
    @Override
    ExternalTableDefinition.Builder setSourceUrisImmut(ImmutableList<String> sourceUrisImmut) {
      this.sourceUrisImmut = sourceUrisImmut;
      return this;
    }
    @Override
    ExternalTableDefinition.Builder setFormatOptionsInner(FormatOptions formatOptionsInner) {
      this.formatOptionsInner = formatOptionsInner;
      return this;
    }
    @Override
    public ExternalTableDefinition.Builder setAutodetect(Boolean autodetect) {
      this.autodetect = autodetect;
      return this;
    }
    @Override
    ExternalTableDefinition.Builder setHivePartitioningOptionsInner(HivePartitioningOptions hivePartitioningOptionsInner) {
      this.hivePartitioningOptionsInner = hivePartitioningOptionsInner;
      return this;
    }
    @Override
    public ExternalTableDefinition build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ExternalTableDefinition(
          this.type,
          this.schema,
          this.compression,
          this.ignoreUnknownValues,
          this.maxBadRecords,
          this.sourceUrisImmut,
          this.formatOptionsInner,
          this.autodetect,
          this.hivePartitioningOptionsInner);
    }
  }

}
