
package com.google.cloud.bigquery;

import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_JobId extends JobId {

  private final String project;
  private final String job;
  private final String location;

  private AutoValue_JobId(
      @Nullable String project,
      @Nullable String job,
      @Nullable String location) {
    this.project = project;
    this.job = job;
    this.location = location;
  }

  @Nullable
  @Override
  public String getProject() {
    return project;
  }

  @Nullable
  @Override
  public String getJob() {
    return job;
  }

  @Nullable
  @Override
  String getLocation() {
    return location;
  }

  @Override
  public String toString() {
    return "JobId{"
        + "project=" + project + ", "
        + "job=" + job + ", "
        + "location=" + location
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof JobId) {
      JobId that = (JobId) o;
      return ((this.project == null) ? (that.getProject() == null) : this.project.equals(that.getProject()))
           && ((this.job == null) ? (that.getJob() == null) : this.job.equals(that.getJob()))
           && ((this.location == null) ? (that.getLocation() == null) : this.location.equals(that.getLocation()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (project == null) ? 0 : this.project.hashCode();
    h *= 1000003;
    h ^= (job == null) ? 0 : this.job.hashCode();
    h *= 1000003;
    h ^= (location == null) ? 0 : this.location.hashCode();
    return h;
  }

  private static final long serialVersionUID = 1225914835379688977L;

  @Override
  public JobId.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends JobId.Builder {
    private String project;
    private String job;
    private String location;
    Builder() {
    }
    private Builder(JobId source) {
      this.project = source.getProject();
      this.job = source.getJob();
      this.location = source.getLocation();
    }
    @Override
    public JobId.Builder setProject(@Nullable String project) {
      this.project = project;
      return this;
    }
    @Override
    public JobId.Builder setJob(@Nullable String job) {
      this.job = job;
      return this;
    }
    @Override
    JobId.Builder setLocation(@Nullable String location) {
      this.location = location;
      return this;
    }
    @Override
    public JobId build() {
      return new AutoValue_JobId(
          this.project,
          this.job,
          this.location);
    }
  }

}
