
package com.google.cloud.bigquery;

import com.google.common.collect.ImmutableList;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_QueryParameterValue extends QueryParameterValue {

  private final String value;
  private final ImmutableList<QueryParameterValue> arrayValuesInner;
  private final StandardSQLTypeName type;
  private final StandardSQLTypeName arrayType;

  private AutoValue_QueryParameterValue(
      @Nullable String value,
      @Nullable ImmutableList<QueryParameterValue> arrayValuesInner,
      StandardSQLTypeName type,
      @Nullable StandardSQLTypeName arrayType) {
    this.value = value;
    this.arrayValuesInner = arrayValuesInner;
    this.type = type;
    this.arrayType = arrayType;
  }

  @Nullable
  @Override
  public String getValue() {
    return value;
  }

  @Nullable
  @Override
  ImmutableList<QueryParameterValue> getArrayValuesInner() {
    return arrayValuesInner;
  }

  @Override
  public StandardSQLTypeName getType() {
    return type;
  }

  @Nullable
  @Override
  public StandardSQLTypeName getArrayType() {
    return arrayType;
  }

  @Override
  public String toString() {
    return "QueryParameterValue{"
        + "value=" + value + ", "
        + "arrayValuesInner=" + arrayValuesInner + ", "
        + "type=" + type + ", "
        + "arrayType=" + arrayType
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof QueryParameterValue) {
      QueryParameterValue that = (QueryParameterValue) o;
      return ((this.value == null) ? (that.getValue() == null) : this.value.equals(that.getValue()))
           && ((this.arrayValuesInner == null) ? (that.getArrayValuesInner() == null) : this.arrayValuesInner.equals(that.getArrayValuesInner()))
           && (this.type.equals(that.getType()))
           && ((this.arrayType == null) ? (that.getArrayType() == null) : this.arrayType.equals(that.getArrayType()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (value == null) ? 0 : this.value.hashCode();
    h *= 1000003;
    h ^= (arrayValuesInner == null) ? 0 : this.arrayValuesInner.hashCode();
    h *= 1000003;
    h ^= this.type.hashCode();
    h *= 1000003;
    h ^= (arrayType == null) ? 0 : this.arrayType.hashCode();
    return h;
  }

  private static final long serialVersionUID = -5620695863123562896L;

  @Override
  public QueryParameterValue.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends QueryParameterValue.Builder {
    private String value;
    private ImmutableList<QueryParameterValue> arrayValuesInner;
    private StandardSQLTypeName type;
    private StandardSQLTypeName arrayType;
    Builder() {
    }
    private Builder(QueryParameterValue source) {
      this.value = source.getValue();
      this.arrayValuesInner = source.getArrayValuesInner();
      this.type = source.getType();
      this.arrayType = source.getArrayType();
    }
    @Override
    public QueryParameterValue.Builder setValue(@Nullable String value) {
      this.value = value;
      return this;
    }
    @Override
    QueryParameterValue.Builder setArrayValuesInner(@Nullable ImmutableList<QueryParameterValue> arrayValuesInner) {
      this.arrayValuesInner = arrayValuesInner;
      return this;
    }
    @Override
    public QueryParameterValue.Builder setType(StandardSQLTypeName type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public QueryParameterValue.Builder setArrayType(@Nullable StandardSQLTypeName arrayType) {
      this.arrayType = arrayType;
      return this;
    }
    @Override
    public QueryParameterValue build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_QueryParameterValue(
          this.value,
          this.arrayValuesInner,
          this.type,
          this.arrayType);
    }
  }

}
