/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.ModelTableDefinition;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableDefinition;
import javax.annotation.Nullable;

final class AutoValue_ModelTableDefinition
extends ModelTableDefinition {
    private final TableDefinition.Type type;
    private final Schema schema;
    private final Long numBytes;
    private final String location;
    private static final long serialVersionUID = 2113445776046717900L;

    private AutoValue_ModelTableDefinition(TableDefinition.Type type, @Nullable Schema schema, @Nullable Long numBytes, @Nullable String location) {
        this.type = type;
        this.schema = schema;
        this.numBytes = numBytes;
        this.location = location;
    }

    @Override
    public TableDefinition.Type getType() {
        return this.type;
    }

    @Override
    @Nullable
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    @Nullable
    public Long getNumBytes() {
        return this.numBytes;
    }

    @Override
    @Nullable
    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return "ModelTableDefinition{type=" + (Object)((Object)this.type) + ", schema=" + this.schema + ", numBytes=" + this.numBytes + ", location=" + this.location + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ModelTableDefinition) {
            ModelTableDefinition that = (ModelTableDefinition)o;
            return this.type.equals((Object)that.getType()) && (this.schema == null ? that.getSchema() == null : this.schema.equals(that.getSchema())) && (this.numBytes == null ? that.getNumBytes() == null : this.numBytes.equals(that.getNumBytes())) && (this.location == null ? that.getLocation() == null : this.location.equals(that.getLocation()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.type.hashCode();
        h *= 1000003;
        h ^= this.schema == null ? 0 : this.schema.hashCode();
        h *= 1000003;
        h ^= this.numBytes == null ? 0 : this.numBytes.hashCode();
        h *= 1000003;
        return h ^= this.location == null ? 0 : this.location.hashCode();
    }

    @Override
    public ModelTableDefinition.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ModelTableDefinition.Builder {
        private TableDefinition.Type type;
        private Schema schema;
        private Long numBytes;
        private String location;

        Builder() {
        }

        private Builder(ModelTableDefinition source) {
            this.type = source.getType();
            this.schema = source.getSchema();
            this.numBytes = source.getNumBytes();
            this.location = source.getLocation();
        }

        @Override
        public ModelTableDefinition.Builder setType(TableDefinition.Type type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public ModelTableDefinition.Builder setSchema(@Nullable Schema schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public ModelTableDefinition.Builder setNumBytes(@Nullable Long numBytes) {
            this.numBytes = numBytes;
            return this;
        }

        @Override
        public ModelTableDefinition.Builder setLocation(@Nullable String location) {
            this.location = location;
            return this;
        }

        @Override
        public ModelTableDefinition build() {
            String missing = "";
            if (this.type == null) {
                missing = missing + " type";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ModelTableDefinition(this.type, this.schema, this.numBytes, this.location);
        }
    }
}

