/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.RoutineArgument;
import com.google.cloud.bigquery.RoutineId;
import com.google.cloud.bigquery.RoutineInfo;
import com.google.cloud.bigquery.StandardSQLDataType;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Objects;

public class Routine
extends RoutineInfo {
    private final BigQueryOptions options;
    private transient BigQuery bigquery;

    Routine(BigQuery bigquery, RoutineInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.bigquery = (BigQuery)Preconditions.checkNotNull((Object)bigquery);
        this.options = (BigQueryOptions)bigquery.getOptions();
    }

    public boolean exists() {
        return this.bigquery.getRoutine(this.getRoutineId(), BigQuery.RoutineOption.fields(new BigQuery.RoutineField[0])) != null;
    }

    public Routine reload(BigQuery.RoutineOption ... options) {
        return this.bigquery.getRoutine(this.getRoutineId(), options);
    }

    public Routine update(BigQuery.RoutineOption ... options) {
        return this.bigquery.update(this, options);
    }

    public boolean delete() {
        return this.bigquery.delete(this.getRoutineId());
    }

    public BigQuery getBigQuery() {
        return this.bigquery;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Routine.class)) {
            return false;
        }
        Routine other = (Routine)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.bigquery = (BigQuery)this.options.getService();
    }

    static Routine fromPb(BigQuery bigquery, com.google.api.services.bigquery.model.Routine routinePb) {
        return new Routine(bigquery, new RoutineInfo.BuilderImpl(routinePb));
    }

    public static class Builder
    extends RoutineInfo.Builder {
        private final BigQuery bigquery;
        private final RoutineInfo.BuilderImpl infoBuilder;

        Builder(BigQuery bigquery, RoutineId routineId) {
            this.bigquery = bigquery;
            this.infoBuilder = new RoutineInfo.BuilderImpl();
            this.infoBuilder.setRoutineId(routineId);
        }

        Builder(Routine routine) {
            this.bigquery = routine.bigquery;
            this.infoBuilder = new RoutineInfo.BuilderImpl(routine);
        }

        @Override
        Builder setRoutineId(RoutineId id) {
            this.infoBuilder.setRoutineId(id);
            return this;
        }

        @Override
        Builder setEtag(String etag) {
            this.infoBuilder.setEtag(etag);
            return this;
        }

        @Override
        public Builder setRoutineType(String routineType) {
            this.infoBuilder.setRoutineType(routineType);
            return this;
        }

        @Override
        Builder setCreationTime(Long creationMillis) {
            this.infoBuilder.setCreationTime(creationMillis);
            return this;
        }

        @Override
        Builder setLastModifiedTime(Long lastModifiedMillis) {
            this.infoBuilder.setLastModifiedTime(lastModifiedMillis);
            return this;
        }

        @Override
        public Builder setLanguage(String language) {
            this.infoBuilder.setLanguage(language);
            return this;
        }

        @Override
        public Builder setArguments(List<RoutineArgument> arguments) {
            this.infoBuilder.setArguments(arguments);
            return this;
        }

        @Override
        public Builder setReturnType(StandardSQLDataType returnType) {
            this.infoBuilder.setReturnType(returnType);
            return this;
        }

        @Override
        public Builder setImportedLibraries(List<String> libraries) {
            this.infoBuilder.setImportedLibraries(libraries);
            return this;
        }

        @Override
        public Builder setBody(String body) {
            this.infoBuilder.setBody(body);
            return this;
        }

        @Override
        public Routine build() {
            return new Routine(this.bigquery, this.infoBuilder);
        }
    }
}

