package com.google.cloud.bigquery;

import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_StandardTableDefinition extends StandardTableDefinition {

  private final TableDefinition.Type type;

  private final Schema schema;

  private final Long numBytes;

  private final Long numLongTermBytes;

  private final Long numRows;

  private final String location;

  private final StandardTableDefinition.StreamingBuffer streamingBuffer;

  private final TimePartitioning timePartitioning;

  private final RangePartitioning rangePartitioning;

  private final Clustering clustering;

  private final TableConstraints tableConstraints;

  private AutoValue_StandardTableDefinition(
      TableDefinition.Type type,
      @Nullable Schema schema,
      @Nullable Long numBytes,
      @Nullable Long numLongTermBytes,
      @Nullable Long numRows,
      @Nullable String location,
      @Nullable StandardTableDefinition.StreamingBuffer streamingBuffer,
      @Nullable TimePartitioning timePartitioning,
      @Nullable RangePartitioning rangePartitioning,
      @Nullable Clustering clustering,
      @Nullable TableConstraints tableConstraints) {
    this.type = type;
    this.schema = schema;
    this.numBytes = numBytes;
    this.numLongTermBytes = numLongTermBytes;
    this.numRows = numRows;
    this.location = location;
    this.streamingBuffer = streamingBuffer;
    this.timePartitioning = timePartitioning;
    this.rangePartitioning = rangePartitioning;
    this.clustering = clustering;
    this.tableConstraints = tableConstraints;
  }

  @Override
  public TableDefinition.Type getType() {
    return type;
  }

  @Nullable
  @Override
  public Schema getSchema() {
    return schema;
  }

  @Nullable
  @Override
  public Long getNumBytes() {
    return numBytes;
  }

  @Nullable
  @Override
  public Long getNumLongTermBytes() {
    return numLongTermBytes;
  }

  @Nullable
  @Override
  public Long getNumRows() {
    return numRows;
  }

  @Nullable
  @Override
  public String getLocation() {
    return location;
  }

  @Nullable
  @Override
  public StandardTableDefinition.StreamingBuffer getStreamingBuffer() {
    return streamingBuffer;
  }

  @Nullable
  @Override
  public TimePartitioning getTimePartitioning() {
    return timePartitioning;
  }

  @Nullable
  @Override
  public RangePartitioning getRangePartitioning() {
    return rangePartitioning;
  }

  @Nullable
  @Override
  public Clustering getClustering() {
    return clustering;
  }

  @Nullable
  @Override
  public TableConstraints getTableConstraints() {
    return tableConstraints;
  }

  @Override
  public String toString() {
    return "StandardTableDefinition{"
        + "type=" + type + ", "
        + "schema=" + schema + ", "
        + "numBytes=" + numBytes + ", "
        + "numLongTermBytes=" + numLongTermBytes + ", "
        + "numRows=" + numRows + ", "
        + "location=" + location + ", "
        + "streamingBuffer=" + streamingBuffer + ", "
        + "timePartitioning=" + timePartitioning + ", "
        + "rangePartitioning=" + rangePartitioning + ", "
        + "clustering=" + clustering + ", "
        + "tableConstraints=" + tableConstraints
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof StandardTableDefinition) {
      StandardTableDefinition that = (StandardTableDefinition) o;
      return this.type.equals(that.getType())
          && (this.schema == null ? that.getSchema() == null : this.schema.equals(that.getSchema()))
          && (this.numBytes == null ? that.getNumBytes() == null : this.numBytes.equals(that.getNumBytes()))
          && (this.numLongTermBytes == null ? that.getNumLongTermBytes() == null : this.numLongTermBytes.equals(that.getNumLongTermBytes()))
          && (this.numRows == null ? that.getNumRows() == null : this.numRows.equals(that.getNumRows()))
          && (this.location == null ? that.getLocation() == null : this.location.equals(that.getLocation()))
          && (this.streamingBuffer == null ? that.getStreamingBuffer() == null : this.streamingBuffer.equals(that.getStreamingBuffer()))
          && (this.timePartitioning == null ? that.getTimePartitioning() == null : this.timePartitioning.equals(that.getTimePartitioning()))
          && (this.rangePartitioning == null ? that.getRangePartitioning() == null : this.rangePartitioning.equals(that.getRangePartitioning()))
          && (this.clustering == null ? that.getClustering() == null : this.clustering.equals(that.getClustering()))
          && (this.tableConstraints == null ? that.getTableConstraints() == null : this.tableConstraints.equals(that.getTableConstraints()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= (schema == null) ? 0 : schema.hashCode();
    h$ *= 1000003;
    h$ ^= (numBytes == null) ? 0 : numBytes.hashCode();
    h$ *= 1000003;
    h$ ^= (numLongTermBytes == null) ? 0 : numLongTermBytes.hashCode();
    h$ *= 1000003;
    h$ ^= (numRows == null) ? 0 : numRows.hashCode();
    h$ *= 1000003;
    h$ ^= (location == null) ? 0 : location.hashCode();
    h$ *= 1000003;
    h$ ^= (streamingBuffer == null) ? 0 : streamingBuffer.hashCode();
    h$ *= 1000003;
    h$ ^= (timePartitioning == null) ? 0 : timePartitioning.hashCode();
    h$ *= 1000003;
    h$ ^= (rangePartitioning == null) ? 0 : rangePartitioning.hashCode();
    h$ *= 1000003;
    h$ ^= (clustering == null) ? 0 : clustering.hashCode();
    h$ *= 1000003;
    h$ ^= (tableConstraints == null) ? 0 : tableConstraints.hashCode();
    return h$;
  }

  private static final long serialVersionUID = 2113445776046717900L;

  @Override
  public StandardTableDefinition.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends StandardTableDefinition.Builder {
    private TableDefinition.Type type;
    private Schema schema;
    private Long numBytes;
    private Long numLongTermBytes;
    private Long numRows;
    private String location;
    private StandardTableDefinition.StreamingBuffer streamingBuffer;
    private TimePartitioning timePartitioning;
    private RangePartitioning rangePartitioning;
    private Clustering clustering;
    private TableConstraints tableConstraints;
    Builder() {
    }
    private Builder(StandardTableDefinition source) {
      this.type = source.getType();
      this.schema = source.getSchema();
      this.numBytes = source.getNumBytes();
      this.numLongTermBytes = source.getNumLongTermBytes();
      this.numRows = source.getNumRows();
      this.location = source.getLocation();
      this.streamingBuffer = source.getStreamingBuffer();
      this.timePartitioning = source.getTimePartitioning();
      this.rangePartitioning = source.getRangePartitioning();
      this.clustering = source.getClustering();
      this.tableConstraints = source.getTableConstraints();
    }
    @Override
    public StandardTableDefinition.Builder setType(TableDefinition.Type type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setSchema(Schema schema) {
      this.schema = schema;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setNumBytes(Long numBytes) {
      this.numBytes = numBytes;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setNumLongTermBytes(Long numLongTermBytes) {
      this.numLongTermBytes = numLongTermBytes;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setNumRows(Long numRows) {
      this.numRows = numRows;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setLocation(String location) {
      this.location = location;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setStreamingBuffer(StandardTableDefinition.StreamingBuffer streamingBuffer) {
      this.streamingBuffer = streamingBuffer;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setTimePartitioning(TimePartitioning timePartitioning) {
      this.timePartitioning = timePartitioning;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setRangePartitioning(RangePartitioning rangePartitioning) {
      this.rangePartitioning = rangePartitioning;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setClustering(Clustering clustering) {
      this.clustering = clustering;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setTableConstraints(TableConstraints tableConstraints) {
      this.tableConstraints = tableConstraints;
      return this;
    }
    @Override
    public StandardTableDefinition build() {
      if (this.type == null) {
        String missing = " type";
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_StandardTableDefinition(
          this.type,
          this.schema,
          this.numBytes,
          this.numLongTermBytes,
          this.numRows,
          this.location,
          this.streamingBuffer,
          this.timePartitioning,
          this.rangePartitioning,
          this.clustering,
          this.tableConstraints);
    }
  }

}
