/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Dataset;
import com.google.cloud.bigquery.Acl;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.RoutineId;
import com.google.cloud.bigquery.TableId;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class AclTest {
    @Test
    public void testDatasetEntity() {
        DatasetId datasetId = DatasetId.of((String)"dataset");
        ImmutableList targetTypes = ImmutableList.of((Object)"VIEWS");
        Acl.DatasetAclEntity entity = new Acl.DatasetAclEntity(datasetId, (List)targetTypes);
        Assert.assertEquals((Object)datasetId, (Object)entity.getId());
        Assert.assertEquals((Object)targetTypes, (Object)entity.getTargetTypes());
        Dataset.Access pb = entity.toPb();
        Assert.assertEquals((Object)entity, (Object)Acl.Entity.fromPb((Dataset.Access)pb));
    }

    @Test
    public void testDomainEntity() {
        Acl.Domain entity = new Acl.Domain("d1");
        Assert.assertEquals((Object)"d1", (Object)entity.getDomain());
        Assert.assertEquals((Object)Acl.Entity.Type.DOMAIN, (Object)entity.getType());
        Dataset.Access pb = entity.toPb();
        Assert.assertEquals((Object)entity, (Object)Acl.Entity.fromPb((Dataset.Access)pb));
    }

    @Test
    public void testGroupEntity() {
        Acl.Group entity = new Acl.Group("g1");
        Assert.assertEquals((Object)"g1", (Object)entity.getIdentifier());
        Assert.assertEquals((Object)Acl.Entity.Type.GROUP, (Object)entity.getType());
        Dataset.Access pb = entity.toPb();
        Assert.assertEquals((Object)entity, (Object)Acl.Entity.fromPb((Dataset.Access)pb));
    }

    @Test
    public void testSpecialGroupEntity() {
        Acl.Group entity = Acl.Group.ofAllAuthenticatedUsers();
        Assert.assertEquals((Object)"allAuthenticatedUsers", (Object)entity.getIdentifier());
        Dataset.Access pb = entity.toPb();
        Assert.assertEquals((Object)entity, (Object)Acl.Entity.fromPb((Dataset.Access)pb));
        entity = Acl.Group.ofProjectWriters();
        Assert.assertEquals((Object)"projectWriters", (Object)entity.getIdentifier());
        pb = entity.toPb();
        Assert.assertEquals((Object)entity, (Object)Acl.Entity.fromPb((Dataset.Access)pb));
        entity = Acl.Group.ofProjectReaders();
        Assert.assertEquals((Object)"projectReaders", (Object)entity.getIdentifier());
        pb = entity.toPb();
        Assert.assertEquals((Object)entity, (Object)Acl.Entity.fromPb((Dataset.Access)pb));
        entity = Acl.Group.ofProjectOwners();
        Assert.assertEquals((Object)"projectOwners", (Object)entity.getIdentifier());
        pb = entity.toPb();
        Assert.assertEquals((Object)entity, (Object)Acl.Entity.fromPb((Dataset.Access)pb));
    }

    @Test
    public void testUserEntity() {
        Acl.User entity = new Acl.User("u1");
        Assert.assertEquals((Object)"u1", (Object)entity.getEmail());
        Assert.assertEquals((Object)Acl.Entity.Type.USER, (Object)entity.getType());
        Dataset.Access pb = entity.toPb();
        Assert.assertEquals((Object)entity, (Object)Acl.Entity.fromPb((Dataset.Access)pb));
    }

    @Test
    public void testViewEntity() {
        TableId viewId = TableId.of((String)"project", (String)"dataset", (String)"view");
        Acl.View entity = new Acl.View(viewId);
        Assert.assertEquals((Object)viewId, (Object)entity.getId());
        Assert.assertEquals((Object)Acl.Entity.Type.VIEW, (Object)entity.getType());
        Dataset.Access pb = entity.toPb();
        Assert.assertEquals((Object)entity, (Object)Acl.Entity.fromPb((Dataset.Access)pb));
    }

    @Test
    public void testRoutineEntity() {
        RoutineId routineId = RoutineId.of((String)"project", (String)"dataset", (String)"routine");
        Acl.Routine entity = new Acl.Routine(routineId);
        Assert.assertEquals((Object)routineId, (Object)entity.getId());
        Assert.assertEquals((Object)Acl.Entity.Type.ROUTINE, (Object)entity.getType());
        Dataset.Access pb = entity.toPb();
        Assert.assertEquals((Object)entity, (Object)Acl.Entity.fromPb((Dataset.Access)pb));
    }

    @Test
    public void testIamMemberEntity() {
        Acl.IamMember entity = new Acl.IamMember("member1");
        Assert.assertEquals((Object)"member1", (Object)entity.getIamMember());
        Dataset.Access pb = entity.toPb();
        Assert.assertEquals((Object)entity, (Object)Acl.Entity.fromPb((Dataset.Access)pb));
    }

    @Test
    public void testOf() {
        Acl acl = Acl.of((Acl.Entity)Acl.Group.ofAllAuthenticatedUsers(), (Acl.Role)Acl.Role.READER);
        Assert.assertEquals((Object)Acl.Group.ofAllAuthenticatedUsers(), (Object)acl.getEntity());
        Assert.assertEquals((Object)Acl.Role.READER, (Object)acl.getRole());
        Dataset.Access pb = acl.toPb();
        Assert.assertEquals((Object)acl, (Object)Acl.fromPb((Dataset.Access)pb));
        Acl.View view = new Acl.View(TableId.of((String)"project", (String)"dataset", (String)"view"));
        acl = Acl.of((Acl.View)view);
        Assert.assertEquals((Object)view, (Object)acl.getEntity());
        Assert.assertEquals(null, (Object)acl.getRole());
        Acl.Routine routine = new Acl.Routine(RoutineId.of((String)"project", (String)"dataset", (String)"routine"));
        acl = Acl.of((Acl.Routine)routine);
        Assert.assertEquals((Object)routine, (Object)acl.getEntity());
        Assert.assertEquals(null, (Object)acl.getRole());
    }

    @Test
    public void testOfWithCondition() {
        Acl.Expr expr = new Acl.Expr("expression", "title", "description", "location");
        Acl acl = Acl.of((Acl.Entity)Acl.Group.ofAllAuthenticatedUsers(), (Acl.Role)Acl.Role.READER, (Acl.Expr)expr);
        Dataset.Access pb = acl.toPb();
        Assert.assertEquals((Object)acl, (Object)Acl.fromPb((Dataset.Access)pb));
        Assert.assertEquals((Object)acl.getCondition(), (Object)expr);
    }
}

