/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.client.util.Data;
import com.google.cloud.bigquery.Annotations;
import com.google.common.truth.Truth;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class AnnotationsTest {
    @Test
    public void testFromUser() {
        Truth.assertThat((Map)Annotations.fromUser(null).userMap()).isNull();
        HashMap<String, String> user = new HashMap<String, String>();
        Truth.assertThat((Map)Annotations.fromUser(user).userMap()).isEmpty();
        user.put("a", "b");
        Annotations annotations = Annotations.fromUser(user);
        Truth.assertThat((Map)annotations.userMap()).containsExactly((Object)"a", (Object)"b", new Object[0]);
        user.put("c", "d");
        Truth.assertThat((Map)annotations.userMap()).containsExactly((Object)"a", (Object)"b", new Object[0]);
    }

    @Test
    public void testFromToPb() {
        Truth.assertThat((Map)Annotations.fromPb(null).toPb()).isNull();
        HashMap<String, String> pb = new HashMap<String, String>();
        Truth.assertThat((Map)Annotations.fromPb(pb).toPb()).isNull();
        pb.put("a", "b");
        Truth.assertThat((Map)Annotations.fromPb(pb).toPb()).isEqualTo(pb);
        pb.put("c", Data.NULL_STRING);
        Truth.assertThat((Map)Annotations.fromPb(pb).toPb()).isEqualTo(pb);
        Map jsonNullMap = (Map)Data.nullOf(HashMap.class);
        Truth.assertThat((Boolean)Data.isNull((Object)Annotations.fromPb((Map)jsonNullMap).toPb())).isTrue();
    }

    @Test
    public void testNullKey() {
        try {
            Annotations.fromUser(Collections.singletonMap(null, "foo"));
            Assert.fail((String)"null key shouldn't work");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Annotations.fromPb(Collections.singletonMap(null, "foo"));
            Assert.fail((String)"null key shouldn't work");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

