/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.AvroOptions;
import org.junit.Assert;
import org.junit.Test;

public class AvroOptionsTest {
    private static final Boolean USE_AVRO_LOGICAL_TYPES = true;
    private static final AvroOptions AVRO_OPTIONS = AvroOptions.newBuilder().setUseAvroLogicalTypes(USE_AVRO_LOGICAL_TYPES.booleanValue()).build();

    @Test
    public void testToBuilder() {
        this.compareAvroOptions(AVRO_OPTIONS, AVRO_OPTIONS.toBuilder().build());
        AvroOptions avroOptions = AVRO_OPTIONS.toBuilder().setUseAvroLogicalTypes(false).build();
        Assert.assertEquals((Object)false, (Object)avroOptions.useAvroLogicalTypes());
        avroOptions = avroOptions.toBuilder().setUseAvroLogicalTypes(true).build();
        this.compareAvroOptions(AVRO_OPTIONS, avroOptions);
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)"AVRO", (Object)AVRO_OPTIONS.getType());
        Assert.assertEquals((Object)USE_AVRO_LOGICAL_TYPES, (Object)AVRO_OPTIONS.useAvroLogicalTypes());
    }

    @Test
    public void testToAndFromPb() {
        this.compareAvroOptions(AVRO_OPTIONS, AvroOptions.fromPb((com.google.api.services.bigquery.model.AvroOptions)AVRO_OPTIONS.toPb()));
        AvroOptions avroOptions = AvroOptions.newBuilder().setUseAvroLogicalTypes(USE_AVRO_LOGICAL_TYPES.booleanValue()).build();
        this.compareAvroOptions(avroOptions, AvroOptions.fromPb((com.google.api.services.bigquery.model.AvroOptions)avroOptions.toPb()));
    }

    private void compareAvroOptions(AvroOptions expected, AvroOptions value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.useAvroLogicalTypes(), (Object)value.useAvroLogicalTypes());
    }
}

