/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.BigLakeConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class BigLakeConfigurationTest {
    private static final String STORAGE_URI = "gs://storage-uri";
    private static final String FILE_FORMAT = "PARQUET";
    private static final String TABLE_FORMAT = "ICEBERG";
    private static final String CONNECTION_ID = "us.test-connection";
    private static final BigLakeConfiguration BIG_LAKE_CONFIGURATION = BigLakeConfiguration.newBuilder().setStorageUri("gs://storage-uri").setFileFormat("PARQUET").setTableFormat("ICEBERG").setConnectionId("us.test-connection").build();
    private static final com.google.api.services.bigquery.model.BigLakeConfiguration BIG_LAKE_CONFIGURATION_PB = new com.google.api.services.bigquery.model.BigLakeConfiguration().setStorageUri("gs://storage-uri").setFileFormat("PARQUET").setTableFormat("ICEBERG").setConnectionId("us.test-connection");

    @Test
    public void testToBuilder() {
        Assert.assertEquals((Object)STORAGE_URI, (Object)BIG_LAKE_CONFIGURATION.getStorageUri());
        Assert.assertEquals((Object)FILE_FORMAT, (Object)BIG_LAKE_CONFIGURATION.getFileFormat());
        Assert.assertEquals((Object)TABLE_FORMAT, (Object)BIG_LAKE_CONFIGURATION.getTableFormat());
        Assert.assertEquals((Object)CONNECTION_ID, (Object)BIG_LAKE_CONFIGURATION.getConnectionId());
    }

    @Test
    public void testToPb() {
        BigLakeConfigurationTest.assertBigLakeConfiguration(BIG_LAKE_CONFIGURATION_PB, BIG_LAKE_CONFIGURATION.toPb());
    }

    @Test
    public void testFromPb() {
        BigLakeConfigurationTest.assertBigLakeConfiguration(BIG_LAKE_CONFIGURATION, BigLakeConfiguration.fromPb((com.google.api.services.bigquery.model.BigLakeConfiguration)BIG_LAKE_CONFIGURATION_PB));
    }

    private static void assertBigLakeConfiguration(BigLakeConfiguration expected, BigLakeConfiguration actual) {
        Assert.assertEquals((Object)expected.getConnectionId(), (Object)actual.getConnectionId());
        Assert.assertEquals((Object)expected.getTableFormat(), (Object)actual.getTableFormat());
        Assert.assertEquals((Object)expected.getStorageUri(), (Object)actual.getStorageUri());
        Assert.assertEquals((Object)expected.getFileFormat(), (Object)actual.getFileFormat());
    }

    private static void assertBigLakeConfiguration(com.google.api.services.bigquery.model.BigLakeConfiguration expected, com.google.api.services.bigquery.model.BigLakeConfiguration actual) {
        Assert.assertEquals((Object)expected.getConnectionId(), (Object)actual.getConnectionId());
        Assert.assertEquals((Object)expected.getTableFormat(), (Object)actual.getTableFormat());
        Assert.assertEquals((Object)expected.getStorageUri(), (Object)actual.getStorageUri());
        Assert.assertEquals((Object)expected.getFileFormat(), (Object)actual.getFileFormat());
    }
}

