/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpResponseException;
import com.google.cloud.BaseServiceException;
import com.google.cloud.RetryHelper;
import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.BigQueryException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class BigQueryExceptionTest {
    @Test
    public void testBigQueryException() {
        BigQueryException exception = new BigQueryException(500, "message");
        Assert.assertEquals((long)500L, (long)exception.getCode());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertNull((Object)exception.getReason());
        Assert.assertNull((Object)exception.getError());
        Assert.assertTrue((boolean)exception.isRetryable());
        exception = new BigQueryException(502, "message");
        Assert.assertEquals((long)502L, (long)exception.getCode());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertNull((Object)exception.getReason());
        Assert.assertNull((Object)exception.getError());
        Assert.assertTrue((boolean)exception.isRetryable());
        exception = new BigQueryException(503, "message");
        Assert.assertEquals((long)503L, (long)exception.getCode());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertNull((Object)exception.getReason());
        Assert.assertNull((Object)exception.getError());
        Assert.assertTrue((boolean)exception.isRetryable());
        exception = new BigQueryException(504, "message");
        Assert.assertEquals((long)504L, (long)exception.getCode());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertNull((Object)exception.getReason());
        Assert.assertNull((Object)exception.getError());
        Assert.assertTrue((boolean)exception.isRetryable());
        exception = new BigQueryException(400, "message");
        Assert.assertEquals((long)400L, (long)exception.getCode());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertNull((Object)exception.getReason());
        Assert.assertNull((Object)exception.getError());
        Assert.assertFalse((boolean)exception.isRetryable());
        BigQueryError error = new BigQueryError("reason", null, null);
        exception = new BigQueryException(504, "message", error);
        Assert.assertEquals((long)504L, (long)exception.getCode());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertEquals((Object)"reason", (Object)exception.getReason());
        Assert.assertEquals((Object)error, (Object)exception.getError());
        Assert.assertTrue((boolean)exception.isRetryable());
        SocketTimeoutException cause = new SocketTimeoutException("socketTimeoutMessage");
        exception = new BigQueryException((IOException)cause);
        Assert.assertEquals((long)0L, (long)exception.getCode());
        Assert.assertNull((Object)exception.getReason());
        Assert.assertEquals((Object)"socketTimeoutMessage", (Object)exception.getMessage());
        Assert.assertEquals((Object)cause, (Object)exception.getCause());
        Assert.assertTrue((boolean)exception.isRetryable());
        Assert.assertSame((Object)cause, (Object)exception.getCause());
        exception = new BigQueryException(504, "message", (Throwable)cause);
        Assert.assertEquals((long)504L, (long)exception.getCode());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertNull((Object)exception.getReason());
        Assert.assertNull((Object)exception.getError());
        Assert.assertTrue((boolean)exception.isRetryable());
        Assert.assertSame((Object)cause, (Object)exception.getCause());
        HttpResponseException httpResponseException = new HttpResponseException.Builder(404, "Service Unavailable", new HttpHeaders()).build();
        exception = new BigQueryException((IOException)httpResponseException);
        Assert.assertEquals((long)404L, (long)exception.getCode());
        Assert.assertFalse((boolean)exception.isRetryable());
        httpResponseException = new HttpResponseException.Builder(504, null, new HttpHeaders()).build();
        exception = new BigQueryException((IOException)httpResponseException);
        Assert.assertEquals((long)504L, (long)exception.getCode());
        Assert.assertTrue((boolean)exception.isRetryable());
        httpResponseException = new HttpResponseException.Builder(503, null, new HttpHeaders()).build();
        exception = new BigQueryException((IOException)httpResponseException);
        Assert.assertEquals((long)503L, (long)exception.getCode());
        Assert.assertTrue((boolean)exception.isRetryable());
        httpResponseException = new HttpResponseException.Builder(502, null, new HttpHeaders()).build();
        exception = new BigQueryException((IOException)httpResponseException);
        Assert.assertEquals((long)502L, (long)exception.getCode());
        Assert.assertTrue((boolean)exception.isRetryable());
        httpResponseException = new HttpResponseException.Builder(500, null, new HttpHeaders()).build();
        exception = new BigQueryException((IOException)httpResponseException);
        Assert.assertEquals((long)500L, (long)exception.getCode());
        Assert.assertTrue((boolean)exception.isRetryable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTranslateAndThrow() throws Exception {
        Object cause = new BigQueryException(503, "message");
        RetryHelper.RetryHelperException exceptionMock = (RetryHelper.RetryHelperException)Mockito.mock(RetryHelper.RetryHelperException.class);
        Mockito.when((Object)exceptionMock.getCause()).thenReturn(cause);
        try {
            BigQueryException.translateAndThrow((RetryHelper.RetryHelperException)exceptionMock);
        }
        catch (BaseServiceException ex) {
            Assert.assertEquals((long)503L, (long)ex.getCode());
            Assert.assertEquals((Object)"message", (Object)ex.getMessage());
            Assert.assertTrue((boolean)ex.isRetryable());
        }
        finally {
            ((RetryHelper.RetryHelperException)Mockito.verify((Object)exceptionMock, (VerificationMode)Mockito.times((int)2))).getCause();
        }
        cause = new IllegalArgumentException("message");
        exceptionMock = (RetryHelper.RetryHelperException)Mockito.mock(RetryHelper.RetryHelperException.class);
        Mockito.when((Object)exceptionMock.getMessage()).thenReturn((Object)"message");
        Mockito.when((Object)exceptionMock.getCause()).thenReturn(cause);
        try {
            BigQueryException.translateAndThrow((RetryHelper.RetryHelperException)exceptionMock);
        }
        catch (BaseServiceException ex) {
            Assert.assertEquals((long)0L, (long)ex.getCode());
            Assert.assertEquals((Object)"message", (Object)ex.getMessage());
            Assert.assertFalse((boolean)ex.isRetryable());
            Assert.assertSame((Object)cause, (Object)ex.getCause());
        }
        finally {
            ((RetryHelper.RetryHelperException)Mockito.verify((Object)exceptionMock)).getMessage();
            ((RetryHelper.RetryHelperException)Mockito.verify((Object)exceptionMock, (VerificationMode)Mockito.times((int)2))).getCause();
        }
    }
}

