/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.gax.paging.Page;
import com.google.api.services.bigquery.model.ErrorProto;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.JobStatus;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.TableCell;
import com.google.api.services.bigquery.model.TableDataInsertAllRequest;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TestIamPermissionsResponse;
import com.google.cloud.Identity;
import com.google.cloud.Policy;
import com.google.cloud.RetryOption;
import com.google.cloud.Role;
import com.google.cloud.ServiceOptions;
import com.google.cloud.Tuple;
import com.google.cloud.bigquery.Acl;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryImpl;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.BigQueryRetryAlgorithm;
import com.google.cloud.bigquery.BigQueryRetryConfig;
import com.google.cloud.bigquery.CopyJobConfiguration;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.InsertAllResponse;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatus;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.Model;
import com.google.cloud.bigquery.ModelId;
import com.google.cloud.bigquery.ModelInfo;
import com.google.cloud.bigquery.ModelTableDefinition;
import com.google.cloud.bigquery.Option;
import com.google.cloud.bigquery.PolicyHelper;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.QueryResponse;
import com.google.cloud.bigquery.RangePartitioning;
import com.google.cloud.bigquery.Routine;
import com.google.cloud.bigquery.RoutineArgument;
import com.google.cloud.bigquery.RoutineId;
import com.google.cloud.bigquery.RoutineInfo;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLDataType;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDataWriteChannel;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.bigquery.WriteChannelConfiguration;
import com.google.cloud.bigquery.spi.BigQueryRpcFactory;
import com.google.cloud.bigquery.spi.v2.BigQueryRpc;
import com.google.cloud.spi.ServiceRpcFactory;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class BigQueryImplTest {
    private static final String PROJECT = "project";
    private static final String LOCATION = "US";
    private static final String OTHER_PROJECT = "otherProject";
    private static final String DATASET = "dataset";
    private static final String TABLE = "table";
    private static final String MODEL = "model";
    private static final String OTHER_MODEL = "otherModel";
    private static final String JOB = "job";
    private static final String OTHER_TABLE = "otherTable";
    private static final String OTHER_DATASET = "otherDataset";
    private static final String ROUTINE = "routine";
    private static final RoutineId ROUTINE_ID = RoutineId.of((String)"dataset", (String)"routine");
    private static final String ETAG = "etag";
    private static final String ROUTINE_TYPE = "SCALAR_FUNCTION";
    private static final Long CREATION_TIME = 10L;
    private static final Long LAST_MODIFIED_TIME = 20L;
    private static final String LANGUAGE = "SQL";
    private static final String UPLOAD_ID = "uploadid";
    private static final int MIN_CHUNK_SIZE = 262144;
    private static final List<Acl> ACCESS_RULES = ImmutableList.of((Object)Acl.of((Acl.Entity)Acl.Group.ofAllAuthenticatedUsers(), (Acl.Role)Acl.Role.READER), (Object)Acl.of((Acl.Entity)new Acl.View(TableId.of((String)"dataset", (String)"table")), (Acl.Role)Acl.Role.WRITER));
    private static final List<Acl> ACCESS_RULES_WITH_PROJECT = ImmutableList.of((Object)Acl.of((Acl.Entity)Acl.Group.ofAllAuthenticatedUsers(), (Acl.Role)Acl.Role.READER), (Object)Acl.of((Acl.View)new Acl.View(TableId.of((String)"project", (String)"dataset", (String)"table"))));
    private static final DatasetInfo DATASET_INFO = DatasetInfo.newBuilder((String)"dataset").setAcl(ACCESS_RULES).setDescription("description").setLocation("US").build();
    private static final DatasetInfo DATASET_INFO_WITH_PROJECT = DatasetInfo.newBuilder((String)"project", (String)"dataset").setAcl(ACCESS_RULES_WITH_PROJECT).setDescription("description").setLocation("US").build();
    private static final DatasetInfo OTHER_DATASET_INFO = DatasetInfo.newBuilder((String)"project", (String)"otherDataset").setAcl(ACCESS_RULES).setDescription("other description").setLocation("US").build();
    private static final TableId TABLE_ID = TableId.of((String)"dataset", (String)"table");
    private static final TableId OTHER_TABLE_ID = TableId.of((String)"project", (String)"dataset", (String)"otherTable");
    private static final TableId TABLE_ID_WITH_PROJECT = TableId.of((String)"project", (String)"dataset", (String)"table");
    private static final Field FIELD_SCHEMA1 = Field.newBuilder((String)"BooleanField", (LegacySQLTypeName)LegacySQLTypeName.BOOLEAN, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("FieldDescription1").build();
    private static final Field FIELD_SCHEMA2 = Field.newBuilder((String)"IntegerField", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("FieldDescription2").build();
    private static final Schema TABLE_SCHEMA = Schema.of((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2});
    private static final StandardTableDefinition TABLE_DEFINITION = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
    private static final ModelTableDefinition MODEL_TABLE_DEFINITION = ModelTableDefinition.newBuilder().build();
    private static final Long EXPIRATION_MS = 86400000L;
    private static final Long TABLE_CREATION_TIME = 1546275600000L;
    private static final TimePartitioning TIME_PARTITIONING = TimePartitioning.of((TimePartitioning.Type)TimePartitioning.Type.DAY, (long)EXPIRATION_MS);
    private static final com.google.api.services.bigquery.model.TimePartitioning PB_TIMEPARTITIONING = new com.google.api.services.bigquery.model.TimePartitioning().setType(null).setField("timestampField");
    private static final TimePartitioning TIME_PARTITIONING_NULL_TYPE = TimePartitioning.fromPb((com.google.api.services.bigquery.model.TimePartitioning)PB_TIMEPARTITIONING);
    private static final StandardTableDefinition TABLE_DEFINITION_WITH_PARTITIONING = StandardTableDefinition.newBuilder().setSchema(TABLE_SCHEMA).setTimePartitioning(TIME_PARTITIONING).build();
    private static final StandardTableDefinition TABLE_DEFINITION_WITH_PARTITIONING_NULL_TYPE = StandardTableDefinition.newBuilder().setSchema(TABLE_SCHEMA).setTimePartitioning(TIME_PARTITIONING_NULL_TYPE).build();
    private static final RangePartitioning.Range RANGE = RangePartitioning.Range.newBuilder().setStart(Long.valueOf(1L)).setInterval(Long.valueOf(2L)).setEnd(Long.valueOf(10L)).build();
    private static final RangePartitioning RANGE_PARTITIONING = RangePartitioning.newBuilder().setField("IntegerField").setRange(RANGE).build();
    private static final StandardTableDefinition TABLE_DEFINITION_WITH_RANGE_PARTITIONING = StandardTableDefinition.newBuilder().setSchema(TABLE_SCHEMA).setRangePartitioning(RANGE_PARTITIONING).build();
    private static final TableInfo TABLE_INFO_RANGE_PARTITIONING = TableInfo.of((TableId)TABLE_ID, (TableDefinition)TABLE_DEFINITION_WITH_RANGE_PARTITIONING);
    private static final TableInfo TABLE_INFO = TableInfo.of((TableId)TABLE_ID, (TableDefinition)TABLE_DEFINITION);
    private static final TableInfo OTHER_TABLE_INFO = TableInfo.of((TableId)OTHER_TABLE_ID, (TableDefinition)TABLE_DEFINITION);
    private static final TableInfo TABLE_INFO_WITH_PROJECT = TableInfo.of((TableId)TABLE_ID_WITH_PROJECT, (TableDefinition)TABLE_DEFINITION);
    private static final TableInfo MODEL_TABLE_INFO_WITH_PROJECT = TableInfo.of((TableId)TABLE_ID_WITH_PROJECT, (TableDefinition)MODEL_TABLE_DEFINITION);
    private static final TableInfo TABLE_INFO_WITH_PARTITIONS = TableInfo.newBuilder((TableId)TABLE_ID, (TableDefinition)TABLE_DEFINITION_WITH_PARTITIONING).setCreationTime(TABLE_CREATION_TIME).build();
    private static final TableInfo TABLE_INFO_WITH_PARTITIONS_NULL_TYPE = TableInfo.newBuilder((TableId)TABLE_ID, (TableDefinition)TABLE_DEFINITION_WITH_PARTITIONING_NULL_TYPE).setCreationTime(TABLE_CREATION_TIME).build();
    private static final ModelId OTHER_MODEL_ID = ModelId.of((String)"dataset", (String)"otherModel");
    private static final ModelId MODEL_ID_WITH_PROJECT = ModelId.of((String)"project", (String)"dataset", (String)"model");
    private static final ModelInfo OTHER_MODEL_INFO = ModelInfo.of((ModelId)OTHER_MODEL_ID);
    private static final ModelInfo MODEL_INFO_WITH_PROJECT = ModelInfo.of((ModelId)MODEL_ID_WITH_PROJECT);
    private static final LoadJobConfiguration LOAD_JOB_CONFIGURATION_WITH_PROJECT = LoadJobConfiguration.of((TableId)TABLE_ID_WITH_PROJECT, (String)"URI");
    private static final JobInfo COMPLETE_LOAD_JOB = JobInfo.of((JobId)JobId.of((String)"project", (String)"job"), (JobConfiguration)LOAD_JOB_CONFIGURATION_WITH_PROJECT);
    private static final CopyJobConfiguration COPY_JOB_CONFIGURATION = CopyJobConfiguration.of((TableId)TABLE_ID, (List)ImmutableList.of((Object)TABLE_ID, (Object)TABLE_ID));
    private static final CopyJobConfiguration COPY_JOB_CONFIGURATION_WITH_PROJECT = CopyJobConfiguration.of((TableId)TABLE_ID_WITH_PROJECT, (List)ImmutableList.of((Object)TABLE_ID_WITH_PROJECT, (Object)TABLE_ID_WITH_PROJECT));
    private static final JobInfo COPY_JOB = JobInfo.of((JobConfiguration)COPY_JOB_CONFIGURATION);
    private static final JobInfo COMPLETE_COPY_JOB = JobInfo.of((JobId)JobId.of((String)"project", (String)"job"), (JobConfiguration)COPY_JOB_CONFIGURATION_WITH_PROJECT);
    private static final QueryJobConfiguration QUERY_JOB_CONFIGURATION = QueryJobConfiguration.newBuilder((String)"SQL").setDefaultDataset(DatasetId.of((String)"dataset")).setDestinationTable(TABLE_ID).build();
    private static final QueryJobConfiguration QUERY_JOB_CONFIGURATION_WITH_PROJECT = QueryJobConfiguration.newBuilder((String)"SQL").setDefaultDataset(DatasetId.of((String)"project", (String)"dataset")).setDestinationTable(TABLE_ID_WITH_PROJECT).build();
    private static final JobInfo COMPLETE_QUERY_JOB = JobInfo.of((JobId)JobId.of((String)"project", (String)"job"), (JobConfiguration)QUERY_JOB_CONFIGURATION_WITH_PROJECT);
    private static final TableCell BOOLEAN_FIELD = new TableCell().setV((Object)"false");
    private static final TableCell INTEGER_FIELD = new TableCell().setV((Object)"1");
    private static final TableRow TABLE_ROW = new TableRow().setF((List)ImmutableList.of((Object)BOOLEAN_FIELD, (Object)INTEGER_FIELD));
    private static final QueryJobConfiguration QUERY_JOB_CONFIGURATION_FOR_QUERY = QueryJobConfiguration.newBuilder((String)"SQL").setDefaultDataset(DatasetId.of((String)"project", (String)"dataset")).setUseQueryCache(Boolean.valueOf(false)).build();
    private static final QueryJobConfiguration QUERY_JOB_CONFIGURATION_FOR_DMLQUERY = QueryJobConfiguration.newBuilder((String)"DML").setDefaultDataset(DatasetId.of((String)"project", (String)"dataset")).setUseQueryCache(Boolean.valueOf(false)).build();
    private static final QueryJobConfiguration QUERY_JOB_CONFIGURATION_FOR_DDLQUERY = QueryJobConfiguration.newBuilder((String)"DDL").setDefaultDataset(DatasetId.of((String)"project", (String)"dataset")).setUseQueryCache(Boolean.valueOf(false)).build();
    private static final JobInfo JOB_INFO = JobInfo.newBuilder((JobConfiguration)QUERY_JOB_CONFIGURATION_FOR_QUERY).setJobId(JobId.of((String)"project", (String)"job")).build();
    private static final String CURSOR = "cursor";
    private static final TableCell CELL_PB1 = new TableCell().setV((Object)"Value1");
    private static final TableCell CELL_PB2 = new TableCell().setV((Object)"Value2");
    private static final ImmutableList<FieldValueList> TABLE_DATA = ImmutableList.of((Object)FieldValueList.of((List)ImmutableList.of((Object)FieldValue.fromPb((Object)CELL_PB1)), (Field[])new Field[0]), (Object)FieldValueList.of((List)ImmutableList.of((Object)FieldValue.fromPb((Object)CELL_PB2)), (Field[])new Field[0]));
    private static final TableDataList TABLE_DATA_PB = new TableDataList().setPageToken("cursor").setTotalRows(Long.valueOf(3L)).setRows((List)ImmutableList.of((Object)new TableRow().setF((List)ImmutableList.of((Object)new TableCell().setV((Object)"Value1"))), (Object)new TableRow().setF((List)ImmutableList.of((Object)new TableCell().setV((Object)"Value2")))));
    private static final Map<BigQueryRpc.Option, ?> EMPTY_RPC_OPTIONS = ImmutableMap.of();
    private static final BigQuery.DatasetOption DATASET_OPTION_FIELDS = BigQuery.DatasetOption.fields((BigQuery.DatasetField[])new BigQuery.DatasetField[]{BigQuery.DatasetField.ACCESS, BigQuery.DatasetField.ETAG});
    private static final BigQuery.DatasetListOption DATASET_LIST_ALL = BigQuery.DatasetListOption.all();
    private static final BigQuery.DatasetListOption DATASET_LIST_PAGE_TOKEN = BigQuery.DatasetListOption.pageToken((String)"cursor");
    private static final BigQuery.DatasetListOption DATASET_LIST_PAGE_SIZE = BigQuery.DatasetListOption.pageSize((long)42L);
    private static final Map<BigQueryRpc.Option, ?> DATASET_LIST_OPTIONS = ImmutableMap.of((Object)BigQueryRpc.Option.ALL_DATASETS, (Object)true, (Object)BigQueryRpc.Option.PAGE_TOKEN, (Object)"cursor", (Object)BigQueryRpc.Option.MAX_RESULTS, (Object)42L);
    private static final BigQuery.DatasetDeleteOption DATASET_DELETE_CONTENTS = BigQuery.DatasetDeleteOption.deleteContents();
    private static final Map<BigQueryRpc.Option, ?> DATASET_DELETE_OPTIONS = ImmutableMap.of((Object)BigQueryRpc.Option.DELETE_CONTENTS, (Object)true);
    private static final BigQuery.TableOption TABLE_OPTION_FIELDS = BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[]{BigQuery.TableField.SCHEMA, BigQuery.TableField.ETAG});
    private static final Field PROJECT_ID_FIELD = Field.newBuilder((String)"project_id", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build();
    private static final Field DATASET_ID_FIELD = Field.newBuilder((String)"dataset_id", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build();
    private static final Field TABLE_ID_FIELD = Field.newBuilder((String)"table_id", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build();
    private static final Field PARTITION_ID_FIELD = Field.newBuilder((String)"partition_id", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build();
    private static final Field CREATION_TIME_FIELD = Field.newBuilder((String)"creation_time", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build();
    private static final Field CREATION_TIMESTAMP_FIELD = Field.newBuilder((String)"creation_timestamp", (LegacySQLTypeName)LegacySQLTypeName.TIMESTAMP, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build();
    private static final Field LAST_MODIFIED_FIELD = Field.newBuilder((String)"last_modified_time", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build();
    private static final Field LAST_MODIFIED_TIMESTAMP_FIELD = Field.newBuilder((String)"last_modified_timestamp", (LegacySQLTypeName)LegacySQLTypeName.TIMESTAMP, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build();
    private static final Schema SCHEMA_PARTITIONS = Schema.of((Field[])new Field[]{PROJECT_ID_FIELD, DATASET_ID_FIELD, TABLE_ID_FIELD, PARTITION_ID_FIELD, CREATION_TIME_FIELD, CREATION_TIMESTAMP_FIELD, LAST_MODIFIED_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD});
    private static final TableDefinition TABLE_DEFINITION_PARTITIONS = StandardTableDefinition.newBuilder().setSchema(SCHEMA_PARTITIONS).setNumBytes(Long.valueOf(0L)).setNumLongTermBytes(Long.valueOf(0L)).setNumRows(Long.valueOf(3L)).setLocation("unknown").build();
    private static final TableInfo TABLE_INFO_PARTITIONS = TableInfo.newBuilder((TableId)TABLE_ID, (TableDefinition)TABLE_DEFINITION_PARTITIONS).setEtag("ETAG").setCreationTime(Long.valueOf(1553689573240L)).setLastModifiedTime(Long.valueOf(1553841163438L)).setNumBytes(Long.valueOf(0L)).setNumLongTermBytes(Long.valueOf(0L)).setNumRows(BigInteger.valueOf(3L)).build();
    private static final TableCell TABLE_CELL1_PROJECT_ID = new TableCell().setV((Object)"project");
    private static final TableCell TABLE_CELL1_DATASET_ID = new TableCell().setV((Object)"dataset");
    private static final TableCell TABLE_CELL1_TABLE_ID = new TableCell().setV((Object)"table");
    private static final TableCell TABLE_CELL1_PARTITION_ID = new TableCell().setV((Object)"20190327");
    private static final TableCell TABLE_CELL1_CREATION_TIME = new TableCell().setV((Object)"1553694932498");
    private static final TableCell TABLE_CELL1_CREATION_TIMESTAMP = new TableCell().setV((Object)"1553694932.498");
    private static final TableCell TABLE_CELL1_LAST_MODIFIED_TIME = new TableCell().setV((Object)"1553694932989");
    private static final TableCell TABLE_CELL1_LAST_MODIFIED_TIMESTAMP = new TableCell().setV((Object)"1553694932.989");
    private static final TableCell TABLE_CELL2_PARTITION_ID = new TableCell().setV((Object)"20190328");
    private static final TableCell TABLE_CELL2_CREATION_TIME = new TableCell().setV((Object)"1553754224760");
    private static final TableCell TABLE_CELL2_CREATION_TIMESTAMP = new TableCell().setV((Object)"1553754224.76");
    private static final TableCell TABLE_CELL2_LAST_MODIFIED_TIME = new TableCell().setV((Object)"1553754225587");
    private static final TableCell TABLE_CELL2_LAST_MODIFIED_TIMESTAMP = new TableCell().setV((Object)"1553754225.587");
    private static final TableCell TABLE_CELL3_PARTITION_ID = new TableCell().setV((Object)"20190329");
    private static final TableCell TABLE_CELL3_CREATION_TIME = new TableCell().setV((Object)"1553841162879");
    private static final TableCell TABLE_CELL3_CREATION_TIMESTAMP = new TableCell().setV((Object)"1553841162.879");
    private static final TableCell TABLE_CELL3_LAST_MODIFIED_TIME = new TableCell().setV((Object)"1553841163438");
    private static final TableCell TABLE_CELL3_LAST_MODIFIED_TIMESTAMP = new TableCell().setV((Object)"1553841163.438");
    private static final TableDataList TABLE_DATA_WITH_PARTITIONS = new TableDataList().setTotalRows(Long.valueOf(3L)).setRows((List)ImmutableList.of((Object)new TableRow().setF((List)ImmutableList.of((Object)TABLE_CELL1_PROJECT_ID, (Object)TABLE_CELL1_DATASET_ID, (Object)TABLE_CELL1_TABLE_ID, (Object)TABLE_CELL1_PARTITION_ID, (Object)TABLE_CELL1_CREATION_TIME, (Object)TABLE_CELL1_CREATION_TIMESTAMP, (Object)TABLE_CELL1_LAST_MODIFIED_TIME, (Object)TABLE_CELL1_LAST_MODIFIED_TIMESTAMP)), (Object)new TableRow().setF((List)ImmutableList.of((Object)TABLE_CELL1_PROJECT_ID, (Object)TABLE_CELL1_DATASET_ID, (Object)TABLE_CELL1_TABLE_ID, (Object)TABLE_CELL2_PARTITION_ID, (Object)TABLE_CELL2_CREATION_TIME, (Object)TABLE_CELL2_CREATION_TIMESTAMP, (Object)TABLE_CELL2_LAST_MODIFIED_TIME, (Object)TABLE_CELL2_LAST_MODIFIED_TIMESTAMP)), (Object)new TableRow().setF((List)ImmutableList.of((Object)TABLE_CELL1_PROJECT_ID, (Object)TABLE_CELL1_DATASET_ID, (Object)TABLE_CELL1_TABLE_ID, (Object)TABLE_CELL3_PARTITION_ID, (Object)TABLE_CELL3_CREATION_TIME, (Object)TABLE_CELL3_CREATION_TIMESTAMP, (Object)TABLE_CELL3_LAST_MODIFIED_TIME, (Object)TABLE_CELL3_LAST_MODIFIED_TIMESTAMP))));
    private static final BigQuery.TableListOption TABLE_LIST_PAGE_SIZE = BigQuery.TableListOption.pageSize((long)42L);
    private static final BigQuery.TableListOption TABLE_LIST_PAGE_TOKEN = BigQuery.TableListOption.pageToken((String)"cursor");
    private static final Map<BigQueryRpc.Option, ?> TABLE_LIST_OPTIONS = ImmutableMap.of((Object)BigQueryRpc.Option.MAX_RESULTS, (Object)42L, (Object)BigQueryRpc.Option.PAGE_TOKEN, (Object)"cursor");
    private static final BigQuery.TableDataListOption TABLE_DATA_LIST_PAGE_SIZE = BigQuery.TableDataListOption.pageSize((long)42L);
    private static final BigQuery.TableDataListOption TABLE_DATA_LIST_PAGE_TOKEN = BigQuery.TableDataListOption.pageToken((String)"cursor");
    private static final BigQuery.TableDataListOption TABLE_DATA_LIST_START_INDEX = BigQuery.TableDataListOption.startIndex((long)0L);
    private static final Map<BigQueryRpc.Option, ?> TABLE_DATA_LIST_OPTIONS = ImmutableMap.of((Object)BigQueryRpc.Option.MAX_RESULTS, (Object)42L, (Object)BigQueryRpc.Option.PAGE_TOKEN, (Object)"cursor", (Object)BigQueryRpc.Option.START_INDEX, (Object)0L);
    private static final BigQuery.JobOption JOB_OPTION_FIELDS = BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[]{BigQuery.JobField.USER_EMAIL});
    private static final BigQuery.JobListOption JOB_LIST_OPTION_FIELD = BigQuery.JobListOption.fields((BigQuery.JobField[])new BigQuery.JobField[]{BigQuery.JobField.STATISTICS});
    private static final BigQuery.JobListOption JOB_LIST_ALL_USERS = BigQuery.JobListOption.allUsers();
    private static final BigQuery.JobListOption JOB_LIST_STATE_FILTER = BigQuery.JobListOption.stateFilter((JobStatus.State[])new JobStatus.State[]{JobStatus.State.DONE, JobStatus.State.PENDING});
    private static final BigQuery.JobListOption JOB_LIST_PAGE_TOKEN = BigQuery.JobListOption.pageToken((String)"cursor");
    private static final BigQuery.JobListOption JOB_LIST_PAGE_SIZE = BigQuery.JobListOption.pageSize((long)42L);
    private static final Map<BigQueryRpc.Option, ?> JOB_LIST_OPTIONS = ImmutableMap.of((Object)BigQueryRpc.Option.ALL_USERS, (Object)true, (Object)BigQueryRpc.Option.STATE_FILTER, (Object)ImmutableList.of((Object)"done", (Object)"pending"), (Object)BigQueryRpc.Option.PAGE_TOKEN, (Object)"cursor", (Object)BigQueryRpc.Option.MAX_RESULTS, (Object)42L);
    private static final BigQuery.QueryResultsOption QUERY_RESULTS_OPTION_TIME = BigQuery.QueryResultsOption.maxWaitTime((long)42L);
    private static final BigQuery.QueryResultsOption QUERY_RESULTS_OPTION_INDEX = BigQuery.QueryResultsOption.startIndex((long)1024L);
    private static final BigQuery.QueryResultsOption QUERY_RESULTS_OPTION_PAGE_TOKEN = BigQuery.QueryResultsOption.pageToken((String)"cursor");
    private static final BigQuery.QueryResultsOption QUERY_RESULTS_OPTION_PAGE_SIZE = BigQuery.QueryResultsOption.pageSize((long)0L);
    private static final Map<BigQueryRpc.Option, ?> QUERY_RESULTS_OPTIONS = ImmutableMap.of((Object)BigQueryRpc.Option.TIMEOUT, (Object)42L, (Object)BigQueryRpc.Option.START_INDEX, (Object)1024L, (Object)BigQueryRpc.Option.PAGE_TOKEN, (Object)"cursor", (Object)BigQueryRpc.Option.MAX_RESULTS, (Object)0L);
    private static final RoutineArgument ARG_1 = RoutineArgument.newBuilder().setDataType(StandardSQLDataType.newBuilder((String)"STRING").build()).setName("arg1").build();
    private static final List<RoutineArgument> ARGUMENT_LIST = ImmutableList.of((Object)ARG_1);
    private static final StandardSQLDataType RETURN_TYPE = StandardSQLDataType.newBuilder((String)"FLOAT64").build();
    private static final List<String> IMPORTED_LIBRARIES = ImmutableList.of((Object)"gs://foo", (Object)"gs://bar", (Object)"gs://baz");
    private static final String BODY = "body";
    private static final RoutineInfo ROUTINE_INFO = RoutineInfo.newBuilder((RoutineId)ROUTINE_ID).setEtag("etag").setRoutineType("SCALAR_FUNCTION").setCreationTime(CREATION_TIME).setLastModifiedTime(LAST_MODIFIED_TIME).setLanguage("SQL").setArguments(ARGUMENT_LIST).setReturnType(RETURN_TYPE).setImportedLibraries(IMPORTED_LIBRARIES).setBody("body").build();
    private static final WriteChannelConfiguration LOAD_CONFIGURATION = WriteChannelConfiguration.newBuilder((TableId)TABLE_ID).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setWriteDisposition(JobInfo.WriteDisposition.WRITE_APPEND).setFormatOptions(FormatOptions.json()).setIgnoreUnknownValues(Boolean.valueOf(true)).setMaxBadRecords(Integer.valueOf(10)).build();
    private static final Policy SAMPLE_IAM_POLICY = Policy.newBuilder().addIdentity(Role.of((String)"roles/bigquery.dataViewer"), Identity.allUsers(), new Identity[0]).setEtag("etag").setVersion(1).build();
    private BigQueryOptions options;
    private BigQueryRpcFactory rpcFactoryMock;
    private BigQueryRpc bigqueryRpcMock;
    private BigQuery bigquery;
    private static final String RATE_LIMIT_ERROR_MSG = "Job exceeded rate limits: Your table exceeded quota for table update operations. For more information, see https://cloud.google.com/bigquery/docs/troubleshoot-quotas";
    @Captor
    private ArgumentCaptor<Map<BigQueryRpc.Option, Object>> capturedOptions;
    @Captor
    private ArgumentCaptor<com.google.api.services.bigquery.model.Job> jobCapture;
    @Captor
    private ArgumentCaptor<byte[]> capturedBuffer;
    @Captor
    private ArgumentCaptor<QueryRequest> requestPbCapture;
    private TableDataWriteChannel writer;

    private BigQueryOptions createBigQueryOptionsForProject(String project, BigQueryRpcFactory rpcFactory) {
        return ((BigQueryOptions.Builder)((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setProjectId(project)).setServiceRpcFactory((ServiceRpcFactory)rpcFactory)).setRetrySettings(ServiceOptions.getNoRetrySettings())).build();
    }

    private BigQueryOptions createBigQueryOptionsForProjectWithLocation(String project, BigQueryRpcFactory rpcFactory) {
        return ((BigQueryOptions.Builder)((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setProjectId(project)).setLocation(LOCATION).setServiceRpcFactory((ServiceRpcFactory)rpcFactory)).setRetrySettings(ServiceOptions.getNoRetrySettings())).build();
    }

    @Before
    public void setUp() {
        this.rpcFactoryMock = (BigQueryRpcFactory)Mockito.mock(BigQueryRpcFactory.class);
        this.bigqueryRpcMock = (BigQueryRpc)Mockito.mock(BigQueryRpc.class);
        Mockito.when((Object)this.rpcFactoryMock.create((ServiceOptions)((BigQueryOptions)Mockito.any(BigQueryOptions.class)))).thenReturn((Object)this.bigqueryRpcMock);
        this.options = this.createBigQueryOptionsForProject(PROJECT, this.rpcFactoryMock);
    }

    @Test
    public void testGetOptions() {
        this.bigquery = (BigQuery)this.options.getService();
        Assert.assertSame((Object)this.options, (Object)this.bigquery.getOptions());
    }

    @Test
    public void testCreateDataset() {
        DatasetInfo datasetInfo = DATASET_INFO.setProjectId(OTHER_PROJECT);
        Mockito.when((Object)this.bigqueryRpcMock.create(datasetInfo.toPb(), EMPTY_RPC_OPTIONS)).thenReturn((Object)datasetInfo.toPb());
        BigQueryOptions bigQueryOptions = this.createBigQueryOptionsForProject(OTHER_PROJECT, this.rpcFactoryMock);
        this.bigquery = (BigQuery)bigQueryOptions.getService();
        Dataset dataset = this.bigquery.create(datasetInfo, new BigQuery.DatasetOption[0]);
        Assert.assertEquals((Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(datasetInfo)), (Object)dataset);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).create(datasetInfo.toPb(), EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testCreateDatasetWithSelectedFields() {
        Mockito.when((Object)this.bigqueryRpcMock.create((com.google.api.services.bigquery.model.Dataset)Mockito.eq((Object)DATASET_INFO_WITH_PROJECT.toPb()), (Map)this.capturedOptions.capture())).thenReturn((Object)DATASET_INFO_WITH_PROJECT.toPb());
        this.bigquery = (BigQuery)this.options.getService();
        Dataset dataset = this.bigquery.create(DATASET_INFO, new BigQuery.DatasetOption[]{DATASET_OPTION_FIELDS});
        String selector = (String)((Map)this.capturedOptions.getValue()).get(DATASET_OPTION_FIELDS.getRpcOption());
        Assert.assertTrue((boolean)selector.contains("datasetReference"));
        Assert.assertTrue((boolean)selector.contains("access"));
        Assert.assertTrue((boolean)selector.contains(ETAG));
        Assert.assertEquals((long)28L, (long)selector.length());
        Assert.assertEquals((Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(DATASET_INFO_WITH_PROJECT)), (Object)dataset);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).create((com.google.api.services.bigquery.model.Dataset)Mockito.eq((Object)DATASET_INFO_WITH_PROJECT.toPb()), (Map)this.capturedOptions.capture());
    }

    @Test
    public void testCreateDatasetWithAccessPolicy() {
        DatasetInfo datasetInfo = DATASET_INFO.setProjectId(OTHER_PROJECT);
        BigQuery.DatasetOption datasetOption = BigQuery.DatasetOption.accessPolicyVersion((Integer)3);
        Mockito.when((Object)this.bigqueryRpcMock.create(datasetInfo.toPb(), BigQueryImpl.optionMap((Option[])new Option[]{datasetOption}))).thenReturn((Object)datasetInfo.toPb());
        BigQueryOptions bigQueryOptions = this.createBigQueryOptionsForProject(OTHER_PROJECT, this.rpcFactoryMock);
        this.bigquery = (BigQuery)bigQueryOptions.getService();
        Dataset dataset = this.bigquery.create(datasetInfo, new BigQuery.DatasetOption[]{datasetOption});
        Assert.assertEquals((Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(datasetInfo)), (Object)dataset);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).create(datasetInfo.toPb(), BigQueryImpl.optionMap((Option[])new Option[]{datasetOption}));
    }

    @Test
    public void testGetDataset() {
        Mockito.when((Object)this.bigqueryRpcMock.getDataset(PROJECT, DATASET, EMPTY_RPC_OPTIONS)).thenReturn((Object)DATASET_INFO_WITH_PROJECT.toPb());
        this.bigquery = (BigQuery)this.options.getService();
        Dataset dataset = this.bigquery.getDataset(DATASET, new BigQuery.DatasetOption[0]);
        Assert.assertEquals((Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(DATASET_INFO_WITH_PROJECT)), (Object)dataset);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getDataset(PROJECT, DATASET, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetDatasetNotFoundWhenThrowIsDisabled() {
        Mockito.when((Object)this.bigqueryRpcMock.getDataset(PROJECT, DATASET, EMPTY_RPC_OPTIONS)).thenReturn((Object)DATASET_INFO_WITH_PROJECT.toPb());
        this.options.setThrowNotFound(false);
        this.bigquery = (BigQuery)this.options.getService();
        Dataset dataset = this.bigquery.getDataset(DATASET, new BigQuery.DatasetOption[0]);
        Assert.assertEquals((Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(DATASET_INFO_WITH_PROJECT)), (Object)dataset);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getDataset(PROJECT, DATASET, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetDatasetNotFoundWhenThrowIsEnabled() {
        Mockito.when((Object)this.bigqueryRpcMock.getDataset(PROJECT, "dataset-not-found", EMPTY_RPC_OPTIONS)).thenReturn(null).thenThrow(new Throwable[]{new BigQueryException(404, "Dataset not found")});
        this.options.setThrowNotFound(true);
        this.bigquery = (BigQuery)this.options.getService();
        try {
            this.bigquery.getDataset("dataset-not-found", new BigQuery.DatasetOption[0]);
            Assert.fail();
        }
        catch (BigQueryException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getDataset(PROJECT, "dataset-not-found", EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetDatasetFromDatasetId() {
        Mockito.when((Object)this.bigqueryRpcMock.getDataset(PROJECT, DATASET, EMPTY_RPC_OPTIONS)).thenReturn((Object)DATASET_INFO_WITH_PROJECT.toPb());
        this.bigquery = (BigQuery)this.options.getService();
        Dataset dataset = this.bigquery.getDataset(DatasetId.of((String)DATASET), new BigQuery.DatasetOption[0]);
        Assert.assertEquals((Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(DATASET_INFO_WITH_PROJECT)), (Object)dataset);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getDataset(PROJECT, DATASET, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetDatasetFromDatasetIdWithProject() {
        DatasetInfo datasetInfo = DATASET_INFO.setProjectId(OTHER_PROJECT);
        DatasetId datasetId = DatasetId.of((String)OTHER_PROJECT, (String)DATASET);
        Mockito.when((Object)this.bigqueryRpcMock.getDataset(OTHER_PROJECT, DATASET, EMPTY_RPC_OPTIONS)).thenReturn((Object)datasetInfo.toPb());
        this.bigquery = (BigQuery)this.options.getService();
        Dataset dataset = this.bigquery.getDataset(datasetId, new BigQuery.DatasetOption[0]);
        Assert.assertEquals((Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(datasetInfo)), (Object)dataset);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getDataset(OTHER_PROJECT, DATASET, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetDatasetWithSelectedFields() {
        Mockito.when((Object)this.bigqueryRpcMock.getDataset((String)Mockito.eq((Object)PROJECT), (String)Mockito.eq((Object)DATASET), (Map)this.capturedOptions.capture())).thenReturn((Object)DATASET_INFO_WITH_PROJECT.toPb());
        this.bigquery = (BigQuery)this.options.getService();
        Dataset dataset = this.bigquery.getDataset(DATASET, new BigQuery.DatasetOption[]{DATASET_OPTION_FIELDS});
        String selector = (String)((Map)this.capturedOptions.getValue()).get(DATASET_OPTION_FIELDS.getRpcOption());
        Assert.assertTrue((boolean)selector.contains("datasetReference"));
        Assert.assertTrue((boolean)selector.contains("access"));
        Assert.assertTrue((boolean)selector.contains(ETAG));
        Assert.assertEquals((long)28L, (long)selector.length());
        Assert.assertEquals((Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(DATASET_INFO_WITH_PROJECT)), (Object)dataset);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getDataset((String)Mockito.eq((Object)PROJECT), (String)Mockito.eq((Object)DATASET), (Map)this.capturedOptions.capture());
    }

    @Test
    public void testListDatasets() {
        this.bigquery = (BigQuery)this.options.getService();
        ImmutableList datasetList = ImmutableList.of((Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(DATASET_INFO_WITH_PROJECT)), (Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(OTHER_DATASET_INFO)));
        Tuple result = Tuple.of((Object)CURSOR, (Object)Iterables.transform((Iterable)datasetList, (Function)DatasetInfo.TO_PB_FUNCTION));
        Mockito.when((Object)this.bigqueryRpcMock.listDatasets(PROJECT, EMPTY_RPC_OPTIONS)).thenReturn((Object)result);
        Page page = this.bigquery.listDatasets(new BigQuery.DatasetListOption[0]);
        Assert.assertEquals((Object)CURSOR, (Object)page.getNextPageToken());
        Assert.assertArrayEquals((Object[])datasetList.toArray(), (Object[])Iterables.toArray((Iterable)page.getValues(), DatasetInfo.class));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listDatasets(PROJECT, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testListDatasetsWithProjects() {
        this.bigquery = (BigQuery)this.options.getService();
        ImmutableList datasetList = ImmutableList.of((Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(DATASET_INFO.setProjectId(OTHER_PROJECT))));
        Tuple result = Tuple.of((Object)CURSOR, (Object)Iterables.transform((Iterable)datasetList, (Function)DatasetInfo.TO_PB_FUNCTION));
        Mockito.when((Object)this.bigqueryRpcMock.listDatasets(OTHER_PROJECT, EMPTY_RPC_OPTIONS)).thenReturn((Object)result);
        Page page = this.bigquery.listDatasets(OTHER_PROJECT, new BigQuery.DatasetListOption[0]);
        Assert.assertEquals((Object)CURSOR, (Object)page.getNextPageToken());
        Assert.assertArrayEquals((Object[])datasetList.toArray(), (Object[])Iterables.toArray((Iterable)page.getValues(), DatasetInfo.class));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listDatasets(OTHER_PROJECT, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testListEmptyDatasets() {
        ImmutableList datasets = ImmutableList.of();
        Tuple result = Tuple.of(null, (Object)datasets);
        Mockito.when((Object)this.bigqueryRpcMock.listDatasets(PROJECT, EMPTY_RPC_OPTIONS)).thenReturn((Object)result);
        this.bigquery = (BigQuery)this.options.getService();
        Page page = this.bigquery.listDatasets(new BigQuery.DatasetListOption[0]);
        Assert.assertNull((Object)page.getNextPageToken());
        Assert.assertArrayEquals((Object[])ImmutableList.of().toArray(), (Object[])Iterables.toArray((Iterable)page.getValues(), Dataset.class));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listDatasets(PROJECT, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testListDatasetsWithOptions() {
        this.bigquery = (BigQuery)this.options.getService();
        ImmutableList datasetList = ImmutableList.of((Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(DATASET_INFO_WITH_PROJECT)), (Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(OTHER_DATASET_INFO)));
        Tuple result = Tuple.of((Object)CURSOR, (Object)Iterables.transform((Iterable)datasetList, (Function)DatasetInfo.TO_PB_FUNCTION));
        Mockito.when((Object)this.bigqueryRpcMock.listDatasets(PROJECT, DATASET_LIST_OPTIONS)).thenReturn((Object)result);
        Page page = this.bigquery.listDatasets(new BigQuery.DatasetListOption[]{DATASET_LIST_ALL, DATASET_LIST_PAGE_TOKEN, DATASET_LIST_PAGE_SIZE});
        Assert.assertEquals((Object)CURSOR, (Object)page.getNextPageToken());
        Assert.assertArrayEquals((Object[])datasetList.toArray(), (Object[])Iterables.toArray((Iterable)page.getValues(), DatasetInfo.class));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listDatasets(PROJECT, DATASET_LIST_OPTIONS);
    }

    @Test
    public void testDeleteDataset() {
        Mockito.when((Object)this.bigqueryRpcMock.deleteDataset(PROJECT, DATASET, EMPTY_RPC_OPTIONS)).thenReturn((Object)true);
        this.bigquery = (BigQuery)this.options.getService();
        Assert.assertTrue((boolean)this.bigquery.delete(DATASET, new BigQuery.DatasetDeleteOption[0]));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).deleteDataset(PROJECT, DATASET, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testDeleteDatasetFromDatasetId() {
        Mockito.when((Object)this.bigqueryRpcMock.deleteDataset(PROJECT, DATASET, EMPTY_RPC_OPTIONS)).thenReturn((Object)true);
        this.bigquery = (BigQuery)this.options.getService();
        Assert.assertTrue((boolean)this.bigquery.delete(DatasetId.of((String)DATASET), new BigQuery.DatasetDeleteOption[0]));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).deleteDataset(PROJECT, DATASET, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testDeleteDatasetFromDatasetIdWithProject() {
        DatasetId datasetId = DatasetId.of((String)OTHER_PROJECT, (String)DATASET);
        Mockito.when((Object)this.bigqueryRpcMock.deleteDataset(OTHER_PROJECT, DATASET, EMPTY_RPC_OPTIONS)).thenReturn((Object)true);
        this.bigquery = (BigQuery)this.options.getService();
        Assert.assertTrue((boolean)this.bigquery.delete(datasetId, new BigQuery.DatasetDeleteOption[0]));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).deleteDataset(OTHER_PROJECT, DATASET, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testDeleteDatasetWithOptions() {
        Mockito.when((Object)this.bigqueryRpcMock.deleteDataset(PROJECT, DATASET, DATASET_DELETE_OPTIONS)).thenReturn((Object)true);
        this.bigquery = (BigQuery)this.options.getService();
        Assert.assertTrue((boolean)this.bigquery.delete(DATASET, new BigQuery.DatasetDeleteOption[]{DATASET_DELETE_CONTENTS}));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).deleteDataset(PROJECT, DATASET, DATASET_DELETE_OPTIONS);
    }

    @Test
    public void testUpdateDataset() {
        DatasetInfo updatedDatasetInfo = DATASET_INFO.setProjectId(OTHER_PROJECT).toBuilder().setDescription("newDescription").build();
        Mockito.when((Object)this.bigqueryRpcMock.patch(updatedDatasetInfo.toPb(), EMPTY_RPC_OPTIONS)).thenReturn((Object)updatedDatasetInfo.toPb());
        this.bigquery = (BigQuery)this.options.getService();
        Dataset dataset = this.bigquery.update(updatedDatasetInfo, new BigQuery.DatasetOption[0]);
        Assert.assertEquals((Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(updatedDatasetInfo)), (Object)dataset);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).patch(updatedDatasetInfo.toPb(), EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testUpdateDatasetWithSelectedFields() {
        DatasetInfo updatedDatasetInfo = DATASET_INFO.toBuilder().setDescription("newDescription").build();
        DatasetInfo updatedDatasetInfoWithProject = DATASET_INFO_WITH_PROJECT.toBuilder().setDescription("newDescription").build();
        Mockito.when((Object)this.bigqueryRpcMock.patch((com.google.api.services.bigquery.model.Dataset)Mockito.eq((Object)updatedDatasetInfoWithProject.toPb()), (Map)this.capturedOptions.capture())).thenReturn((Object)updatedDatasetInfoWithProject.toPb());
        this.bigquery = (BigQuery)this.options.getService();
        Dataset dataset = this.bigquery.update(updatedDatasetInfo, new BigQuery.DatasetOption[]{DATASET_OPTION_FIELDS});
        String selector = (String)((Map)this.capturedOptions.getValue()).get(DATASET_OPTION_FIELDS.getRpcOption());
        Assert.assertTrue((boolean)selector.contains("datasetReference"));
        Assert.assertTrue((boolean)selector.contains("access"));
        Assert.assertTrue((boolean)selector.contains(ETAG));
        Assert.assertEquals((long)28L, (long)selector.length());
        Assert.assertEquals((Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(updatedDatasetInfoWithProject)), (Object)dataset);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).patch((com.google.api.services.bigquery.model.Dataset)Mockito.eq((Object)updatedDatasetInfoWithProject.toPb()), (Map)this.capturedOptions.capture());
    }

    @Test
    public void testCreateTable() {
        TableInfo tableInfo = TABLE_INFO.setProjectId(OTHER_PROJECT);
        Mockito.when((Object)this.bigqueryRpcMock.create(tableInfo.toPb(), EMPTY_RPC_OPTIONS)).thenReturn((Object)tableInfo.toPb());
        BigQueryOptions bigQueryOptions = this.createBigQueryOptionsForProject(OTHER_PROJECT, this.rpcFactoryMock);
        this.bigquery = (BigQuery)bigQueryOptions.getService();
        Table table = this.bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertEquals((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(tableInfo)), (Object)table);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).create(tableInfo.toPb(), EMPTY_RPC_OPTIONS);
    }

    @Test
    public void tesCreateExternalTable() {
        TableInfo createTableInfo = TableInfo.of((TableId)TABLE_ID, (TableDefinition)ExternalTableDefinition.newBuilder().setSchema(TABLE_SCHEMA).build()).setProjectId(OTHER_PROJECT);
        com.google.api.services.bigquery.model.Table expectedCreateInput = createTableInfo.toPb().setSchema(TABLE_SCHEMA.toPb());
        expectedCreateInput.getExternalDataConfiguration().setSchema(null);
        Mockito.when((Object)this.bigqueryRpcMock.create(expectedCreateInput, EMPTY_RPC_OPTIONS)).thenReturn((Object)createTableInfo.toPb());
        BigQueryOptions bigQueryOptions = this.createBigQueryOptionsForProject(OTHER_PROJECT, this.rpcFactoryMock);
        this.bigquery = (BigQuery)bigQueryOptions.getService();
        Table table = this.bigquery.create(createTableInfo, new BigQuery.TableOption[0]);
        Assert.assertEquals((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(createTableInfo)), (Object)table);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).create(expectedCreateInput, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testCreateTableWithoutProject() {
        TableInfo tableInfo = TABLE_INFO.setProjectId(PROJECT);
        TableId tableId = TableId.of((String)"", (String)TABLE_ID.getDataset(), (String)TABLE_ID.getTable());
        tableInfo.toBuilder().setTableId(tableId);
        Mockito.when((Object)this.bigqueryRpcMock.create(tableInfo.toPb(), EMPTY_RPC_OPTIONS)).thenReturn((Object)tableInfo.toPb());
        BigQueryOptions bigQueryOptions = this.createBigQueryOptionsForProject(PROJECT, this.rpcFactoryMock);
        this.bigquery = (BigQuery)bigQueryOptions.getService();
        Table table = this.bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertEquals((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(tableInfo)), (Object)table);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).create(tableInfo.toPb(), EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testCreateTableWithSelectedFields() {
        Mockito.when((Object)this.bigqueryRpcMock.create((com.google.api.services.bigquery.model.Table)Mockito.eq((Object)TABLE_INFO_WITH_PROJECT.toPb()), (Map)this.capturedOptions.capture())).thenReturn((Object)TABLE_INFO_WITH_PROJECT.toPb());
        this.bigquery = (BigQuery)this.options.getService();
        Table table = this.bigquery.create(TABLE_INFO, new BigQuery.TableOption[]{TABLE_OPTION_FIELDS});
        String selector = (String)((Map)this.capturedOptions.getValue()).get(TABLE_OPTION_FIELDS.getRpcOption());
        Assert.assertTrue((boolean)selector.contains("tableReference"));
        Assert.assertTrue((boolean)selector.contains("schema"));
        Assert.assertTrue((boolean)selector.contains(ETAG));
        Assert.assertEquals((long)31L, (long)selector.length());
        Assert.assertEquals((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO_WITH_PROJECT)), (Object)table);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).create((com.google.api.services.bigquery.model.Table)Mockito.eq((Object)TABLE_INFO_WITH_PROJECT.toPb()), (Map)this.capturedOptions.capture());
    }

    @Test
    public void testGetTable() {
        Mockito.when((Object)this.bigqueryRpcMock.getTable(PROJECT, DATASET, TABLE, EMPTY_RPC_OPTIONS)).thenReturn((Object)TABLE_INFO_WITH_PROJECT.toPb());
        this.bigquery = (BigQuery)this.options.getService();
        Table table = this.bigquery.getTable(DATASET, TABLE, new BigQuery.TableOption[0]);
        Assert.assertEquals((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO_WITH_PROJECT)), (Object)table);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getTable(PROJECT, DATASET, TABLE, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetModel() {
        Mockito.when((Object)this.bigqueryRpcMock.getModel(PROJECT, DATASET, MODEL, EMPTY_RPC_OPTIONS)).thenReturn((Object)MODEL_INFO_WITH_PROJECT.toPb());
        this.bigquery = (BigQuery)this.options.getService();
        Model model = this.bigquery.getModel(DATASET, MODEL, new BigQuery.ModelOption[0]);
        Assert.assertEquals((Object)new Model(this.bigquery, new ModelInfo.BuilderImpl(MODEL_INFO_WITH_PROJECT)), (Object)model);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getModel(PROJECT, DATASET, MODEL, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetModelNotFoundWhenThrowIsEnabled() {
        String expected = "Model not found";
        Mockito.when((Object)this.bigqueryRpcMock.getModel(PROJECT, DATASET, MODEL, EMPTY_RPC_OPTIONS)).thenReturn(null).thenThrow(new Throwable[]{new BigQueryException(404, expected)});
        this.options.setThrowNotFound(true);
        this.bigquery = (BigQuery)this.options.getService();
        try {
            this.bigquery.getModel(DATASET, MODEL, new BigQuery.ModelOption[0]);
        }
        catch (BigQueryException ex) {
            Assert.assertEquals((Object)expected, (Object)ex.getMessage());
        }
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getModel(PROJECT, DATASET, MODEL, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testListPartition() {
        Mockito.when((Object)this.bigqueryRpcMock.getTable(PROJECT, DATASET, "table$__PARTITIONS_SUMMARY__", EMPTY_RPC_OPTIONS)).thenReturn((Object)TABLE_INFO_PARTITIONS.toPb());
        Mockito.when((Object)this.bigqueryRpcMock.listTableData(PROJECT, DATASET, TABLE, EMPTY_RPC_OPTIONS)).thenReturn((Object)TABLE_DATA_WITH_PARTITIONS);
        this.bigquery = (BigQuery)this.options.getService();
        List partition = this.bigquery.listPartitions(TABLE_ID_WITH_PROJECT);
        Assert.assertEquals((long)3L, (long)partition.size());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getTable(PROJECT, DATASET, "table$__PARTITIONS_SUMMARY__", EMPTY_RPC_OPTIONS);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listTableData(PROJECT, DATASET, TABLE, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetTableNotFoundWhenThrowIsDisabled() {
        Mockito.when((Object)this.bigqueryRpcMock.getTable(PROJECT, DATASET, TABLE, EMPTY_RPC_OPTIONS)).thenReturn((Object)TABLE_INFO_WITH_PROJECT.toPb());
        this.options.setThrowNotFound(false);
        this.bigquery = (BigQuery)this.options.getService();
        Table table = this.bigquery.getTable(DATASET, TABLE, new BigQuery.TableOption[0]);
        Assert.assertEquals((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO_WITH_PROJECT)), (Object)table);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getTable(PROJECT, DATASET, TABLE, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetTableNotFoundWhenThrowIsEnabled() {
        Mockito.when((Object)this.bigqueryRpcMock.getTable(PROJECT, DATASET, "table-not-found", EMPTY_RPC_OPTIONS)).thenReturn(null).thenThrow(new Throwable[]{new BigQueryException(404, "Table not found")});
        this.options.setThrowNotFound(true);
        this.bigquery = (BigQuery)this.options.getService();
        try {
            this.bigquery.getTable(DATASET, "table-not-found", new BigQuery.TableOption[0]);
            Assert.fail();
        }
        catch (BigQueryException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getTable(PROJECT, DATASET, "table-not-found", EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetTableFromTableId() {
        Mockito.when((Object)this.bigqueryRpcMock.getTable(PROJECT, DATASET, TABLE, EMPTY_RPC_OPTIONS)).thenReturn((Object)TABLE_INFO_WITH_PROJECT.toPb());
        this.bigquery = (BigQuery)this.options.getService();
        Table table = this.bigquery.getTable(TABLE_ID, new BigQuery.TableOption[0]);
        Assert.assertEquals((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO_WITH_PROJECT)), (Object)table);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getTable(PROJECT, DATASET, TABLE, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetTableFromTableIdWithProject() {
        TableInfo tableInfo = TABLE_INFO.setProjectId(OTHER_PROJECT);
        TableId tableId = TABLE_ID.setProjectId(OTHER_PROJECT);
        Mockito.when((Object)this.bigqueryRpcMock.getTable(OTHER_PROJECT, DATASET, TABLE, EMPTY_RPC_OPTIONS)).thenReturn((Object)tableInfo.toPb());
        BigQueryOptions bigQueryOptions = this.createBigQueryOptionsForProject(OTHER_PROJECT, this.rpcFactoryMock);
        this.bigquery = (BigQuery)bigQueryOptions.getService();
        Table table = this.bigquery.getTable(tableId, new BigQuery.TableOption[0]);
        Assert.assertEquals((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(tableInfo)), (Object)table);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getTable(OTHER_PROJECT, DATASET, TABLE, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetTableFromTableIdWithoutProject() {
        TableInfo tableInfo = TABLE_INFO.setProjectId(PROJECT);
        TableId tableId = TableId.of((String)"", (String)TABLE_ID.getDataset(), (String)TABLE_ID.getTable());
        Mockito.when((Object)this.bigqueryRpcMock.getTable(PROJECT, DATASET, TABLE, EMPTY_RPC_OPTIONS)).thenReturn((Object)tableInfo.toPb());
        BigQueryOptions bigQueryOptions = this.createBigQueryOptionsForProject(PROJECT, this.rpcFactoryMock);
        this.bigquery = (BigQuery)bigQueryOptions.getService();
        Table table = this.bigquery.getTable(tableId, new BigQuery.TableOption[0]);
        Assert.assertEquals((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(tableInfo)), (Object)table);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getTable(PROJECT, DATASET, TABLE, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetTableWithSelectedFields() {
        Mockito.when((Object)this.bigqueryRpcMock.getTable((String)Mockito.eq((Object)PROJECT), (String)Mockito.eq((Object)DATASET), (String)Mockito.eq((Object)TABLE), (Map)this.capturedOptions.capture())).thenReturn((Object)TABLE_INFO_WITH_PROJECT.toPb());
        this.bigquery = (BigQuery)this.options.getService();
        Table table = this.bigquery.getTable(TABLE_ID, new BigQuery.TableOption[]{TABLE_OPTION_FIELDS});
        String selector = (String)((Map)this.capturedOptions.getValue()).get(TABLE_OPTION_FIELDS.getRpcOption());
        Assert.assertTrue((boolean)selector.contains("tableReference"));
        Assert.assertTrue((boolean)selector.contains("schema"));
        Assert.assertTrue((boolean)selector.contains(ETAG));
        Assert.assertEquals((long)31L, (long)selector.length());
        Assert.assertEquals((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO_WITH_PROJECT)), (Object)table);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getTable((String)Mockito.eq((Object)PROJECT), (String)Mockito.eq((Object)DATASET), (String)Mockito.eq((Object)TABLE), (Map)this.capturedOptions.capture());
    }

    @Test
    public void testListTables() {
        this.bigquery = (BigQuery)this.options.getService();
        ImmutableList tableList = ImmutableList.of((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO_WITH_PROJECT)), (Object)new Table(this.bigquery, new TableInfo.BuilderImpl(OTHER_TABLE_INFO)), (Object)new Table(this.bigquery, new TableInfo.BuilderImpl(MODEL_TABLE_INFO_WITH_PROJECT)));
        Tuple result = Tuple.of((Object)CURSOR, (Object)Iterables.transform((Iterable)tableList, (Function)TableInfo.TO_PB_FUNCTION));
        Mockito.when((Object)this.bigqueryRpcMock.listTables(PROJECT, DATASET, EMPTY_RPC_OPTIONS)).thenReturn((Object)result);
        Page page = this.bigquery.listTables(DATASET, new BigQuery.TableListOption[0]);
        Assert.assertEquals((Object)CURSOR, (Object)page.getNextPageToken());
        Assert.assertArrayEquals((Object[])tableList.toArray(), (Object[])Iterables.toArray((Iterable)page.getValues(), Table.class));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listTables(PROJECT, DATASET, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testListTablesReturnedParameters() {
        this.bigquery = (BigQuery)this.options.getService();
        ImmutableList tableList = ImmutableList.of((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO_WITH_PARTITIONS)));
        Tuple result = Tuple.of((Object)CURSOR, (Object)Iterables.transform((Iterable)tableList, (Function)TableInfo.TO_PB_FUNCTION));
        Mockito.when((Object)this.bigqueryRpcMock.listTables(PROJECT, DATASET, TABLE_LIST_OPTIONS)).thenReturn((Object)result);
        Page page = this.bigquery.listTables(DATASET, new BigQuery.TableListOption[]{TABLE_LIST_PAGE_SIZE, TABLE_LIST_PAGE_TOKEN});
        Assert.assertEquals((Object)CURSOR, (Object)page.getNextPageToken());
        Assert.assertArrayEquals((Object[])tableList.toArray(), (Object[])Iterables.toArray((Iterable)page.getValues(), Table.class));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listTables(PROJECT, DATASET, TABLE_LIST_OPTIONS);
    }

    @Test
    public void testListTablesReturnedParametersNullType() {
        this.bigquery = (BigQuery)this.options.getService();
        ImmutableList tableList = ImmutableList.of((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO_WITH_PARTITIONS_NULL_TYPE)));
        Tuple result = Tuple.of((Object)CURSOR, (Object)Iterables.transform((Iterable)tableList, (Function)TableInfo.TO_PB_FUNCTION));
        Mockito.when((Object)this.bigqueryRpcMock.listTables(PROJECT, DATASET, TABLE_LIST_OPTIONS)).thenReturn((Object)result);
        Page page = this.bigquery.listTables(DATASET, new BigQuery.TableListOption[]{TABLE_LIST_PAGE_SIZE, TABLE_LIST_PAGE_TOKEN});
        Assert.assertEquals((Object)CURSOR, (Object)page.getNextPageToken());
        Assert.assertArrayEquals((Object[])tableList.toArray(), (Object[])Iterables.toArray((Iterable)page.getValues(), Table.class));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listTables(PROJECT, DATASET, TABLE_LIST_OPTIONS);
    }

    @Test
    public void testListTablesWithRangePartitioning() {
        this.bigquery = (BigQuery)this.options.getService();
        ImmutableList tableList = ImmutableList.of((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO_RANGE_PARTITIONING)));
        Tuple result = Tuple.of((Object)CURSOR, (Object)Iterables.transform((Iterable)tableList, (Function)TableInfo.TO_PB_FUNCTION));
        Mockito.when((Object)this.bigqueryRpcMock.listTables(PROJECT, DATASET, TABLE_LIST_OPTIONS)).thenReturn((Object)result);
        Page page = this.bigquery.listTables(DATASET, new BigQuery.TableListOption[]{TABLE_LIST_PAGE_SIZE, TABLE_LIST_PAGE_TOKEN});
        Assert.assertEquals((Object)CURSOR, (Object)page.getNextPageToken());
        Assert.assertArrayEquals((Object[])tableList.toArray(), (Object[])Iterables.toArray((Iterable)page.getValues(), Table.class));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listTables(PROJECT, DATASET, TABLE_LIST_OPTIONS);
    }

    @Test
    public void testListTablesFromDatasetId() {
        this.bigquery = (BigQuery)this.options.getService();
        ImmutableList tableList = ImmutableList.of((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO_WITH_PROJECT)), (Object)new Table(this.bigquery, new TableInfo.BuilderImpl(OTHER_TABLE_INFO)));
        Tuple result = Tuple.of((Object)CURSOR, (Object)Iterables.transform((Iterable)tableList, (Function)TableInfo.TO_PB_FUNCTION));
        Mockito.when((Object)this.bigqueryRpcMock.listTables(PROJECT, DATASET, EMPTY_RPC_OPTIONS)).thenReturn((Object)result);
        Page page = this.bigquery.listTables(DatasetId.of((String)DATASET), new BigQuery.TableListOption[0]);
        Assert.assertEquals((Object)CURSOR, (Object)page.getNextPageToken());
        Assert.assertArrayEquals((Object[])tableList.toArray(), (Object[])Iterables.toArray((Iterable)page.getValues(), Table.class));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listTables(PROJECT, DATASET, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testListTablesFromDatasetIdWithProject() {
        this.bigquery = (BigQuery)this.options.getService();
        ImmutableList tableList = ImmutableList.of((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO.setProjectId(OTHER_PROJECT))));
        Tuple result = Tuple.of((Object)CURSOR, (Object)Iterables.transform((Iterable)tableList, (Function)TableInfo.TO_PB_FUNCTION));
        Mockito.when((Object)this.bigqueryRpcMock.listTables(OTHER_PROJECT, DATASET, EMPTY_RPC_OPTIONS)).thenReturn((Object)result);
        Page page = this.bigquery.listTables(DatasetId.of((String)OTHER_PROJECT, (String)DATASET), new BigQuery.TableListOption[0]);
        Assert.assertEquals((Object)CURSOR, (Object)page.getNextPageToken());
        Assert.assertArrayEquals((Object[])tableList.toArray(), (Object[])Iterables.toArray((Iterable)page.getValues(), Table.class));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listTables(OTHER_PROJECT, DATASET, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testListTablesWithOptions() {
        this.bigquery = (BigQuery)this.options.getService();
        ImmutableList tableList = ImmutableList.of((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO_WITH_PROJECT)), (Object)new Table(this.bigquery, new TableInfo.BuilderImpl(OTHER_TABLE_INFO)));
        Tuple result = Tuple.of((Object)CURSOR, (Object)Iterables.transform((Iterable)tableList, (Function)TableInfo.TO_PB_FUNCTION));
        Mockito.when((Object)this.bigqueryRpcMock.listTables(PROJECT, DATASET, TABLE_LIST_OPTIONS)).thenReturn((Object)result);
        Page page = this.bigquery.listTables(DATASET, new BigQuery.TableListOption[]{TABLE_LIST_PAGE_SIZE, TABLE_LIST_PAGE_TOKEN});
        Assert.assertEquals((Object)CURSOR, (Object)page.getNextPageToken());
        Assert.assertArrayEquals((Object[])tableList.toArray(), (Object[])Iterables.toArray((Iterable)page.getValues(), Table.class));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listTables(PROJECT, DATASET, TABLE_LIST_OPTIONS);
    }

    @Test
    public void testListModels() {
        this.bigquery = (BigQuery)this.options.getService();
        ImmutableList modelList = ImmutableList.of((Object)new Model(this.bigquery, new ModelInfo.BuilderImpl(MODEL_INFO_WITH_PROJECT)), (Object)new Model(this.bigquery, new ModelInfo.BuilderImpl(OTHER_MODEL_INFO)));
        Tuple result = Tuple.of((Object)CURSOR, (Object)Iterables.transform((Iterable)modelList, (Function)ModelInfo.TO_PB_FUNCTION));
        Mockito.when((Object)this.bigqueryRpcMock.listModels(PROJECT, DATASET, EMPTY_RPC_OPTIONS)).thenReturn((Object)result);
        Page page = this.bigquery.listModels(DATASET, new BigQuery.ModelListOption[0]);
        Assert.assertEquals((Object)CURSOR, (Object)page.getNextPageToken());
        Assert.assertArrayEquals((Object[])modelList.toArray(), (Object[])Iterables.toArray((Iterable)page.getValues(), Model.class));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listModels(PROJECT, DATASET, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testListModelsWithModelId() {
        this.bigquery = (BigQuery)this.options.getService();
        ImmutableList modelList = ImmutableList.of((Object)new Model(this.bigquery, new ModelInfo.BuilderImpl(MODEL_INFO_WITH_PROJECT)), (Object)new Model(this.bigquery, new ModelInfo.BuilderImpl(OTHER_MODEL_INFO)));
        Tuple result = Tuple.of((Object)CURSOR, (Object)Iterables.transform((Iterable)modelList, (Function)ModelInfo.TO_PB_FUNCTION));
        Mockito.when((Object)this.bigqueryRpcMock.listModels(PROJECT, DATASET, EMPTY_RPC_OPTIONS)).thenReturn((Object)result);
        Page page = this.bigquery.listModels(DatasetId.of((String)DATASET), new BigQuery.ModelListOption[0]);
        Assert.assertEquals((Object)CURSOR, (Object)page.getNextPageToken());
        Assert.assertArrayEquals((Object[])modelList.toArray(), (Object[])Iterables.toArray((Iterable)page.getValues(), Model.class));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listModels(PROJECT, DATASET, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testDeleteTable() {
        Mockito.when((Object)this.bigqueryRpcMock.deleteTable(PROJECT, DATASET, TABLE)).thenReturn((Object)true);
        this.bigquery = (BigQuery)this.options.getService();
        Assert.assertTrue((boolean)this.bigquery.delete(TABLE_ID));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).deleteTable(PROJECT, DATASET, TABLE);
    }

    @Test
    public void testDeleteTableFromTableId() {
        Mockito.when((Object)this.bigqueryRpcMock.deleteTable(PROJECT, DATASET, TABLE)).thenReturn((Object)true);
        this.bigquery = (BigQuery)this.options.getService();
        Assert.assertTrue((boolean)this.bigquery.delete(TABLE_ID));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).deleteTable(PROJECT, DATASET, TABLE);
    }

    @Test
    public void testDeleteTableFromTableIdWithProject() {
        TableId tableId = TABLE_ID.setProjectId(OTHER_PROJECT);
        Mockito.when((Object)this.bigqueryRpcMock.deleteTable(OTHER_PROJECT, DATASET, TABLE)).thenReturn((Object)true);
        BigQueryOptions bigQueryOptions = this.createBigQueryOptionsForProject(OTHER_PROJECT, this.rpcFactoryMock);
        this.bigquery = (BigQuery)bigQueryOptions.getService();
        Assert.assertTrue((boolean)this.bigquery.delete(tableId));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).deleteTable(OTHER_PROJECT, DATASET, TABLE);
    }

    @Test
    public void testDeleteTableFromTableIdWithoutProject() {
        TableId tableId = TableId.of((String)"", (String)TABLE_ID.getDataset(), (String)TABLE_ID.getTable());
        Mockito.when((Object)this.bigqueryRpcMock.deleteTable(PROJECT, DATASET, TABLE)).thenReturn((Object)true);
        BigQueryOptions bigQueryOptions = this.createBigQueryOptionsForProject(PROJECT, this.rpcFactoryMock);
        this.bigquery = (BigQuery)bigQueryOptions.getService();
        Assert.assertTrue((boolean)this.bigquery.delete(tableId));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).deleteTable(PROJECT, DATASET, TABLE);
    }

    @Test
    public void testDeleteModel() {
        Mockito.when((Object)this.bigqueryRpcMock.deleteModel(PROJECT, DATASET, MODEL)).thenReturn((Object)true);
        this.bigquery = (BigQuery)this.options.getService();
        Assert.assertTrue((boolean)this.bigquery.delete(ModelId.of((String)DATASET, (String)MODEL)));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).deleteModel(PROJECT, DATASET, MODEL);
    }

    @Test
    public void testUpdateModel() {
        ModelInfo updateModelInfo = MODEL_INFO_WITH_PROJECT.setProjectId(OTHER_PROJECT).toBuilder().setDescription("newDescription").build();
        Mockito.when((Object)this.bigqueryRpcMock.patch(updateModelInfo.toPb(), EMPTY_RPC_OPTIONS)).thenReturn((Object)updateModelInfo.toPb());
        BigQueryOptions bigQueryOptions = this.createBigQueryOptionsForProject(OTHER_PROJECT, this.rpcFactoryMock);
        this.bigquery = (BigQuery)bigQueryOptions.getService();
        Model actualModel = this.bigquery.update(updateModelInfo, new BigQuery.ModelOption[0]);
        Assert.assertEquals((Object)new Model(this.bigquery, new ModelInfo.BuilderImpl(updateModelInfo)), (Object)actualModel);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).patch(updateModelInfo.toPb(), EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testUpdateTable() {
        TableInfo updatedTableInfo = TABLE_INFO.setProjectId(OTHER_PROJECT).toBuilder().setDescription("newDescription").build();
        Mockito.when((Object)this.bigqueryRpcMock.patch(updatedTableInfo.toPb(), EMPTY_RPC_OPTIONS)).thenReturn((Object)updatedTableInfo.toPb());
        BigQueryOptions bigQueryOptions = this.createBigQueryOptionsForProject(OTHER_PROJECT, this.rpcFactoryMock);
        this.bigquery = (BigQuery)bigQueryOptions.getService();
        Table table = this.bigquery.update(updatedTableInfo, new BigQuery.TableOption[0]);
        Assert.assertEquals((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(updatedTableInfo)), (Object)table);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).patch(updatedTableInfo.toPb(), EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testUpdateExternalTableWithNewSchema() {
        TableInfo updatedTableInfo = TableInfo.of((TableId)TABLE_ID, (TableDefinition)ExternalTableDefinition.newBuilder().setSchema(TABLE_SCHEMA).build()).setProjectId(OTHER_PROJECT);
        com.google.api.services.bigquery.model.Table expectedPatchInput = updatedTableInfo.toPb().setSchema(TABLE_SCHEMA.toPb());
        expectedPatchInput.getExternalDataConfiguration().setSchema(null);
        Mockito.when((Object)this.bigqueryRpcMock.patch(expectedPatchInput, EMPTY_RPC_OPTIONS)).thenReturn((Object)updatedTableInfo.toPb());
        BigQueryOptions bigQueryOptions = this.createBigQueryOptionsForProject(OTHER_PROJECT, this.rpcFactoryMock);
        this.bigquery = (BigQuery)bigQueryOptions.getService();
        Table table = this.bigquery.update(updatedTableInfo, new BigQuery.TableOption[0]);
        Assert.assertEquals((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(updatedTableInfo)), (Object)table);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).patch(expectedPatchInput, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testUpdateTableWithoutProject() {
        TableInfo tableInfo = TABLE_INFO.setProjectId(PROJECT);
        TableId tableId = TableId.of((String)"", (String)TABLE_ID.getDataset(), (String)TABLE_ID.getTable());
        tableInfo.toBuilder().setTableId(tableId);
        Mockito.when((Object)this.bigqueryRpcMock.patch(tableInfo.toPb(), EMPTY_RPC_OPTIONS)).thenReturn((Object)tableInfo.toPb());
        BigQueryOptions bigQueryOptions = this.createBigQueryOptionsForProject(PROJECT, this.rpcFactoryMock);
        this.bigquery = (BigQuery)bigQueryOptions.getService();
        Table table = this.bigquery.update(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertEquals((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(tableInfo)), (Object)table);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).patch(tableInfo.toPb(), EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testUpdateTableWithSelectedFields() {
        TableInfo updatedTableInfo = TABLE_INFO.toBuilder().setDescription("newDescription").build();
        TableInfo updatedTableInfoWithProject = TABLE_INFO_WITH_PROJECT.toBuilder().setDescription("newDescription").build();
        Mockito.when((Object)this.bigqueryRpcMock.patch((com.google.api.services.bigquery.model.Table)Mockito.eq((Object)updatedTableInfoWithProject.toPb()), (Map)this.capturedOptions.capture())).thenReturn((Object)updatedTableInfoWithProject.toPb());
        this.bigquery = (BigQuery)this.options.getService();
        Table table = this.bigquery.update(updatedTableInfo, new BigQuery.TableOption[]{TABLE_OPTION_FIELDS});
        String selector = (String)((Map)this.capturedOptions.getValue()).get(TABLE_OPTION_FIELDS.getRpcOption());
        Assert.assertTrue((boolean)selector.contains("tableReference"));
        Assert.assertTrue((boolean)selector.contains("schema"));
        Assert.assertTrue((boolean)selector.contains(ETAG));
        Assert.assertEquals((long)31L, (long)selector.length());
        Assert.assertEquals((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(updatedTableInfoWithProject)), (Object)table);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).patch((com.google.api.services.bigquery.model.Table)Mockito.eq((Object)updatedTableInfoWithProject.toPb()), (Map)this.capturedOptions.capture());
    }

    @Test
    public void testUpdateTableWithAutoDetectSchema() {
        TableInfo updatedTableInfo = TABLE_INFO.toBuilder().setDescription("newDescription").build();
        TableInfo updatedTableInfoWithProject = TABLE_INFO_WITH_PROJECT.toBuilder().setDescription("newDescription").build();
        Mockito.when((Object)this.bigqueryRpcMock.patch((com.google.api.services.bigquery.model.Table)Mockito.eq((Object)updatedTableInfoWithProject.toPb()), (Map)this.capturedOptions.capture())).thenReturn((Object)updatedTableInfoWithProject.toPb());
        this.bigquery = (BigQuery)this.options.getService();
        Table table = this.bigquery.update(updatedTableInfo, new BigQuery.TableOption[]{BigQuery.TableOption.autodetectSchema((boolean)true)});
        Boolean selector = (Boolean)((Map)this.capturedOptions.getValue()).get(BigQueryRpc.Option.AUTODETECT_SCHEMA);
        Assert.assertTrue((boolean)selector);
        Assert.assertEquals((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(updatedTableInfoWithProject)), (Object)table);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).patch((com.google.api.services.bigquery.model.Table)Mockito.eq((Object)updatedTableInfoWithProject.toPb()), (Map)this.capturedOptions.capture());
    }

    @Test
    public void testInsertAllWithRowIdShouldRetry() {
        ImmutableMap row1 = ImmutableMap.of((Object)"field", (Object)"value1");
        ImmutableMap row2 = ImmutableMap.of((Object)"field", (Object)"value2");
        ImmutableList rows = ImmutableList.of((Object)new InsertAllRequest.RowToInsert("row1", (Map)row1), (Object)new InsertAllRequest.RowToInsert("row2", (Map)row2));
        InsertAllRequest request = InsertAllRequest.newBuilder((TableId)TABLE_ID).setRows((Iterable)rows).setSkipInvalidRows(false).setIgnoreUnknownValues(true).setTemplateSuffix("suffix").build();
        TableDataInsertAllRequest requestPb = new TableDataInsertAllRequest().setRows(Lists.transform((List)rows, (Function)new Function<InsertAllRequest.RowToInsert, TableDataInsertAllRequest.Rows>(){

            public TableDataInsertAllRequest.Rows apply(InsertAllRequest.RowToInsert rowToInsert) {
                return new TableDataInsertAllRequest.Rows().setInsertId(rowToInsert.getId()).setJson(rowToInsert.getContent());
            }
        })).setSkipInvalidRows(Boolean.valueOf(false)).setIgnoreUnknownValues(Boolean.valueOf(true)).setTemplateSuffix("suffix");
        TableDataInsertAllResponse responsePb = new TableDataInsertAllResponse().setInsertErrors((List)ImmutableList.of((Object)new TableDataInsertAllResponse.InsertErrors().setIndex(Long.valueOf(0L)).setErrors((List)ImmutableList.of((Object)new ErrorProto().setMessage("ErrorMessage")))));
        Mockito.when((Object)this.bigqueryRpcMock.insertAll(PROJECT, DATASET, TABLE, requestPb)).thenThrow(new Throwable[]{new BigQueryException(500, "InternalError")}).thenReturn((Object)responsePb);
        this.bigquery = (BigQuery)((BigQueryOptions.Builder)this.options.toBuilder().setRetrySettings(ServiceOptions.getDefaultRetrySettings())).build().getService();
        InsertAllResponse response = this.bigquery.insertAll(request);
        Assert.assertNotNull((Object)response.getErrorsFor(0L));
        Assert.assertNull((Object)response.getErrorsFor(1L));
        Assert.assertEquals((long)1L, (long)response.getErrorsFor(0L).size());
        Assert.assertEquals((Object)"ErrorMessage", (Object)((BigQueryError)response.getErrorsFor(0L).get(0)).getMessage());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock, (VerificationMode)Mockito.times((int)2))).insertAll(PROJECT, DATASET, TABLE, requestPb);
    }

    @Test
    public void testInsertAllWithoutRowIdShouldNotRetry() {
        ImmutableMap row1 = ImmutableMap.of((Object)"field", (Object)"value1");
        ImmutableMap row2 = ImmutableMap.of((Object)"field", (Object)"value2");
        ImmutableList rows = ImmutableList.of((Object)InsertAllRequest.RowToInsert.of((Map)row1), (Object)InsertAllRequest.RowToInsert.of((Map)row2));
        InsertAllRequest request = InsertAllRequest.newBuilder((TableId)TABLE_ID).setRows((Iterable)rows).setSkipInvalidRows(false).setIgnoreUnknownValues(true).setTemplateSuffix("suffix").build();
        TableDataInsertAllRequest requestPb = new TableDataInsertAllRequest().setRows(Lists.transform((List)rows, (Function)new Function<InsertAllRequest.RowToInsert, TableDataInsertAllRequest.Rows>(){

            public TableDataInsertAllRequest.Rows apply(InsertAllRequest.RowToInsert rowToInsert) {
                return new TableDataInsertAllRequest.Rows().setInsertId(rowToInsert.getId()).setJson(rowToInsert.getContent());
            }
        })).setSkipInvalidRows(Boolean.valueOf(false)).setIgnoreUnknownValues(Boolean.valueOf(true)).setTemplateSuffix("suffix");
        Mockito.when((Object)this.bigqueryRpcMock.insertAll(PROJECT, DATASET, TABLE, requestPb)).thenThrow(new Throwable[]{new BigQueryException(500, "InternalError")});
        this.bigquery = (BigQuery)((BigQueryOptions.Builder)this.options.toBuilder().setRetrySettings(ServiceOptions.getDefaultRetrySettings())).build().getService();
        try {
            this.bigquery.insertAll(request);
            Assert.fail();
        }
        catch (BigQueryException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).insertAll(PROJECT, DATASET, TABLE, requestPb);
    }

    @Test
    public void testInsertAllWithProject() {
        ImmutableMap row1 = ImmutableMap.of((Object)"field", (Object)"value1");
        ImmutableMap row2 = ImmutableMap.of((Object)"field", (Object)"value2");
        ImmutableList rows = ImmutableList.of((Object)new InsertAllRequest.RowToInsert("row1", (Map)row1), (Object)new InsertAllRequest.RowToInsert("row2", (Map)row2));
        TableId tableId = TableId.of((String)OTHER_PROJECT, (String)DATASET, (String)TABLE);
        InsertAllRequest request = InsertAllRequest.newBuilder((TableId)tableId).setRows((Iterable)rows).setSkipInvalidRows(false).setIgnoreUnknownValues(true).setTemplateSuffix("suffix").build();
        TableDataInsertAllRequest requestPb = new TableDataInsertAllRequest().setRows(Lists.transform((List)rows, (Function)new Function<InsertAllRequest.RowToInsert, TableDataInsertAllRequest.Rows>(){

            public TableDataInsertAllRequest.Rows apply(InsertAllRequest.RowToInsert rowToInsert) {
                return new TableDataInsertAllRequest.Rows().setInsertId(rowToInsert.getId()).setJson(rowToInsert.getContent());
            }
        })).setSkipInvalidRows(Boolean.valueOf(false)).setIgnoreUnknownValues(Boolean.valueOf(true)).setTemplateSuffix("suffix");
        TableDataInsertAllResponse responsePb = new TableDataInsertAllResponse().setInsertErrors((List)ImmutableList.of((Object)new TableDataInsertAllResponse.InsertErrors().setIndex(Long.valueOf(0L)).setErrors((List)ImmutableList.of((Object)new ErrorProto().setMessage("ErrorMessage")))));
        Mockito.when((Object)this.bigqueryRpcMock.insertAll(OTHER_PROJECT, DATASET, TABLE, requestPb)).thenReturn((Object)responsePb);
        BigQueryOptions bigQueryOptions = this.createBigQueryOptionsForProject(OTHER_PROJECT, this.rpcFactoryMock);
        this.bigquery = (BigQuery)bigQueryOptions.getService();
        InsertAllResponse response = this.bigquery.insertAll(request);
        Assert.assertNotNull((Object)response.getErrorsFor(0L));
        Assert.assertNull((Object)response.getErrorsFor(1L));
        Assert.assertEquals((long)1L, (long)response.getErrorsFor(0L).size());
        Assert.assertEquals((Object)"ErrorMessage", (Object)((BigQueryError)response.getErrorsFor(0L).get(0)).getMessage());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).insertAll(OTHER_PROJECT, DATASET, TABLE, requestPb);
    }

    @Test
    public void testInsertAllWithProjectInTable() {
        ImmutableMap row1 = ImmutableMap.of((Object)"field", (Object)"value1");
        ImmutableMap row2 = ImmutableMap.of((Object)"field", (Object)"value2");
        ImmutableList rows = ImmutableList.of((Object)new InsertAllRequest.RowToInsert("row1", (Map)row1), (Object)new InsertAllRequest.RowToInsert("row2", (Map)row2));
        TableId tableId = TableId.of((String)"project-different-from-option", (String)DATASET, (String)TABLE);
        InsertAllRequest request = InsertAllRequest.newBuilder((TableId)tableId).setRows((Iterable)rows).setSkipInvalidRows(false).setIgnoreUnknownValues(true).setTemplateSuffix("suffix").build();
        TableDataInsertAllRequest requestPb = new TableDataInsertAllRequest().setRows(Lists.transform((List)rows, (Function)new Function<InsertAllRequest.RowToInsert, TableDataInsertAllRequest.Rows>(){

            public TableDataInsertAllRequest.Rows apply(InsertAllRequest.RowToInsert rowToInsert) {
                return new TableDataInsertAllRequest.Rows().setInsertId(rowToInsert.getId()).setJson(rowToInsert.getContent());
            }
        })).setSkipInvalidRows(Boolean.valueOf(false)).setIgnoreUnknownValues(Boolean.valueOf(true)).setTemplateSuffix("suffix");
        TableDataInsertAllResponse responsePb = new TableDataInsertAllResponse().setInsertErrors((List)ImmutableList.of((Object)new TableDataInsertAllResponse.InsertErrors().setIndex(Long.valueOf(0L)).setErrors((List)ImmutableList.of((Object)new ErrorProto().setMessage("ErrorMessage")))));
        Mockito.when((Object)this.bigqueryRpcMock.insertAll("project-different-from-option", DATASET, TABLE, requestPb)).thenReturn((Object)responsePb);
        BigQueryOptions bigQueryOptions = this.createBigQueryOptionsForProject(OTHER_PROJECT, this.rpcFactoryMock);
        this.bigquery = (BigQuery)bigQueryOptions.getService();
        InsertAllResponse response = this.bigquery.insertAll(request);
        Assert.assertNotNull((Object)response.getErrorsFor(0L));
        Assert.assertNull((Object)response.getErrorsFor(1L));
        Assert.assertEquals((long)1L, (long)response.getErrorsFor(0L).size());
        Assert.assertEquals((Object)"ErrorMessage", (Object)((BigQueryError)response.getErrorsFor(0L).get(0)).getMessage());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).insertAll("project-different-from-option", DATASET, TABLE, requestPb);
    }

    @Test
    public void testListTableData() {
        Mockito.when((Object)this.bigqueryRpcMock.listTableData(PROJECT, DATASET, TABLE, EMPTY_RPC_OPTIONS)).thenReturn((Object)TABLE_DATA_PB);
        this.bigquery = (BigQuery)this.options.getService();
        TableResult page = this.bigquery.listTableData(DATASET, TABLE, new BigQuery.TableDataListOption[0]);
        Assert.assertEquals((Object)CURSOR, (Object)page.getNextPageToken());
        Assert.assertArrayEquals((Object[])TABLE_DATA.toArray(), (Object[])Iterables.toArray((Iterable)page.getValues(), List.class));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listTableData(PROJECT, DATASET, TABLE, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testListTableDataFromTableId() {
        Mockito.when((Object)this.bigqueryRpcMock.listTableData(PROJECT, DATASET, TABLE, EMPTY_RPC_OPTIONS)).thenReturn((Object)TABLE_DATA_PB);
        this.bigquery = (BigQuery)this.options.getService();
        TableResult page = this.bigquery.listTableData(TableId.of((String)DATASET, (String)TABLE), new BigQuery.TableDataListOption[0]);
        Assert.assertEquals((Object)CURSOR, (Object)page.getNextPageToken());
        Assert.assertArrayEquals((Object[])TABLE_DATA.toArray(), (Object[])Iterables.toArray((Iterable)page.getValues(), List.class));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listTableData(PROJECT, DATASET, TABLE, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testListTableDataFromTableIdWithProject() {
        TableId tableId = TABLE_ID.setProjectId(OTHER_PROJECT);
        Mockito.when((Object)this.bigqueryRpcMock.listTableData(OTHER_PROJECT, DATASET, TABLE, EMPTY_RPC_OPTIONS)).thenReturn((Object)TABLE_DATA_PB);
        BigQueryOptions bigQueryOptions = this.createBigQueryOptionsForProject(PROJECT, this.rpcFactoryMock);
        this.bigquery = (BigQuery)bigQueryOptions.getService();
        TableResult page = this.bigquery.listTableData(tableId, new BigQuery.TableDataListOption[0]);
        Assert.assertEquals((Object)CURSOR, (Object)page.getNextPageToken());
        Assert.assertArrayEquals((Object[])TABLE_DATA.toArray(), (Object[])Iterables.toArray((Iterable)page.getValues(), List.class));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listTableData(OTHER_PROJECT, DATASET, TABLE, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testListTableDataWithOptions() {
        Mockito.when((Object)this.bigqueryRpcMock.listTableData(PROJECT, DATASET, TABLE, TABLE_DATA_LIST_OPTIONS)).thenReturn((Object)TABLE_DATA_PB);
        this.bigquery = (BigQuery)this.options.getService();
        TableResult page = this.bigquery.listTableData(DATASET, TABLE, new BigQuery.TableDataListOption[]{TABLE_DATA_LIST_PAGE_SIZE, TABLE_DATA_LIST_PAGE_TOKEN, TABLE_DATA_LIST_START_INDEX});
        Assert.assertEquals((Object)CURSOR, (Object)page.getNextPageToken());
        Assert.assertArrayEquals((Object[])TABLE_DATA.toArray(), (Object[])Iterables.toArray((Iterable)page.getValues(), List.class));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listTableData(PROJECT, DATASET, TABLE, TABLE_DATA_LIST_OPTIONS);
    }

    @Test
    public void testListTableDataWithNextPage() {
        ((BigQueryRpc)Mockito.doReturn((Object)TABLE_DATA_PB).when((Object)this.bigqueryRpcMock)).listTableData(PROJECT, DATASET, TABLE, TABLE_DATA_LIST_OPTIONS);
        this.bigquery = (BigQuery)this.options.getService();
        TableResult page = this.bigquery.listTableData(DATASET, TABLE, new BigQuery.TableDataListOption[]{TABLE_DATA_LIST_PAGE_SIZE, TABLE_DATA_LIST_PAGE_TOKEN, TABLE_DATA_LIST_START_INDEX});
        Assert.assertEquals((Object)CURSOR, (Object)page.getNextPageToken());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listTableData(PROJECT, DATASET, TABLE, TABLE_DATA_LIST_OPTIONS);
        Assert.assertArrayEquals((Object[])TABLE_DATA.toArray(), (Object[])Iterables.toArray((Iterable)page.getValues(), List.class));
        ImmutableMap SECOND_TABLE_DATA_LIST_OPTIONS = ImmutableMap.of((Object)BigQueryRpc.Option.PAGE_TOKEN, (Object)CURSOR, (Object)BigQueryRpc.Option.START_INDEX, (Object)0L);
        ((BigQueryRpc)Mockito.doReturn((Object)new TableDataList().setPageToken(null).setTotalRows(Long.valueOf(1L)).setRows((List)ImmutableList.of((Object)new TableRow().setF((List)ImmutableList.of((Object)new TableCell().setV((Object)"Value3"))), (Object)new TableRow().setF((List)ImmutableList.of((Object)new TableCell().setV((Object)"Value4")))))).when((Object)this.bigqueryRpcMock)).listTableData(PROJECT, DATASET, TABLE, (Map)SECOND_TABLE_DATA_LIST_OPTIONS);
        Assert.assertTrue((boolean)page.hasNextPage());
        page = page.getNextPage();
        Assert.assertNull((Object)page.getNextPageToken());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listTableData(PROJECT, DATASET, TABLE, (Map)SECOND_TABLE_DATA_LIST_OPTIONS);
    }

    private static com.google.api.services.bigquery.model.Job newJobPb() {
        return new com.google.api.services.bigquery.model.Job().setConfiguration(new com.google.api.services.bigquery.model.JobConfiguration().setQuery(new JobConfigurationQuery().setQuery("FOO")));
    }

    @Test
    public void testCreateJobSuccess() {
        String id = "testCreateJobSuccess-id";
        JobId jobId = JobId.of((String)id);
        String query = "SELECT * in FOO";
        Mockito.when((Object)this.bigqueryRpcMock.create((com.google.api.services.bigquery.model.Job)this.jobCapture.capture(), (Map)Mockito.eq(EMPTY_RPC_OPTIONS))).thenReturn((Object)BigQueryImplTest.newJobPb());
        this.bigquery = (BigQuery)this.options.getService();
        Truth.assertThat((Object)this.bigquery.create(JobInfo.of((JobId)jobId, (JobConfiguration)QueryJobConfiguration.of((String)query)), new BigQuery.JobOption[0])).isNotNull();
        Truth.assertThat((String)((com.google.api.services.bigquery.model.Job)this.jobCapture.getValue()).getJobReference().getJobId()).isEqualTo((Object)id);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).create((com.google.api.services.bigquery.model.Job)this.jobCapture.capture(), (Map)Mockito.eq(EMPTY_RPC_OPTIONS));
    }

    @Test
    public void testCreateJobFailureShouldRetry() {
        Mockito.when((Object)this.bigqueryRpcMock.create((com.google.api.services.bigquery.model.Job)this.jobCapture.capture(), (Map)Mockito.eq(EMPTY_RPC_OPTIONS))).thenThrow(new Throwable[]{new BigQueryException(500, "InternalError")}).thenThrow(new Throwable[]{new BigQueryException(502, "Bad Gateway")}).thenThrow(new Throwable[]{new BigQueryException(503, "Service Unavailable")}).thenThrow(new Throwable[]{new BigQueryException(400, RATE_LIMIT_ERROR_MSG)}).thenThrow(new Throwable[]{new BigQueryException(200, RATE_LIMIT_ERROR_MSG)}).thenReturn((Object)BigQueryImplTest.newJobPb());
        this.bigquery = (BigQuery)this.options.getService();
        this.bigquery = (BigQuery)((BigQueryOptions.Builder)this.options.toBuilder().setRetrySettings(ServiceOptions.getDefaultRetrySettings())).build().getService();
        ((BigQueryImpl)this.bigquery).create(JobInfo.of((JobConfiguration)QUERY_JOB_CONFIGURATION_FOR_DMLQUERY), new BigQuery.JobOption[0]);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock, (VerificationMode)Mockito.times((int)6))).create((com.google.api.services.bigquery.model.Job)this.jobCapture.capture(), (Map)Mockito.eq(EMPTY_RPC_OPTIONS));
    }

    @Test
    public void testCreateJobWithBigQueryRetryConfigFailureShouldRetry() {
        BigQuery.JobOption bigQueryRetryConfigOption = BigQuery.JobOption.bigQueryRetryConfig((BigQueryRetryConfig)BigQueryRetryConfig.newBuilder().retryOnMessage(new String[]{"Exceeded rate limits:"}).retryOnMessage(new String[]{"Job exceeded rate limits:"}).retryOnRegEx(new String[]{".*exceed.*rate.*limit.*"}).build());
        Map bigQueryRpcOptions = BigQueryImpl.optionMap((Option[])new Option[]{bigQueryRetryConfigOption});
        Mockito.when((Object)this.bigqueryRpcMock.create((com.google.api.services.bigquery.model.Job)this.jobCapture.capture(), (Map)Mockito.eq((Object)bigQueryRpcOptions))).thenThrow(new Throwable[]{new BigQueryException(400, RATE_LIMIT_ERROR_MSG)}).thenThrow(new Throwable[]{new BigQueryException(200, RATE_LIMIT_ERROR_MSG)}).thenReturn((Object)BigQueryImplTest.newJobPb());
        this.bigquery = (BigQuery)this.options.getService();
        this.bigquery = (BigQuery)((BigQueryOptions.Builder)this.options.toBuilder().setRetrySettings(ServiceOptions.getDefaultRetrySettings())).build().getService();
        ((BigQueryImpl)this.bigquery).create(JobInfo.of((JobConfiguration)QUERY_JOB_CONFIGURATION_FOR_DMLQUERY), new BigQuery.JobOption[]{bigQueryRetryConfigOption});
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock, (VerificationMode)Mockito.times((int)3))).create((com.google.api.services.bigquery.model.Job)this.jobCapture.capture(), (Map)Mockito.eq((Object)bigQueryRpcOptions));
    }

    @Test
    public void testCreateJobWithBigQueryRetryConfigFailureShouldNotRetry() {
        BigQuery.JobOption bigQueryRetryConfigOption = BigQuery.JobOption.bigQueryRetryConfig((BigQueryRetryConfig)BigQueryRetryConfig.newBuilder().build());
        Map bigQueryRpcOptions = BigQueryImpl.optionMap((Option[])new Option[]{bigQueryRetryConfigOption});
        Mockito.when((Object)this.bigqueryRpcMock.create((com.google.api.services.bigquery.model.Job)this.jobCapture.capture(), (Map)Mockito.eq((Object)bigQueryRpcOptions))).thenThrow(new Throwable[]{new BigQueryException(400, RATE_LIMIT_ERROR_MSG)});
        this.bigquery = (BigQuery)this.options.getService();
        this.bigquery = (BigQuery)((BigQueryOptions.Builder)this.options.toBuilder().setRetrySettings(ServiceOptions.getDefaultRetrySettings())).build().getService();
        try {
            ((BigQueryImpl)this.bigquery).create(JobInfo.of((JobConfiguration)QUERY_JOB_CONFIGURATION_FOR_DMLQUERY), new BigQuery.JobOption[]{bigQueryRetryConfigOption});
            Assert.fail((String)"JobException expected");
        }
        catch (BigQueryException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock, (VerificationMode)Mockito.times((int)1))).create((com.google.api.services.bigquery.model.Job)this.jobCapture.capture(), (Map)Mockito.eq((Object)bigQueryRpcOptions));
    }

    @Test
    public void testCreateJobWithRetryOptionsFailureShouldRetry() {
        BigQuery.JobOption retryOptions = BigQuery.JobOption.retryOptions((RetryOption[])new RetryOption[]{RetryOption.maxAttempts((int)4)});
        Map bigQueryRpcOptions = BigQueryImpl.optionMap((Option[])new Option[]{retryOptions});
        Mockito.when((Object)this.bigqueryRpcMock.create((com.google.api.services.bigquery.model.Job)this.jobCapture.capture(), (Map)Mockito.eq((Object)bigQueryRpcOptions))).thenThrow(new Throwable[]{new BigQueryException(500, "InternalError")}).thenThrow(new Throwable[]{new BigQueryException(502, "Bad Gateway")}).thenThrow(new Throwable[]{new BigQueryException(503, "Service Unavailable")}).thenReturn((Object)BigQueryImplTest.newJobPb());
        this.bigquery = (BigQuery)this.options.getService();
        this.bigquery = (BigQuery)((BigQueryOptions.Builder)this.options.toBuilder().setRetrySettings(ServiceOptions.getDefaultRetrySettings())).build().getService();
        ((BigQueryImpl)this.bigquery).create(JobInfo.of((JobConfiguration)QUERY_JOB_CONFIGURATION_FOR_DMLQUERY), new BigQuery.JobOption[]{retryOptions});
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock, (VerificationMode)Mockito.times((int)4))).create((com.google.api.services.bigquery.model.Job)this.jobCapture.capture(), (Map)Mockito.eq((Object)bigQueryRpcOptions));
    }

    @Test
    public void testCreateJobWithRetryOptionsFailureShouldNotRetry() {
        BigQuery.JobOption retryOptions = BigQuery.JobOption.retryOptions((RetryOption[])new RetryOption[]{RetryOption.maxAttempts((int)1)});
        Map bigQueryRpcOptions = BigQueryImpl.optionMap((Option[])new Option[]{retryOptions});
        Mockito.when((Object)this.bigqueryRpcMock.create((com.google.api.services.bigquery.model.Job)this.jobCapture.capture(), (Map)Mockito.eq((Object)bigQueryRpcOptions))).thenThrow(new Throwable[]{new BigQueryException(500, "InternalError")}).thenReturn((Object)BigQueryImplTest.newJobPb());
        this.bigquery = (BigQuery)this.options.getService();
        this.bigquery = (BigQuery)((BigQueryOptions.Builder)this.options.toBuilder().setRetrySettings(ServiceOptions.getDefaultRetrySettings())).build().getService();
        try {
            ((BigQueryImpl)this.bigquery).create(JobInfo.of((JobConfiguration)QUERY_JOB_CONFIGURATION_FOR_DMLQUERY), new BigQuery.JobOption[]{retryOptions});
            Assert.fail((String)"JobException expected");
        }
        catch (BigQueryException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock, (VerificationMode)Mockito.times((int)1))).create((com.google.api.services.bigquery.model.Job)this.jobCapture.capture(), (Map)Mockito.eq((Object)bigQueryRpcOptions));
    }

    @Test
    public void testCreateJobWithSelectedFields() {
        Mockito.when((Object)this.bigqueryRpcMock.create((com.google.api.services.bigquery.model.Job)Mockito.any(com.google.api.services.bigquery.model.Job.class), (Map)this.capturedOptions.capture())).thenReturn((Object)BigQueryImplTest.newJobPb());
        BigQuery.JobOption jobOptions = BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[]{BigQuery.JobField.USER_EMAIL});
        this.bigquery = (BigQuery)this.options.getService();
        this.bigquery.create(JobInfo.of((JobConfiguration)QueryJobConfiguration.of((String)"SOME QUERY")), new BigQuery.JobOption[]{jobOptions});
        String selector = (String)((Map)this.capturedOptions.getValue()).get(jobOptions.getRpcOption());
        Truth.assertThat((Object[])selector.split(",")).asList().containsExactly(new Object[]{"jobReference", "configuration", "user_email"});
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).create((com.google.api.services.bigquery.model.Job)Mockito.any(com.google.api.services.bigquery.model.Job.class), (Map)this.capturedOptions.capture());
    }

    @Test
    public void testCreateJobNoGet() {
        String id = "testCreateJobNoGet-id";
        JobId jobId = JobId.of((String)id);
        String query = "SELECT * in FOO";
        Mockito.when((Object)this.bigqueryRpcMock.create((com.google.api.services.bigquery.model.Job)this.jobCapture.capture(), (Map)Mockito.eq(EMPTY_RPC_OPTIONS))).thenThrow(new Throwable[]{new BigQueryException(409, "already exists, for some reason")});
        this.bigquery = (BigQuery)this.options.getService();
        try {
            this.bigquery.create(JobInfo.of((JobId)jobId, (JobConfiguration)QueryJobConfiguration.of((String)query)), new BigQuery.JobOption[0]);
            Assert.fail((String)"should throw");
        }
        catch (BigQueryException e) {
            Truth.assertThat((String)((com.google.api.services.bigquery.model.Job)this.jobCapture.getValue()).getJobReference().getJobId()).isEqualTo((Object)id);
        }
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).create((com.google.api.services.bigquery.model.Job)this.jobCapture.capture(), (Map)Mockito.eq(EMPTY_RPC_OPTIONS));
    }

    @Test
    public void testCreateJobTryGet() {
        String id = "testCreateJobTryGet-id";
        String query = "SELECT * in FOO";
        Supplier<JobId> idProvider = new Supplier<JobId>(){

            public JobId get() {
                return JobId.of((String)"testCreateJobTryGet-id");
            }
        };
        Mockito.when((Object)this.bigqueryRpcMock.create((com.google.api.services.bigquery.model.Job)this.jobCapture.capture(), (Map)Mockito.eq(EMPTY_RPC_OPTIONS))).thenThrow(new Throwable[]{new BigQueryException(409, "already exists, for some reason")});
        Mockito.when((Object)this.bigqueryRpcMock.getJob((String)Mockito.any(String.class), (String)Mockito.eq((Object)"testCreateJobTryGet-id"), (String)Mockito.eq((Object)null), (Map)Mockito.eq(EMPTY_RPC_OPTIONS))).thenReturn((Object)BigQueryImplTest.newJobPb());
        this.bigquery = (BigQuery)this.options.getService();
        ((BigQueryImpl)this.bigquery).create(JobInfo.of((JobConfiguration)QueryJobConfiguration.of((String)query)), (Supplier)idProvider, new BigQuery.JobOption[0]);
        Truth.assertThat((String)((com.google.api.services.bigquery.model.Job)this.jobCapture.getValue()).getJobReference().getJobId()).isEqualTo((Object)"testCreateJobTryGet-id");
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).create((com.google.api.services.bigquery.model.Job)this.jobCapture.capture(), (Map)Mockito.eq(EMPTY_RPC_OPTIONS));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getJob((String)Mockito.any(String.class), (String)Mockito.eq((Object)"testCreateJobTryGet-id"), (String)Mockito.eq((Object)null), (Map)Mockito.eq(EMPTY_RPC_OPTIONS));
    }

    @Test
    public void testCreateJobTryGetNotRandom() {
        Map withStatisticOption = BigQueryImpl.optionMap((Option[])new Option[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[]{BigQuery.JobField.STATISTICS})});
        String id = "testCreateJobTryGet-id";
        String query = "SELECT * in FOO";
        Mockito.when((Object)this.bigqueryRpcMock.create((com.google.api.services.bigquery.model.Job)this.jobCapture.capture(), (Map)Mockito.eq(EMPTY_RPC_OPTIONS))).thenThrow(new Throwable[]{new BigQueryException(409, "already exists, for some reason", (Throwable)new RuntimeException("Already Exists: Job"))});
        Mockito.when((Object)this.bigqueryRpcMock.getJob((String)Mockito.any(String.class), (String)Mockito.eq((Object)"testCreateJobTryGet-id"), (String)Mockito.eq((Object)null), (Map)Mockito.eq((Object)withStatisticOption))).thenReturn((Object)BigQueryImplTest.newJobPb().setId("testCreateJobTryGet-id").setStatistics(new JobStatistics().setCreationTime(Long.valueOf(System.currentTimeMillis()))));
        this.bigquery = (BigQuery)this.options.getService();
        Job job = ((BigQueryImpl)this.bigquery).create(JobInfo.of((JobId)JobId.of((String)"testCreateJobTryGet-id"), (JobConfiguration)QueryJobConfiguration.of((String)query)), new BigQuery.JobOption[0]);
        Truth.assertThat((Object)job).isNotNull();
        Truth.assertThat((String)((com.google.api.services.bigquery.model.Job)this.jobCapture.getValue()).getJobReference().getJobId()).isEqualTo((Object)"testCreateJobTryGet-id");
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).create((com.google.api.services.bigquery.model.Job)this.jobCapture.capture(), (Map)Mockito.eq(EMPTY_RPC_OPTIONS));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getJob((String)Mockito.any(String.class), (String)Mockito.eq((Object)"testCreateJobTryGet-id"), (String)Mockito.eq((Object)null), (Map)Mockito.eq((Object)withStatisticOption));
    }

    @Test
    public void testCreateJobWithProjectId() {
        JobInfo jobInfo = JobInfo.newBuilder((JobConfiguration)QUERY_JOB_CONFIGURATION.setProjectId(OTHER_PROJECT)).setJobId(JobId.of((String)OTHER_PROJECT, (String)JOB)).build();
        Mockito.when((Object)this.bigqueryRpcMock.create((com.google.api.services.bigquery.model.Job)Mockito.eq((Object)jobInfo.toPb()), (Map)this.capturedOptions.capture())).thenReturn((Object)jobInfo.toPb());
        BigQueryOptions bigQueryOptions = this.createBigQueryOptionsForProject(OTHER_PROJECT, this.rpcFactoryMock);
        this.bigquery = (BigQuery)bigQueryOptions.getService();
        Job job = this.bigquery.create(jobInfo, new BigQuery.JobOption[]{JOB_OPTION_FIELDS});
        Assert.assertEquals((Object)new Job(this.bigquery, new JobInfo.BuilderImpl(jobInfo)), (Object)job);
        String selector = (String)((Map)this.capturedOptions.getValue()).get(JOB_OPTION_FIELDS.getRpcOption());
        Assert.assertTrue((boolean)selector.contains("jobReference"));
        Assert.assertTrue((boolean)selector.contains("configuration"));
        Assert.assertTrue((boolean)selector.contains("user_email"));
        Assert.assertEquals((long)37L, (long)selector.length());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).create((com.google.api.services.bigquery.model.Job)Mockito.eq((Object)jobInfo.toPb()), (Map)this.capturedOptions.capture());
    }

    @Test
    public void testGetJob() {
        Mockito.when((Object)this.bigqueryRpcMock.getJob(PROJECT, JOB, null, EMPTY_RPC_OPTIONS)).thenReturn((Object)COMPLETE_COPY_JOB.toPb());
        this.bigquery = (BigQuery)this.options.getService();
        Job job = this.bigquery.getJob(JOB, new BigQuery.JobOption[0]);
        Assert.assertEquals((Object)new Job(this.bigquery, new JobInfo.BuilderImpl(COMPLETE_COPY_JOB)), (Object)job);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getJob(PROJECT, JOB, null, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetJobWithLocation() {
        Mockito.when((Object)this.bigqueryRpcMock.getJob(PROJECT, JOB, LOCATION, EMPTY_RPC_OPTIONS)).thenReturn((Object)COMPLETE_COPY_JOB.toPb());
        BigQueryOptions options = this.createBigQueryOptionsForProjectWithLocation(PROJECT, this.rpcFactoryMock);
        this.bigquery = (BigQuery)options.getService();
        Job job = this.bigquery.getJob(JOB, new BigQuery.JobOption[0]);
        Assert.assertEquals((Object)new Job(this.bigquery, new JobInfo.BuilderImpl(COMPLETE_COPY_JOB)), (Object)job);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getJob(PROJECT, JOB, LOCATION, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetJobNotFoundWhenThrowIsDisabled() {
        Mockito.when((Object)this.bigqueryRpcMock.getJob(PROJECT, JOB, null, EMPTY_RPC_OPTIONS)).thenReturn((Object)COMPLETE_COPY_JOB.toPb());
        this.options.setThrowNotFound(false);
        this.bigquery = (BigQuery)this.options.getService();
        Job job = this.bigquery.getJob(JOB, new BigQuery.JobOption[0]);
        Assert.assertEquals((Object)new Job(this.bigquery, new JobInfo.BuilderImpl(COMPLETE_COPY_JOB)), (Object)job);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getJob(PROJECT, JOB, null, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetJobNotFoundWhenThrowIsEnabled() {
        Mockito.when((Object)this.bigqueryRpcMock.getJob(PROJECT, "job-not-found", null, EMPTY_RPC_OPTIONS)).thenReturn(null).thenThrow(new Throwable[]{new BigQueryException(404, "Job not found")});
        this.options.setThrowNotFound(true);
        this.bigquery = (BigQuery)this.options.getService();
        try {
            this.bigquery.getJob("job-not-found", new BigQuery.JobOption[0]);
            Assert.fail();
        }
        catch (BigQueryException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getJob(PROJECT, "job-not-found", null, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetJobFromJobId() {
        Mockito.when((Object)this.bigqueryRpcMock.getJob(PROJECT, JOB, null, EMPTY_RPC_OPTIONS)).thenReturn((Object)COMPLETE_COPY_JOB.toPb());
        this.bigquery = (BigQuery)this.options.getService();
        Job job = this.bigquery.getJob(JobId.of((String)JOB), new BigQuery.JobOption[0]);
        Assert.assertEquals((Object)new Job(this.bigquery, new JobInfo.BuilderImpl(COMPLETE_COPY_JOB)), (Object)job);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getJob(PROJECT, JOB, null, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetJobFromJobIdWithLocation() {
        Mockito.when((Object)this.bigqueryRpcMock.getJob(PROJECT, JOB, LOCATION, EMPTY_RPC_OPTIONS)).thenReturn((Object)COMPLETE_COPY_JOB.toPb());
        BigQueryOptions options = this.createBigQueryOptionsForProjectWithLocation(PROJECT, this.rpcFactoryMock);
        this.bigquery = (BigQuery)options.getService();
        Job job = this.bigquery.getJob(JobId.of((String)JOB), new BigQuery.JobOption[0]);
        Assert.assertEquals((Object)new Job(this.bigquery, new JobInfo.BuilderImpl(COMPLETE_COPY_JOB)), (Object)job);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getJob(PROJECT, JOB, LOCATION, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetJobFromJobIdWithProject() {
        JobId jobId = JobId.of((String)OTHER_PROJECT, (String)JOB);
        JobInfo jobInfo = COPY_JOB.setProjectId(OTHER_PROJECT);
        Mockito.when((Object)this.bigqueryRpcMock.getJob(OTHER_PROJECT, JOB, null, EMPTY_RPC_OPTIONS)).thenReturn((Object)jobInfo.toPb());
        this.bigquery = (BigQuery)this.options.getService();
        Job job = this.bigquery.getJob(jobId, new BigQuery.JobOption[0]);
        Assert.assertEquals((Object)new Job(this.bigquery, new JobInfo.BuilderImpl(jobInfo)), (Object)job);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getJob(OTHER_PROJECT, JOB, null, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetJobFromJobIdWithProjectWithLocation() {
        JobId jobId = JobId.of((String)OTHER_PROJECT, (String)JOB);
        JobInfo jobInfo = COPY_JOB.setProjectId(OTHER_PROJECT);
        Mockito.when((Object)this.bigqueryRpcMock.getJob(OTHER_PROJECT, JOB, LOCATION, EMPTY_RPC_OPTIONS)).thenReturn((Object)jobInfo.toPb());
        BigQueryOptions options = this.createBigQueryOptionsForProjectWithLocation(PROJECT, this.rpcFactoryMock);
        this.bigquery = (BigQuery)options.getService();
        Job job = this.bigquery.getJob(jobId, new BigQuery.JobOption[0]);
        Assert.assertEquals((Object)new Job(this.bigquery, new JobInfo.BuilderImpl(jobInfo)), (Object)job);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getJob(OTHER_PROJECT, JOB, LOCATION, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testListJobs() {
        this.bigquery = (BigQuery)this.options.getService();
        ImmutableList jobList = ImmutableList.of((Object)new Job(this.bigquery, new JobInfo.BuilderImpl(COMPLETE_QUERY_JOB)), (Object)new Job(this.bigquery, new JobInfo.BuilderImpl(COMPLETE_LOAD_JOB)));
        Tuple result = Tuple.of((Object)CURSOR, (Object)Iterables.transform((Iterable)jobList, (Function)new Function<Job, com.google.api.services.bigquery.model.Job>(){

            public com.google.api.services.bigquery.model.Job apply(Job job) {
                return job.toPb();
            }
        }));
        Mockito.when((Object)this.bigqueryRpcMock.listJobs(PROJECT, EMPTY_RPC_OPTIONS)).thenReturn((Object)result);
        Page page = this.bigquery.listJobs(new BigQuery.JobListOption[0]);
        Assert.assertEquals((Object)CURSOR, (Object)page.getNextPageToken());
        Assert.assertArrayEquals((Object[])jobList.toArray(), (Object[])Iterables.toArray((Iterable)page.getValues(), Job.class));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listJobs(PROJECT, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testListJobsWithOptions() {
        this.bigquery = (BigQuery)this.options.getService();
        ImmutableList jobList = ImmutableList.of((Object)new Job(this.bigquery, new JobInfo.BuilderImpl(COMPLETE_QUERY_JOB)), (Object)new Job(this.bigquery, new JobInfo.BuilderImpl(COMPLETE_LOAD_JOB)));
        Tuple result = Tuple.of((Object)CURSOR, (Object)Iterables.transform((Iterable)jobList, (Function)new Function<Job, com.google.api.services.bigquery.model.Job>(){

            public com.google.api.services.bigquery.model.Job apply(Job job) {
                return job.toPb();
            }
        }));
        Mockito.when((Object)this.bigqueryRpcMock.listJobs(PROJECT, JOB_LIST_OPTIONS)).thenReturn((Object)result);
        Page page = this.bigquery.listJobs(new BigQuery.JobListOption[]{JOB_LIST_ALL_USERS, JOB_LIST_STATE_FILTER, JOB_LIST_PAGE_TOKEN, JOB_LIST_PAGE_SIZE});
        Assert.assertEquals((Object)CURSOR, (Object)page.getNextPageToken());
        Assert.assertArrayEquals((Object[])jobList.toArray(), (Object[])Iterables.toArray((Iterable)page.getValues(), Job.class));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listJobs(PROJECT, JOB_LIST_OPTIONS);
    }

    @Test
    public void testListJobsWithSelectedFields() {
        this.bigquery = (BigQuery)this.options.getService();
        ImmutableList jobList = ImmutableList.of((Object)new Job(this.bigquery, new JobInfo.BuilderImpl(COMPLETE_QUERY_JOB)), (Object)new Job(this.bigquery, new JobInfo.BuilderImpl(COMPLETE_LOAD_JOB)));
        Tuple result = Tuple.of((Object)CURSOR, (Object)Iterables.transform((Iterable)jobList, (Function)new Function<Job, com.google.api.services.bigquery.model.Job>(){

            public com.google.api.services.bigquery.model.Job apply(Job job) {
                return job.toPb();
            }
        }));
        Mockito.when((Object)this.bigqueryRpcMock.listJobs((String)Mockito.eq((Object)PROJECT), (Map)this.capturedOptions.capture())).thenReturn((Object)result);
        Page page = this.bigquery.listJobs(new BigQuery.JobListOption[]{JOB_LIST_OPTION_FIELD});
        Assert.assertEquals((Object)CURSOR, (Object)page.getNextPageToken());
        Assert.assertArrayEquals((Object[])jobList.toArray(), (Object[])Iterables.toArray((Iterable)page.getValues(), Job.class));
        String selector = (String)((Map)this.capturedOptions.getValue()).get(JOB_OPTION_FIELDS.getRpcOption());
        Assert.assertTrue((boolean)selector.contains("nextPageToken,jobs("));
        Assert.assertTrue((boolean)selector.contains("configuration"));
        Assert.assertTrue((boolean)selector.contains("jobReference"));
        Assert.assertTrue((boolean)selector.contains("statistics"));
        Assert.assertTrue((boolean)selector.contains("state"));
        Assert.assertTrue((boolean)selector.contains("errorResult"));
        Assert.assertTrue((boolean)selector.contains(")"));
        Assert.assertEquals((long)75L, (long)selector.length());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listJobs((String)Mockito.eq((Object)PROJECT), (Map)this.capturedOptions.capture());
    }

    @Test
    public void testCancelJob() {
        Mockito.when((Object)this.bigqueryRpcMock.cancel(PROJECT, JOB, null)).thenReturn((Object)true);
        this.bigquery = (BigQuery)this.options.getService();
        Assert.assertTrue((boolean)this.bigquery.cancel(JOB));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).cancel(PROJECT, JOB, null);
    }

    @Test
    public void testCancelJobFromJobId() {
        Mockito.when((Object)this.bigqueryRpcMock.cancel(PROJECT, JOB, null)).thenReturn((Object)true);
        this.bigquery = (BigQuery)this.options.getService();
        Assert.assertTrue((boolean)this.bigquery.cancel(JobId.of((String)PROJECT, (String)JOB)));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).cancel(PROJECT, JOB, null);
    }

    @Test
    public void testCancelJobFromJobIdWithProject() {
        JobId jobId = JobId.of((String)OTHER_PROJECT, (String)JOB);
        Mockito.when((Object)this.bigqueryRpcMock.cancel(OTHER_PROJECT, JOB, null)).thenReturn((Object)true);
        this.bigquery = (BigQuery)this.options.getService();
        Assert.assertTrue((boolean)this.bigquery.cancel(jobId));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).cancel(OTHER_PROJECT, JOB, null);
    }

    @Test
    public void testQueryRequestCompleted() throws InterruptedException {
        JobId queryJob = JobId.of((String)PROJECT, (String)JOB);
        com.google.api.services.bigquery.model.Job jobResponsePb = new com.google.api.services.bigquery.model.Job().setConfiguration(QUERY_JOB_CONFIGURATION_FOR_QUERY.toPb()).setJobReference(queryJob.toPb()).setId(JOB).setStatus(new JobStatus().setState("DONE"));
        jobResponsePb.getConfiguration().getQuery().setDestinationTable(TABLE_ID.toPb());
        GetQueryResultsResponse responsePb = new GetQueryResultsResponse().setJobReference(queryJob.toPb()).setRows((List)ImmutableList.of((Object)TABLE_ROW)).setJobComplete(Boolean.valueOf(true)).setCacheHit(Boolean.valueOf(false)).setPageToken(CURSOR).setTotalBytesProcessed(Long.valueOf(42L)).setTotalRows(BigInteger.valueOf(1L)).setSchema(TABLE_SCHEMA.toPb());
        Mockito.when((Object)this.bigqueryRpcMock.create(JOB_INFO.toPb(), Collections.emptyMap())).thenReturn((Object)jobResponsePb);
        Mockito.when((Object)this.bigqueryRpcMock.getQueryResults(PROJECT, JOB, null, BigQueryImpl.optionMap((Option[])Job.DEFAULT_QUERY_WAIT_OPTIONS))).thenReturn((Object)responsePb);
        Mockito.when((Object)this.bigqueryRpcMock.listTableData(PROJECT, DATASET, TABLE, Collections.emptyMap())).thenReturn((Object)new TableDataList().setPageToken("").setRows((List)ImmutableList.of((Object)TABLE_ROW)).setTotalRows(Long.valueOf(1L)));
        this.bigquery = (BigQuery)this.options.getService();
        TableResult result = this.bigquery.query(QUERY_JOB_CONFIGURATION_FOR_QUERY, queryJob, new BigQuery.JobOption[0]);
        Truth.assertThat((Object)result.getSchema()).isEqualTo((Object)TABLE_SCHEMA);
        Truth.assertThat((Long)result.getTotalRows()).isEqualTo((Object)1);
        for (FieldValueList row : result.getValues()) {
            Truth.assertThat((Boolean)row.get(0).getBooleanValue()).isFalse();
            Truth.assertThat((Long)row.get(1).getLongValue()).isEqualTo((Object)1);
        }
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).create(JOB_INFO.toPb(), Collections.emptyMap());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getQueryResults(PROJECT, JOB, null, BigQueryImpl.optionMap((Option[])Job.DEFAULT_QUERY_WAIT_OPTIONS));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listTableData(PROJECT, DATASET, TABLE, Collections.emptyMap());
    }

    @Test
    public void testFastQueryRequestCompleted() throws InterruptedException {
        com.google.api.services.bigquery.model.QueryResponse queryResponsePb = new com.google.api.services.bigquery.model.QueryResponse().setCacheHit(Boolean.valueOf(false)).setJobComplete(Boolean.valueOf(true)).setKind("bigquery#queryResponse").setPageToken(null).setRows((List)ImmutableList.of((Object)TABLE_ROW)).setSchema(TABLE_SCHEMA.toPb()).setTotalBytesProcessed(Long.valueOf(42L)).setTotalRows(BigInteger.valueOf(1L));
        Mockito.when((Object)this.bigqueryRpcMock.queryRpc((String)Mockito.eq((Object)PROJECT), (QueryRequest)this.requestPbCapture.capture())).thenReturn((Object)queryResponsePb);
        this.bigquery = (BigQuery)this.options.getService();
        TableResult result = this.bigquery.query(QUERY_JOB_CONFIGURATION_FOR_QUERY, new BigQuery.JobOption[0]);
        Assert.assertNull((Object)result.getNextPage());
        Assert.assertNull((Object)result.getNextPageToken());
        Assert.assertFalse((boolean)result.hasNextPage());
        Truth.assertThat((Object)result.getSchema()).isEqualTo((Object)TABLE_SCHEMA);
        Truth.assertThat((Long)result.getTotalRows()).isEqualTo((Object)1);
        for (FieldValueList row : result.getValues()) {
            Truth.assertThat((Boolean)row.get(0).getBooleanValue()).isFalse();
            Truth.assertThat((Long)row.get(1).getLongValue()).isEqualTo((Object)1);
        }
        QueryRequest requestPb = (QueryRequest)this.requestPbCapture.getValue();
        Assert.assertEquals((Object)QUERY_JOB_CONFIGURATION_FOR_QUERY.getQuery(), (Object)requestPb.getQuery());
        Assert.assertEquals((Object)QUERY_JOB_CONFIGURATION_FOR_QUERY.getDefaultDataset().getDataset(), (Object)requestPb.getDefaultDataset().getDatasetId());
        Assert.assertEquals((Object)QUERY_JOB_CONFIGURATION_FOR_QUERY.useQueryCache(), (Object)requestPb.getUseQueryCache());
        Assert.assertNull((Object)requestPb.getLocation());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).queryRpc((String)Mockito.eq((Object)PROJECT), (QueryRequest)this.requestPbCapture.capture());
    }

    @Test
    public void testFastQueryRequestCompletedWithLocation() throws InterruptedException {
        com.google.api.services.bigquery.model.QueryResponse queryResponsePb = new com.google.api.services.bigquery.model.QueryResponse().setCacheHit(Boolean.valueOf(false)).setJobComplete(Boolean.valueOf(true)).setKind("bigquery#queryResponse").setPageToken(null).setRows((List)ImmutableList.of((Object)TABLE_ROW)).setSchema(TABLE_SCHEMA.toPb()).setTotalBytesProcessed(Long.valueOf(42L)).setTotalRows(BigInteger.valueOf(1L));
        Mockito.when((Object)this.bigqueryRpcMock.queryRpc((String)Mockito.eq((Object)PROJECT), (QueryRequest)this.requestPbCapture.capture())).thenReturn((Object)queryResponsePb);
        BigQueryOptions options = this.createBigQueryOptionsForProjectWithLocation(PROJECT, this.rpcFactoryMock);
        this.bigquery = (BigQuery)options.getService();
        TableResult result = this.bigquery.query(QUERY_JOB_CONFIGURATION_FOR_QUERY, new BigQuery.JobOption[0]);
        Assert.assertNull((Object)result.getNextPage());
        Assert.assertNull((Object)result.getNextPageToken());
        Assert.assertFalse((boolean)result.hasNextPage());
        Truth.assertThat((Object)result.getSchema()).isEqualTo((Object)TABLE_SCHEMA);
        Truth.assertThat((Long)result.getTotalRows()).isEqualTo((Object)1);
        for (FieldValueList row : result.getValues()) {
            Truth.assertThat((Boolean)row.get(0).getBooleanValue()).isFalse();
            Truth.assertThat((Long)row.get(1).getLongValue()).isEqualTo((Object)1);
        }
        QueryRequest requestPb = (QueryRequest)this.requestPbCapture.getValue();
        Assert.assertEquals((Object)QUERY_JOB_CONFIGURATION_FOR_QUERY.getQuery(), (Object)requestPb.getQuery());
        Assert.assertEquals((Object)QUERY_JOB_CONFIGURATION_FOR_QUERY.getDefaultDataset().getDataset(), (Object)requestPb.getDefaultDataset().getDatasetId());
        Assert.assertEquals((Object)QUERY_JOB_CONFIGURATION_FOR_QUERY.useQueryCache(), (Object)requestPb.getUseQueryCache());
        Assert.assertEquals((Object)LOCATION, (Object)requestPb.getLocation());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).queryRpc((String)Mockito.eq((Object)PROJECT), (QueryRequest)this.requestPbCapture.capture());
    }

    @Test
    public void testFastQueryMultiplePages() throws InterruptedException {
        JobId queryJob = JobId.of((String)PROJECT, (String)JOB);
        com.google.api.services.bigquery.model.Job responseJob = new com.google.api.services.bigquery.model.Job().setConfiguration(QUERY_JOB_CONFIGURATION_FOR_QUERY.toPb()).setJobReference(queryJob.toPb()).setId(JOB).setStatus(new JobStatus().setState("DONE"));
        responseJob.getConfiguration().getQuery().setDestinationTable(TABLE_ID.toPb());
        Mockito.when((Object)this.bigqueryRpcMock.getJob(PROJECT, JOB, null, EMPTY_RPC_OPTIONS)).thenReturn((Object)responseJob);
        Mockito.when((Object)this.bigqueryRpcMock.listTableData(PROJECT, DATASET, TABLE, BigQueryImpl.optionMap((Option[])new Option[]{BigQuery.TableDataListOption.pageToken((String)CURSOR)}))).thenReturn((Object)new TableDataList().setPageToken(CURSOR).setRows((List)ImmutableList.of((Object)TABLE_ROW)).setTotalRows(Long.valueOf(1L)));
        com.google.api.services.bigquery.model.QueryResponse queryResponsePb = new com.google.api.services.bigquery.model.QueryResponse().setCacheHit(Boolean.valueOf(false)).setJobReference(queryJob.toPb()).setJobComplete(Boolean.valueOf(true)).setKind("bigquery#queryResponse").setPageToken(CURSOR).setRows((List)ImmutableList.of((Object)TABLE_ROW)).setSchema(TABLE_SCHEMA.toPb()).setTotalBytesProcessed(Long.valueOf(42L)).setTotalRows(BigInteger.valueOf(1L));
        Mockito.when((Object)this.bigqueryRpcMock.queryRpc((String)Mockito.eq((Object)PROJECT), (QueryRequest)this.requestPbCapture.capture())).thenReturn((Object)queryResponsePb);
        this.bigquery = (BigQuery)this.options.getService();
        TableResult result = this.bigquery.query(QUERY_JOB_CONFIGURATION_FOR_QUERY, new BigQuery.JobOption[0]);
        Assert.assertTrue((boolean)result.hasNextPage());
        Assert.assertNotNull((Object)result.getNextPageToken());
        Assert.assertNotNull((Object)result.getNextPage());
        QueryRequest requestPb = (QueryRequest)this.requestPbCapture.getValue();
        Assert.assertEquals((Object)QUERY_JOB_CONFIGURATION_FOR_QUERY.getQuery(), (Object)requestPb.getQuery());
        Assert.assertEquals((Object)QUERY_JOB_CONFIGURATION_FOR_QUERY.getDefaultDataset().getDataset(), (Object)requestPb.getDefaultDataset().getDatasetId());
        Assert.assertEquals((Object)QUERY_JOB_CONFIGURATION_FOR_QUERY.useQueryCache(), (Object)requestPb.getUseQueryCache());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getJob(PROJECT, JOB, null, EMPTY_RPC_OPTIONS);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listTableData(PROJECT, DATASET, TABLE, BigQueryImpl.optionMap((Option[])new Option[]{BigQuery.TableDataListOption.pageToken((String)CURSOR)}));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).queryRpc((String)Mockito.eq((Object)PROJECT), (QueryRequest)this.requestPbCapture.capture());
    }

    @Test
    public void testFastQuerySlowDdl() throws InterruptedException {
        JobId queryJob = JobId.of((String)PROJECT, (String)JOB);
        com.google.api.services.bigquery.model.QueryResponse queryResponsePb = new com.google.api.services.bigquery.model.QueryResponse().setJobComplete(Boolean.valueOf(false)).setJobReference(queryJob.toPb()).setRows((List)ImmutableList.of((Object)TABLE_ROW)).setSchema(TABLE_SCHEMA.toPb());
        com.google.api.services.bigquery.model.Job responseJob = new com.google.api.services.bigquery.model.Job().setConfiguration(QUERY_JOB_CONFIGURATION_FOR_QUERY.toPb()).setJobReference(queryJob.toPb()).setId(JOB).setStatus(new JobStatus().setState("DONE"));
        GetQueryResultsResponse queryResultsResponsePb = new GetQueryResultsResponse().setJobReference(responseJob.getJobReference()).setRows((List)ImmutableList.of((Object)TABLE_ROW)).setJobComplete(Boolean.valueOf(true)).setTotalRows(BigInteger.valueOf(1L)).setSchema(TABLE_SCHEMA.toPb());
        Mockito.when((Object)this.bigqueryRpcMock.queryRpc((String)Mockito.eq((Object)PROJECT), (QueryRequest)this.requestPbCapture.capture())).thenReturn((Object)queryResponsePb);
        responseJob.getConfiguration().getQuery().setDestinationTable(TABLE_ID.toPb());
        Mockito.when((Object)this.bigqueryRpcMock.getJob(PROJECT, JOB, null, EMPTY_RPC_OPTIONS)).thenReturn((Object)responseJob);
        Mockito.when((Object)this.bigqueryRpcMock.getQueryResults(PROJECT, JOB, null, BigQueryImpl.optionMap((Option[])Job.DEFAULT_QUERY_WAIT_OPTIONS))).thenReturn((Object)queryResultsResponsePb);
        Mockito.when((Object)this.bigqueryRpcMock.listTableData(PROJECT, DATASET, TABLE, EMPTY_RPC_OPTIONS)).thenReturn((Object)new TableDataList().setRows((List)ImmutableList.of((Object)TABLE_ROW)).setTotalRows(Long.valueOf(1L)));
        this.bigquery = (BigQuery)this.options.getService();
        TableResult result = this.bigquery.query(QUERY_JOB_CONFIGURATION_FOR_QUERY, new BigQuery.JobOption[0]);
        Truth.assertThat((Object)result.getSchema()).isEqualTo((Object)TABLE_SCHEMA);
        Truth.assertThat((Long)result.getTotalRows()).isEqualTo((Object)1);
        for (FieldValueList row : result.getValues()) {
            Truth.assertThat((Boolean)row.get(0).getBooleanValue()).isFalse();
            Truth.assertThat((Long)row.get(1).getLongValue()).isEqualTo((Object)1);
        }
        QueryRequest requestPb = (QueryRequest)this.requestPbCapture.getValue();
        Assert.assertEquals((Object)QUERY_JOB_CONFIGURATION_FOR_QUERY.getQuery(), (Object)requestPb.getQuery());
        Assert.assertEquals((Object)QUERY_JOB_CONFIGURATION_FOR_QUERY.getDefaultDataset().getDataset(), (Object)requestPb.getDefaultDataset().getDatasetId());
        Assert.assertEquals((Object)QUERY_JOB_CONFIGURATION_FOR_QUERY.useQueryCache(), (Object)requestPb.getUseQueryCache());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).queryRpc((String)Mockito.eq((Object)PROJECT), (QueryRequest)this.requestPbCapture.capture());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getJob(PROJECT, JOB, null, EMPTY_RPC_OPTIONS);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getQueryResults(PROJECT, JOB, null, BigQueryImpl.optionMap((Option[])Job.DEFAULT_QUERY_WAIT_OPTIONS));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listTableData(PROJECT, DATASET, TABLE, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testQueryRequestCompletedOptions() throws InterruptedException {
        JobId queryJob = JobId.of((String)PROJECT, (String)JOB);
        com.google.api.services.bigquery.model.Job jobResponsePb = new com.google.api.services.bigquery.model.Job().setConfiguration(QUERY_JOB_CONFIGURATION_FOR_QUERY.toPb()).setJobReference(queryJob.toPb()).setId(JOB).setStatus(new JobStatus().setState("DONE"));
        jobResponsePb.getConfiguration().getQuery().setDestinationTable(TABLE_ID.toPb());
        GetQueryResultsResponse responsePb = new GetQueryResultsResponse().setJobReference(queryJob.toPb()).setRows((List)ImmutableList.of((Object)TABLE_ROW)).setJobComplete(Boolean.valueOf(true)).setCacheHit(Boolean.valueOf(false)).setPageToken(CURSOR).setTotalBytesProcessed(Long.valueOf(42L)).setTotalRows(BigInteger.valueOf(1L)).setSchema(TABLE_SCHEMA.toPb());
        Mockito.when((Object)this.bigqueryRpcMock.create(JOB_INFO.toPb(), Collections.emptyMap())).thenReturn((Object)jobResponsePb);
        EnumMap optionMap = Maps.newEnumMap(BigQueryRpc.Option.class);
        BigQuery.QueryResultsOption pageSizeOption = BigQuery.QueryResultsOption.pageSize((long)42L);
        optionMap.put(pageSizeOption.getRpcOption(), pageSizeOption.getValue());
        Mockito.when((Object)this.bigqueryRpcMock.getQueryResults(PROJECT, JOB, null, BigQueryImpl.optionMap((Option[])Job.DEFAULT_QUERY_WAIT_OPTIONS))).thenReturn((Object)responsePb);
        Mockito.when((Object)this.bigqueryRpcMock.listTableData(PROJECT, DATASET, TABLE, (Map)optionMap)).thenReturn((Object)new TableDataList().setPageToken("").setRows((List)ImmutableList.of((Object)TABLE_ROW)).setTotalRows(Long.valueOf(1L)));
        this.bigquery = (BigQuery)this.options.getService();
        Job job = this.bigquery.create(JobInfo.of((JobId)queryJob, (JobConfiguration)QUERY_JOB_CONFIGURATION_FOR_QUERY), new BigQuery.JobOption[0]);
        TableResult result = job.getQueryResults(new BigQuery.QueryResultsOption[]{pageSizeOption});
        Truth.assertThat((Object)result.getSchema()).isEqualTo((Object)TABLE_SCHEMA);
        Truth.assertThat((Long)result.getTotalRows()).isEqualTo((Object)1);
        for (FieldValueList row : result.getValues()) {
            Truth.assertThat((Boolean)row.get(0).getBooleanValue()).isFalse();
            Truth.assertThat((Long)row.get(1).getLongValue()).isEqualTo((Object)1);
        }
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).create(JOB_INFO.toPb(), Collections.emptyMap());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getQueryResults(PROJECT, JOB, null, BigQueryImpl.optionMap((Option[])Job.DEFAULT_QUERY_WAIT_OPTIONS));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listTableData(PROJECT, DATASET, TABLE, (Map)optionMap);
    }

    @Test
    public void testQueryRequestCompletedOnSecondAttempt() throws InterruptedException {
        JobId queryJob = JobId.of((String)PROJECT, (String)JOB);
        com.google.api.services.bigquery.model.Job jobResponsePb1 = new com.google.api.services.bigquery.model.Job().setConfiguration(QUERY_JOB_CONFIGURATION_FOR_QUERY.toPb()).setJobReference(queryJob.toPb()).setId(JOB);
        jobResponsePb1.setStatus(new JobStatus().setState("DONE"));
        jobResponsePb1.getConfiguration().getQuery().setDestinationTable(TABLE_ID.toPb());
        GetQueryResultsResponse responsePb1 = new GetQueryResultsResponse().setJobReference(queryJob.toPb()).setJobComplete(Boolean.valueOf(false));
        GetQueryResultsResponse responsePb2 = new GetQueryResultsResponse().setJobReference(queryJob.toPb()).setRows((List)ImmutableList.of((Object)TABLE_ROW)).setJobComplete(Boolean.valueOf(true)).setCacheHit(Boolean.valueOf(false)).setPageToken(CURSOR).setTotalBytesProcessed(Long.valueOf(42L)).setTotalRows(BigInteger.valueOf(1L)).setSchema(TABLE_SCHEMA.toPb());
        Mockito.when((Object)this.bigqueryRpcMock.create(JOB_INFO.toPb(), Collections.emptyMap())).thenReturn((Object)jobResponsePb1);
        Mockito.when((Object)this.bigqueryRpcMock.getQueryResults(PROJECT, JOB, null, BigQueryImpl.optionMap((Option[])Job.DEFAULT_QUERY_WAIT_OPTIONS))).thenReturn((Object)responsePb1);
        Mockito.when((Object)this.bigqueryRpcMock.getQueryResults(PROJECT, JOB, null, BigQueryImpl.optionMap((Option[])Job.DEFAULT_QUERY_WAIT_OPTIONS))).thenReturn((Object)responsePb2);
        Mockito.when((Object)this.bigqueryRpcMock.listTableData(PROJECT, DATASET, TABLE, Collections.emptyMap())).thenReturn((Object)new TableDataList().setPageToken("").setRows((List)ImmutableList.of((Object)TABLE_ROW)).setTotalRows(Long.valueOf(1L)));
        this.bigquery = (BigQuery)this.options.getService();
        TableResult result = this.bigquery.query(QUERY_JOB_CONFIGURATION_FOR_QUERY, queryJob, new BigQuery.JobOption[0]);
        Truth.assertThat((Object)result.getSchema()).isEqualTo((Object)TABLE_SCHEMA);
        Truth.assertThat((Long)result.getTotalRows()).isEqualTo((Object)1);
        for (FieldValueList row : result.getValues()) {
            Truth.assertThat((Boolean)row.get(0).getBooleanValue()).isFalse();
            Truth.assertThat((Long)row.get(1).getLongValue()).isEqualTo((Object)1);
        }
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).create(JOB_INFO.toPb(), Collections.emptyMap());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getQueryResults(PROJECT, JOB, null, BigQueryImpl.optionMap((Option[])Job.DEFAULT_QUERY_WAIT_OPTIONS));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getQueryResults(PROJECT, JOB, null, BigQueryImpl.optionMap((Option[])Job.DEFAULT_QUERY_WAIT_OPTIONS));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listTableData(PROJECT, DATASET, TABLE, Collections.emptyMap());
    }

    @Test
    public void testGetQueryResults() {
        JobId queryJob = JobId.of((String)JOB);
        GetQueryResultsResponse responsePb = new GetQueryResultsResponse().setEtag(ETAG).setJobReference(queryJob.toPb()).setRows((List)ImmutableList.of((Object)TABLE_ROW)).setJobComplete(Boolean.valueOf(true)).setCacheHit(Boolean.valueOf(false)).setPageToken(CURSOR).setTotalBytesProcessed(Long.valueOf(42L)).setTotalRows(BigInteger.valueOf(1L));
        Mockito.when((Object)this.bigqueryRpcMock.getQueryResults(PROJECT, JOB, null, EMPTY_RPC_OPTIONS)).thenReturn((Object)responsePb);
        this.bigquery = (BigQuery)this.options.getService();
        QueryResponse response = this.bigquery.getQueryResults(queryJob, new BigQuery.QueryResultsOption[0]);
        Assert.assertEquals((Object)true, (Object)response.getCompleted());
        Assert.assertEquals(null, (Object)response.getSchema());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getQueryResults(PROJECT, JOB, null, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetQueryResultsRetry() {
        JobId queryJob = JobId.of((String)JOB);
        GetQueryResultsResponse responsePb = new GetQueryResultsResponse().setEtag(ETAG).setJobReference(queryJob.toPb()).setRows((List)ImmutableList.of((Object)TABLE_ROW)).setJobComplete(Boolean.valueOf(true)).setCacheHit(Boolean.valueOf(false)).setPageToken(CURSOR).setTotalBytesProcessed(Long.valueOf(42L)).setTotalRows(BigInteger.valueOf(1L));
        Mockito.when((Object)this.bigqueryRpcMock.getQueryResults(PROJECT, JOB, null, EMPTY_RPC_OPTIONS)).thenThrow(new Throwable[]{new BigQueryException(500, "InternalError")}).thenThrow(new Throwable[]{new BigQueryException(502, "Bad Gateway")}).thenThrow(new Throwable[]{new BigQueryException(503, "Service Unavailable")}).thenThrow(new Throwable[]{new BigQueryException(504, "Gateway Timeout")}).thenThrow(new Throwable[]{new BigQueryException(400, "Exceeded rate limits:")}).thenReturn((Object)responsePb);
        this.bigquery = (BigQuery)((BigQueryOptions.Builder)this.options.toBuilder().setRetrySettings(ServiceOptions.getDefaultRetrySettings())).build().getService();
        QueryResponse response = this.bigquery.getQueryResults(queryJob, new BigQuery.QueryResultsOption[0]);
        Assert.assertEquals((Object)true, (Object)response.getCompleted());
        Assert.assertEquals(null, (Object)response.getSchema());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock, (VerificationMode)Mockito.times((int)6))).getQueryResults(PROJECT, JOB, null, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetQueryResultsWithProject() {
        JobId queryJob = JobId.of((String)OTHER_PROJECT, (String)JOB);
        GetQueryResultsResponse responsePb = new GetQueryResultsResponse().setEtag(ETAG).setJobReference(queryJob.toPb()).setRows((List)ImmutableList.of((Object)TABLE_ROW)).setJobComplete(Boolean.valueOf(true)).setCacheHit(Boolean.valueOf(false)).setPageToken(CURSOR).setTotalBytesProcessed(Long.valueOf(42L)).setTotalRows(BigInteger.valueOf(1L));
        Mockito.when((Object)this.bigqueryRpcMock.getQueryResults(OTHER_PROJECT, JOB, null, EMPTY_RPC_OPTIONS)).thenReturn((Object)responsePb);
        this.bigquery = (BigQuery)this.options.getService();
        QueryResponse response = this.bigquery.getQueryResults(queryJob, new BigQuery.QueryResultsOption[0]);
        Assert.assertTrue((boolean)response.getCompleted());
        Assert.assertEquals(null, (Object)response.getSchema());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getQueryResults(OTHER_PROJECT, JOB, null, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetQueryResultsWithOptions() {
        JobId queryJob = JobId.of((String)PROJECT, (String)JOB);
        GetQueryResultsResponse responsePb = new GetQueryResultsResponse().setJobReference(queryJob.toPb()).setRows((List)ImmutableList.of((Object)TABLE_ROW)).setJobComplete(Boolean.valueOf(true)).setCacheHit(Boolean.valueOf(false)).setPageToken(CURSOR).setTotalBytesProcessed(Long.valueOf(42L)).setTotalRows(BigInteger.valueOf(1L));
        Mockito.when((Object)this.bigqueryRpcMock.getQueryResults(PROJECT, JOB, null, QUERY_RESULTS_OPTIONS)).thenReturn((Object)responsePb);
        this.bigquery = (BigQuery)this.options.getService();
        QueryResponse response = this.bigquery.getQueryResults(queryJob, new BigQuery.QueryResultsOption[]{QUERY_RESULTS_OPTION_TIME, QUERY_RESULTS_OPTION_INDEX, QUERY_RESULTS_OPTION_PAGE_SIZE, QUERY_RESULTS_OPTION_PAGE_TOKEN});
        Assert.assertEquals((Object)true, (Object)response.getCompleted());
        Assert.assertEquals(null, (Object)response.getSchema());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getQueryResults(PROJECT, JOB, null, QUERY_RESULTS_OPTIONS);
    }

    @Test
    public void testGetDatasetRetryableException() {
        Mockito.when((Object)this.bigqueryRpcMock.getDataset(PROJECT, DATASET, EMPTY_RPC_OPTIONS)).thenThrow(new Throwable[]{new BigQueryException(500, "InternalError")}).thenReturn((Object)DATASET_INFO_WITH_PROJECT.toPb());
        this.bigquery = (BigQuery)((BigQueryOptions.Builder)this.options.toBuilder().setRetrySettings(ServiceOptions.getDefaultRetrySettings())).build().getService();
        Dataset dataset = this.bigquery.getDataset(DATASET, new BigQuery.DatasetOption[0]);
        Assert.assertEquals((Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(DATASET_INFO_WITH_PROJECT)), (Object)dataset);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock, (VerificationMode)Mockito.times((int)2))).getDataset(PROJECT, DATASET, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testNonRetryableException() {
        String exceptionMessage = "Not Implemented";
        Mockito.when((Object)this.bigqueryRpcMock.getDataset(PROJECT, DATASET, EMPTY_RPC_OPTIONS)).thenThrow(new Throwable[]{new BigQueryException(501, exceptionMessage)});
        this.bigquery = (BigQuery)((BigQueryOptions.Builder)this.options.toBuilder().setRetrySettings(ServiceOptions.getDefaultRetrySettings())).build().getService();
        try {
            this.bigquery.getDataset(DatasetId.of((String)DATASET), new BigQuery.DatasetOption[0]);
            Assert.fail();
        }
        catch (BigQueryException ex) {
            Assert.assertEquals((Object)exceptionMessage, (Object)ex.getMessage());
        }
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getDataset(PROJECT, DATASET, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testRuntimeException() {
        String exceptionMessage = "Artificial runtime exception";
        Mockito.when((Object)this.bigqueryRpcMock.getDataset(PROJECT, DATASET, EMPTY_RPC_OPTIONS)).thenThrow(new Throwable[]{new RuntimeException(exceptionMessage)});
        this.bigquery = (BigQuery)((BigQueryOptions.Builder)this.options.toBuilder().setRetrySettings(ServiceOptions.getDefaultRetrySettings())).build().getService();
        try {
            this.bigquery.getDataset(DATASET, new BigQuery.DatasetOption[0]);
            Assert.fail();
        }
        catch (BigQueryException ex) {
            Assert.assertTrue((boolean)ex.getMessage().endsWith(exceptionMessage));
        }
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getDataset(PROJECT, DATASET, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testQueryDryRun() throws Exception {
        try {
            ((BigQuery)((BigQueryOptions.Builder)this.options.toBuilder().setRetrySettings(ServiceOptions.getDefaultRetrySettings())).build().getService()).query(QueryJobConfiguration.newBuilder((String)"foo").setDryRun(Boolean.valueOf(true)).build(), new BigQuery.JobOption[0]);
            Assert.fail();
        }
        catch (UnsupportedOperationException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void testFastQuerySQLShouldRetry() throws Exception {
        com.google.api.services.bigquery.model.QueryResponse responsePb = new com.google.api.services.bigquery.model.QueryResponse().setCacheHit(Boolean.valueOf(false)).setJobComplete(Boolean.valueOf(true)).setRows((List)ImmutableList.of((Object)TABLE_ROW)).setPageToken(null).setTotalBytesProcessed(Long.valueOf(42L)).setTotalRows(BigInteger.valueOf(1L)).setSchema(TABLE_SCHEMA.toPb());
        Mockito.when((Object)this.bigqueryRpcMock.queryRpc((String)Mockito.eq((Object)PROJECT), (QueryRequest)this.requestPbCapture.capture())).thenThrow(new Throwable[]{new BigQueryException(500, "InternalError")}).thenThrow(new Throwable[]{new BigQueryException(502, "Bad Gateway")}).thenThrow(new Throwable[]{new BigQueryException(503, "Service Unavailable")}).thenThrow(new Throwable[]{new BigQueryException(504, "Gateway Timeout")}).thenReturn((Object)responsePb);
        this.bigquery = (BigQuery)((BigQueryOptions.Builder)this.options.toBuilder().setRetrySettings(ServiceOptions.getDefaultRetrySettings())).build().getService();
        TableResult response = this.bigquery.query(QUERY_JOB_CONFIGURATION_FOR_QUERY, new BigQuery.JobOption[0]);
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)response.getSchema());
        Assert.assertEquals((long)1L, (long)response.getTotalRows());
        List allRequests = this.requestPbCapture.getAllValues();
        boolean idempotent = true;
        String firstRequestId = ((QueryRequest)allRequests.get(0)).getRequestId();
        for (QueryRequest request : allRequests) {
            idempotent = request.getRequestId().equals(firstRequestId);
        }
        Assert.assertTrue((boolean)idempotent);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock, (VerificationMode)Mockito.times((int)5))).queryRpc((String)Mockito.eq((Object)PROJECT), (QueryRequest)this.requestPbCapture.capture());
    }

    @Test
    public void testFastQueryDMLShouldRetry() throws Exception {
        com.google.api.services.bigquery.model.QueryResponse responsePb = new com.google.api.services.bigquery.model.QueryResponse().setCacheHit(Boolean.valueOf(false)).setJobComplete(Boolean.valueOf(true)).setRows((List)ImmutableList.of((Object)TABLE_ROW)).setPageToken(null).setTotalBytesProcessed(Long.valueOf(42L)).setNumDmlAffectedRows(Long.valueOf(1L)).setSchema(TABLE_SCHEMA.toPb());
        Mockito.when((Object)this.bigqueryRpcMock.queryRpc((String)Mockito.eq((Object)PROJECT), (QueryRequest)this.requestPbCapture.capture())).thenThrow(new Throwable[]{new BigQueryException(500, "InternalError")}).thenThrow(new Throwable[]{new BigQueryException(502, "Bad Gateway")}).thenThrow(new Throwable[]{new BigQueryException(503, "Service Unavailable")}).thenThrow(new Throwable[]{new BigQueryException(504, "Gateway Timeout")}).thenReturn((Object)responsePb);
        this.bigquery = (BigQuery)((BigQueryOptions.Builder)this.options.toBuilder().setRetrySettings(ServiceOptions.getDefaultRetrySettings())).build().getService();
        TableResult response = this.bigquery.query(QUERY_JOB_CONFIGURATION_FOR_DMLQUERY, new BigQuery.JobOption[0]);
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)response.getSchema());
        Assert.assertEquals((long)1L, (long)response.getTotalRows());
        List allRequests = this.requestPbCapture.getAllValues();
        boolean idempotent = true;
        String firstRequestId = ((QueryRequest)allRequests.get(0)).getRequestId();
        for (QueryRequest request : allRequests) {
            idempotent = request.getRequestId().equals(firstRequestId);
        }
        Assert.assertTrue((boolean)idempotent);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock, (VerificationMode)Mockito.times((int)5))).queryRpc((String)Mockito.eq((Object)PROJECT), (QueryRequest)this.requestPbCapture.capture());
    }

    @Test
    public void testFastQueryRateLimitIdempotency() throws Exception {
        com.google.api.services.bigquery.model.QueryResponse responsePb = new com.google.api.services.bigquery.model.QueryResponse().setCacheHit(Boolean.valueOf(false)).setJobComplete(Boolean.valueOf(true)).setRows((List)ImmutableList.of((Object)TABLE_ROW)).setPageToken(null).setTotalBytesProcessed(Long.valueOf(42L)).setNumDmlAffectedRows(Long.valueOf(1L)).setSchema(TABLE_SCHEMA.toPb());
        Mockito.when((Object)this.bigqueryRpcMock.queryRpc((String)Mockito.eq((Object)PROJECT), (QueryRequest)this.requestPbCapture.capture())).thenThrow(new Throwable[]{new BigQueryException(500, "InternalError")}).thenThrow(new Throwable[]{new BigQueryException(502, "Bad Gateway")}).thenThrow(new Throwable[]{new BigQueryException(503, "Service Unavailable")}).thenThrow(new Throwable[]{new BigQueryException(504, "Gateway Timeout")}).thenThrow(new Throwable[]{new BigQueryException(400, RATE_LIMIT_ERROR_MSG)}).thenReturn((Object)responsePb);
        this.bigquery = (BigQuery)((BigQueryOptions.Builder)this.options.toBuilder().setRetrySettings(ServiceOptions.getDefaultRetrySettings())).build().getService();
        TableResult response = this.bigquery.query(QUERY_JOB_CONFIGURATION_FOR_DMLQUERY, new BigQuery.JobOption[0]);
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)response.getSchema());
        Assert.assertEquals((long)1L, (long)response.getTotalRows());
        List allRequests = this.requestPbCapture.getAllValues();
        boolean idempotent = true;
        String firstRequestId = ((QueryRequest)allRequests.get(0)).getRequestId();
        for (QueryRequest request : allRequests) {
            idempotent = idempotent && request.getRequestId().equals(firstRequestId);
        }
        Assert.assertTrue((boolean)idempotent);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock, (VerificationMode)Mockito.times((int)6))).queryRpc((String)Mockito.eq((Object)PROJECT), (QueryRequest)this.requestPbCapture.capture());
    }

    @Test
    public void testRateLimitRegEx() throws Exception {
        String msg2 = "Job eceeded rate limits: Your table exceeded quota for table update operations. For more information, see https://cloud.google.com/bigquery/docs/troubleshoot-quotas";
        String msg3 = "exceeded rate exceeded quota for table update";
        String msg4 = "exceeded rate limits";
        Assert.assertTrue((boolean)BigQueryRetryAlgorithm.matchRegEx((String)".*exceed.*rate.*limit.*", (String)RATE_LIMIT_ERROR_MSG));
        Assert.assertFalse((boolean)BigQueryRetryAlgorithm.matchRegEx((String)".*exceed.*rate.*limit.*", (String)msg2.toLowerCase()));
        Assert.assertFalse((boolean)BigQueryRetryAlgorithm.matchRegEx((String)".*exceed.*rate.*limit.*", (String)msg3.toLowerCase()));
        Assert.assertTrue((boolean)BigQueryRetryAlgorithm.matchRegEx((String)".*exceed.*rate.*limit.*", (String)msg4.toLowerCase()));
    }

    @Test
    public void testFastQueryDDLShouldRetry() throws Exception {
        com.google.api.services.bigquery.model.QueryResponse responsePb = new com.google.api.services.bigquery.model.QueryResponse().setCacheHit(Boolean.valueOf(false)).setJobComplete(Boolean.valueOf(true)).setRows((List)ImmutableList.of((Object)TABLE_ROW)).setPageToken(null).setTotalBytesProcessed(Long.valueOf(42L)).setSchema(TABLE_SCHEMA.toPb());
        Mockito.when((Object)this.bigqueryRpcMock.queryRpc((String)Mockito.eq((Object)PROJECT), (QueryRequest)this.requestPbCapture.capture())).thenThrow(new Throwable[]{new BigQueryException(500, "InternalError")}).thenThrow(new Throwable[]{new BigQueryException(502, "Bad Gateway")}).thenThrow(new Throwable[]{new BigQueryException(503, "Service Unavailable")}).thenThrow(new Throwable[]{new BigQueryException(504, "Gateway Timeout")}).thenReturn((Object)responsePb);
        this.bigquery = (BigQuery)((BigQueryOptions.Builder)this.options.toBuilder().setRetrySettings(ServiceOptions.getDefaultRetrySettings())).build().getService();
        TableResult response = this.bigquery.query(QUERY_JOB_CONFIGURATION_FOR_DDLQUERY, new BigQuery.JobOption[0]);
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)response.getSchema());
        Assert.assertEquals((long)0L, (long)response.getTotalRows());
        List allRequests = this.requestPbCapture.getAllValues();
        boolean idempotent = true;
        String firstRequestId = ((QueryRequest)allRequests.get(0)).getRequestId();
        for (QueryRequest request : allRequests) {
            idempotent = request.getRequestId().equals(firstRequestId);
        }
        Assert.assertTrue((boolean)idempotent);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock, (VerificationMode)Mockito.times((int)5))).queryRpc((String)Mockito.eq((Object)PROJECT), (QueryRequest)this.requestPbCapture.capture());
    }

    @Test
    public void testFastQueryBigQueryException() throws InterruptedException {
        ImmutableList errorProtoList = ImmutableList.of((Object)new ErrorProto().setMessage("Backend error1").setLocation("testLocation1").setReason("Backend issue1"), (Object)new ErrorProto().setMessage("Backend error2").setLocation("testLocation2").setReason("Backend issue2"));
        com.google.api.services.bigquery.model.QueryResponse responsePb = new com.google.api.services.bigquery.model.QueryResponse().setJobComplete(Boolean.valueOf(true)).setPageToken(null).setErrors((List)errorProtoList);
        Mockito.when((Object)this.bigqueryRpcMock.queryRpc((String)Mockito.eq((Object)PROJECT), (QueryRequest)this.requestPbCapture.capture())).thenReturn((Object)responsePb);
        this.bigquery = (BigQuery)this.options.getService();
        try {
            this.bigquery.query(QUERY_JOB_CONFIGURATION_FOR_QUERY, new BigQuery.JobOption[0]);
            Assert.fail((String)"BigQueryException expected");
        }
        catch (BigQueryException ex) {
            Assert.assertEquals((Object)Lists.transform((List)errorProtoList, (Function)BigQueryError.FROM_PB_FUNCTION), (Object)ex.getErrors());
        }
        QueryRequest requestPb = (QueryRequest)this.requestPbCapture.getValue();
        Assert.assertEquals((Object)QUERY_JOB_CONFIGURATION_FOR_QUERY.getQuery(), (Object)requestPb.getQuery());
        Assert.assertEquals((Object)QUERY_JOB_CONFIGURATION_FOR_QUERY.getDefaultDataset().getDataset(), (Object)requestPb.getDefaultDataset().getDatasetId());
        Assert.assertEquals((Object)QUERY_JOB_CONFIGURATION_FOR_QUERY.useQueryCache(), (Object)requestPb.getUseQueryCache());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).queryRpc((String)Mockito.eq((Object)PROJECT), (QueryRequest)this.requestPbCapture.capture());
    }

    @Test
    public void testCreateRoutine() {
        RoutineInfo routineInfo = ROUTINE_INFO.setProjectId(OTHER_PROJECT);
        Mockito.when((Object)this.bigqueryRpcMock.create(routineInfo.toPb(), EMPTY_RPC_OPTIONS)).thenReturn((Object)routineInfo.toPb());
        BigQueryOptions bigQueryOptions = this.createBigQueryOptionsForProject(OTHER_PROJECT, this.rpcFactoryMock);
        this.bigquery = (BigQuery)bigQueryOptions.getService();
        Routine actualRoutine = this.bigquery.create(routineInfo, new BigQuery.RoutineOption[0]);
        Assert.assertEquals((Object)new Routine(this.bigquery, new RoutineInfo.BuilderImpl(routineInfo)), (Object)actualRoutine);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).create(routineInfo.toPb(), EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetRoutine() {
        Mockito.when((Object)this.bigqueryRpcMock.getRoutine(PROJECT, DATASET, ROUTINE, EMPTY_RPC_OPTIONS)).thenReturn((Object)ROUTINE_INFO.toPb());
        this.bigquery = (BigQuery)this.options.getService();
        Routine routine = this.bigquery.getRoutine(DATASET, ROUTINE, new BigQuery.RoutineOption[0]);
        Assert.assertEquals((Object)new Routine(this.bigquery, new RoutineInfo.BuilderImpl(ROUTINE_INFO)), (Object)routine);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getRoutine(PROJECT, DATASET, ROUTINE, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetRoutineWithRountineId() {
        Mockito.when((Object)this.bigqueryRpcMock.getRoutine(PROJECT, DATASET, ROUTINE, EMPTY_RPC_OPTIONS)).thenReturn((Object)ROUTINE_INFO.toPb());
        this.bigquery = (BigQuery)this.options.getService();
        Routine routine = this.bigquery.getRoutine(ROUTINE_ID, new BigQuery.RoutineOption[0]);
        Assert.assertEquals((Object)new Routine(this.bigquery, new RoutineInfo.BuilderImpl(ROUTINE_INFO)), (Object)routine);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getRoutine(PROJECT, DATASET, ROUTINE, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testGetRoutineWithEnabledThrowNotFoundException() {
        Mockito.when((Object)this.bigqueryRpcMock.getRoutine(PROJECT, DATASET, ROUTINE, EMPTY_RPC_OPTIONS)).thenReturn(null).thenThrow(new Throwable[]{new BigQueryException(404, "Routine not found")});
        this.options.setThrowNotFound(true);
        this.bigquery = (BigQuery)this.options.getService();
        try {
            Routine routine = this.bigquery.getRoutine(ROUTINE_ID, new BigQuery.RoutineOption[0]);
            Assert.fail();
        }
        catch (BigQueryException ex) {
            Assert.assertEquals((Object)"Routine not found", (Object)ex.getMessage());
        }
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getRoutine(PROJECT, DATASET, ROUTINE, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testUpdateRoutine() {
        RoutineInfo updatedRoutineInfo = ROUTINE_INFO.setProjectId(OTHER_PROJECT).toBuilder().setDescription("newDescription").build();
        Mockito.when((Object)this.bigqueryRpcMock.update(updatedRoutineInfo.toPb(), EMPTY_RPC_OPTIONS)).thenReturn((Object)updatedRoutineInfo.toPb());
        BigQueryOptions bigQueryOptions = this.createBigQueryOptionsForProject(OTHER_PROJECT, this.rpcFactoryMock);
        this.bigquery = (BigQuery)bigQueryOptions.getService();
        Routine routine = this.bigquery.update(updatedRoutineInfo, new BigQuery.RoutineOption[0]);
        Assert.assertEquals((Object)new Routine(this.bigquery, new RoutineInfo.BuilderImpl(updatedRoutineInfo)), (Object)routine);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).update(updatedRoutineInfo.toPb(), EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testListRoutines() {
        this.bigquery = (BigQuery)this.options.getService();
        ImmutableList routineList = ImmutableList.of((Object)new Routine(this.bigquery, new RoutineInfo.BuilderImpl(ROUTINE_INFO)));
        Tuple result = Tuple.of((Object)CURSOR, (Object)Iterables.transform((Iterable)routineList, (Function)RoutineInfo.TO_PB_FUNCTION));
        Mockito.when((Object)this.bigqueryRpcMock.listRoutines(PROJECT, DATASET, EMPTY_RPC_OPTIONS)).thenReturn((Object)result);
        Page page = this.bigquery.listRoutines(DATASET, new BigQuery.RoutineListOption[0]);
        Assert.assertEquals((Object)CURSOR, (Object)page.getNextPageToken());
        Assert.assertArrayEquals((Object[])routineList.toArray(), (Object[])Iterables.toArray((Iterable)page.getValues(), Routine.class));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listRoutines(PROJECT, DATASET, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testListRoutinesWithDatasetId() {
        this.bigquery = (BigQuery)this.options.getService();
        ImmutableList routineList = ImmutableList.of((Object)new Routine(this.bigquery, new RoutineInfo.BuilderImpl(ROUTINE_INFO)));
        Tuple result = Tuple.of((Object)CURSOR, (Object)Iterables.transform((Iterable)routineList, (Function)RoutineInfo.TO_PB_FUNCTION));
        Mockito.when((Object)this.bigqueryRpcMock.listRoutines(PROJECT, DATASET, EMPTY_RPC_OPTIONS)).thenReturn((Object)result);
        Page page = this.bigquery.listRoutines(DatasetId.of((String)PROJECT, (String)DATASET), new BigQuery.RoutineListOption[0]);
        Assert.assertEquals((Object)CURSOR, (Object)page.getNextPageToken());
        Assert.assertArrayEquals((Object[])routineList.toArray(), (Object[])Iterables.toArray((Iterable)page.getValues(), Routine.class));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).listRoutines(PROJECT, DATASET, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testDeleteRoutine() {
        Mockito.when((Object)this.bigqueryRpcMock.deleteRoutine(PROJECT, DATASET, ROUTINE)).thenReturn((Object)true);
        this.bigquery = (BigQuery)this.options.getService();
        Assert.assertTrue((boolean)this.bigquery.delete(ROUTINE_ID));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).deleteRoutine(PROJECT, DATASET, ROUTINE);
    }

    @Test
    public void testWriteWithJob() throws IOException {
        this.bigquery = (BigQuery)this.options.getService();
        Job job = new Job(this.bigquery, new JobInfo.BuilderImpl(JOB_INFO));
        Mockito.when((Object)this.bigqueryRpcMock.open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()))).thenReturn((Object)UPLOAD_ID);
        Mockito.when((Object)this.bigqueryRpcMock.write((String)Mockito.eq((Object)UPLOAD_ID), (byte[])this.capturedBuffer.capture(), Mockito.eq((int)0), Mockito.eq((long)0L), Mockito.eq((int)0), Mockito.eq((boolean)true))).thenReturn((Object)job.toPb());
        this.writer = new TableDataWriteChannel(this.options, JOB_INFO.getJobId(), LOAD_CONFIGURATION);
        this.writer.close();
        Assert.assertEquals((Object)job, (Object)this.writer.getJob());
        this.bigquery.writer(JOB_INFO.getJobId(), LOAD_CONFIGURATION);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).write((String)Mockito.eq((Object)UPLOAD_ID), (byte[])this.capturedBuffer.capture(), Mockito.eq((int)0), Mockito.eq((long)0L), Mockito.eq((int)0), Mockito.eq((boolean)true));
    }

    @Test
    public void testWriteChannel() throws IOException {
        this.bigquery = (BigQuery)this.options.getService();
        Job job = new Job(this.bigquery, new JobInfo.BuilderImpl(JOB_INFO));
        Mockito.when((Object)this.bigqueryRpcMock.open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()))).thenReturn((Object)UPLOAD_ID);
        Mockito.when((Object)this.bigqueryRpcMock.write((String)Mockito.eq((Object)UPLOAD_ID), (byte[])this.capturedBuffer.capture(), Mockito.eq((int)0), Mockito.eq((long)0L), Mockito.eq((int)0), Mockito.eq((boolean)true))).thenReturn((Object)job.toPb());
        this.writer = new TableDataWriteChannel(this.options, JOB_INFO.getJobId(), LOAD_CONFIGURATION);
        this.writer.close();
        Assert.assertEquals((Object)job, (Object)this.writer.getJob());
        this.bigquery.writer(LOAD_CONFIGURATION);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).write((String)Mockito.eq((Object)UPLOAD_ID), (byte[])this.capturedBuffer.capture(), Mockito.eq((int)0), Mockito.eq((long)0L), Mockito.eq((int)0), Mockito.eq((boolean)true));
    }

    @Test
    public void testGetIamPolicy() {
        String resourceId = String.format("projects/%s/datasets/%s/tables/%s", PROJECT, DATASET, TABLE);
        com.google.api.services.bigquery.model.Policy apiPolicy = PolicyHelper.convertToApiPolicy((Policy)SAMPLE_IAM_POLICY);
        Mockito.when((Object)this.bigqueryRpcMock.getIamPolicy(resourceId, EMPTY_RPC_OPTIONS)).thenReturn((Object)apiPolicy);
        this.bigquery = (BigQuery)this.options.getService();
        Policy policy = this.bigquery.getIamPolicy(TABLE_ID, new BigQuery.IAMOption[0]);
        Assert.assertEquals((Object)policy, (Object)SAMPLE_IAM_POLICY);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).getIamPolicy(resourceId, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testSetIamPolicy() {
        String resourceId = String.format("projects/%s/datasets/%s/tables/%s", PROJECT, DATASET, TABLE);
        com.google.api.services.bigquery.model.Policy apiPolicy = PolicyHelper.convertToApiPolicy((Policy)SAMPLE_IAM_POLICY);
        Mockito.when((Object)this.bigqueryRpcMock.setIamPolicy(resourceId, apiPolicy, EMPTY_RPC_OPTIONS)).thenReturn((Object)apiPolicy);
        this.bigquery = (BigQuery)this.options.getService();
        Policy returnedPolicy = this.bigquery.setIamPolicy(TABLE_ID, SAMPLE_IAM_POLICY, new BigQuery.IAMOption[0]);
        Assert.assertEquals((Object)returnedPolicy, (Object)SAMPLE_IAM_POLICY);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).setIamPolicy(resourceId, apiPolicy, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testTestIamPermissions() {
        String resourceId = String.format("projects/%s/datasets/%s/tables/%s", PROJECT, DATASET, TABLE);
        ImmutableList checkedPermissions = ImmutableList.of((Object)"foo", (Object)"bar", (Object)"baz");
        ImmutableList grantedPermissions = ImmutableList.of((Object)"foo", (Object)"bar");
        TestIamPermissionsResponse response = new TestIamPermissionsResponse().setPermissions((List)grantedPermissions);
        Mockito.when((Object)this.bigqueryRpcMock.testIamPermissions(resourceId, (List)checkedPermissions, EMPTY_RPC_OPTIONS)).thenReturn((Object)response);
        this.bigquery = (BigQuery)this.options.getService();
        List perms = this.bigquery.testIamPermissions(TABLE_ID, (List)checkedPermissions, new BigQuery.IAMOption[0]);
        Assert.assertEquals((Object)perms, (Object)grantedPermissions);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).testIamPermissions(resourceId, (List)checkedPermissions, EMPTY_RPC_OPTIONS);
    }

    @Test
    public void testTestIamPermissionsWhenNoPermissionsGranted() {
        String resourceId = String.format("projects/%s/datasets/%s/tables/%s", PROJECT, DATASET, TABLE);
        ImmutableList checkedPermissions = ImmutableList.of((Object)"foo", (Object)"bar", (Object)"baz");
        TestIamPermissionsResponse response = new TestIamPermissionsResponse().setPermissions(null);
        Mockito.when((Object)this.bigqueryRpcMock.testIamPermissions(resourceId, (List)checkedPermissions, EMPTY_RPC_OPTIONS)).thenReturn((Object)response);
        this.bigquery = (BigQuery)this.options.getService();
        List perms = this.bigquery.testIamPermissions(TABLE_ID, (List)checkedPermissions, new BigQuery.IAMOption[0]);
        Assert.assertEquals((Object)perms, (Object)ImmutableList.of());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).testIamPermissions(resourceId, (List)checkedPermissions, EMPTY_RPC_OPTIONS);
    }
}

